//==============================================================================
//	
//	Copyright (c) 2002-
//	Authors:
//	* Andrew Hinton <ug60axh@cs.bham.ac.uk> (University of Birmingham)
//	* Dave Parker <david.parker@comlab.ox.ac.uk> (University of Oxford, formerly University of Birmingham)
//	
//------------------------------------------------------------------------------
//	
//	This file is part of PRISM.
//	
//	PRISM is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//	
//	PRISM is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//	
//	You should have received a copy of the GNU General Public License
//	along with PRISM; if not, write to the Free Software Foundation,
//	Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//	
//==============================================================================

package userinterface.util;

import java.util.ArrayList;

public class SelectionEvent
{
	private ArrayList<PropertyOwner> selectedItems;

	/**
	 * Creates a new instance of SelectionEvent 
	 */
	public SelectionEvent(ArrayList<PropertyOwner> selectedItems)
	{
		this.selectedItems = selectedItems;
	}

	/**
	 * Getter for property selectedItems.
	 * @return Value of property selectedItems.
	 */
	public ArrayList<PropertyOwner> getSelectedItems()
	{
		return selectedItems;
	}

	public PropertyOwner getSelectedItem(int i)
	{
		return selectedItems.get(i);
	}

	public int getSelectionSize()
	{
		return selectedItems.size();
	}
}
