//==============================================================================
//	
//	Copyright (c) 2002-
//	Authors:
//	* Mark Kattenbelt <mark.kattenbelt@comlab.ox.ac.uk> (University of Oxford, formerly University of Birmingham)
//	
//------------------------------------------------------------------------------
//	
//	This file is part of PRISM.
//	
//	PRISM is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//	
//	PRISM is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//	
//	You should have received a copy of the GNU General Public License
//	along with PRISM; if not, write to the Free Software Foundation,
//	Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//	
//==============================================================================

package userinterface.simulator;

import javax.swing.*;

import java.awt.*;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import userinterface.*;

public class GUITimeDialog extends JDialog
{
	private static final long serialVersionUID = 1L;
	
	//ATTRIBUTES    
	private double time;
	private boolean cancelled;

	private static double lastTime = 1.0d;

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JPanel allPanel;
	private javax.swing.JPanel bottomPanel;
	private javax.swing.JPanel buttonPanel;
	private javax.swing.JButton cancelButton;
	private javax.swing.JLabel inputLabel;
	private javax.swing.JButton okayButton;
	private javax.swing.JTextField timeInputField;
	private javax.swing.JPanel timeInputPanel;
	private javax.swing.JPanel topPanel;
	private javax.swing.JLabel warningLabel;

	// End of variables declaration//GEN-END:variables

	/** Creates new form GUIConstantsPicker */
	private GUITimeDialog(GUIPrism parent, GUISimulator simulator)
	{
		super(parent, "Provide a time", true);

		//initialise
		initComponents();

		this.getRootPane().setDefaultButton(okayButton);

		this.time = lastTime;
		this.cancelled = false;

		this.timeInputField.setText("" + time);

		this.warningLabel.setIcon(GUIPrism.getIconFromImage("smallError.png"));
		this.warningLabel.setVisible(false);

		this.timeInputField.getDocument().addDocumentListener(new DocumentListener()
		{
			public void changedUpdate(DocumentEvent e)
			{
				try {
					Double.parseDouble(timeInputField.getText());
					GUITimeDialog.this.warningLabel.setVisible(false);
					GUITimeDialog.this.okayButton.setEnabled(true);
				} catch (NumberFormatException nfe) {
					GUITimeDialog.this.warningLabel.setVisible(true);
					GUITimeDialog.this.okayButton.setEnabled(false);
				}
			}

			public void removeUpdate(DocumentEvent e)
			{
				changedUpdate(e);
			}

			public void insertUpdate(DocumentEvent e)
			{
				changedUpdate(e);
			}
		});

		super.setBounds(new Rectangle(550, 300));
		setResizable(true);
		setLocationRelativeTo(getParent()); // centre

		this.setVisible(true);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
	private void initComponents()
	{
		allPanel = new javax.swing.JPanel();
		bottomPanel = new javax.swing.JPanel();
		warningLabel = new javax.swing.JLabel();
		buttonPanel = new javax.swing.JPanel();
		okayButton = new javax.swing.JButton();
		cancelButton = new javax.swing.JButton();
		topPanel = new javax.swing.JPanel();
		timeInputPanel = new javax.swing.JPanel();
		inputLabel = new javax.swing.JLabel();
		timeInputField = new javax.swing.JTextField();

		addWindowListener(new java.awt.event.WindowAdapter()
		{
			public void windowClosing(java.awt.event.WindowEvent evt)
			{
				closeDialog(evt);
			}
		});

		allPanel.setLayout(new java.awt.BorderLayout());

		allPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
		bottomPanel.setLayout(new java.awt.BorderLayout());

		warningLabel.setText("Please enter a valid positive double");
		warningLabel.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 5, 0, 0));
		bottomPanel.add(warningLabel, java.awt.BorderLayout.CENTER);

		buttonPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

		okayButton.setText("Okay");
		okayButton.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				okayButtonActionPerformed(evt);
			}
		});

		buttonPanel.add(okayButton);

		cancelButton.setText("Cancel");
		cancelButton.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				cancelButtonActionPerformed(evt);
			}
		});

		buttonPanel.add(cancelButton);

		bottomPanel.add(buttonPanel, java.awt.BorderLayout.EAST);

		allPanel.add(bottomPanel, java.awt.BorderLayout.SOUTH);

		topPanel.setLayout(new java.awt.BorderLayout());

		topPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Time spent in state"));
		timeInputPanel.setLayout(new java.awt.GridLayout(1, 2, 5, 5));

		timeInputPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
		inputLabel.setText("Provide a time:");
		timeInputPanel.add(inputLabel);

		timeInputField.setText("1.0");
		timeInputPanel.add(timeInputField);

		topPanel.add(timeInputPanel, java.awt.BorderLayout.NORTH);

		allPanel.add(topPanel, java.awt.BorderLayout.CENTER);

		getContentPane().add(allPanel, java.awt.BorderLayout.CENTER);

	}// </editor-fold>//GEN-END:initComponents

	private void okayButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_okayButtonActionPerformed
	{//GEN-HEADEREND:event_okayButtonActionPerformed
		try {
			time = Double.parseDouble(timeInputField.getText());
		} catch (NumberFormatException nfe) { // Shouldn't happen.
			cancelled = true;
		}
		dispose();
	}//GEN-LAST:event_okayButtonActionPerformed

	private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelButtonActionPerformed
	{//GEN-HEADEREND:event_cancelButtonActionPerformed
		cancelled = true;
		dispose();
	}//GEN-LAST:event_cancelButtonActionPerformed

	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
	{
		setVisible(false);
		dispose();
	}//GEN-LAST:event_closeDialog

	public boolean isCancelled()
	{
		return cancelled;
	}

	public double getTime()
	{
		return time;
	}

	/** Returns a time, or -1 for cancel. */
	public static double askTime(GUIPrism prism, GUISimulator simulator)
	{
		GUITimeDialog dialog = new GUITimeDialog(prism, simulator);

		if (dialog.isCancelled()) {
			return -1;
		} else {
			GUITimeDialog.lastTime = dialog.time;
			return dialog.time;
		}
	}
}
