//==============================================================================
//
//	Copyright (c) 2025-
//	Authors:
//	* Dave Parker <d.a.parker@cs.bham.ac.uk> (University of Birmingham)
//
//------------------------------------------------------------------------------
//
//	This file is part of PRISM.
//
//	PRISM is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	PRISM is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with PRISM; if not, write to the Free Software Foundation,
//	Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//==============================================================================

package explicit;

import java.util.Iterator;
import java.util.Map;

import common.Interval;
import prism.ModelType;

/**
 * Interface for classes that provide (read) access to an explicit-state interval POMDP.
 */
public interface IPOMDP<Value> extends UPOMDP<Value>, IntervalModel<Value>
{
    // Accessors (for Model) - default implementations

    @Override
    default ModelType getModelType()
    {
        return ModelType.IPOMDP;
    }

    // Accessors

    @Override
    POMDP<Interval<Value>> getIntervalModel();

    /**
     * Get an iterator over the (interval) transitions from choice {@code i} of state {@code s}.
     */
    Iterator<Map.Entry<Integer, Interval<Value>>> getIntervalTransitionsIterator(int s, int i);
}
