/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactorQuotient<C extends GcdRingElem<C>>
extends FactorAbstract<Quotient<C>> {
    private static final Logger logger = LogManager.getLogger(FactorQuotient.class);
    protected final FactorAbstract<C> nengine;

    protected FactorQuotient() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorQuotient(QuotientRing<C> quotientRing) {
        this(quotientRing, FactorFactory.getImplementation(quotientRing.ring.coFac));
    }

    public FactorQuotient(QuotientRing<C> quotientRing, FactorAbstract<C> factorAbstract) {
        super(quotientRing);
        this.nengine = factorAbstract;
    }

    @Override
    public List<GenPolynomial<Quotient<C>>> baseFactorsSquarefree(GenPolynomial<Quotient<C>> genPolynomial) {
        return this.factorsSquarefree(genPolynomial);
    }

    @Override
    public List<GenPolynomial<Quotient<C>>> factorsSquarefree(GenPolynomial<Quotient<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<Quotient<C>>> arrayList = new ArrayList<GenPolynomial<Quotient<C>>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isONE()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomial<Quotient<C>> genPolynomial2 = genPolynomial;
        Quotient<C> quotient = genPolynomial.leadingBaseCoefficient();
        if (!quotient.isONE()) {
            genPolynomial2 = genPolynomial2.monic();
        }
        QuotientRing quotientRing = (QuotientRing)genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing2 = quotientRing.ring;
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2, genPolynomialRing);
        GenPolynomial genPolynomial3 = PolyUfdUtil.integralFromQuotientCoefficients(genPolynomialRing3, genPolynomial2);
        List<GenPolynomial<GenPolynomial<C>>> list = this.nengine.recursiveFactorsSquarefree(genPolynomial3);
        if (logger.isInfoEnabled()) {
            logger.info("irfacts = " + list);
        }
        if (list.size() <= 1) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        List list2 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, list);
        if (!quotient.isONE()) {
            GenPolynomial<Quotient<Quotient<C>>> genPolynomial4 = list2.get(0);
            list2.remove(genPolynomial4);
            genPolynomial4 = genPolynomial4.multiply(quotient);
            list2.add(0, genPolynomial4);
        }
        if (logger.isInfoEnabled()) {
            logger.info("qfacts = " + list2);
        }
        arrayList.addAll(list2);
        return arrayList;
    }
}

