/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.FactorFraction;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorFractionTest
extends TestCase {
    int rl = 1;
    int kl = 3;
    int ll = 4;
    int el = 4;
    float q = 0.5f;
    QuotientRing<BigRational> efac;
    GenPolynomialRing<BigRational> mfac;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FactorFractionTest.suite());
    }

    public FactorFractionTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorFractionTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(1L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"z"};
        this.mfac = new GenPolynomialRing<BigRational>(bigRational, this.rl, termOrder, stringArray);
        this.efac = new QuotientRing<BigRational>(this.mfac);
    }

    protected void tearDown() {
        this.efac = null;
        ComputerThreads.terminate();
    }

    public void testQuotientFactorization() {
        Quotient quotient = this.efac.random(this.kl, this.ll, this.el, this.q);
        quotient = (Quotient)quotient.power(3L);
        Quotient<BigRational> quotient2 = this.efac.random(this.kl, this.ll, this.el, this.q);
        Quotient<Quotient<BigRational>> quotient3 = quotient.multiply(quotient2);
        FactorFraction factorFraction = new FactorFraction(this.efac);
        SortedMap<Quotient<Quotient<BigRational>>, Long> sortedMap = factorFraction.factors(quotient3);
        if (quotient3.isZERO()) {
            FactorFractionTest.assertTrue((String)"#facs == 0", (sortedMap.size() == 0 ? 1 : 0) != 0);
        } else {
            FactorFractionTest.assertTrue((String)"#facs >= 1", (sortedMap.size() >= 1 ? 1 : 0) != 0);
        }
        for (Quotient<Quotient<BigRational>> quotient4 : sortedMap.keySet()) {
            FactorFractionTest.assertTrue((String)("irred(q): " + quotient4), (boolean)factorFraction.isIrreducible(quotient4));
        }
        boolean bl = factorFraction.isFactorization(quotient3, sortedMap);
        FactorFractionTest.assertTrue((String)"prod(factor(c)) == c", (boolean)bl);
    }
}

