/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseSigSeqIter;
import edu.jas.gb.SigPair;
import edu.jas.gb.SigPoly;
import edu.jas.gb.SigReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseGGVSigSeqIter<C extends RingElem<C>>
extends GroebnerBaseSigSeqIter<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseGGVSigSeqIter.class);

    public GroebnerBaseGGVSigSeqIter() {
        this(new SigReductionSeq());
    }

    public GroebnerBaseGGVSigSeqIter(SigReductionSeq<C> sigReductionSeq) {
        super(sigReductionSeq);
    }

    @Override
    GenPolynomial<C> SPolynomial(SigPoly<C> sigPoly, SigPoly<C> sigPoly2) {
        return this.sred.SPolynomialHalf(sigPoly, sigPoly2);
    }

    @Override
    List<SigPair<C>> pruneP(List<SigPair<C>> list, List<ExpVector> list2) {
        ArrayList<SigPair<C>> arrayList = new ArrayList<SigPair<C>>(list.size());
        for (SigPair<C> sigPair : list) {
            ExpVector expVector = sigPair.sigma.leadingExpVector();
            if (expVector == null) continue;
            boolean bl = false;
            for (ExpVector expVector2 : list2) {
                if (!expVector.multipleOf(expVector2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(sigPair);
        }
        return arrayList;
    }

    @Override
    List<SigPair<C>> pruneS(List<SigPair<C>> list, List<ExpVector> list2, List<SigPoly<C>> list3, List<SigPoly<C>> list4) {
        ArrayList<SigPair<C>> arrayList = new ArrayList<SigPair<C>>(list.size());
        for (SigPair<C> sigPair : list) {
            ExpVector expVector = sigPair.sigma.leadingExpVector();
            if (expVector == null) continue;
            boolean bl = false;
            for (ExpVector expVector2 : list2) {
                if (!expVector.multipleOf(expVector2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            bl = false;
            for (SigPair sigPair2 : list) {
                if (!expVector.equals(sigPair2.sigma.leadingExpVector()) || sigPair.pi.poly.compareTo(sigPair2.pi.poly) >= 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            bl = false;
            for (SigPair sigPair3 : arrayList) {
                if (!expVector.equals(sigPair3.sigma.leadingExpVector())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(sigPair);
            logger.debug("added p = " + sigPair.sigma);
        }
        return arrayList;
    }

    @Override
    List<ExpVector> initializeSyz(List<GenPolynomial<C>> list, List<SigPoly<C>> list2) {
        ArrayList<ExpVector> arrayList = new ArrayList<ExpVector>();
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.isZERO()) continue;
            arrayList.add(genPolynomial.leadingExpVector());
        }
        return arrayList;
    }

    @Override
    void updateSyz(List<ExpVector> list, SigPoly<C> sigPoly) {
        if (sigPoly.poly.isZERO() && !sigPoly.sigma.isZERO()) {
            list.add(sigPoly.sigma.leadingExpVector());
        }
    }
}

