/*
 * Decompiled with CFR 0.152.
 */
package com.sri.yices;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;

public class BigRational {
    private BigInteger numerator;
    private BigInteger denominator;
    private static final BigInteger ten = BigInteger.TEN;

    public BigRational(byte[] byArray, byte[] byArray2) {
        this.numerator = new BigInteger(byArray);
        this.denominator = new BigInteger(byArray2);
        if (this.denominator.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Division by zero");
        }
    }

    public BigRational(byte[] byArray) {
        this.numerator = new BigInteger(byArray);
        this.denominator = BigInteger.ONE;
    }

    public BigRational(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Division by zero");
        }
        this.numerator = bigInteger;
        this.denominator = bigInteger2;
    }

    public BigRational(String string) {
        int n = string.indexOf(47);
        if (n < 0) {
            this.numerator = new BigInteger(string);
            this.denominator = BigInteger.ONE;
        } else if (n + 1 < string.length()) {
            this.numerator = new BigInteger(string.substring(0, n));
            this.denominator = new BigInteger(string.substring(n + 1));
            this.normalize();
        } else {
            throw new NumberFormatException();
        }
    }

    public BigRational(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        int n = bigDecimal.scale();
        if (n >= 0) {
            this.numerator = bigInteger;
            this.denominator = ten.pow(n);
        } else {
            this.numerator = bigInteger.multiply(ten.multiply(ten.pow(-(++n))));
            this.denominator = BigInteger.ONE;
        }
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public boolean isInteger() {
        return this.denominator.compareTo(BigInteger.ONE) == 0;
    }

    public boolean fitsLong() {
        return this.isInteger() && this.numerator.bitLength() <= 63;
    }

    public boolean fitsInt() {
        return this.isInteger() && this.numerator.bitLength() <= 31;
    }

    public BigInteger toInteger() {
        return this.numerator.divide(this.denominator);
    }

    public long longValue() {
        return this.numerator.longValueExact();
    }

    public int intValue() {
        return this.numerator.intValueExact();
    }

    public double doubleValue() {
        BigDecimal bigDecimal = new BigDecimal(this.numerator);
        BigDecimal bigDecimal2 = new BigDecimal(this.denominator);
        return bigDecimal.divide(bigDecimal2, 64, RoundingMode.HALF_EVEN).doubleValue();
    }

    protected byte[] numToBytes() {
        return this.numerator.toByteArray();
    }

    protected byte[] denToBytes() {
        return this.denominator.toByteArray();
    }

    public String toString() {
        Object object = this.numerator.toString();
        if (!this.denominator.equals(BigInteger.ONE)) {
            object = (String)object + "/" + this.denominator.toString();
        }
        return object;
    }

    public void normalize() {
        BigInteger bigInteger = this.numerator.gcd(this.denominator);
        if (!bigInteger.equals(BigInteger.ONE)) {
            this.numerator = this.numerator.divide(bigInteger);
            this.denominator = this.denominator.divide(bigInteger);
        }
        if (this.denominator.signum() < 0) {
            this.numerator = this.numerator.negate();
            this.denominator = this.denominator.negate();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BigRational bigRational = (BigRational)object;
        return this.denominator.equals(bigRational.denominator) && this.numerator.equals(bigRational.numerator);
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator);
    }
}

