/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.kern.StringUtil;
import edu.jas.structure.AlgebraFactory;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenMatrixRing<C extends RingElem<C>>
implements AlgebraFactory<GenMatrix<C>, C> {
    private static final Logger logger = LogManager.getLogger(GenMatrixRing.class);
    public final RingFactory<C> coFac;
    public final int rows;
    public final int cols;
    public final int blocksize;
    public static final int DEFAULT_BSIZE = 10;
    public final GenMatrix<C> ZERO;
    public final GenMatrix<C> ONE;
    private static final Random random = new Random();
    public static final float DEFAULT_DENSITY = 0.5f;
    private final float density = 0.5f;

    public GenMatrixRing(RingFactory<C> ringFactory, int n, int n2) {
        this(ringFactory, n, n2, 10);
    }

    public GenMatrixRing(RingFactory<C> ringFactory, int n, int n2, int n3) {
        if (ringFactory == null) {
            throw new IllegalArgumentException("RingFactory is null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("rows < 1 " + n);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("cols < 1 " + n2);
        }
        this.coFac = ringFactory;
        this.rows = n;
        this.cols = n2;
        this.blocksize = n3;
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.cols);
        for (int i = 0; i < this.cols; ++i) {
            arrayList.add((RingElem)this.coFac.getZERO());
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            arrayList2.add(new ArrayList(arrayList));
        }
        this.ZERO = new GenMatrix(this, arrayList2);
        arrayList2 = new ArrayList(this.rows);
        RingElem ringElem = (RingElem)this.coFac.getONE();
        for (int i = 0; i < this.rows; ++i) {
            if (i >= this.cols) continue;
            ArrayList<RingElem> arrayList3 = new ArrayList<RingElem>(arrayList);
            arrayList3.set(i, ringElem);
            arrayList2.add(arrayList3);
        }
        this.ONE = new GenMatrix(this, arrayList2);
        logger.info("{} x {} matrix ring with blocksize {} over {} constructed", (Object)this.rows, (Object)this.cols, (Object)this.blocksize, this.coFac);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.coFac.getClass().getSimpleName());
        stringBuffer.append("[" + this.rows + "," + this.cols + "]");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("Mat(");
        String string = null;
        try {
            string = ((RingElem)((Object)this.coFac)).toScriptFactory();
        }
        catch (Exception exception) {
            string = this.coFac.toScript();
        }
        stringBuffer.append(string + "," + this.rows + "," + this.cols + ")");
        return stringBuffer.toString();
    }

    @Override
    public GenMatrix<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public GenMatrix<C> getONE() {
        return this.ONE;
    }

    @Override
    public List<GenMatrix<C>> generators() {
        List list = this.coFac.generators();
        ArrayList<GenMatrix<C>> arrayList = new ArrayList<GenMatrix<C>>(this.rows * this.cols * list.size());
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                for (RingElem ringElem : list) {
                    GenMatrix<RingElem> genMatrix = this.ZERO.set(i, j, ringElem);
                    arrayList.add(genMatrix);
                }
            }
        }
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return this.coFac.isFinite();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GenMatrixRing)) {
            return false;
        }
        GenMatrixRing genMatrixRing = (GenMatrixRing)object;
        if (this.rows != genMatrixRing.rows) {
            return false;
        }
        if (this.cols != genMatrixRing.cols) {
            return false;
        }
        return this.coFac.equals(genMatrixRing.coFac);
    }

    public int hashCode() {
        int n = this.rows * 17 + this.cols;
        n = 37 * n + this.coFac.hashCode();
        return n;
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public boolean isAssociative() {
        return this.rows == this.cols && this.coFac.isAssociative();
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    public GenMatrixRing<C> transpose() {
        if (this.rows == this.cols) {
            return this;
        }
        return new GenMatrixRing<C>(this.coFac, this.cols, this.rows, this.blocksize);
    }

    public GenMatrixRing<C> product(GenMatrixRing<C> genMatrixRing) {
        if (this.cols != genMatrixRing.rows) {
            throw new IllegalArgumentException("invalid dimensions in product");
        }
        if (!this.coFac.equals(genMatrixRing.coFac)) {
            throw new IllegalArgumentException("invalid coefficients in product");
        }
        if (this.rows == genMatrixRing.rows && this.cols == genMatrixRing.cols) {
            return this;
        }
        return new GenMatrixRing<C>(this.coFac, this.rows, genMatrixRing.cols, this.blocksize);
    }

    public GenMatrixRing<C> stack(GenMatrixRing<C> genMatrixRing) {
        if (this.cols != genMatrixRing.cols) {
            throw new IllegalArgumentException("invalid dimensions in stack");
        }
        if (!this.coFac.equals(genMatrixRing.coFac)) {
            throw new IllegalArgumentException("invalid coefficients in stack");
        }
        if (genMatrixRing.rows == 0) {
            return this;
        }
        int n = this.rows + genMatrixRing.rows;
        return new GenMatrixRing<C>(this.coFac, n, this.cols, this.blocksize);
    }

    public GenMatrixRing<C> concat(GenMatrixRing<C> genMatrixRing) {
        if (this.rows != genMatrixRing.rows) {
            throw new IllegalArgumentException("invalid dimensions in concat");
        }
        if (!this.coFac.equals(genMatrixRing.coFac)) {
            throw new IllegalArgumentException("invalid coefficients in stack");
        }
        if (genMatrixRing.cols == 0) {
            return this;
        }
        int n = this.cols + genMatrixRing.cols;
        return new GenMatrixRing<C>(this.coFac, this.rows, n, this.blocksize);
    }

    @Override
    public GenMatrix<C> fromInteger(long l) {
        RingElem ringElem = (RingElem)this.coFac.fromInteger(l);
        return this.ONE.scalarMultiply(ringElem);
    }

    @Override
    public GenMatrix<C> fromInteger(BigInteger bigInteger) {
        RingElem ringElem = (RingElem)this.coFac.fromInteger(bigInteger);
        return this.ONE.scalarMultiply(ringElem);
    }

    @Override
    public GenMatrix<C> fromList(List<List<C>> list) {
        if (list == null) {
            return this.ZERO;
        }
        if (list.size() > this.rows) {
            throw new IllegalArgumentException("size v > rows " + list + " > " + this.rows);
        }
        ArrayList arrayList = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<Object> arrayList2;
            List<C> list2 = list.get(i);
            if (list2 == null) {
                arrayList2 = this.ZERO.matrix.get(0);
            } else {
                if (list2.size() > this.cols) {
                    throw new IllegalArgumentException("size v > cols " + list2 + " > " + this.cols);
                }
                arrayList2 = new ArrayList(this.cols);
                arrayList2.addAll(list2);
                for (int j = arrayList2.size(); j < this.cols; ++j) {
                    arrayList2.add((RingElem)this.coFac.getZERO());
                }
            }
            arrayList.add(arrayList2);
        }
        return new GenMatrix(this, arrayList);
    }

    public GenMatrix<C> fromVectors(List<GenVector<C>> list) {
        ArrayList arrayList = new ArrayList();
        for (GenVector<C> genVector : list) {
            ArrayList arrayList2 = new ArrayList(genVector.val);
            arrayList.add(arrayList2);
        }
        GenMatrixRing<C> genMatrixRing = new GenMatrixRing<C>(this.coFac, arrayList.size(), this.cols);
        return genMatrixRing.fromList((List)arrayList);
    }

    @Override
    public GenMatrix<C> random(int n) {
        return this.random(n, 0.5f, random);
    }

    @Override
    public GenMatrix<C> random(int n, float f) {
        return this.random(n, f, random);
    }

    @Override
    public GenMatrix<C> random(int n, Random random) {
        return this.random(n, 0.5f, random);
    }

    public GenMatrix<C> random(int n, float f, Random random) {
        ArrayList arrayList = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<RingElem> arrayList2 = new ArrayList<RingElem>(this.cols);
            for (int j = 0; j < this.cols; ++j) {
                RingElem ringElem = random.nextFloat() < f ? (RingElem)this.coFac.random(n, random) : (RingElem)this.coFac.getZERO();
                arrayList2.add(ringElem);
            }
            arrayList.add(arrayList2);
        }
        return new GenMatrix(this, arrayList);
    }

    public GenMatrix<C> randomUpper(int n, float f) {
        return this.randomUpper(n, f, random);
    }

    public GenMatrix<C> randomUpper(int n, float f, Random random) {
        ArrayList arrayList = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<RingElem> arrayList2 = new ArrayList<RingElem>(this.cols);
            for (int j = 0; j < this.cols; ++j) {
                RingElem ringElem = (RingElem)this.coFac.getZERO();
                if (j >= i && random.nextFloat() < f) {
                    ringElem = (RingElem)this.coFac.random(n, random);
                }
                arrayList2.add(ringElem);
            }
            arrayList.add(arrayList2);
        }
        return new GenMatrix(this, arrayList);
    }

    public GenMatrix<C> randomLower(int n, float f) {
        return this.randomLower(n, f, random);
    }

    public GenMatrix<C> randomLower(int n, float f, Random random) {
        ArrayList arrayList = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<RingElem> arrayList2 = new ArrayList<RingElem>(this.cols);
            for (int j = 0; j < this.cols; ++j) {
                RingElem ringElem = (RingElem)this.coFac.getZERO();
                if (j <= i && random.nextFloat() < f) {
                    ringElem = (RingElem)this.coFac.random(n, random);
                }
                arrayList2.add(ringElem);
            }
            arrayList.add(arrayList2);
        }
        return new GenMatrix(this, arrayList);
    }

    @Override
    public GenMatrix<C> copy(GenMatrix<C> genMatrix) {
        if (genMatrix == null) {
            return genMatrix;
        }
        return genMatrix.copy();
    }

    public GenMatrix<C> generate(BiFunction<Integer, Integer, C> biFunction) {
        ArrayList arrayList = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<RingElem> arrayList2 = new ArrayList<RingElem>(this.cols);
            for (int j = 0; j < this.cols; ++j) {
                RingElem ringElem = (RingElem)biFunction.apply(i, j);
                arrayList2.add(ringElem);
            }
            arrayList.add(arrayList2);
        }
        return new GenMatrix(this, arrayList);
    }

    @Override
    public GenMatrix<C> parse(String string) {
        int n = string.indexOf("[");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        ArrayList arrayList = new ArrayList(this.rows);
        GenVectorModul<C> genVectorModul = new GenVectorModul<C>(this.coFac, this.cols);
        do {
            String string2;
            int n2;
            if ((n = string.indexOf("]")) != (n2 = string.lastIndexOf("]"))) {
                if (n < 0) continue;
                string2 = string.substring(0, n);
                string = string.substring(n);
                Element element = genVectorModul.parse(string2);
                ArrayList arrayList2 = new ArrayList(((GenVector)element).val);
                arrayList.add(arrayList2);
                n = string.indexOf(",");
                if (n < 0) continue;
                string = string.substring(n + 1);
                continue;
            }
            if (n < 0 || (string2 = string.substring(0, n)).trim().length() <= 0) break;
            throw new RuntimeException("Error e not empty " + string2);
        } while (n >= 0);
        return new GenMatrix(this, arrayList);
    }

    @Override
    public GenMatrix<C> parse(Reader reader) {
        String string = StringUtil.nextPairedString(reader, '[', ']');
        return this.parse(string);
    }
}

