/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInt;
import edu.jas.arith.ModIntRing;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.InvalidExpressionException;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenPolynomialTokenizerTest
extends TestCase {
    RingFactory fac;
    GenPolynomialRing pfac;
    GenSolvablePolynomialRing spfac;
    GenPolynomialTokenizer parser;
    Reader source;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenPolynomialTokenizerTest.suite());
    }

    public GenPolynomialTokenizerTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GenPolynomialTokenizerTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.fac = null;
        this.pfac = null;
        this.parser = null;
        this.source = null;
    }

    protected void tearDown() {
        this.fac = null;
        this.pfac = null;
        this.parser = null;
        this.source = null;
    }

    public void testBigRational() {
        String string = "Rat(x,y,z) L ( ( 1 ), ( 0 ), ( 3/4 - 6/8 ), ( 1 x + x^3 + 1/3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (polynomialList.list.size() == 4 ? 1 : 0) != 0);
        BigRational bigRational = new BigRational(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigRational>(bigRational, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial2.isZERO());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial4.length());
    }

    public void testBigInteger() {
        String string = "Int(x,y,z) L ( ( 1 ), ( 0 ), ( 3 2 - 6 ), ( 1 x + x^3 + 3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (polynomialList.list.size() == 4 ? 1 : 0) != 0);
        BigInteger bigInteger = new BigInteger(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigInteger>(bigInteger, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial2.isZERO());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial4.length());
    }

    public void testModInteger() {
        String string = "Mod 19 (x,y,z) L ( ( 1 ), ( 0 ), ( 3 2 - 6 + 19 ), ( 1 x + x^3 + 3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (polynomialList.list.size() == 4 ? 1 : 0) != 0);
        ModIntRing modIntRing = new ModIntRing(19);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<ModInt>(modIntRing, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        ModLongRing modLongRing = new ModLongRing(19L);
        GenPolynomialTokenizerTest.assertFalse((String)"fac != lfac", (boolean)modIntRing.equals(modLongRing));
        GenPolynomialTokenizerTest.assertFalse((String)"lfac != f.ring.coFac", (boolean)modLongRing.equals(polynomialList.ring.coFac));
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial2.isZERO());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial4.length());
    }

    public void testBigComplex() {
        String string = "Complex(x,y,z) L ( ( 1i0 ), ( 0i0 ), ( 3/4i2 - 6/8i2 ), ( 1i0 x + x^3 + 1i3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (polynomialList.list.size() == 4 ? 1 : 0) != 0);
        BigComplex bigComplex = new BigComplex(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigComplex>(bigComplex, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial2.isZERO());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial4.length());
    }

    public void testBigDecimal() {
        String string = "D(x,y,z) L ( ( 1 ), ( 0 ), ( 0.25 * 0.25 - 0.25^2 ), ( 1 x + x^3 + 0.3333333333333333333333 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (polynomialList.list.size() == 4 ? 1 : 0) != 0);
        BigDecimal bigDecimal = new BigDecimal(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigDecimal>(bigDecimal, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial2.isZERO());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial4.length());
    }

    public void testBigQuaternion() {
        String string = "Quat(x,y,z) L ( ( 1i0j0k0 ), ( 0i0j0k0 ), ( 3/4i2j1k3 - 6/8i2j1k3 ), ( 1 x + x^3 + 1i2j3k4 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (polynomialList.list.size() == 4 ? 1 : 0) != 0);
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigQuaternion>(bigQuaternionRing, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial2.isZERO());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial4.length());
    }

    public void testSolvableBigRational() {
        String string = "Rat(x,y,z) L RelationTable (  ( z ), ( y ), ( y z - 1 ) ) (  ( 1 ),  ( 0 ),  ( 3/4 - 6/8 ),  ( 1 x + x^3 + 1/3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        try {
            polynomialList = this.parser.nextSolvablePolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (polynomialList.list.size() == 4 ? 1 : 0) != 0);
        BigRational bigRational = new BigRational(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.spfac = new GenSolvablePolynomialRing<BigRational>(bigRational, n, termOrder, stringArray);
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(this.spfac.parse("z"));
        arrayList.add(this.spfac.parse("y"));
        arrayList.add(this.spfac.parse("y z - 1"));
        this.spfac.addSolvRelations(arrayList);
        GenPolynomialTokenizerTest.assertEquals((String)"spfac == f.ring", (Object)this.spfac, polynomialList.ring);
        GenSolvablePolynomial genSolvablePolynomial = polynomialList.castToSolvableList().get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(0) )", (boolean)genSolvablePolynomial.isONE());
        GenSolvablePolynomial genSolvablePolynomial2 = polynomialList.castToSolvableList().get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genSolvablePolynomial2.isZERO());
        GenSolvablePolynomial genSolvablePolynomial3 = polynomialList.castToSolvableList().get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(2) )", (boolean)genSolvablePolynomial3.isZERO());
        GenSolvablePolynomial genSolvablePolynomial4 = polynomialList.castToSolvableList().get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genSolvablePolynomial4.length());
    }

    public void testSolvableModInteger() {
        String string = "Mod 19 (x,y,z) L RelationTable (  ( z ), ( y ), ( y z - 1 ) ) ( ( 1 ), ( 0 ), ( 3 2 - 6 + 19 ), ( 1 x + x^3 + 3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        try {
            polynomialList = this.parser.nextSolvablePolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (polynomialList.list.size() == 4 ? 1 : 0) != 0);
        ModIntRing modIntRing = new ModIntRing(19);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.spfac = new GenSolvablePolynomialRing<ModInt>(modIntRing, n, termOrder, stringArray);
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(this.spfac.parse("z"));
        arrayList.add(this.spfac.parse("y"));
        arrayList.add(this.spfac.parse("y z - 1"));
        this.spfac.addSolvRelations(arrayList);
        GenPolynomialTokenizerTest.assertEquals((String)"spfac == f.ring", (Object)this.spfac, polynomialList.ring);
        GenSolvablePolynomial genSolvablePolynomial = polynomialList.castToSolvableList().get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(0) )", (boolean)genSolvablePolynomial.isONE());
        GenSolvablePolynomial genSolvablePolynomial2 = polynomialList.castToSolvableList().get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genSolvablePolynomial2.isZERO());
        GenSolvablePolynomial genSolvablePolynomial3 = polynomialList.castToSolvableList().get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(2) )", (boolean)genSolvablePolynomial3.isZERO());
        GenSolvablePolynomial genSolvablePolynomial4 = polynomialList.castToSolvableList().get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genSolvablePolynomial4.length());
    }

    public void testBigIntegerModule() {
        String string = "Int(x,y,z) L (  (   ( 1 ),   ( 0 ),   ( 3 2 - 6 ),   ( 1 x + x^3 + 3 y z - x^3 )  ),  ( ( 1 ), ( 0 ) ) )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        ModuleList moduleList = null;
        try {
            moduleList = this.parser.nextSubModuleSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"m != null", (moduleList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( m ) = 2", (moduleList.list.size() == 2 ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( m[0] ) = 4", (moduleList.list.get(0).size() == 4 ? 1 : 0) != 0);
        BigInteger bigInteger = new BigInteger(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigInteger>(bigInteger, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == m.ring", (Object)this.pfac, moduleList.ring);
        List list = moduleList.list;
        List list2 = list.get(0);
        GenPolynomial genPolynomial = list2.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = list2.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial2.isZERO());
        GenPolynomial genPolynomial3 = list2.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = list2.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial4.length());
        list2 = list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (list2.size() == 4 ? 1 : 0) != 0);
        genPolynomial = list2.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        genPolynomial2 = list2.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial2.isZERO());
        genPolynomial3 = list2.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial3.isZERO());
        genPolynomial4 = list2.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(3) )", (boolean)genPolynomial4.isZERO());
    }

    public void testBigRationalSolvableModule() {
        String string = "Rat(x,y,z) L RelationTable (  ( z ), ( y ), ( y z - 1 ) ) (  (   ( 1 ),   ( 0 ),   ( 3/4 - 6/8 ),   ( 1 x + x^3 + 1/3 y z - x^3 )  ),  ( ( x ), ( 1 ), ( 0 ) )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        ModuleList moduleList = null;
        try {
            moduleList = this.parser.nextSolvableSubModuleSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"m != null", (moduleList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( m ) = 2", (moduleList.list.size() == 2 ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( m[0] ) = 4", (moduleList.list.get(0).size() == 4 ? 1 : 0) != 0);
        BigRational bigRational = new BigRational(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.spfac = new GenSolvablePolynomialRing<BigRational>(bigRational, n, termOrder, stringArray);
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(this.spfac.parse("z"));
        arrayList.add(this.spfac.parse("y"));
        arrayList.add(this.spfac.parse("y z - 1"));
        this.spfac.addSolvRelations(arrayList);
        GenPolynomialTokenizerTest.assertEquals((String)"spfac == m.ring", (Object)this.spfac, moduleList.ring);
        List list = moduleList.castToSolvableList();
        List list2 = list.get(0);
        GenSolvablePolynomial genSolvablePolynomial = list2.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genSolvablePolynomial.isONE());
        GenSolvablePolynomial genSolvablePolynomial2 = list2.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genSolvablePolynomial2.isZERO());
        GenSolvablePolynomial genSolvablePolynomial3 = list2.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genSolvablePolynomial3.isZERO());
        GenSolvablePolynomial genSolvablePolynomial4 = list2.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genSolvablePolynomial4.length());
        list2 = list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 4", (list2.size() == 4 ? 1 : 0) != 0);
        genSolvablePolynomial = list2.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"!isONE( f.get(0) )", (!genSolvablePolynomial.isONE() ? 1 : 0) != 0);
        genSolvablePolynomial2 = list2.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(1) )", (boolean)genSolvablePolynomial2.isONE());
        genSolvablePolynomial3 = list2.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genSolvablePolynomial3.isZERO());
        genSolvablePolynomial4 = list2.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(3) )", (boolean)genSolvablePolynomial4.isZERO());
    }

    public void removedTestAlgebraicNumber() {
        String string = "AN[ (i) ( i^2 + 1 ) ] (x,y,z) L ( ( 1 ), ( _i_ ), ( 0 ), ( _i^2_ + 1 ), ( 1 x + x^3 + _3 i_ y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        AlgebraicNumberRing algebraicNumberRing = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
            algebraicNumberRing = (AlgebraicNumberRing)polynomialList.ring.coFac;
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (polynomialList.list.size() == 5 ? 1 : 0) != 0);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing(algebraicNumberRing, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)genPolynomial2.isUnit());
        genPolynomial2 = genPolynomial2.monic();
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)genPolynomial2.isONE());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial4.isZERO());
        GenPolynomial genPolynomial5 = polynomialList.list.get(4);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial5.length());
    }

    public void removedTestGaloisField() {
        String string = "AN[ 19 (i) ( i^2 + 1 ) ] (x,y,z) L ( ( 20 ), ( _i_ ), ( 0 ), ( _i^2_ + 20 ), ( 1 x + x^3 + _3 i_ y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        AlgebraicNumberRing algebraicNumberRing = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
            algebraicNumberRing = (AlgebraicNumberRing)polynomialList.ring.coFac;
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (polynomialList.list.size() == 5 ? 1 : 0) != 0);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing(algebraicNumberRing, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)genPolynomial2.isUnit());
        genPolynomial2 = genPolynomial2.monic();
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)genPolynomial2.isONE());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial4.isZERO());
        GenPolynomial genPolynomial5 = polynomialList.list.get(4);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial5.length());
    }

    public void testAlgebraicNumberBrace() {
        String string = "AN[ (i) ( i^2 + 1 ) ] (x,y,z) L ( ( 1 ), ( { i } ), ( 0 ), ( { i^2 } + 1 ), ( 1 x + x^3 + { 3 i }^2  y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        AlgebraicNumberRing algebraicNumberRing = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
            algebraicNumberRing = (AlgebraicNumberRing)polynomialList.ring.coFac;
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (polynomialList.list.size() == 5 ? 1 : 0) != 0);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing(algebraicNumberRing, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)genPolynomial2.isUnit());
        genPolynomial2 = genPolynomial2.monic();
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)genPolynomial2.isONE());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial4.isZERO());
        GenPolynomial genPolynomial5 = polynomialList.list.get(4);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial5.length());
    }

    public void testGaloisFieldBrace() {
        String string = "AN[ 19 (i) ( i^2 + 1 ) ] (x,y,z) L ( ( 20 ), ( { i } ), ( 0 ), ( { i^2 } + 20 ), ( 1 x + x^3 + { 3 i }^3 y z + { -1 }^3 x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        AlgebraicNumberRing algebraicNumberRing = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
            algebraicNumberRing = (AlgebraicNumberRing)polynomialList.ring.coFac;
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (polynomialList.list.size() == 5 ? 1 : 0) != 0);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing(algebraicNumberRing, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)genPolynomial2.isUnit());
        genPolynomial2 = genPolynomial2.monic();
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)genPolynomial2.isONE());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial4.isZERO());
        GenPolynomial genPolynomial5 = polynomialList.list.get(4);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial5.length());
    }

    public void testGaloisFieldWoBrace() {
        String string = "AN[ 19 (i) ( i^2 + 1 ) ] (x,y,z) L ( ( 20 ), ( i ), ( 0 ), ( i^2 + 20 ), ( 1 x + x^3 + 3^3 i^3 y z - (x)^3 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        AlgebraicNumberRing algebraicNumberRing = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
            algebraicNumberRing = (AlgebraicNumberRing)polynomialList.ring.coFac;
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (polynomialList.list.size() == 5 ? 1 : 0) != 0);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing(algebraicNumberRing, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)genPolynomial2.isUnit());
        genPolynomial2 = genPolynomial2.monic();
        GenPolynomialTokenizerTest.assertTrue((String)"isUnit( f.get(1) )", (boolean)genPolynomial2.isONE());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial4.isZERO());
        GenPolynomial genPolynomial5 = polynomialList.list.get(4);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial5.length());
    }

    public void testBigRationalGeneric() {
        String string = "Rat(x,y,z) L ( ( 1^3 ), ( 0^3 ), ( { 3/4 }^2 - 6/8^2 ), ( { 1 }^2 x + x^3 + 1/3 y z - x^3 ), ( 1.0001 - 0.0001 + { 0.25 }**2 - 1/4^2 )  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList.list != null ? 1 : 0) != 0);
        GenPolynomialTokenizerTest.assertTrue((String)"length( f ) = 5", (polynomialList.list.size() == 5 ? 1 : 0) != 0);
        BigRational bigRational = new BigRational(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigRational>(bigRational, n, termOrder, stringArray);
        GenPolynomialTokenizerTest.assertEquals((String)"pfac == f.ring", (Object)this.pfac, polynomialList.ring);
        GenPolynomial genPolynomial = polynomialList.list.get(0);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(0) )", (boolean)genPolynomial.isONE());
        GenPolynomial genPolynomial2 = polynomialList.list.get(1);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(1) )", (boolean)genPolynomial2.isZERO());
        GenPolynomial genPolynomial3 = polynomialList.list.get(2);
        GenPolynomialTokenizerTest.assertTrue((String)"isZERO( f.get(2) )", (boolean)genPolynomial3.isZERO());
        GenPolynomial genPolynomial4 = polynomialList.list.get(3);
        GenPolynomialTokenizerTest.assertEquals((String)"f.get(3).length() == 2", (int)2, (int)genPolynomial4.length());
        GenPolynomial genPolynomial5 = polynomialList.list.get(4);
        GenPolynomialTokenizerTest.assertTrue((String)"isONE( f.get(4) )", (boolean)genPolynomial5.isONE());
    }

    public void testBigRationalErorr() {
        String string = "Rat(x,y,z) L ( ( { 3 ),  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        PolynomialList polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        catch (InvalidExpressionException invalidExpressionException) {
            // empty catch block
        }
        string = "Rat(x,y,z) L ( ( 3 } ),  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        catch (InvalidExpressionException invalidExpressionException) {
            // empty catch block
        }
        string = "Rat(x,y,z) L ( ( { x } ),  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        catch (InvalidExpressionException invalidExpressionException) {
            // empty catch block
        }
        string = "Rat(x,y,z) L ( ( w ),  )";
        this.source = new StringReader(string);
        this.parser = new GenPolynomialTokenizer(this.source);
        polynomialList = null;
        try {
            polynomialList = this.parser.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GenPolynomialTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            GenPolynomialTokenizerTest.fail((String)("" + classCastException));
        }
        catch (InvalidExpressionException invalidExpressionException) {
            // empty catch block
        }
        GenPolynomialTokenizerTest.assertTrue((String)"f != null", (polynomialList == null ? 1 : 0) != 0);
    }

    public void testVariables() {
        String string = "a,b,c,d,e";
        String[] stringArray = GenPolynomialTokenizer.variableList(string);
        GenPolynomialTokenizerTest.assertTrue((String)"len == 5: ", (stringArray.length == 5 ? 1 : 0) != 0);
        String string2 = "a,b,c,d,e";
        stringArray = GenPolynomialTokenizer.expressionVariables(string2);
        GenPolynomialTokenizerTest.assertTrue((String)"len == 5: ", (stringArray.length == 5 ? 1 : 0) != 0);
        string2 = "b,c,d,e*a,b,c,d";
        stringArray = GenPolynomialTokenizer.expressionVariables(string2);
        GenPolynomialTokenizerTest.assertTrue((String)"len == 5: ", (stringArray.length == 5 ? 1 : 0) != 0);
        string2 = "b + c^3 - d + e*a - b/c +d";
        stringArray = GenPolynomialTokenizer.expressionVariables(string2);
        GenPolynomialTokenizerTest.assertTrue((String)"len == 5: ", (stringArray.length == 5 ? 1 : 0) != 0);
        string2 = "(b + c)^3 - { d + e*a } / [ b/c + d ] + (b + 3f + f*3 + f3)";
        stringArray = GenPolynomialTokenizer.expressionVariables(string2);
        GenPolynomialTokenizerTest.assertTrue((String)"len == 7: ", (stringArray.length == 7 ? 1 : 0) != 0);
    }
}

