/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseSeq<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseSeq.class);
    private static final boolean debug = logger.isDebugEnabled();

    public GroebnerBaseSeq() {
    }

    public GroebnerBaseSeq(Reduction<C> reduction) {
        super(reduction);
    }

    public GroebnerBaseSeq(PairList<C> pairList) {
        super(pairList);
    }

    public GroebnerBaseSeq(Reduction<C> reduction, PairList<C> pairList) {
        super(reduction, pairList);
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolyUtil.monic(list2)).size() <= 1) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        PairList<C> pairList = this.strategy.create(n, genPolynomialRing);
        pairList.put(list2);
        logger.info("start " + pairList);
        while (pairList.hasNext()) {
            GenPolynomial genPolynomial;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenPolynomial genPolynomial2 = pair.pi;
            GenPolynomial genPolynomial3 = pair.pj;
            if (debug) {
                logger.debug("pi    = " + genPolynomial2);
                logger.debug("pj    = " + genPolynomial3);
            }
            if ((genPolynomial = this.red.SPolynomial(genPolynomial2, genPolynomial3)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.debug("ht(S) = " + genPolynomial.leadingExpVector());
            }
            GenPolynomial<C> genPolynomial4 = this.red.normalform(list2, genPolynomial);
            if (debug) {
                logger.info("ht(H) = " + genPolynomial4.monic());
            }
            if (genPolynomial4.isZERO()) {
                pair.setZero();
                continue;
            }
            genPolynomial4 = genPolynomial4.monic();
            if (debug) {
                logger.info("ht(H) = " + genPolynomial4.leadingExpVector());
            }
            if ((genPolynomial4 = genPolynomial4.monic()).isONE()) {
                list2.clear();
                list2.add(genPolynomial4);
                pairList.putOne();
                logger.info("end " + pairList);
                return list2;
            }
            if (debug) {
                logger.info("H = " + genPolynomial4);
            }
            if (genPolynomial4.length() <= 0) continue;
            list2.add(genPolynomial4);
            pairList.put(genPolynomial4);
        }
        logger.debug("#sequential list = " + list2.size());
        list2 = this.minimalGB(list2);
        logger.info("end " + pairList);
        return list2;
    }

    @Override
    public ExtendedGB<C> extGB(int n, List<GenPolynomial<C>> list) {
        GenPolynomial genPolynomial;
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("null or empty F not allowed");
        }
        List list2 = new ArrayList();
        ArrayList arrayList = new ArrayList();
        List list3 = new ArrayList();
        PairList<C> pairList = null;
        boolean bl = false;
        int n2 = list.size();
        List<GenPolynomial<Object>> list4 = null;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        GenPolynomialRing genPolynomialRing = null;
        int n3 = 0;
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (genPolynomial2.length() > 0) {
                ++n3;
            }
            if (genPolynomialRing != null) continue;
            genPolynomialRing = genPolynomial2.ring;
        }
        MonoidElem monoidElem = genPolynomialRing.getONE();
        int n4 = 0;
        ListIterator<GenPolynomial<C>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GenPolynomial<C> genPolynomial3 = listIterator.next();
            if (genPolynomial3.length() > 0) {
                list4 = new ArrayList(n3);
                for (int i = 0; i < n3; ++i) {
                    list4.add(null);
                }
                list4.set(n4, (GenPolynomial<Object>)monoidElem);
                ++n4;
                if (genPolynomial3.isUnit()) {
                    list2.clear();
                    list2.add(genPolynomial3);
                    list3.clear();
                    list3.add(list4);
                    bl = true;
                    break;
                }
                list2.add(genPolynomial3);
                list3.add(list4);
                if (pairList == null) {
                    pairList = this.strategy.create(n, genPolynomial3.ring);
                    if (!genPolynomial3.ring.coFac.isField()) {
                        throw new RuntimeException("coefficients not from a field");
                    }
                }
                pairList.put(genPolynomial3);
                continue;
            }
            --n2;
        }
        if (n2 <= 1 || bl) {
            for (GenPolynomial<C> genPolynomial4 : list) {
                list4 = new ArrayList(list2.size());
                for (int i = 0; i < list2.size(); ++i) {
                    list4.add(null);
                }
                GenPolynomial genPolynomial5 = this.red.normalform(list4, list2, genPolynomial4);
                if (!genPolynomial5.isZERO()) {
                    logger.error("nonzero H = " + genPolynomial5);
                }
                arrayList.add(list4);
            }
            ExtendedGB<C> extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
            return extendedGB;
        }
        while (pairList.hasNext() && !bl) {
            int n5;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            int n6 = pair.i;
            int n7 = pair.j;
            GenPolynomial genPolynomial6 = pair.pi;
            GenPolynomial genPolynomial7 = pair.pj;
            if (debug) {
                logger.info("i, pi    = " + n6 + ", " + genPolynomial6);
                logger.info("j, pj    = " + n7 + ", " + genPolynomial7);
            }
            arrayList2 = new ArrayList(list2.size());
            for (n5 = 0; n5 < list2.size(); ++n5) {
                arrayList2.add(null);
            }
            GenPolynomial genPolynomial8 = this.red.SPolynomial(arrayList2, n6, genPolynomial6, n7, genPolynomial7);
            if (debug) {
                logger.debug("is reduction S = " + this.red.isReductionNF(arrayList2, list2, genPolynomialRing.getZERO(), genPolynomial8));
            }
            if (genPolynomial8.isZERO()) continue;
            if (debug) {
                logger.debug("ht(S) = " + genPolynomial8.leadingExpVector());
            }
            arrayList3 = new ArrayList(list2.size());
            for (n5 = 0; n5 < list2.size(); ++n5) {
                arrayList3.add(null);
            }
            genPolynomial = this.red.normalform(arrayList3, list2, genPolynomial8);
            if (debug) {
                logger.debug("is reduction H = " + this.red.isReductionNF(arrayList3, list2, genPolynomial8, genPolynomial));
            }
            if (genPolynomial.isZERO()) continue;
            if (debug) {
                logger.debug("ht(H) = " + genPolynomial.leadingExpVector());
            }
            list4 = new ArrayList(list2.size() + 1);
            for (n5 = 0; n5 < list2.size(); ++n5) {
                AbelianGroupElem abelianGroupElem;
                AbelianGroupElem<GenPolynomial<GenPolynomial>> abelianGroupElem2 = (GenPolynomial)arrayList2.get(n5);
                if (abelianGroupElem2 != null) {
                    abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).negate();
                }
                if ((abelianGroupElem = (GenPolynomial)arrayList3.get(n5)) != null) {
                    abelianGroupElem = abelianGroupElem.negate();
                }
                abelianGroupElem2 = abelianGroupElem2 == null ? abelianGroupElem : ((GenPolynomial)abelianGroupElem2).sum(abelianGroupElem);
                list4.add((GenPolynomial<Object>)abelianGroupElem2);
            }
            if (debug) {
                logger.debug("is reduction 0+sum(row,G) == H : " + this.red.isReductionNF(list4, list2, genPolynomial, genPolynomialRing.getZERO()));
            }
            list4.add(null);
            Object object = genPolynomial.leadingBaseCoefficient();
            object = (RingElem)object.inverse();
            genPolynomial = genPolynomial.multiply(object);
            list4 = this.blas.scalarProduct(((GenPolynomial)monoidElem).multiply(object), list4);
            list4.set(list2.size(), (GenPolynomial<Object>)monoidElem);
            if (genPolynomial.isONE()) {
                list2.add(genPolynomial);
                list3.add(list4);
                bl = true;
                break;
            }
            if (debug) {
                logger.debug("H = " + genPolynomial);
            }
            list2.add(genPolynomial);
            pairList.put(genPolynomial);
            list3.add(list4);
        }
        if (debug) {
            ExtendedGB<C> extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
            logger.info("exgb unnorm = " + extendedGB);
        }
        list3 = this.normalizeMatrix(list.size(), list3);
        if (debug) {
            ExtendedGB<C> extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
            logger.info("exgb nonmin = " + extendedGB);
            boolean bl2 = this.isReductionMatrix(extendedGB);
            logger.info("exgb t2 = " + bl2);
        }
        ExtendedGB extendedGB = this.minimalExtendedGB(list.size(), list2, list3);
        list2 = extendedGB.G;
        list3 = extendedGB.G2F;
        logger.debug("#sequential list = " + list2.size());
        logger.info("" + pairList);
        for (GenPolynomial<C> genPolynomial9 : list) {
            list4 = new ArrayList(list2.size());
            for (int i = 0; i < list2.size(); ++i) {
                list4.add(null);
            }
            genPolynomial = this.red.normalform(list4, list2, genPolynomial9);
            if (!genPolynomial.isZERO()) {
                logger.error("nonzero H = " + genPolynomial);
            }
            arrayList.add(list4);
        }
        extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
        if (debug) {
            logger.info("exgb nonmin = " + extendedGB);
            boolean bl3 = this.isReductionMatrix(extendedGB);
            logger.info("exgb t2 = " + bl3);
        }
        return extendedGB;
    }
}

