/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import userinterface.GUIPlugin;
import userinterface.model.GUIModelEditor;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.GUITextModelEditor;
import userinterface.util.GUIComputationEvent;

public class LoadPRISMModelThread
extends Thread {
    private GUIMultiModelHandler handler;
    private GUIModelEditor edit;
    private File f;
    private boolean reload;
    private GUIPlugin plug;
    private GUITextModelEditor textEdit;
    private boolean replace;
    private Exception ex;

    public LoadPRISMModelThread(GUIMultiModelHandler gUIMultiModelHandler, GUIModelEditor gUIModelEditor, File file, boolean bl) {
        this.handler = gUIMultiModelHandler;
        this.edit = gUIModelEditor;
        this.f = file;
        this.reload = bl;
        this.plug = gUIMultiModelHandler.getGUIPlugin();
        this.replace = false;
        this.ex = null;
    }

    @Override
    public void run() {
        if (this.edit instanceof GUITextModelEditor) {
            this.textEdit = (GUITextModelEditor)this.edit;
            this.replace = false;
        } else {
            this.textEdit = new GUITextModelEditor("", this.handler);
            this.replace = true;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        LoadPRISMModelThread.this.plug.startProgress();
                        LoadPRISMModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, LoadPRISMModelThread.this.plug));
                        LoadPRISMModelThread.this.plug.setTaskBarText("Loading model...");
                        LoadPRISMModelThread.this.textEdit.read(new FileReader(LoadPRISMModelThread.this.f), LoadPRISMModelThread.this.f);
                    }
                    catch (IOException iOException) {
                        LoadPRISMModelThread.this.ex = iOException;
                    }
                }
            });
            if (this.ex != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LoadPRISMModelThread.this.plug.stopProgress();
                        LoadPRISMModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, LoadPRISMModelThread.this.plug));
                        LoadPRISMModelThread.this.plug.setTaskBarText("Loading model... error.");
                        LoadPRISMModelThread.this.plug.error("Could not open file \"" + String.valueOf(LoadPRISMModelThread.this.f) + "\"");
                    }
                });
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LoadPRISMModelThread.this.plug.stopProgress();
                    LoadPRISMModelThread.this.plug.setTaskBarText("Loading model... done.");
                    LoadPRISMModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, LoadPRISMModelThread.this.plug));
                    if (!LoadPRISMModelThread.this.reload) {
                        LoadPRISMModelThread.this.handler.prismModelLoaded(LoadPRISMModelThread.this.textEdit, LoadPRISMModelThread.this.f, LoadPRISMModelThread.this.replace);
                    } else {
                        LoadPRISMModelThread.this.handler.prismModelReLoaded(LoadPRISMModelThread.this.f);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

