/*
 * Decompiled with CFR 0.152.
 */
package symbolic.model;

import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.PrismException;

public class ModelVariablesDD {
    private Vector<String> ddVarNames = new Vector();
    private JDDVars ddVariables = new JDDVars();
    private int nextDDVarIndex = 0;
    private JDDVars extraStateVariables = new JDDVars();
    private JDDVars extraActionVariables = new JDDVars();

    public ModelVariablesDD copy() {
        ModelVariablesDD modelVariablesDD = new ModelVariablesDD();
        modelVariablesDD.ddVarNames = new Vector<String>(this.ddVarNames);
        modelVariablesDD.ddVariables = this.ddVariables.copy();
        modelVariablesDD.extraStateVariables = this.extraStateVariables.copy();
        modelVariablesDD.extraActionVariables = this.extraActionVariables.copy();
        modelVariablesDD.nextDDVarIndex = this.nextDDVarIndex;
        return modelVariablesDD;
    }

    public void clear() {
        this.ddVariables.derefAll();
        this.extraStateVariables.derefAll();
        this.extraActionVariables.derefAll();
    }

    public Vector<String> getDDVarNames() {
        return this.ddVarNames;
    }

    public JDDNode allocateVariable(String string) {
        JDDNode jDDNode = JDD.Var(this.nextDDVarIndex);
        ++this.nextDDVarIndex;
        this.ddVariables.addVar(jDDNode.copy());
        this.ddVarNames.add(string);
        return jDDNode;
    }

    public void preallocateExtraStateVariables(int n) {
        for (int i = 0; i < n; ++i) {
            JDDNode jDDNode = this.allocateVariable("");
            this.extraStateVariables.addVar(jDDNode);
        }
    }

    public JDDNode allocateExtraStateVariable(String string) {
        JDDNode jDDNode;
        if (this.extraStateVariables.getNumVars() > 0) {
            jDDNode = this.extraStateVariables.getVar(0);
            this.extraStateVariables.removeVar(jDDNode);
            this.ddVarNames.set(jDDNode.getIndex(), string);
        } else {
            jDDNode = this.allocateVariable(string);
        }
        return jDDNode;
    }

    public boolean canPrependExtraStateVariable(int n) {
        return n * 2 <= this.extraStateVariables.getNumVars();
    }

    public JDDVars allocateExtraStateVariable(int n, String string, boolean bl) throws PrismException {
        int n2 = 2 * n;
        JDDVars jDDVars = new JDDVars();
        if (n2 == 0) {
            return jDDVars;
        }
        if (bl) {
            if (!this.canPrependExtraStateVariable(n)) {
                throw new PrismException("Can not prepend " + n2 + " extra row/col variables");
            }
            int n3 = this.extraStateVariables.getNumVars() - n2;
            for (int i = 0; i < n; ++i) {
                JDDNode jDDNode = this.extraStateVariables.getVar(n3++);
                JDDNode jDDNode2 = this.extraStateVariables.getVar(n3++);
                jDDVars.addVar(jDDNode);
                jDDVars.addVar(jDDNode2);
                this.ddVarNames.set(jDDNode.getIndex(), string + "." + i);
                this.ddVarNames.set(jDDNode2.getIndex(), string + "'." + i);
            }
            this.extraStateVariables.removeVars(jDDVars);
            return jDDVars;
        }
        for (int i = 0; i < n; ++i) {
            jDDVars.addVar(this.allocateVariable(string + "." + i));
            jDDVars.addVar(this.allocateVariable(string + "'." + i));
        }
        return jDDVars;
    }

    public void preallocateExtraActionVariables(int n) {
        for (int i = 0; i < n; ++i) {
            JDDNode jDDNode = this.allocateVariable("");
            this.extraActionVariables.addVar(jDDNode);
        }
    }

    public JDDVars allocateExtraActionVariable(int n, String string) throws PrismException {
        JDDVars jDDVars = new JDDVars();
        if (n == 0) {
            return jDDVars;
        }
        if (this.extraActionVariables.getNumVars() < n) {
            throw new PrismException("Not enough extra action variables preallocated, please increase using -ddextraactionvars switch!");
        }
        int n2 = this.extraActionVariables.getNumVars() - n;
        for (int i = 0; i < n; ++i) {
            JDDNode jDDNode = this.extraActionVariables.getVar(n2++);
            jDDVars.addVar(jDDNode);
            this.ddVarNames.set(jDDNode.getIndex(), string + "." + i);
        }
        this.extraActionVariables.removeVars(jDDVars);
        return jDDVars;
    }

    public JDDVars getExtraStateVariables() {
        return this.extraStateVariables;
    }

    public JDDVars getExtraActionVariables() {
        return this.extraActionVariables;
    }
}

