/*
 * Decompiled with CFR 0.152.
 */
package symbolic.model;

import io.ModelExportOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import odd.ODDUtils;
import parser.State;
import parser.Values;
import parser.VarList;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import symbolic.model.ModelVariablesDD;
import symbolic.states.StateList;
import symbolic.states.StateListMTBDD;

public interface Model
extends prism.Model<Double> {
    public JDDNode getStart();

    default public StateList getStartStates() {
        return new StateListMTBDD(this.getStart(), this);
    }

    public JDDNode getDeadlocks();

    default public StateList getDeadlockStates() {
        return new StateListMTBDD(this.getDeadlocks(), this);
    }

    public JDDNode getReach();

    public ODDNode getODD();

    default public StateList getReachableStates() {
        return new StateListMTBDD(this.getReach(), this);
    }

    public JDDNode getTrans();

    public JDDNode getTrans01();

    public JDDNode getTransReln();

    public VarList getVarList();

    public Values getConstantValues();

    public List<String> getSynchs();

    public JDDNode getLabelDD(String var1);

    default public boolean hasLabelDD(String string) {
        return this.getLabels().contains(string);
    }

    public Set<String> getLabels();

    public int getNumRewardStructs();

    public String getRewardStructName(int var1);

    public JDDNode getStateRewards(int var1);

    public JDDNode getStateRewards(String var1);

    default public JDDNode getStateRewards() {
        return this.getStateRewards(0);
    }

    public JDDNode getTransRewards(int var1);

    public JDDNode getTransRewards(String var1);

    default public JDDNode getTransRewards() {
        return this.getTransRewards(0);
    }

    public ModelVariablesDD getModelVariables();

    default public Vector<String> getDDVarNames() {
        return this.getModelVariables().getDDVarNames();
    }

    public JDDVars getAllDDRowVars();

    public JDDVars getAllDDColVars();

    default public int getNumDDRowVars() {
        return this.getAllDDRowVars().n();
    }

    default public int getNumDDColVars() {
        return this.getAllDDColVars().n();
    }

    public int getNumDDVarsInTrans();

    public JDDVars[] getVarDDRowVars();

    public JDDVars[] getVarDDColVars();

    public JDDVars getVarDDRowVars(int var1);

    public JDDVars getVarDDColVars(int var1);

    default public void printTransInfo(PrismLog prismLog) {
        this.printTransInfo(prismLog, false);
    }

    public void printTransInfo(PrismLog var1, boolean var2);

    public String getTransDDVarSummary();

    public String getTransDDVarInfo();

    default public void exportToFile(int n, boolean bl, File file) throws FileNotFoundException, PrismException {
        this.exportToFile(n, bl, file, 16);
    }

    public void exportToFile(int var1, boolean var2, File var3, int var4) throws FileNotFoundException, PrismException;

    public void exportToFile(File var1, ModelExportOptions var2) throws FileNotFoundException, PrismException;

    default public void exportStateRewardsToFile(int n, int n2, File file) throws FileNotFoundException, PrismException {
        this.exportStateRewardsToFile(n, n2, file, 16, false);
    }

    public void exportStateRewardsToFile(int var1, int var2, File var3, int var4, boolean var5) throws FileNotFoundException, PrismException;

    public void exportStateRewardsToFile(int var1, File var2, ModelExportOptions var3) throws FileNotFoundException, PrismException;

    default public void exportTransRewardsToFile(int n, int n2, boolean bl, File file) throws FileNotFoundException, PrismException {
        this.exportTransRewardsToFile(n, n2, bl, file, 16, false);
    }

    public void exportTransRewardsToFile(int var1, int var2, boolean var3, File var4, int var5, boolean var6) throws FileNotFoundException, PrismException;

    public void exportTransRewardsToFile(int var1, File var2, ModelExportOptions var3) throws FileNotFoundException, PrismException;

    public void exportStates(int var1, PrismLog var2);

    default public State convertBddToState(JDDNode jDDNode) {
        return Model.convertBddToState(jDDNode, this.getAllDDRowVars(), this.getVarList());
    }

    public static State convertBddToState(JDDNode jDDNode, JDDVars jDDVars, VarList varList) {
        JDDNode jDDNode2 = jDDNode;
        int n = jDDVars.n();
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (jDDNode2.getIndex() > jDDVars.getVarIndex(i)) continue;
            if (!jDDNode2.getElse().equals(JDD.ZERO)) {
                jDDNode2 = jDDNode2.getElse();
                continue;
            }
            bitSet.set(i, true);
            jDDNode2 = jDDNode2.getThen();
        }
        return varList.convertBitSetToState(bitSet);
    }

    default public int convertBddToIndex(JDDNode jDDNode) throws PrismNotSupportedException {
        ODDNode oDDNode = this.getODD();
        ODDUtils.checkInt(oDDNode, "Cannot convert Bdd to index in model");
        JDDVars jDDVars = this.getAllDDRowVars();
        JDDNode jDDNode2 = jDDNode;
        ODDNode oDDNode2 = oDDNode;
        int n = jDDVars.n();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (jDDNode2.getIndex() > jDDVars.getVarIndex(i)) {
                oDDNode2 = oDDNode2.getElse();
                continue;
            }
            if (!jDDNode2.getElse().equals(JDD.ZERO)) {
                jDDNode2 = jDDNode2.getElse();
                oDDNode2 = oDDNode2.getElse();
                continue;
            }
            jDDNode2 = jDDNode2.getThen();
            n2 = (int)((long)n2 + oDDNode2.getEOff());
            oDDNode2 = oDDNode2.getThen();
        }
        return n2;
    }

    public String getTransName();

    public String getTransSymbol();

    public void clear();

    default public int getNumVars() {
        return this.getVarList().getNumVars();
    }

    default public String getVarName(int n) {
        return this.getVarList().getName(n);
    }

    default public int getVarIndex(String string) {
        return this.getVarList().getIndex(string);
    }

    default public int getVarLow(int n) {
        return this.getVarList().getLow(n);
    }

    default public int getVarHigh(int n) {
        return this.getVarList().getHigh(n);
    }

    default public int getVarRange(int n) {
        return this.getVarList().getRange(n);
    }
}

