/*
 * Decompiled with CFR 0.152.
 */
package strat;

import explicit.ConstructInducedModel;
import explicit.Distribution;
import explicit.DistributionOver;
import explicit.NondetModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import parser.State;
import prism.Model;
import prism.PrismException;
import prism.PrismLog;
import strat.Strategy;
import strat.StrategyExplicit;
import strat.StrategyExportOptions;

public class MRStrategy<Value>
extends StrategyExplicit<Value> {
    protected List<Distribution<Value>> choiceProbs;

    public MRStrategy(NondetModel<Value> nondetModel) {
        super(nondetModel);
        int n = nondetModel.getNumStates();
        this.choiceProbs = new ArrayList<Distribution<Value>>(n);
        for (int i = 0; i < n; ++i) {
            this.choiceProbs.add(new Distribution(nondetModel.getEvaluator()));
        }
    }

    public void setChoiceProbability(int n, int n2, Value Value2) {
        this.choiceProbs.get(n).set(n2, Value2);
    }

    @Override
    public boolean isRandomised() {
        return true;
    }

    @Override
    public Object getChoiceAction(int n, int n3) {
        Distribution<Value> distribution = this.choiceProbs.get(n);
        return distribution.isEmpty() ? Strategy.UNDEFINED : DistributionOver.create(distribution, n2 -> this.model.getAction(n, (int)n2));
    }

    @Override
    public int getChoiceIndex(int n, int n2) {
        return -1;
    }

    @Override
    public explicit.Model<Value> constructInducedModel(StrategyExportOptions strategyExportOptions) throws PrismException {
        ConstructInducedModel constructInducedModel = new ConstructInducedModel();
        constructInducedModel.setMode(strategyExportOptions.getMode()).setReachOnly(strategyExportOptions.getReachOnly());
        explicit.Model model = constructInducedModel.constructInducedModel(this.model, this);
        return model;
    }

    @Override
    public void exportActions(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        List<State> list = this.model.getStatesList();
        boolean bl = strategyExportOptions.getShowStates() && list != null;
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            Object object = this.getChoiceAction(i, -1);
            if (object == UNDEFINED) continue;
            prismLog.println(String.valueOf(bl ? (Serializable)list.get(i) : Integer.valueOf(i)) + "=" + String.valueOf(object));
        }
    }

    @Override
    public void exportIndices(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        List<State> list = this.model.getStatesList();
        boolean bl = strategyExportOptions.getShowStates() && list != null;
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            Distribution<Value> distribution = this.choiceProbs.get(i);
            if (distribution.isEmpty()) continue;
            prismLog.println(String.valueOf(bl ? (Serializable)list.get(i) : Integer.valueOf(i)) + "=" + String.valueOf(distribution));
        }
    }

    @Override
    public void exportInducedModel(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        Model model = this.constructInducedModel(strategyExportOptions);
        model.exportToPrismExplicitTra(prismLog, strategyExportOptions.getModelPrecision());
    }

    @Override
    public void exportDotFile(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        Model model = this.constructInducedModel(strategyExportOptions);
        model.exportToDotFile(prismLog, null, strategyExportOptions.getShowStates(), strategyExportOptions.getModelPrecision());
    }

    @Override
    public void clear() {
        this.choiceProbs = null;
    }

    public String toString() {
        return "[" + IntStream.range(0, this.getNumStates()).mapToObj(n -> n + "=" + this.getChoiceActionString(n, -1)).collect(Collectors.joining(",")) + "]";
    }
}

