/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import settings.Setting;
import settings.SettingDisplay;
import settings.SettingEditor;
import settings.SettingException;
import settings.SettingOwner;
import settings.TableResizer;

public class SettingTable
extends JPanel
implements ListSelectionListener,
TableModelListener,
ItemListener,
SettingDisplay {
    private Component parent;
    private SettingTableModel theModel;
    private int lineWidth;
    private boolean shouldRemove;
    JLabel commentLabel;
    JTextArea commentText;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneCommentText;
    JComboBox theCombo;
    JTable theTable;
    JPanel topPanel;

    public SettingTable(Component component) {
        this.parent = component;
        this.theModel = new SettingTableModel();
        this.initComponents();
        this.theModel.setJTable(this.theTable);
        this.theModel.addTableModelListener(this);
        this.lineWidth = this.theTable.getRowHeight();
        this.theTable.setModel(this.theModel);
        this.theTable.setRowSelectionAllowed(false);
        this.theTable.setColumnSelectionAllowed(false);
        this.theTable.getSelectionModel().addListSelectionListener(this);
        this.theTable.setAutoResizeMode(3);
        this.theCombo.setModel(this.theModel.getComboModel());
        this.theCombo.addItemListener(this);
        this.theTable.setSurrendersFocusOnKeystroke(true);
        this.theTable.getColumnModel().getColumn(0).setMinWidth(30);
        this.theTable.setRequestFocusEnabled(false);
        TableColumn tableColumn = this.theTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new SettingCellRenderer());
        tableColumn.setCellEditor(new SettingCellEditor());
        TableResizer tableResizer = new TableResizer(this.theTable);
        this.theTable.addMouseListener(tableResizer);
        this.theTable.addMouseMotionListener(tableResizer);
        this.doChoiceBox();
        this.commentLabel.setFont(new Font("serif", 1, 12));
        this.shouldRemove = true;
    }

    public void setOwners(ArrayList arrayList) {
        this.theModel.setOwners(arrayList);
    }

    public void refreshGroupNames() {
        this.theModel.refreshGroupNames();
    }

    public void setNameColumnWidth(int n) {
    }

    private void doChoiceBox() {
        if (this.theModel.getNumGroups() == 0) {
            this.topPanel.removeAll();
            JLabel jLabel = new JLabel("");
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.add((Component)jLabel, "Center");
        } else if (this.theModel.getNumGroups() == 1) {
            this.topPanel.removeAll();
            JLabel jLabel = new JLabel(this.theCombo.getModel().getElementAt(0).toString());
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.add((Component)jLabel, "Center");
        } else {
            this.topPanel.removeAll();
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.add((Component)this.theCombo, "Center");
        }
        this.revalidate();
    }

    public void stopEditing() {
        if (this.theTable.getCellEditor() != null) {
            this.theTable.getCellEditor().stopCellEditing();
            this.theTable.removeEditor();
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JSplitPane jSplitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.getViewport().setBackground(Color.white);
        this.theTable = new JTable(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                TableCellEditor tableCellEditor = this.getCellEditor();
                if (tableCellEditor != null) {
                    Object object = tableCellEditor.getCellEditorValue();
                    this.setValueAt(object, this.editingRow, this.editingColumn);
                    if (SettingTable.this.shouldRemove) {
                        this.removeEditor();
                        this.getSelectionModel().setSelectionInterval(this.editingRow, this.editingRow);
                        this.getColumnModel().getSelectionModel().setSelectionInterval(this.editingColumn, this.editingColumn);
                    } else {
                        this.getSelectionModel().setSelectionInterval(this.editingRow, this.editingRow);
                        this.getColumnModel().getSelectionModel().setSelectionInterval(this.editingColumn, this.editingColumn);
                    }
                    SettingTable.this.shouldRemove = false;
                }
            }

            @Override
            protected void configureEnclosingScrollPane() {
                Container container;
                Container container2 = this.getParent();
                if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)container;
                    JViewport jViewport = jScrollPane.getViewport();
                    if (jViewport == null || jViewport.getView() != this) {
                        return;
                    }
                    jScrollPane.getViewport().setBackingStoreEnabled(true);
                    jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
                }
            }
        };
        this.theTable.setModel(this.theModel);
        this.theTable.setSelectionMode(0);
        this.theTable.setRowSelectionAllowed(false);
        this.theTable.setColumnSelectionAllowed(false);
        this.theTable.setCellSelectionEnabled(true);
        JPanel jPanel2 = new JPanel();
        this.commentText = new JTextArea();
        this.jScrollPaneCommentText = new JScrollPane(this.commentText);
        this.commentLabel = new JLabel();
        this.topPanel = new JPanel();
        this.theCombo = new JComboBox();
        this.setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jSplitPane.setBackground(new Color(255, 255, 255));
        jSplitPane.setBorder(null);
        jSplitPane.setDividerSize(3);
        jSplitPane.setOrientation(0);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setOneTouchExpandable(true);
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setBorder(new LineBorder(SystemColor.textInactiveText));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.theTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.theTable.setDoubleBuffered(true);
        this.theTable.setGridColor(new Color(198, 197, 197));
        this.jScrollPane1.setViewportView(this.theTable);
        jSplitPane.setLeftComponent(this.jScrollPane1);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new LineBorder(SystemColor.inactiveCaption));
        jPanel2.setMinimumSize(new Dimension(10, 75));
        jPanel2.setPreferredSize(new Dimension(100, 75));
        this.commentText.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.commentText.setColumns(1);
        this.commentText.setEditable(false);
        this.commentText.setLineWrap(true);
        this.commentText.setWrapStyleWord(true);
        this.commentText.setBorder(null);
        this.commentText.setDoubleBuffered(true);
        this.commentText.setFocusable(false);
        this.jScrollPaneCommentText.setMinimumSize(new Dimension(100, 75));
        this.jScrollPaneCommentText.setPreferredSize(new Dimension(100, 75));
        this.jScrollPaneCommentText.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneCommentText.setVerticalScrollBarPolicy(20);
        jPanel2.add((Component)this.jScrollPaneCommentText, "Center");
        jPanel2.add((Component)this.commentLabel, "North");
        jSplitPane.setRightComponent(jPanel2);
        jPanel.add((Component)jSplitPane, "Center");
        this.add((Component)jPanel, "Center");
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.theCombo, "North");
        this.add((Component)this.topPanel, "North");
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.theTable != null) {
            this.theTable.setRowHeight(this.getFontMetrics(font).getHeight() + 4);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Setting setting = this.theModel.getSelectedProperty(this.theTable.getSelectedRow());
        if (setting != null) {
            this.commentLabel.setText(setting.getName());
            this.commentText.setText(setting.getComment());
            this.commentText.setCaretPosition(0);
        } else {
            this.commentLabel.setText("");
            this.commentText.setText("");
            this.commentText.setCaretPosition(0);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Setting setting = this.theModel.getSelectedProperty(this.theTable.getSelectedRow());
        if (setting != null) {
            this.commentLabel.setText(setting.getName());
            this.commentText.setText(setting.getComment());
            this.commentText.setCaretPosition(0);
        } else {
            this.commentLabel.setText("");
            this.commentText.setText("");
            this.commentText.setCaretPosition(0);
        }
        this.theCombo.setModel(this.theModel.getComboModel());
        this.doChoiceBox();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.theModel.setCurrentGroup(this.theCombo.getSelectedIndex());
    }

    @Override
    public void redisplaySetting(Setting setting) {
        Setting setting2 = this.theModel.getSelectedProperty(this.theTable.getSelectedRow());
        if (setting2 != null) {
            this.commentLabel.setText(setting2.getName());
            this.commentText.setText(setting2.getComment());
            this.commentText.setCaretPosition(0);
        } else {
            this.commentLabel.setText("");
            this.commentText.setText("");
            this.commentText.setCaretPosition(0);
        }
        this.theModel.fireTableDataChanged();
        this.theTable.repaint();
    }

    public static void printArray(ArrayList arrayList) {
        System.out.print("(");
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.print(String.valueOf(arrayList.get(i)) + " ");
        }
    }

    class SettingTableModel
    extends AbstractTableModel {
        private ArrayList owners;
        private ArrayList groupNames = new ArrayList();
        private ArrayList groupStarts = new ArrayList();
        private ArrayList groupSizes = new ArrayList();
        private int currentGroup;
        private DefaultComboBoxModel comboModel;
        private JTable theTable = null;

        public SettingTableModel() {
            this.owners = new ArrayList();
            this.comboModel = new DefaultComboBoxModel();
        }

        public void setJTable(JTable jTable) {
            this.theTable = jTable;
        }

        public void setOwners(ArrayList arrayList) {
            this.owners = arrayList;
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            SettingOwner settingOwner = null;
            int n = 0;
            Object object = "";
            this.groupNames = new ArrayList();
            this.groupStarts = new ArrayList();
            this.groupSizes = new ArrayList();
            int n2 = 0;
            Object object2 = "";
            while (iterator.hasNext()) {
                SettingOwner settingOwner2 = (SettingOwner)iterator.next();
                if (settingOwner == null) {
                    ++n;
                    if (!settingOwner2.getSettingOwnerName().equals("")) {
                        object2 = (String)object2 + "'" + settingOwner2.getSettingOwnerName() + "'";
                    }
                    object = settingOwner2.getSettingOwnerClassName();
                    this.groupStarts.add(0);
                } else if (settingOwner2.getSettingOwnerID() == settingOwner.getSettingOwnerID()) {
                    ++n;
                    if (!settingOwner2.getSettingOwnerClassName().endsWith("s")) {
                        object = settingOwner2.getSettingOwnerClassName() + "s";
                    }
                    if (!settingOwner2.getSettingOwnerName().equals("")) {
                        object2 = (String)object2 + ", '" + settingOwner2.getSettingOwnerName() + "'";
                    }
                } else {
                    object = (String)object + " " + (String)object2;
                    object2 = "";
                    this.groupNames.add(object);
                    this.groupSizes.add(n);
                    n = 0;
                    ++n;
                    object2 = (String)object2 + "'" + settingOwner2.getSettingOwnerName() + "'";
                    if (!settingOwner2.getSettingOwnerName().equals("")) {
                        object = settingOwner2.getSettingOwnerClassName() + " '" + settingOwner2.getSettingOwnerName() + "'";
                    }
                    this.groupStarts.add(n2);
                }
                settingOwner = settingOwner2;
                ++n2;
            }
            if (arrayList.size() != 0) {
                object = (String)object + " " + (String)object2;
                this.groupNames.add(object);
                this.groupSizes.add(n);
            }
            if (this.currentGroup > arrayList.size() - 1) {
                this.currentGroup = 0;
            }
            this.comboModel = new DefaultComboBoxModel<Object>(this.groupNames.toArray());
            this.fireTableDataChanged();
        }

        public void refreshGroupNames() {
            Iterator iterator = this.owners.iterator();
            SettingOwner settingOwner = null;
            int n = 0;
            Object object = "";
            this.groupNames = new ArrayList();
            int n2 = 0;
            Object object2 = "";
            while (iterator.hasNext()) {
                SettingOwner settingOwner2 = (SettingOwner)iterator.next();
                if (settingOwner == null) {
                    ++n;
                    if (!settingOwner2.getSettingOwnerName().equals("")) {
                        object2 = (String)object2 + "'" + settingOwner2.getSettingOwnerName() + "'";
                    }
                    object = settingOwner2.getSettingOwnerClassName();
                } else if (settingOwner2.getSettingOwnerID() == settingOwner.getSettingOwnerID()) {
                    ++n;
                    if (!settingOwner2.getSettingOwnerClassName().endsWith("s")) {
                        object = settingOwner2.getSettingOwnerClassName() + "s";
                    }
                    if (!settingOwner2.getSettingOwnerName().equals("")) {
                        object2 = (String)object2 + ", '" + settingOwner2.getSettingOwnerName() + "'";
                    }
                } else {
                    object = (String)object + " " + (String)object2;
                    object2 = "";
                    this.groupNames.add(object);
                    n = 0;
                    ++n;
                    object2 = (String)object2 + "'" + settingOwner2.getSettingOwnerName() + "'";
                    if (!settingOwner2.getSettingOwnerName().equals("")) {
                        object = settingOwner2.getSettingOwnerClassName() + " '" + settingOwner2.getSettingOwnerName() + "'";
                    }
                }
                settingOwner = settingOwner2;
                ++n2;
            }
            if (this.owners.size() != 0) {
                object = (String)object + " " + (String)object2;
                this.groupNames.add(object);
            }
            this.comboModel = new DefaultComboBoxModel<Object>(this.groupNames.toArray());
            this.fireTableDataChanged();
        }

        public String getGroupName(int n) {
            return (String)this.groupNames.get(n);
        }

        public int getNumGroupNames() {
            return this.groupNames.size();
        }

        @Override
        public int getRowCount() {
            if (this.groupNames.size() == 0) {
                return 0;
            }
            SettingOwner settingOwner = (SettingOwner)this.owners.get((Integer)this.groupStarts.get(this.currentGroup));
            return settingOwner.getNumSettings();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Property";
            }
            return "Value";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                SettingOwner settingOwner = (SettingOwner)this.owners.get((Integer)this.groupStarts.get(this.currentGroup));
                return settingOwner.getSetting(n).getName();
            }
            if (this.getCurrentGroupSize() == 1) {
                SettingOwner settingOwner = this.getOwner(this.getCurrentGroupStart());
                return settingOwner.getSetting(n);
            }
            ArrayList<Setting> arrayList = new ArrayList<Setting>();
            for (int i = this.getCurrentGroupStart(); i < this.getCurrentGroupStart() + this.getCurrentGroupSize(); ++i) {
                SettingOwner settingOwner = this.getOwner(i);
                arrayList.add(settingOwner.getSetting(n));
            }
            return arrayList;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            return this.getSelectedProperty(n).isEnabled();
        }

        public Setting getSelectedProperty(int n) {
            if (n < 0) {
                return null;
            }
            SettingOwner settingOwner = this.getOwner(this.getCurrentGroupStart());
            return settingOwner.getSetting(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            try {
                if (n2 == 1) {
                    if (this.getCurrentGroupSize() == 1) {
                        SettingOwner settingOwner = this.getOwner(this.getCurrentGroupStart());
                        if (!object.equals("$%^&*NOTCHANGED*&^%$")) {
                            settingOwner.getSetting(n).editValue(object);
                        }
                    } else {
                        for (int i = this.getCurrentGroupStart(); i < this.getCurrentGroupStart() + this.getCurrentGroupSize(); ++i) {
                            SettingOwner settingOwner = this.getOwner(i);
                            if (object.equals("$%^&*NOTCHANGED*&^%$")) continue;
                            settingOwner.getSetting(n).editValue(object);
                        }
                    }
                }
                SettingTable.this.shouldRemove = true;
            }
            catch (SettingException settingException) {
                String string = object instanceof SettingException ? ((SettingException)object).getMessage() : settingException.getMessage();
                JOptionPane.showMessageDialog(SettingTable.this.parent, string, "Error", 0);
                SettingTable.this.shouldRemove = false;
            }
        }

        public int getCurrentGroup() {
            return this.currentGroup;
        }

        protected int getCurrentGroupSize() {
            return (Integer)this.groupSizes.get(this.currentGroup);
        }

        protected int getCurrentGroupStart() {
            return (Integer)this.groupStarts.get(this.currentGroup);
        }

        protected String getCurrentGroupName() {
            return (String)this.groupNames.get(this.currentGroup);
        }

        protected SettingOwner getOwner(int n) {
            return (SettingOwner)this.owners.get(n);
        }

        public int getNumGroups() {
            return this.groupNames.size();
        }

        public void setCurrentGroup(int n) {
            this.currentGroup = n;
            this.fireTableDataChanged();
        }

        public DefaultComboBoxModel getComboModel() {
            return this.comboModel;
        }
    }

    class SettingCellRenderer
    implements TableCellRenderer {
        SettingCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Setting) {
                Setting setting = (Setting)object;
                return setting.getSettingRenderer().getTableCellRendererComponent(jTable, setting, setting.getValue(), bl, bl2, setting.isEnabled(), n, n2);
            }
            if (object instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)object;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                boolean bl3 = true;
                Setting setting = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!(arrayList.get(i) instanceof Setting)) continue;
                    Setting setting2 = (Setting)arrayList.get(i);
                    if (i == 0) {
                        setting = setting2;
                    }
                    if (!setting2.isEnabled()) {
                        bl3 = false;
                    }
                    arrayList2.add(setting2.getValue());
                }
                if (setting != null) {
                    return setting.getSettingRenderer().getTableCellRendererComponent(jTable, setting, arrayList2, bl, bl2, bl3, n, n2);
                }
                return new JLabel("ERRORRRRR!!!!");
            }
            return new JLabel("ERRRORRRRRR!!!!");
        }
    }

    class SettingCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private SettingEditor currentEditor;

        SettingCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            try {
                return this.currentEditor.getEditorValue();
            }
            catch (SettingException settingException) {
                return settingException;
            }
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return SettingTable.this.shouldRemove;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof Setting) {
                Setting setting = (Setting)object;
                this.currentEditor = setting.getSettingEditor();
                return this.currentEditor.getTableCellEditorComponent(jTable, setting, setting.getValue(), bl, n, n2);
            }
            if (object instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)object;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                boolean bl2 = true;
                Setting setting = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!(arrayList.get(i) instanceof Setting)) continue;
                    Setting setting2 = (Setting)arrayList.get(i);
                    if (i == 0) {
                        setting = setting2;
                    }
                    if (!setting2.isEnabled()) {
                        bl2 = false;
                    }
                    arrayList2.add(setting2.getValue());
                }
                if (setting != null) {
                    this.currentEditor = setting.getSettingEditor();
                    return this.currentEditor.getTableCellEditorComponent(jTable, setting, arrayList2, bl, n, n2);
                }
                return new JLabel("ERRORRRRR!!!!");
            }
            return new JLabel("NEVER!!!!");
        }
    }
}

