/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import parser.PrismParser;
import parser.PrismParserTokenManager;
import parser.Token;
import prism.Prism;
import prism.PrismLangException;

public class PrismSyntaxHighlighter {
    public static final int PUNCTUATION = 0;
    public static final int COMMENT = 1;
    public static final int WHITESPACE = 2;
    public static final int KEYWORD = 3;
    public static final int NUMERIC = 4;
    public static final int IDENTIFIER = 5;
    public static final int PREPROC = 6;
    public static final int EOF = 100;
    private static final int ECHO = 0;
    private static final int HTML = 1;
    private static final int LATEX = 2;
    private static final int PRISMGUI = 3;
    private static final ArrayList<String> puncReplaceTo_ECHO;
    private static final ArrayList<String> puncReplaceFrom_ECHO;
    private static final ArrayList<String> puncReplaceTo_HTML;
    private static final ArrayList<String> puncReplaceFrom_HTML;
    private static final ArrayList<String> puncReplaceTo_LATEX;
    private static final ArrayList<String> puncReplaceFrom_LATEX;
    private static final ArrayList<String> puncReplaceTo_LATEXMATHS;
    private static final ArrayList<String> puncReplaceFrom_LATEXMATHS;
    private static final ArrayList<String> puncReplaceTo_PRISMGUI;
    private static final ArrayList<String> puncReplaceFrom_PRISMGUI;
    private static int quoteAlternator;
    private static StringBuffer resStringBuffer;
    private static int resNewLine;
    private static boolean resStart;
    private static int[] resTypeArray;
    private static int resCharCount;

    public static String echoFile(File file) throws FileNotFoundException, PrismLangException {
        resStringBuffer = new StringBuffer();
        PrismSyntaxHighlighter.highlight(new FileInputStream(file), 0);
        return resStringBuffer.toString();
    }

    public static String echoFile(InputStream inputStream) throws PrismLangException {
        resStringBuffer = new StringBuffer();
        PrismSyntaxHighlighter.highlight(inputStream, 0);
        return resStringBuffer.toString();
    }

    public static String lineToHtml(String string) throws PrismLangException {
        resStringBuffer = new StringBuffer();
        PrismSyntaxHighlighter.highlight(new ByteArrayInputStream(string.getBytes()), 1);
        return resStringBuffer.toString();
    }

    public static String fileToHtml(File file, boolean bl, String string) throws FileNotFoundException, PrismLangException {
        resStringBuffer = new StringBuffer();
        if (bl) {
            resStringBuffer.append(PrismSyntaxHighlighter.htmlFileHeader(file.getName(), string));
        }
        PrismSyntaxHighlighter.highlight(new FileInputStream(file), 1);
        if (bl) {
            resStringBuffer.append(PrismSyntaxHighlighter.htmlFileFooter());
        }
        return resStringBuffer.toString();
    }

    public static String fileToHtml(InputStream inputStream, boolean bl, String string) throws PrismLangException {
        resStringBuffer = new StringBuffer();
        if (bl) {
            resStringBuffer.append(PrismSyntaxHighlighter.htmlFileHeader("PRISM Code", string));
        }
        PrismSyntaxHighlighter.highlight(inputStream, 1);
        if (bl) {
            resStringBuffer.append(PrismSyntaxHighlighter.htmlFileFooter());
        }
        return resStringBuffer.toString();
    }

    public static String fileToLatex(File file, boolean bl) throws FileNotFoundException, PrismLangException {
        resStringBuffer = new StringBuffer();
        resNewLine = 1;
        resStart = true;
        if (bl) {
            resStringBuffer.append(PrismSyntaxHighlighter.latexFileHeader(file.getName()));
        }
        PrismSyntaxHighlighter.highlight(new FileInputStream(file), 2);
        if (bl) {
            resStringBuffer.append(PrismSyntaxHighlighter.latexFileFooter());
        }
        return resStringBuffer.toString();
    }

    public static String fileToLatex(InputStream inputStream, boolean bl) throws PrismLangException {
        resStringBuffer = new StringBuffer();
        resNewLine = 1;
        resStart = true;
        if (bl) {
            resStringBuffer.append(PrismSyntaxHighlighter.latexFileHeader("PRISM Code"));
        }
        PrismSyntaxHighlighter.highlight(inputStream, 2);
        if (bl) {
            resStringBuffer.append(PrismSyntaxHighlighter.latexFileFooter());
        }
        return resStringBuffer.toString();
    }

    public static int[] lineForPrismGUI(String string) throws PrismLangException {
        resTypeArray = new int[string.length()];
        resCharCount = 0;
        PrismSyntaxHighlighter.highlight(new ByteArrayInputStream(string.getBytes()), 3);
        return resTypeArray;
    }

    private static String htmlFileHeader(String string, String string2) {
        Object object = "";
        object = (String)object + "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n";
        object = (String)object + "\"http://www.w3.org/TR/html4/loose.dtd\">\n";
        object = (String)object + "<html>\n";
        object = (String)object + "<head>\n";
        object = (String)object + "<title>\n";
        object = (String)object + string + "\n";
        object = (String)object + "</title>\n";
        object = (String)object + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n";
        object = (String)object + "<!-- Style sheet \"prism.css\" can be found in the \"etc\" directory of the PRISM distribution -->\n";
        object = (String)object + "<link type=\"text/css\" rel=\"stylesheet\" href=\"" + string2 + "\">\n";
        object = (String)object + "</head>\n";
        object = (String)object + "<body text=\"#000000\" bgcolor=\"#ffffff\">\n";
        object = (String)object + "<pre>\n";
        return object;
    }

    private static String htmlFileFooter() {
        Object object = "";
        object = (String)object + "</pre>\n";
        object = (String)object + "</body>\n";
        object = (String)object + "</html>\n";
        return object;
    }

    private static String latexFileHeader(String string) {
        Object object = "";
        object = (String)object + "\\centering\n";
        object = (String)object + "{\\scriptsize\n";
        object = (String)object + "\\fbox{\\begin{minipage}{6in}\n";
        object = (String)object + "\\begin{tabbing}\n";
        return object;
    }

    private static String latexFileFooter() {
        Object object = "";
        object = (String)object + "\\end{tabbing}\n";
        object = (String)object + "\\end{minipage}}}\n";
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void highlight(InputStream inputStream, int n) throws PrismLangException {
        boolean bl = false;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                Token token;
                PrismParser.ReInit(inputStream);
                PrismParserTokenManager prismParserTokenManager = PrismParser.token_source;
                Token token2 = token = prismParserTokenManager.getNextToken();
                while (token != null && token.kind != 0) {
                    token = token.next = prismParserTokenManager.getNextToken();
                }
                token = token2;
                while (!bl) {
                    if (token == null) {
                        bl = true;
                        continue;
                    }
                    if (token.kind == 0) {
                        bl = true;
                    }
                    if (token.kind == 119) {
                        String string = "Lexical error (\"" + token.image + "\", line " + token.beginLine + ", column " + token.beginColumn + ")";
                        throw new PrismLangException(string);
                    }
                    if (token.specialToken != null) {
                        Token token3 = token.specialToken;
                        while (token3.specialToken != null) {
                            token3 = token3.specialToken;
                        }
                        while (token3 != null) {
                            if (token3.kind == 2) {
                                PrismSyntaxHighlighter.output(token3.image, 1, n);
                            } else {
                                PrismSyntaxHighlighter.output(token3.image, 2, n);
                            }
                            token3 = token3.next;
                        }
                    }
                    if (token.kind == 0) {
                        PrismSyntaxHighlighter.output(token.image, 100, n);
                        continue;
                    }
                    if (token.kind > 2 && token.kind < 79) {
                        PrismSyntaxHighlighter.output(token.image, 3, n);
                    } else if (token.kind == 114 || token.kind == 115) {
                        PrismSyntaxHighlighter.output(token.image, 4, n);
                    } else if (token.kind == 117 || token.kind == 116) {
                        PrismSyntaxHighlighter.output(token.image, 5, n);
                    } else if (token.kind == 118) {
                        PrismSyntaxHighlighter.output(token.image, 6, n);
                    } else {
                        PrismSyntaxHighlighter.output(token.image, 0, n);
                    }
                    token = token.next;
                }
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void output(String string, int n, int n2) {
        int n3;
        if (n2 == 2 && resNewLine > 0 && (n != 2 || !"\r".equals(string) && !"\n".equals(string))) {
            if (n == 100) {
                resNewLine = 1;
            }
            for (n3 = 0; n3 < resNewLine; ++n3) {
                if (!resStart) {
                    resStringBuffer.append("$}");
                    if (n != 100) {
                        resStringBuffer.append(" \\\\");
                    }
                    resStringBuffer.append("\n");
                }
                if (n != 100) {
                    resStringBuffer.append("\\mbox{$");
                }
                resStart = false;
            }
            resNewLine = 0;
        }
        string = PrismSyntaxHighlighter.replacePunc(string, n, n2);
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 1: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 2: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 3: {
                        int n4 = string.length();
                        for (n3 = 0; n3 < n4; ++n3) {
                            PrismSyntaxHighlighter.resTypeArray[PrismSyntaxHighlighter.resCharCount++] = 0;
                        }
                        return;
                    }
                }
                return;
            }
            case 1: {
                string = string.replaceAll("\r", "");
                switch (n2) {
                    case 0: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 1: {
                        resStringBuffer.append("<span class=\"prismcomment\">" + string.substring(0, string.length() - 1) + "</span>\n");
                        return;
                    }
                    case 2: {
                        resStringBuffer.append("\\prismcomment{" + string.substring(0, string.length() - 1) + "}");
                        ++resNewLine;
                        return;
                    }
                    case 3: {
                        int n5 = string.length();
                        for (n3 = 0; n3 < n5; ++n3) {
                            PrismSyntaxHighlighter.resTypeArray[PrismSyntaxHighlighter.resCharCount++] = 1;
                        }
                        return;
                    }
                }
                return;
            }
            case 2: {
                if ("\r".equals(string)) return;
                switch (n2) {
                    case 0: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 1: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 2: {
                        if ("\n".equals(string)) {
                            ++resNewLine;
                            return;
                        }
                        if (" ".equals(string)) {
                            resStringBuffer.append(" \\; ");
                            return;
                        }
                        if ("\t".equals(string)) {
                            resStringBuffer.append("\\prismtab");
                            return;
                        }
                        resStringBuffer.append(string);
                        return;
                    }
                    case 3: {
                        int n6 = string.length();
                        for (n3 = 0; n3 < n6; ++n3) {
                            PrismSyntaxHighlighter.resTypeArray[PrismSyntaxHighlighter.resCharCount++] = 2;
                        }
                        return;
                    }
                }
                return;
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 1: {
                        resStringBuffer.append("<span class=\"prismkeyword\">" + string + "</span>");
                        return;
                    }
                    case 2: {
                        resStringBuffer.append("\\prismkeyword{" + string + "}");
                        return;
                    }
                    case 3: {
                        int n7 = string.length();
                        for (n3 = 0; n3 < n7; ++n3) {
                            PrismSyntaxHighlighter.resTypeArray[PrismSyntaxHighlighter.resCharCount++] = 3;
                        }
                        return;
                    }
                }
                return;
            }
            case 4: {
                switch (n2) {
                    case 0: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 1: {
                        resStringBuffer.append("<span class=\"prismnum\">" + string + "</span>");
                        return;
                    }
                    case 2: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 3: {
                        int n8 = string.length();
                        for (n3 = 0; n3 < n8; ++n3) {
                            PrismSyntaxHighlighter.resTypeArray[PrismSyntaxHighlighter.resCharCount++] = 4;
                        }
                        return;
                    }
                }
                return;
            }
            case 5: {
                switch (n2) {
                    case 0: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 1: {
                        resStringBuffer.append("<span class=\"prismident\">" + string + "</span>");
                        return;
                    }
                    case 2: {
                        resStringBuffer.append("\\prismident{" + string + "}");
                        return;
                    }
                    case 3: {
                        int n9 = string.length();
                        for (n3 = 0; n3 < n9; ++n3) {
                            PrismSyntaxHighlighter.resTypeArray[PrismSyntaxHighlighter.resCharCount++] = 5;
                        }
                        return;
                    }
                }
                return;
            }
            case 6: {
                switch (n2) {
                    case 0: {
                        resStringBuffer.append(string);
                        return;
                    }
                    case 1: {
                        resStringBuffer.append("<span class=\"prismpreproc\">" + string + "</span>");
                        return;
                    }
                    case 2: {
                        resStringBuffer.append("\\prismpreproc{" + string + "}");
                        return;
                    }
                    case 3: {
                        int n10 = string.length();
                        for (n3 = 0; n3 < n10; ++n3) {
                            PrismSyntaxHighlighter.resTypeArray[PrismSyntaxHighlighter.resCharCount++] = 6;
                        }
                        return;
                    }
                }
                return;
            }
            case 100: {
                switch (n2) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        if (resStringBuffer.length() <= 0 || resStringBuffer.charAt(resStringBuffer.length() - 1) == '\n') return;
                        resStringBuffer.append("$}");
                        break block0;
                    }
                }
            }
        }
    }

    public static String replacePunc(String string, int n, int n2) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        switch (n2) {
            case 0: {
                arrayList2 = puncReplaceTo_ECHO;
                arrayList = puncReplaceFrom_ECHO;
                break;
            }
            case 1: {
                arrayList2 = puncReplaceTo_HTML;
                arrayList = puncReplaceFrom_HTML;
                break;
            }
            case 2: {
                if (n == 1) {
                    arrayList2 = puncReplaceTo_LATEX;
                    arrayList = puncReplaceFrom_LATEX;
                    break;
                }
                arrayList2 = puncReplaceTo_LATEXMATHS;
                arrayList = puncReplaceFrom_LATEXMATHS;
                break;
            }
            case 3: {
                arrayList2 = puncReplaceTo_PRISMGUI;
                arrayList = puncReplaceFrom_PRISMGUI;
                break;
            }
            default: {
                arrayList2 = puncReplaceTo_ECHO;
                arrayList = puncReplaceFrom_ECHO;
            }
        }
        String string2 = string;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            String string3 = arrayList.get(i);
            String string4 = arrayList2.get(i);
            string2 = string2.replaceAll(string3, string4);
        }
        if (n2 == 2 && string.contains("\"")) {
            string2 = string2.replaceAll("\"", quoteAlternator == 1 ? "\\\\mbox{``}" : "\\\\mbox{''}");
            quoteAlternator = 3 - quoteAlternator;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        String string = "prism.css";
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].matches("-.*")) {
                String string2 = stringArray[n].substring(1);
                if (string2.equals("css")) {
                    if (stringArray.length < n + 2) {
                        System.out.print("Error: Missing argument for switch " + stringArray[n]);
                        System.exit(1);
                    }
                    string = stringArray[n + 1];
                    n += 2;
                    continue;
                }
                System.out.print("Error: Unknown switch " + stringArray[n]);
                System.exit(1);
                continue;
            }
            arrayList.add(stringArray[n]);
            ++n;
        }
        if (arrayList.size() == 0) {
            System.out.println("Error: First argument must be output type");
            System.exit(1);
        }
        try {
            if (((String)arrayList.get(0)).equals("echo")) {
                if (arrayList.size() > 1) {
                    System.out.print(PrismSyntaxHighlighter.echoFile(new File((String)arrayList.get(1))));
                } else {
                    System.out.print(PrismSyntaxHighlighter.echoFile(System.in));
                }
            } else if (((String)arrayList.get(0)).equals("html")) {
                if (arrayList.size() > 1) {
                    System.out.print(PrismSyntaxHighlighter.fileToHtml(new File((String)arrayList.get(1)), true, string));
                } else {
                    System.out.print(PrismSyntaxHighlighter.fileToHtml(System.in, false, string));
                }
            } else if (((String)arrayList.get(0)).equals("latex")) {
                if (arrayList.size() > 1) {
                    System.out.print(PrismSyntaxHighlighter.fileToLatex(new File((String)arrayList.get(1)), true));
                } else {
                    System.out.print(PrismSyntaxHighlighter.fileToLatex(System.in, false));
                }
            } else {
                System.out.println("Error: Type must be \"echo\", \"html\" or \"latex\"");
                System.exit(1);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: Could not load file \"" + (String)arrayList.get(1) + "\"");
            System.exit(1);
        }
        catch (PrismLangException prismLangException) {
            System.out.println("Error: " + prismLangException.getMessage());
            System.exit(1);
        }
    }

    static {
        quoteAlternator = 1;
        puncReplaceFrom_ECHO = new ArrayList();
        puncReplaceTo_ECHO = new ArrayList();
        puncReplaceFrom_HTML = new ArrayList();
        puncReplaceTo_HTML = new ArrayList();
        puncReplaceFrom_HTML.add("&");
        puncReplaceTo_HTML.add("&amp;");
        puncReplaceFrom_HTML.add("<");
        puncReplaceTo_HTML.add("&lt;");
        puncReplaceFrom_HTML.add(">");
        puncReplaceTo_HTML.add("&gt;");
        puncReplaceFrom_LATEX = new ArrayList();
        puncReplaceTo_LATEX = new ArrayList();
        puncReplaceFrom_LATEX.add("\\{");
        puncReplaceTo_LATEX.add("\\\\{");
        puncReplaceFrom_LATEX.add("\\}");
        puncReplaceTo_LATEX.add("\\\\}");
        puncReplaceFrom_LATEX.add("&");
        puncReplaceTo_LATEX.add("\\\\&");
        puncReplaceFrom_LATEX.add("_");
        puncReplaceTo_LATEX.add("\\\\_");
        puncReplaceFrom_LATEX.add("%");
        puncReplaceTo_LATEX.add("\\\\%");
        puncReplaceFrom_LATEX.add(">=");
        puncReplaceTo_LATEX.add("\\${\\\\geq}\\$");
        puncReplaceFrom_LATEX.add("<=");
        puncReplaceTo_LATEX.add("\\${\\\\leq}\\$");
        puncReplaceFrom_LATEX.add("->");
        puncReplaceTo_LATEX.add("\\$\\\\rightarrow\\$");
        puncReplaceFrom_LATEX.add("=>");
        puncReplaceTo_LATEX.add("\\$\\\\Rightarrow\\$");
        puncReplaceFrom_LATEX.add("=");
        puncReplaceTo_LATEX.add("\\${=}\\$");
        puncReplaceFrom_LATEX.add(">");
        puncReplaceTo_LATEX.add("\\${>}\\$");
        puncReplaceFrom_LATEX.add("<");
        puncReplaceTo_LATEX.add("\\${<}\\$");
        puncReplaceFrom_LATEX.add("#");
        puncReplaceTo_LATEX.add("\\\\#");
        puncReplaceFrom_LATEXMATHS = new ArrayList();
        puncReplaceTo_LATEXMATHS = new ArrayList();
        puncReplaceFrom_LATEXMATHS.add("\\{");
        puncReplaceTo_LATEXMATHS.add("\\\\{");
        puncReplaceFrom_LATEXMATHS.add("\\}");
        puncReplaceTo_LATEXMATHS.add("\\\\}");
        puncReplaceFrom_LATEXMATHS.add("&");
        puncReplaceTo_LATEXMATHS.add("\\\\&");
        puncReplaceFrom_LATEXMATHS.add("_");
        puncReplaceTo_LATEXMATHS.add("\\\\_");
        puncReplaceFrom_LATEXMATHS.add("%");
        puncReplaceTo_LATEXMATHS.add("\\\\%");
        puncReplaceFrom_LATEXMATHS.add(">=");
        puncReplaceTo_LATEXMATHS.add("{\\\\geq}");
        puncReplaceFrom_LATEXMATHS.add("<=");
        puncReplaceTo_LATEXMATHS.add("{\\\\leq}");
        puncReplaceFrom_LATEXMATHS.add("->");
        puncReplaceTo_LATEXMATHS.add("\\\\rightarrow");
        puncReplaceFrom_LATEXMATHS.add("=>");
        puncReplaceTo_LATEXMATHS.add("\\\\Rightarrow");
        puncReplaceFrom_LATEXMATHS.add("=");
        puncReplaceTo_LATEXMATHS.add("{=}");
        puncReplaceFrom_LATEXMATHS.add(">");
        puncReplaceTo_LATEXMATHS.add("{>}");
        puncReplaceFrom_LATEXMATHS.add("<");
        puncReplaceTo_LATEXMATHS.add("{<}");
        puncReplaceFrom_PRISMGUI = new ArrayList();
        puncReplaceTo_PRISMGUI = new ArrayList();
    }
}

