/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import jltl2ba.MyBitSet;
import jltl2dstar.NBA2DAResult;
import jltl2dstar.SafraTree;
import jltl2dstar.SafraTreeNode;

public class SafraTreeTemplate
implements NBA2DAResult<SafraTree> {
    private SafraTree _safraTree;
    private MyBitSet _renameableNames;
    private MyBitSet _restrictedNames;

    public SafraTreeTemplate(SafraTree safraTree) {
        this._safraTree = safraTree;
        this._renameableNames = new MyBitSet();
        this._restrictedNames = new MyBitSet();
    }

    public SafraTree getSafraTree() {
        return this._safraTree;
    }

    @Override
    public SafraTree getState() {
        return this._safraTree;
    }

    public MyBitSet renameableNames() {
        return this._renameableNames;
    }

    public MyBitSet restrictedNames() {
        return this._restrictedNames;
    }

    public void setRenameable(int n, boolean bl) {
        this._renameableNames.set(n, bl);
    }

    public boolean isRenameable(int n) {
        return this._renameableNames.get(n);
    }

    public void setRestricted(int n, boolean bl) {
        this._restrictedNames.set(n, bl);
    }

    public boolean isRestricted(int n) {
        return this._restrictedNames.get(n);
    }

    public boolean matches(SafraTree safraTree) {
        SafraTreeNode safraTreeNode = this._safraTree.getRootNode();
        SafraTreeNode safraTreeNode2 = safraTree.getRootNode();
        if (safraTreeNode == null || safraTreeNode2 == null) {
            assert (safraTreeNode == null && safraTreeNode2 == null);
            return true;
        }
        return this.matches(safraTreeNode, safraTreeNode2);
    }

    private boolean matches(SafraTreeNode safraTreeNode, SafraTreeNode safraTreeNode2) {
        SafraTreeNode safraTreeNode3;
        assert (safraTreeNode != null && safraTreeNode2 != null);
        if (safraTreeNode == null || safraTreeNode2 == null) {
            return false;
        }
        if (!this.renameableNames().get(safraTreeNode.getID()) ? safraTreeNode2.getID() != safraTreeNode.getID() : this.restrictedNames().get(safraTreeNode2.getID())) {
            return false;
        }
        assert (safraTreeNode.getLabeling().equals(safraTreeNode2.getLabeling()));
        assert (safraTreeNode.hasFinalFlag() == safraTreeNode2.hasFinalFlag());
        SafraTreeNode safraTreeNode4 = safraTreeNode.getOldestChild();
        for (safraTreeNode3 = safraTreeNode2.getOldestChild(); safraTreeNode4 != null && safraTreeNode3 != null; safraTreeNode4 = safraTreeNode4.getYoungerBrother(), safraTreeNode3 = safraTreeNode3.getYoungerBrother()) {
            if (this.matches(safraTreeNode4, safraTreeNode3)) continue;
            return false;
        }
        assert (safraTreeNode4 == null && safraTreeNode3 == null);
        return true;
    }
}

