/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import jltl2ba.MyBitSet;
import prism.PrismException;

public class RabinAcceptance
implements Iterable<Integer> {
    private int _acceptance_count;
    private Vector<MyBitSet> _acceptance_L = new Vector();
    private Vector<MyBitSet> _acceptance_U = new Vector();
    boolean _is_compact = true;

    public boolean isCompact() {
        return this._is_compact;
    }

    public void makeCompact() {
        int n;
        if (this.isCompact()) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < this._acceptance_L.size(); ++n) {
            if (this._acceptance_L.get(n) == null) continue;
            if (n != n2) {
                this._acceptance_L.set(n2, this._acceptance_L.get(n));
                this._acceptance_U.set(n2, this._acceptance_U.get(n));
            }
            ++n2;
        }
        n = n2;
        this._acceptance_L.setSize(n);
        this._acceptance_U.setSize(n);
        this._is_compact = true;
    }

    public void moveStates(Vector<Integer> vector) throws PrismException {
        if (!this.isCompact()) {
            this.makeCompact();
        }
        for (int i = 0; i < this.size(); ++i) {
            this.move_acceptance_bits(this._acceptance_L.get(i), vector);
            this.move_acceptance_bits(this._acceptance_U.get(i), vector);
        }
    }

    public void outputAcceptanceHeader(PrintStream printStream) throws PrismException {
        printStream.println("Acceptance-Pairs: " + this.size());
    }

    public void outputAcceptanceHeaderHOA(PrintStream printStream) throws PrismException {
        printStream.println("acc-name: Rabin " + this.size());
        printStream.print("Acceptance: " + this.size() * 2 + " ");
        if (this.size() == 0) {
            printStream.println("f");
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                printStream.print(" | ");
            }
            printStream.print("( Fin(" + 2 * i + ") & Inf(" + (2 * i + 1) + ") )");
        }
        printStream.println();
    }

    public void outputAcceptanceForState(PrintStream printStream, int n) throws PrismException {
        printStream.print("Acc-Sig:");
        for (int i = 0; i < this.size(); ++i) {
            if (this.isStateInAcceptance_L(i, n)) {
                printStream.print(" +" + i);
            }
            if (!this.isStateInAcceptance_U(i, n)) continue;
            printStream.print(" -" + i);
        }
        printStream.println();
    }

    public void outputAcceptanceForStateHOA(PrintStream printStream, int n) throws PrismException {
        Object object = "";
        for (int i = 0; i < this.size(); ++i) {
            if (this.isStateInAcceptance_L(i, n)) {
                object = (String)object + (!((String)object).isEmpty() ? " " : "") + (i * 2 + 1);
            }
            if (!this.isStateInAcceptance_U(i, n)) continue;
            object = (String)object + (!((String)object).isEmpty() ? " " : "") + i * 2;
        }
        if (!((String)object).isEmpty()) {
            printStream.println("{" + (String)object + "}");
        }
    }

    public void addState(int n) {
    }

    public int newAcceptancePair() {
        MyBitSet myBitSet = new MyBitSet();
        MyBitSet myBitSet2 = new MyBitSet();
        this._acceptance_L.add(myBitSet);
        this._acceptance_U.add(myBitSet2);
        ++this._acceptance_count;
        return this._acceptance_L.size() - 1;
    }

    public int newAcceptancePairs(int n) {
        int n2 = this._acceptance_L.size();
        for (int i = 0; i < n; ++i) {
            this.newAcceptancePair();
        }
        return n2;
    }

    public void removeAcceptancePair(int n) {
        if (this._acceptance_L.get(n) != null) {
            --this._acceptance_count;
        }
        this._acceptance_L.set(n, null);
        this._acceptance_U.set(n, null);
        this._is_compact = false;
    }

    public MyBitSet getAcceptance_L(int n) {
        return this._acceptance_L.get(n);
    }

    public MyBitSet getAcceptance_U(int n) {
        return this._acceptance_U.get(n);
    }

    public MyBitSet getAcceptance_L_forState(int n) {
        return this.getMyBitSetForState(n, this._acceptance_L);
    }

    public MyBitSet getAcceptance_U_forState(int n) {
        return this.getMyBitSetForState(n, this._acceptance_U);
    }

    public boolean isStateInAcceptance_L(int n, int n2) {
        return this._acceptance_L.get(n).get(n2);
    }

    public boolean isStateInAcceptance_U(int n, int n2) {
        return this._acceptance_U.get(n).get(n2);
    }

    void stateIn_L(int n, int n2, boolean bl) {
        this.getAcceptance_L(n).set(n2, bl);
    }

    void stateIn_U(int n, int n2, boolean bl) {
        this.getAcceptance_U(n).set(n2, bl);
    }

    public int size() throws PrismException {
        if (!this.isCompact()) {
            throw new PrismException("Can't give acceptance pair count for uncompacted condition");
        }
        return this._acceptance_L.size();
    }

    private MyBitSet getMyBitSetForState(int n, Vector<MyBitSet> vector) {
        MyBitSet myBitSet = new MyBitSet(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == null || !vector.get(i).get(n)) continue;
            myBitSet.set(i);
        }
        return myBitSet;
    }

    private void move_acceptance_bits(MyBitSet myBitSet, Vector<Integer> vector) throws PrismException {
        int n = myBitSet.nextSetBit(0);
        while (n != -1) {
            int n2 = vector.get(n);
            if (n2 > n) {
                throw new PrismException("Wrong mapping in move_acceptance_bits");
            }
            if (n != n2) {
                myBitSet.set(n2);
                myBitSet.clear(n);
            }
            n = myBitSet.nextSetBit(n + 1);
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return new AcceptancePairIterator(this._acceptance_L);
    }

    public static class AcceptancePairIterator
    implements Iterator<Integer> {
        private Vector<MyBitSet> _acceptance_vector;
        private int index;

        public AcceptancePairIterator(Vector<MyBitSet> vector) {
            this._acceptance_vector = vector;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this._acceptance_vector.size();
        }

        @Override
        public Integer next() throws NoSuchElementException {
            if (this.hasNext()) {
                Integer n = this.index;
                this.increment();
                return n;
            }
            throw new NoSuchElementException();
        }

        private void increment() {
            ++this.index;
            while (this.index < this._acceptance_vector.size() && this._acceptance_vector.get(this.index) == null) {
                ++this.index;
            }
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static enum RabinColor {
        RABIN_WHITE,
        RABIN_GREEN,
        RABIN_RED;

    }
}

