/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import jltl2ba.APSet;
import jltl2dstar.DA_State;
import jltl2dstar.DBA2DRA;
import jltl2dstar.DRA;
import jltl2dstar.NBA;
import jltl2dstar.Options_Safra;
import jltl2dstar.SafraNBA2DRA;
import jltl2dstar.SafraTree;
import jltl2dstar.SafraTreeTemplate;
import jltl2dstar.SafrasAlgorithm;
import jltl2dstar.StateMapper;
import jltl2dstar.StateMapperFuzzy;
import prism.PrismException;

public class NBA2DRA {
    private Options_Safra _options;
    private boolean _detailed_states;

    public NBA2DRA() {
        this._detailed_states = false;
    }

    public NBA2DRA(Options_Safra options_Safra, boolean bl) {
        this._options = options_Safra;
        this._detailed_states = bl;
    }

    public DRA convert(NBA nBA, int n) throws PrismException {
        if (nBA.size() == 0 || nBA.getStartState() == null) {
            APSet aPSet = nBA.getAPSet();
            DRA dRA = new DRA(aPSet);
            dRA.constructEmpty();
            return dRA;
        }
        if (this._options.dba_check && nBA.isDeterministic()) {
            return DBA2DRA.dba2dra(nBA, false);
        }
        return this.convert_safra(nBA, n);
    }

    public DRA convert_safra(NBA nBA, int n) throws PrismException {
        SafrasAlgorithm safrasAlgorithm = new SafrasAlgorithm(nBA, this._options);
        APSet aPSet = nBA.getAPSet();
        DRA dRA = new DRA(aPSet);
        if (!this._options.opt_rename) {
            SafraNBA2DRA safraNBA2DRA = new SafraNBA2DRA(this._detailed_states);
            safraNBA2DRA.convert(safrasAlgorithm, dRA, n, new StateMapper<SafraTreeTemplate, SafraTree, DA_State>());
            return dRA;
        }
        SafraNBA2DRA safraNBA2DRA = new SafraNBA2DRA(this._detailed_states);
        safraNBA2DRA.convert(safrasAlgorithm, dRA, n, new StateMapperFuzzy());
        return dRA;
    }
}

