/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmctools.umbj;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import io.github.pmctools.umbj.UMBBitPacking;
import io.github.pmctools.umbj.UMBException;
import io.github.pmctools.umbj.UMBFormat;
import io.github.pmctools.umbj.UMBType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UMBIndex {
    public Integer formatVersion = 1;
    public Integer formatRevision = 0;
    public ModelData modelData = new ModelData();
    public FileData fileData = new FileData();
    public TransitionSystem transitionSystem = new TransitionSystem();
    public LinkedHashMap<String, LinkedHashMap<String, Annotation>> annotations = new LinkedHashMap();
    public LinkedHashMap<UMBEntity, ValuationDescription> valuations = new LinkedHashMap();
    public transient List<String> annotationGroups = new ArrayList<String>();
    public transient Map<String, Map<String, String>> annotationAliasMaps = new LinkedHashMap<String, Map<String, String>>();
    public transient Annotation actionsAnnotation = UMBIndex.createStandaloneAnnotation("actions", UMBType.create(UMBType.Type.STRING));
    public transient Annotation observationsAnnotation = UMBIndex.createStandaloneAnnotation("observations", UMBType.create(UMBType.Type.INT));

    public void validate() throws UMBException {
        UMBIndex.checkFieldExists(this.formatVersion, "formatVersion");
        UMBIndex.checkFieldExists(this.formatRevision, "formatVersion");
        if (this.modelData != null) {
            this.modelData.validate();
        }
        if (this.fileData != null) {
            this.fileData.validate();
        }
        UMBIndex.checkFieldExists(this.transitionSystem, "transitionSystem");
        this.transitionSystem.validate();
        if (this.annotations != null) {
            for (Map.Entry<Object, Object> entry : this.annotations.entrySet()) {
                this.validateAnnotations((String)entry.getKey(), (Map)entry.getValue());
            }
        }
        if (this.valuations != null) {
            for (Map.Entry<Object, Object> entry : this.valuations.entrySet()) {
                UMBIndex.checkFieldExists(((ValuationDescription)entry.getValue()).unique, "valuations." + String.valueOf(entry.getKey()) + ".unique");
                for (ValuationClassDescription valuationClassDescription : ((ValuationDescription)entry.getValue()).classes) {
                    this.validateValuationDescription(valuationClassDescription, "valuations.classes." + String.valueOf(entry.getKey()));
                }
            }
        }
    }

    public void validateAnnotations(String string, Map<String, Annotation> map) throws UMBException {
        for (Map.Entry<String, Annotation> entry : map.entrySet()) {
            if ("".equals(entry.getKey())) {
                throw new UMBException("Empty annotation ID in group \"" + string + "\"");
            }
            if (!UMBFormat.isValidID(entry.getKey())) {
                throw new UMBException("\"" + entry.getKey() + "\" is not a valid annotation ID in group \"" + string + "\"");
            }
            Annotation annotation = entry.getValue();
            annotation.validate();
        }
    }

    public void validateValuationDescription(ValuationClassDescription valuationClassDescription, String string) throws UMBException {
        UMBIndex.checkFieldExists(valuationClassDescription.variables, string + ".variables");
        for (ValuationVariable valuationVariable : valuationClassDescription.variables) {
            this.validateValuationVariable(valuationVariable);
        }
    }

    public void validateValuationVariable(ValuationVariable valuationVariable) throws UMBException {
        if (valuationVariable.padding != null) {
            if (valuationVariable.name != null || valuationVariable.type != null) {
                throw new UMBException("Malformed variable/padding in state valuation metadata");
            }
        } else {
            if (valuationVariable.name == null) {
                throw new UMBException("Unnamed variable in state valuation metadata");
            }
            if (valuationVariable.type == null) {
                throw new UMBException("Untyped variable in state valuation metadata");
            }
            if (valuationVariable.type.size == null) {
                throw new UMBException("Only fixed size variables are currently supported for state valuations");
            }
        }
    }

    public void setTime(Time time) {
        this.transitionSystem.time = time;
    }

    public void setNumPlayers(int n) {
        this.transitionSystem.numPlayers = n;
    }

    public void setNumStates(long l) {
        this.transitionSystem.numStates = l;
    }

    public void setNumInitialStates(long l) {
        this.transitionSystem.numInitialStates = l;
    }

    public void setNumChoices(long l) {
        this.transitionSystem.numChoices = l;
    }

    public void setNumBranches(long l) {
        this.transitionSystem.numBranches = l;
    }

    public void setNumChoiceActions(int n) {
        this.transitionSystem.numChoiceActions = n;
    }

    public void setNumBranchActions(int n) {
        this.transitionSystem.numBranchActions = n;
    }

    public void setNumObservations(int n) {
        this.transitionSystem.numObservations = n;
    }

    public void setObservationsApplyTo(UMBEntity uMBEntity) {
        this.transitionSystem.observationsApplyTo = uMBEntity;
    }

    public void setBranchProbabilityType(UMBType uMBType) {
        this.transitionSystem.branchProbabilityType = uMBType;
    }

    public void setExitRateType(UMBType uMBType) {
        this.transitionSystem.exitRateType = uMBType;
    }

    public void setObservationProbabilityType(UMBType uMBType) {
        this.transitionSystem.observationProbabilityType = uMBType;
    }

    public void setPlayerNames(List<String> list) {
        this.transitionSystem.playerNames = new ArrayList<String>(list);
    }

    public void setModelType(ModelType modelType, boolean bl) throws UMBException {
        switch (modelType) {
            case DTMC: 
            case IDTMC: {
                this.setTime(Time.DISCRETE);
                this.setNumPlayers(0);
                this.setBranchProbabilityType(bl ? UMBType.create(UMBType.Type.RATIONAL) : UMBType.create(UMBType.Type.DOUBLE));
                this.setExitRateType(null);
                break;
            }
            case CTMC: {
                this.setTime(Time.STOCHASTIC);
                this.setNumPlayers(0);
                this.setBranchProbabilityType(bl ? UMBType.create(UMBType.Type.RATIONAL) : UMBType.create(UMBType.Type.DOUBLE));
                this.setExitRateType(bl ? UMBType.create(UMBType.Type.RATIONAL) : UMBType.create(UMBType.Type.DOUBLE));
                break;
            }
            case MDP: 
            case POMDP: {
                this.setTime(Time.DISCRETE);
                this.setNumPlayers(1);
                this.setBranchProbabilityType(bl ? UMBType.create(UMBType.Type.RATIONAL) : UMBType.create(UMBType.Type.DOUBLE));
                this.setExitRateType(null);
                break;
            }
            case IMDP: 
            case IPOMDP: {
                this.setTime(Time.DISCRETE);
                this.setNumPlayers(1);
                this.setBranchProbabilityType(bl ? UMBType.create(UMBType.Type.RATIONAL_INTERVAL) : UMBType.create(UMBType.Type.DOUBLE_INTERVAL));
                this.setExitRateType(null);
                break;
            }
            case CTMDP: {
                this.setTime(Time.STOCHASTIC);
                this.setNumPlayers(1);
                this.setBranchProbabilityType(bl ? UMBType.create(UMBType.Type.RATIONAL) : UMBType.create(UMBType.Type.DOUBLE));
                this.setExitRateType(bl ? UMBType.create(UMBType.Type.RATIONAL) : UMBType.create(UMBType.Type.DOUBLE));
                break;
            }
            case MA: {
                this.setTime(Time.URGENT_STOCHASTIC);
                this.setNumPlayers(1);
                this.setBranchProbabilityType(bl ? UMBType.create(UMBType.Type.RATIONAL) : UMBType.create(UMBType.Type.DOUBLE));
                this.setExitRateType(bl ? UMBType.create(UMBType.Type.RATIONAL) : UMBType.create(UMBType.Type.DOUBLE));
                break;
            }
            case TSG: 
            case ITSG: {
                this.setTime(Time.DISCRETE);
                this.setNumPlayers(2);
                this.setBranchProbabilityType(null);
                this.setExitRateType(null);
                break;
            }
            case LTS: {
                this.setTime(Time.DISCRETE);
                this.setNumPlayers(1);
                this.setBranchProbabilityType(null);
                this.setExitRateType(null);
                break;
            }
            case TG: {
                this.setTime(Time.DISCRETE);
                this.setNumPlayers(2);
                this.setBranchProbabilityType(null);
                this.setExitRateType(null);
                break;
            }
            default: {
                throw new UMBException("Unsupported model type \"" + String.valueOf(modelType) + "\"");
            }
        }
        if (EnumSet.of(ModelType.POMDP, ModelType.IPOMDP).contains(modelType)) {
            this.setNumObservations(1);
            this.setObservationsApplyTo(UMBEntity.STATES);
        } else {
            this.setNumObservations(0);
        }
    }

    public Annotation addAnnotation(String string, String string2, UMBType uMBType) throws UMBException {
        Map<String, Object> map;
        if (!uMBType.type.isRational() && !uMBType.isDefaultSize()) {
            throw new UMBException("Annotation type must have default size unless it is rational");
        }
        if (!this.annotationGroups.contains(string)) {
            if (!UMBFormat.isValidID(string)) {
                throw new UMBException("Invalid group ID \"" + string + "\"");
            }
            this.annotationGroups.add(string);
            this.annotationAliasMaps.put(string, new LinkedHashMap());
            this.annotations.put(string, new LinkedHashMap());
        }
        if (string2 != null && !string2.isEmpty() && (map = this.annotationAliasMaps.get(string)).containsKey(string2)) {
            throw new UMBException("Duplicate alias \"" + string2 + "\" in group \"" + string + "\"");
        }
        map = this.annotations.get(string);
        Annotation annotation = new Annotation();
        annotation.group = string;
        String string3 = Integer.toString(((HashMap)map).size() + 1);
        if (string2 != null && !string2.isEmpty()) {
            string3 = UMBFormat.toValidUniqueID(string2, arg_0 -> map.containsKey(arg_0));
            annotation.alias = string2;
            this.annotationAliasMaps.get(string).put(string2, string3);
        }
        annotation.id = string3;
        annotation.type = uMBType;
        ((HashMap)map).put(string3, annotation);
        return annotation;
    }

    public static Annotation createStandaloneAnnotation(String string, UMBType uMBType) {
        StandaloneAnnotation standaloneAnnotation = new StandaloneAnnotation();
        standaloneAnnotation.type = uMBType;
        standaloneAnnotation.folderName = string;
        return standaloneAnnotation;
    }

    public void addSingleValuationDescription(UMBEntity uMBEntity, boolean bl, UMBBitPacking uMBBitPacking) throws UMBException {
        this.addValuationDescriptions(uMBEntity, bl);
        this.addValuationDescriptionClass(uMBEntity, uMBBitPacking);
    }

    public void addValuationDescriptions(UMBEntity uMBEntity, boolean bl) throws UMBException {
        if (this.valuations.containsKey(uMBEntity)) {
            throw new UMBException("Valuations have already been added for " + String.valueOf(uMBEntity));
        }
        this.valuations.put(uMBEntity, new ValuationDescription(bl));
    }

    public int addValuationDescriptionClass(UMBEntity uMBEntity, UMBBitPacking uMBBitPacking) throws UMBException {
        ValuationDescription valuationDescription = this.valuations.get(uMBEntity);
        valuationDescription.classes.add(uMBBitPacking.toValuationClassDescription());
        return valuationDescription.classes.size() - 1;
    }

    public Time getTime() {
        return this.transitionSystem.time;
    }

    public int getNumPlayers() {
        return this.transitionSystem.numPlayers;
    }

    public long getNumStates() {
        return this.transitionSystem.numStates;
    }

    public long getNumInitialStates() {
        return this.transitionSystem.numInitialStates;
    }

    public long getNumChoices() {
        return this.transitionSystem.numChoices;
    }

    public long getNumBranches() {
        return this.transitionSystem.numBranches;
    }

    public int getNumChoiceActions() {
        return this.transitionSystem.numChoiceActions;
    }

    public int getNumBranchActions() {
        return this.transitionSystem.numBranchActions;
    }

    public int getNumObservations() {
        return this.transitionSystem.numObservations;
    }

    public UMBEntity getObservationsApplyTo() {
        return this.transitionSystem.observationsApplyTo;
    }

    public UMBType getBranchProbabilityType() {
        return this.transitionSystem.branchProbabilityType;
    }

    public UMBType getExitRateType() {
        return this.transitionSystem.exitRateType;
    }

    public UMBType getObservationProbabilityType() {
        return this.transitionSystem.observationProbabilityType;
    }

    public List<String> getPlayerNames() {
        return this.transitionSystem.playerNames;
    }

    public long getEntityCount(UMBEntity uMBEntity) throws UMBException {
        switch (uMBEntity) {
            case STATES: {
                return this.getNumStates();
            }
            case CHOICES: {
                return this.getNumChoices();
            }
            case BRANCHES: {
                return this.getNumBranches();
            }
            case OBSERVATIONS: {
                return this.getNumObservations();
            }
            case PLAYERS: {
                return this.getNumPlayers();
            }
        }
        throw new UMBException("Unsupported entity \"" + String.valueOf(uMBEntity) + "\"");
    }

    public ModelType getModelType() {
        boolean bl = this.transitionSystem.branchProbabilityType != null;
        int n = this.getNumPlayers();
        boolean bl2 = this.getNumObservations() > 0;
        Time time = this.getTime();
        boolean bl3 = this.transitionSystem.branchProbabilityType != null && this.transitionSystem.branchProbabilityType.type.isInterval();
        ModelType modelType = null;
        if (bl) {
            if (n == 0) {
                if (bl2) {
                    return null;
                }
                switch (time) {
                    case DISCRETE: {
                        modelType = ModelType.DTMC;
                        break;
                    }
                    case STOCHASTIC: {
                        modelType = ModelType.CTMC;
                        break;
                    }
                    case URGENT_STOCHASTIC: {
                        return null;
                    }
                }
            } else if (n == 1) {
                switch (time) {
                    case DISCRETE: {
                        modelType = bl2 ? ModelType.POMDP : ModelType.MDP;
                        break;
                    }
                    case STOCHASTIC: {
                        modelType = bl2 ? null : ModelType.CTMDP;
                        break;
                    }
                    case URGENT_STOCHASTIC: {
                        modelType = bl2 ? null : ModelType.MA;
                    }
                }
            } else {
                if (bl2) {
                    return null;
                }
                switch (time) {
                    case DISCRETE: {
                        modelType = ModelType.TSG;
                        break;
                    }
                    case STOCHASTIC: 
                    case URGENT_STOCHASTIC: {
                        return null;
                    }
                }
            }
        } else {
            if (bl2) {
                return null;
            }
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                return ModelType.LTS;
            }
            return ModelType.TG;
        }
        if (modelType == null) {
            return null;
        }
        if (!bl3) {
            return modelType;
        }
        switch (modelType) {
            case DTMC: {
                return ModelType.IDTMC;
            }
            case MDP: {
                return ModelType.IMDP;
            }
            case POMDP: {
                return ModelType.IPOMDP;
            }
            case TSG: {
                return ModelType.ITSG;
            }
        }
        return null;
    }

    public Annotation getAnnotation(String string, String string2) throws UMBException {
        LinkedHashMap<String, Annotation> linkedHashMap = this.annotations.get(string);
        if (linkedHashMap == null) {
            throw new UMBException("Unknown annotation group ID \"" + string + "\"");
        }
        Annotation annotation = linkedHashMap.get(string2);
        if (annotation == null) {
            throw new UMBException("Unknown annotation ID \"" + string2 + "\" in group \"" + string + "\"");
        }
        return annotation;
    }

    public boolean annotationWithAliasExists(String string, String string2) {
        Map<String, String> map = this.annotationAliasMaps.get(string);
        if (map == null) {
            return false;
        }
        return map.containsKey(string2);
    }

    public String getAnnotationIdForAlias(String string, String string2) throws UMBException {
        Map<String, String> map = this.annotationAliasMaps.get(string);
        if (map == null) {
            throw new UMBException("Annotation group \"" + string + "\" does not exist");
        }
        String string3 = map.get(string2);
        if (string3 == null) {
            throw new UMBException("No annotation with alias \"" + string2 + "\" in group \"" + string + "\" exists");
        }
        return string3;
    }

    public LinkedHashMap<String, Annotation> getAPAnnotations() {
        return this.annotations.getOrDefault("aps", new LinkedHashMap());
    }

    public List<Annotation> getAPAnnotationsList() {
        return new ArrayList<Annotation>(this.getAPAnnotations().values());
    }

    public boolean hasAPAnnotations() {
        return !this.getAPAnnotations().isEmpty();
    }

    public int getNumAPAnnotations() {
        return this.getAPAnnotations().size();
    }

    public Annotation getAPAnnotation(int n) {
        return this.getAPAnnotationsList().get(n);
    }

    public Annotation getAPAnnotationByID(String string) throws UMBException {
        Annotation annotation = this.getAPAnnotations().get(string);
        if (annotation == null) {
            throw new UMBException("Unknown AP annotation ID \"" + string + "\"");
        }
        return annotation;
    }

    public boolean hasAPAnnotationWithAlias(String string) {
        return this.annotationWithAliasExists("aps", string);
    }

    public Annotation getAPAnnotationByAlias(String string) throws UMBException {
        String string2 = this.getAnnotationIdForAlias("aps", string);
        return this.getAPAnnotationByID(string2);
    }

    public List<String> getAPNames() {
        return this.getAPAnnotationsList().stream().map(Annotation::getName).collect(Collectors.toCollection(ArrayList::new));
    }

    public LinkedHashMap<String, Annotation> getRewardAnnotations() {
        return this.annotations.getOrDefault("rewards", new LinkedHashMap());
    }

    public List<Annotation> getRewardAnnotationsList() {
        return new ArrayList<Annotation>(this.getRewardAnnotations().values());
    }

    public boolean hasRewardAnnotations() {
        return !this.getRewardAnnotations().isEmpty();
    }

    public int getNumRewardAnnotations() {
        return this.getRewardAnnotations().size();
    }

    public Annotation getRewardAnnotation(int n) {
        return this.getRewardAnnotationsList().get(n);
    }

    public Annotation getRewardAnnotationByID(String string) throws UMBException {
        Annotation annotation = this.getRewardAnnotations().get(string);
        if (annotation == null) {
            throw new UMBException("Unknown reward annotation ID \"" + string + "\"");
        }
        return annotation;
    }

    public boolean hasRewardAnnotationWithAlias(String string) {
        return this.annotationWithAliasExists("rewards", string);
    }

    public Annotation getRewardAnnotationByAlias(String string) throws UMBException {
        String string2 = this.getAnnotationIdForAlias("rewards", string);
        return this.getRewardAnnotationByID(string2);
    }

    public List<String> getRewardNames() {
        return this.getRewardAnnotationsList().stream().map(Annotation::getName).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean hasStateRewards(int n) {
        return this.getRewardAnnotation(n).appliesTo(UMBEntity.STATES);
    }

    public boolean hasChoiceRewards(int n) {
        return this.getRewardAnnotation(n).appliesTo(UMBEntity.CHOICES);
    }

    public boolean hasBranchRewards(int n) {
        return this.getRewardAnnotation(n).appliesTo(UMBEntity.BRANCHES);
    }

    public boolean hasValuations(UMBEntity uMBEntity) {
        return this.valuations != null && this.valuations.containsKey(uMBEntity) && !this.valuations.get((Object)uMBEntity).classes.isEmpty();
    }

    public boolean areValuationsUnique(UMBEntity uMBEntity) {
        return this.valuations != null && this.valuations.containsKey(uMBEntity) && this.valuations.get((Object)uMBEntity).unique != false;
    }

    public UMBBitPacking getValuationBitPacking(UMBEntity uMBEntity) throws UMBException {
        return this.getValuationBitPacking(uMBEntity, 0);
    }

    public UMBBitPacking getValuationBitPacking(UMBEntity uMBEntity, int n) throws UMBException {
        if (this.valuations == null || !this.valuations.containsKey(uMBEntity) || this.valuations.get((Object)uMBEntity).classes.size() <= n) {
            throw new UMBException("No valuation metadata present");
        }
        return new UMBBitPacking(this.valuations.get((Object)uMBEntity).classes.get(n));
    }

    public int getNumValuationClasses(UMBEntity uMBEntity) throws UMBException {
        if (this.valuations == null || !this.valuations.containsKey(uMBEntity)) {
            throw new UMBException("No valuation metadata present");
        }
        return this.valuations.get((Object)uMBEntity).classes.size();
    }

    private static void checkFieldExists(Object object, String string) throws UMBException {
        UMBIndex.checkFieldExistsIff(object, string, true);
    }

    private static void checkFieldExistsIff(Object object, String string, boolean bl) throws UMBException {
        if (bl && object == null) {
            throw new UMBException("Required field \"" + UMBIndex.fieldNameToUMB(string) + "\" is missing");
        }
        if (!bl && object != null) {
            throw new UMBException("Field \"" + UMBIndex.fieldNameToUMB(string) + "\" should not be present");
        }
    }

    public String toJSON() {
        return UMBIndex.gsonBuilder().toJson((Object)this);
    }

    public static UMBIndex fromJSON(String string) throws UMBException {
        try {
            UMBIndex uMBIndex = (UMBIndex)UMBIndex.gsonBuilder().fromJson(string, UMBIndex.class);
            uMBIndex.buildAnnotationInfo();
            return uMBIndex;
        }
        catch (JsonParseException jsonParseException) {
            throw new UMBException(jsonParseException.getMessage());
        }
    }

    private void buildAnnotationInfo() {
        this.annotationGroups = new ArrayList<String>();
        this.annotationAliasMaps = new LinkedHashMap<String, Map<String, String>>();
        this.annotationGroups.addAll(this.annotations.keySet());
        for (Map.Entry<String, LinkedHashMap<String, Annotation>> entry : this.annotations.entrySet()) {
            String string = entry.getKey();
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            this.annotationAliasMaps.put(string, linkedHashMap);
            for (Map.Entry<String, Annotation> entry2 : entry.getValue().entrySet()) {
                entry2.getValue().group = string;
                entry2.getValue().id = entry2.getKey();
                if (entry2.getValue().alias == null) continue;
                linkedHashMap.put(entry2.getValue().alias, entry2.getKey());
            }
        }
    }

    private static Gson gsonBuilder() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_DASHES).registerTypeHierarchyAdapter(UMBField.class, new EnumSerializer()).registerTypeHierarchyAdapter(UMBField.class, new EnumDeserializer()).setPrettyPrinting().create();
    }

    public static String fieldNameToUMB(String string) {
        return string.replaceAll("([a-z])([A-Z])", "$1-$2").replaceAll("^([A-Z])", "$1").toLowerCase();
    }

    public static class ModelData {
        public String name;
        public String version;
        public List<String> authors;
        public String description;
        public String comment;
        public String doi;
        public String url;

        public void validate() throws UMBException {
        }
    }

    public static class FileData {
        public String tool;
        public String toolVersion;
        public Long creationDate = Instant.now().getEpochSecond();
        public Object parameters;

        public void validate() throws UMBException {
        }
    }

    public static class TransitionSystem {
        public Time time;
        @SerializedName(value="#players")
        public Integer numPlayers;
        @SerializedName(value="#states")
        public Long numStates;
        @SerializedName(value="#initial-states")
        public Long numInitialStates;
        @SerializedName(value="#choices")
        public Long numChoices;
        @SerializedName(value="#choice-actions")
        public Integer numChoiceActions;
        @SerializedName(value="#branches")
        public Long numBranches;
        @SerializedName(value="#branch-actions")
        public Integer numBranchActions;
        @SerializedName(value="#observations")
        public Integer numObservations;
        public UMBEntity observationsApplyTo;
        public UMBType branchProbabilityType;
        public UMBType exitRateType;
        public UMBType observationProbabilityType;
        public List<String> playerNames;

        public void validate() throws UMBException {
            UMBIndex.checkFieldExists(this.time, "time");
            UMBIndex.checkFieldExists(this.numPlayers, "numPlayers");
            if (this.numPlayers < 0) {
                throw new UMBException("Number of players must be non-negative");
            }
            UMBIndex.checkFieldExists(this.numStates, "numStates");
            if (this.numStates < 0L) {
                throw new UMBException("Number of states must be at least 1");
            }
            UMBIndex.checkFieldExists(this.numInitialStates, "numInitialStates");
            if (this.numInitialStates < 0L) {
                throw new UMBException("Number of initial states must be non-negative");
            }
            UMBIndex.checkFieldExists(this.numChoices, "numChoices");
            if (this.numChoices < 0L) {
                throw new UMBException("Number of choices must be non-negative");
            }
            UMBIndex.checkFieldExists(this.numChoiceActions, "numChoiceActions");
            if (this.numChoiceActions < 0) {
                throw new UMBException("Number of choice actions must be non-negative");
            }
            UMBIndex.checkFieldExists(this.numBranches, "numBranches");
            if (this.numBranches < 0L) {
                throw new UMBException("Number of branches must be non-negative");
            }
            UMBIndex.checkFieldExists(this.numBranchActions, "numBranchActions");
            if (this.numBranchActions < 0) {
                throw new UMBException("Number of branch actions must be non-negative");
            }
            UMBIndex.checkFieldExists(this.numObservations, "numObservations");
            if (this.numObservations < 0) {
                throw new UMBException("Number of observations must be non-negative");
            }
            if (this.numObservations > 0) {
                UMBIndex.checkFieldExists(this.observationsApplyTo, "observationsApplyTo");
                if (!EnumSet.of(UMBEntity.STATES, UMBEntity.BRANCHES).contains(this.observationsApplyTo)) {
                    throw new UMBException("Invalid value \" + observationsApplyTo\" for " + UMBIndex.fieldNameToUMB("observationsApplyTo"));
                }
            }
            if (this.branchProbabilityType != null) {
                if (!this.branchProbabilityType.type.isContinuousNumeric()) {
                    throw new UMBException("Branch probability type must be a continuous numeric type");
                }
                if (!this.branchProbabilityType.isDefaultSize()) {
                    throw new UMBException("Branch probability type must have default size");
                }
            }
            UMBIndex.checkFieldExistsIff(this.exitRateType, "exitRateType", this.time == Time.STOCHASTIC || this.time == Time.URGENT_STOCHASTIC);
            if (this.exitRateType != null) {
                if (!this.exitRateType.type.isContinuousNumeric()) {
                    throw new UMBException("Exit rate type must be a continuous numeric type");
                }
                if (!this.exitRateType.isDefaultSize()) {
                    throw new UMBException("Exit rate type must have default size");
                }
            }
            if (this.observationProbabilityType != null) {
                if (!this.observationProbabilityType.type.isContinuousNumeric()) {
                    throw new UMBException("Observation probability type must be a continuous numeric type");
                }
                if (!this.observationProbabilityType.isDefaultSize()) {
                    throw new UMBException("Observation probability type must have default size");
                }
            }
            if (this.numPlayers > 1) {
                UMBIndex.checkFieldExists(this.playerNames, "playerNames");
                if (this.playerNames.size() != this.numPlayers.intValue()) {
                    throw new UMBException("Player name list does not match number of players");
                }
                if (!this.playerNames.stream().allMatch(new HashSet()::add)) {
                    throw new UMBException("Player names must be unique");
                }
            } else if (this.playerNames != null) {
                throw new UMBException("Player names should be omitted in non-game models");
            }
        }
    }

    public static class ValuationDescription {
        public Boolean unique;
        @SerializedName(value="#strings")
        public Integer numStrings;
        public List<ValuationClassDescription> classes = new ArrayList<ValuationClassDescription>();

        public ValuationDescription(boolean bl) {
            this.unique = bl;
        }
    }

    public static class ValuationClassDescription {
        public List<ValuationVariable> variables = new ArrayList<ValuationVariable>();

        public int numBits() {
            int n = 0;
            for (ValuationVariable valuationVariable : this.variables) {
                n += valuationVariable.numBits();
            }
            return n;
        }
    }

    public static class Annotation {
        public transient String group;
        public transient String id;
        public String alias;
        public String description;
        public List<UMBEntity> appliesTo = new ArrayList<UMBEntity>();
        public UMBType type;
        @SerializedName(value="#strings")
        public Integer numStrings;
        public UMBType probabilityType;
        @SerializedName(value="#probabilities")
        public Integer numProbabilities;

        public void addAppliesTo(UMBEntity uMBEntity) {
            this.appliesTo.add(uMBEntity);
        }

        public void validate() throws UMBException {
            UMBIndex.checkFieldExists(this.appliesTo, "appliesTo");
            if (this.appliesTo.isEmpty()) {
                throw new UMBException("Annotation \"" + this.id + "\" in group \"" + this.group + "\" is empty");
            }
            UMBIndex.checkFieldExists(this.type, "type");
            UMBIndex.checkFieldExistsIff(this.numStrings, "numStrings", this.type.type == UMBType.Type.STRING);
            if (this.type.type == UMBType.Type.STRING && this.numStrings <= 0) {
                throw new UMBException("Number of strings must be positive");
            }
            UMBIndex.checkFieldExistsIff(this.numProbabilities, "#probabilities", this.probabilityType != null);
            if (this.probabilityType != null && this.numProbabilities <= 0) {
                throw new UMBException("Number of probabilities must be positive");
            }
        }

        public String getName() {
            return this.alias == null ? this.id : this.alias;
        }

        public boolean appliesTo(UMBEntity uMBEntity) {
            return this.appliesTo.contains(uMBEntity);
        }

        public UMBType getType() {
            return this.type;
        }

        public int getNumStrings() {
            return this.numStrings;
        }

        public UMBType getProbabilityType() {
            return this.probabilityType;
        }

        public String getFolderName(UMBEntity uMBEntity) {
            return UMBFormat.annotationFolder(this.group, this.id, uMBEntity);
        }

        public String getFilename(UMBEntity uMBEntity) {
            return UMBFormat.annotationFile(this.group, this.id, uMBEntity);
        }

        public String getDistributionFilename(UMBEntity uMBEntity) {
            return UMBFormat.annotationDistributionFile(this.group, this.id, uMBEntity);
        }

        public String getProbabilitiesFilename(UMBEntity uMBEntity) {
            return UMBFormat.annotationProbabilitiesFile(this.group, this.id, uMBEntity);
        }
    }

    public static class ValuationVariable {
        public String name;
        public Boolean isOptional;
        public UMBType type;
        public Integer padding;

        public boolean isVariable() {
            return this.padding == null;
        }

        public boolean isPadding() {
            return this.padding != null;
        }

        public int numBits() {
            if (this.padding != null) {
                return this.padding;
            }
            if (this.type.size != null) {
                return this.type.size;
            }
            return 0;
        }
    }

    public static enum Time implements UMBField
    {
        DISCRETE,
        STOCHASTIC,
        URGENT_STOCHASTIC;

    }

    public static enum UMBEntity implements UMBField
    {
        STATES,
        CHOICES,
        BRANCHES,
        OBSERVATIONS,
        PLAYERS;


        public String toString() {
            switch (this) {
                case STATES: {
                    return "states";
                }
                case CHOICES: {
                    return "choices";
                }
                case BRANCHES: {
                    return "branches";
                }
                case OBSERVATIONS: {
                    return "observations";
                }
                case PLAYERS: {
                    return "players";
                }
            }
            return "?";
        }
    }

    public static enum ModelType implements UMBField
    {
        DTMC,
        CTMC,
        MDP,
        POMDP,
        CTMDP,
        MA,
        TSG,
        LTS,
        TG,
        IDTMC,
        IMDP,
        IPOMDP,
        ITSG;

    }

    public static class StandaloneAnnotation
    extends Annotation {
        public String folderName;

        @Override
        public String getFolderName(UMBEntity uMBEntity) {
            return this.folderName + "/" + String.valueOf(uMBEntity);
        }

        @Override
        public String getFilename(UMBEntity uMBEntity) {
            return this.getFolderName(uMBEntity) + "/values.bin";
        }
    }

    static interface UMBField {
        default public String description() {
            return UMBField.toUMB(((Enum)((Object)this)).name());
        }

        public static String toUMB(String string) {
            return string.toLowerCase().replace("_", "-");
        }
    }

    static class EnumSerializer<T extends Enum<T>>
    implements JsonSerializer<T> {
        EnumSerializer() {
        }

        public JsonElement serialize(T t, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(UMBField.toUMB(((Enum)t).name()));
        }
    }

    static class EnumDeserializer<T extends Enum<T>>
    implements JsonDeserializer<T> {
        EnumDeserializer() {
        }

        public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            String string = jsonElement.getAsString();
            try {
                if (!jsonElement.isJsonPrimitive()) {
                    throw new IllegalArgumentException();
                }
                for (Enum enum_ : (Enum[])((Class)type).getEnumConstants()) {
                    if (!UMBField.toUMB(enum_.name()).equals(UMBField.toUMB(string))) continue;
                    return (T)enum_;
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = UMBIndex.fieldNameToUMB(((Class)type).getSimpleName());
                throw new JsonParseException("Invalid value \"" + string + "\" for " + string2, (Throwable)illegalArgumentException);
            }
        }
    }
}

