/*
 * Decompiled with CFR 0.152.
 */
package io;

import explicit.CTMC;
import explicit.Model;
import explicit.NondetModel;
import explicit.PartiallyObservableModel;
import io.ModelExportOptions;
import io.ModelExporter;
import io.Transition;
import java.util.Iterator;
import prism.Evaluator;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;

public class DRNExporter<Value>
extends ModelExporter<Value> {
    public DRNExporter() {
    }

    public DRNExporter(ModelExportOptions modelExportOptions) {
        super(modelExportOptions);
    }

    @Override
    public void exportModel(Model<Value> model, PrismLog prismLog) throws PrismException {
        this.setEvaluator(model.getEvaluator());
        Evaluator evaluator = this.getRewardEvaluator();
        ModelType modelType = model.getModelType();
        int n = this.getNumRewards();
        int n2 = this.getNumLabels();
        int n3 = model.getNumStates();
        boolean bl = this.modelExportOptions.getShowActions(modelType.nondeterministic());
        prismLog.println("// Exported by prism");
        prismLog.println("// Original model type: " + String.valueOf((Object)modelType));
        prismLog.println("@type: " + String.valueOf((Object)modelType));
        prismLog.println("@parameters");
        prismLog.println();
        prismLog.println("@reward_models");
        prismLog.println(String.join((CharSequence)" ", PrismUtils.listReversed(this.getRewardNames())));
        prismLog.println("@nr_states");
        prismLog.println(model.getNumStates());
        prismLog.println("@nr_choices");
        if (modelType.nondeterministic()) {
            prismLog.println(((NondetModel)model).getNumChoices());
        } else {
            prismLog.println(model.getNumStates());
        }
        prismLog.println("@model");
        for (int i = 0; i < n3; ++i) {
            int n4;
            prismLog.print("state " + i);
            if (modelType.partiallyObservable()) {
                prismLog.print(" {" + ((PartiallyObservableModel)model).getObservation(i) + "}");
            }
            if (modelType.continuousTime()) {
                prismLog.print(" !" + String.valueOf(((CTMC)model).getExitRate(i)));
            }
            if (n > 0) {
                prismLog.print(" " + this.getStateRewardTuple(this.getRewards(), i).toStringReversed(object -> this.formatValue(object, evaluator), ", "));
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if (!this.getLabel(n4).get(i)) continue;
                prismLog.print(" " + this.getLabelName(n4));
            }
            prismLog.println();
            n4 = 1;
            if (modelType.nondeterministic()) {
                n4 = ((NondetModel)model).getNumChoices(i);
            }
            for (int j = 0; j < n4; ++j) {
                prismLog.print("\taction ");
                if (modelType.nondeterministic() && bl) {
                    Iterator<Transition<Object>> iterator = ((NondetModel)model).getAction(i, j);
                    prismLog.print(iterator != null ? iterator : "__NOLABEL__");
                } else {
                    prismLog.print(j);
                }
                if (n > 0) {
                    prismLog.print(" " + this.getTransitionRewardTuple(this.getRewards(), i, j).toStringReversed(object -> this.formatValue(object, evaluator), ", "));
                }
                prismLog.println();
                for (Transition<Object> transition : this.getSortedTransitionsIterator(model, i, j, bl)) {
                    prismLog.println("\t\t" + transition.target + " : " + transition.toString(this.modelExportOptions));
                }
            }
        }
    }
}

