/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.CTMCModelChecker;
import explicit.CTMCSimple;
import explicit.CTMDPSimple;
import explicit.DTMC;
import explicit.DTMCModelChecker;
import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.DistributionSet;
import explicit.MDP;
import explicit.MDPModelChecker;
import explicit.MDPSimple;
import explicit.ModelCheckerResult;
import explicit.ModelSimple;
import explicit.ProbModelChecker;
import explicit.QuantAbstractRefine;
import explicit.STPG;
import explicit.STPGAbstrSimple;
import explicit.StateModelChecker;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class PrismSTPGAbstractRefine
extends QuantAbstractRefine {
    protected String traFile;
    protected String labFile;
    protected String rewsFile;
    protected String rewtFile;
    protected String targetLabel;
    protected boolean exact = false;
    protected boolean exactCheck = false;
    protected boolean rebuildImmed = false;
    protected ModelSimple<Double> modelConcrete;
    protected int nConcrete;
    protected BitSet initialConcrete;
    protected BitSet targetConcrete;
    protected double exactInit;
    protected int[] concreteToAbstract;
    protected List<List<Set<Integer>>> abstractToConcrete;

    public PrismSTPGAbstractRefine(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    protected void initialise() throws PrismException {
        int n;
        int n2;
        this.mainLog.println("Building concrete " + (this.buildEmbeddedDtmc ? "(embedded) " : "") + String.valueOf((Object)this.modelType) + "...");
        switch (this.modelType) {
            case DTMC: {
                this.modelConcrete = this.buildEmbeddedDtmc ? new CTMCSimple() : new DTMCSimple();
                break;
            }
            case CTMC: {
                this.modelConcrete = new CTMCSimple<Double>();
                break;
            }
            case MDP: {
                this.modelConcrete = new MDPSimple<Double>();
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot handle model type " + String.valueOf((Object)this.modelType));
            }
        }
        this.modelConcrete.buildFromPrismExplicit(this.traFile);
        if (this.buildEmbeddedDtmc) {
            this.mainLog.println("Concrete CTMC: " + this.modelConcrete.infoString());
            this.modelConcrete = ((CTMCSimple)this.modelConcrete).buildEmbeddedDTMC();
        }
        this.mainLog.println("Concrete " + String.valueOf((Object)this.modelType) + ": " + this.modelConcrete.infoString());
        this.nConcrete = this.modelConcrete.getNumStates();
        if (this.modelType == ModelType.CTMC && this.propertyType != QuantAbstractRefine.PropertyType.PROB_REACH) {
            ((CTMCSimple)this.modelConcrete).uniformise(((CTMCSimple)this.modelConcrete).getDefaultUniformisationRate());
        }
        Map<String, BitSet> map = StateModelChecker.loadLabelsFile(this.labFile);
        this.initialConcrete = map.get("init");
        this.targetConcrete = map.get(this.targetLabel);
        if (this.targetConcrete == null) {
            throw new PrismException("Unknown label \"" + this.targetLabel + "\"");
        }
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(this.initialConcrete, this.modelConcrete.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n3 = (Integer)ofInt.next();
            this.modelConcrete.addInitialState(n3);
        }
        if (this.exact) {
            this.doExactModelChecking();
            if (!this.exactCheck) {
                throw new PrismException("Terminated early after exact verification");
            }
        }
        this.concreteToAbstract = new int[this.nConcrete];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = 0; n2 < this.nConcrete; ++n2) {
            boolean bl4 = this.targetConcrete.get(n2);
            boolean bl5 = this.initialConcrete.get(n2);
            bl3 |= !bl4 && bl5;
            bl2 |= bl4 && bl5;
            bl |= !bl4 && !bl5;
            this.concreteToAbstract[n2] = bl4 ? 1 : (bl5 ? 0 : 2);
        }
        if (!bl3) {
            throw new PrismException("No non-target initial states");
        }
        if (this.verbosity >= 10) {
            this.mainLog.print("Initial concreteToAbstract: ");
            this.mainLog.println(this.concreteToAbstract);
        }
        int n4 = bl ? 3 : 2;
        switch (this.modelType) {
            case DTMC: {
                this.abstraction = new MDPSimple(n4);
                break;
            }
            case CTMC: {
                this.abstraction = new CTMDPSimple(n4);
                break;
            }
            case MDP: {
                this.abstraction = new STPGAbstrSimple(n4);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot handle model type " + String.valueOf((Object)this.modelType));
            }
        }
        this.abstraction.addInitialState(0);
        if (bl2) {
            this.abstraction.addInitialState(1);
        }
        this.target = new BitSet(n4);
        this.target.set(1);
        this.abstractToConcrete = new ArrayList<List<Set<Integer>>>(n4);
        for (n = 0; n < n4; ++n) {
            this.abstractToConcrete.add(new ArrayList());
        }
        for (n2 = 0; n2 < this.nConcrete; ++n2) {
            int n5;
            n = this.concreteToAbstract[n2];
            switch (this.modelType) {
                case DTMC: {
                    Distribution distribution = this.buildAbstractDistribution(n2, (DTMCSimple)this.modelConcrete);
                    n5 = ((MDPSimple)this.abstraction).addChoice(n, distribution);
                    break;
                }
                case CTMC: {
                    Distribution distribution = this.buildAbstractDistribution(n2, (CTMCSimple)this.modelConcrete);
                    n5 = ((CTMDPSimple)this.abstraction).addChoice(n, distribution);
                    break;
                }
                case MDP: {
                    DistributionSet distributionSet = this.buildAbstractDistributionSet(n2, (MDPSimple)this.modelConcrete, (STPG)((Object)this.abstraction));
                    n5 = ((STPGAbstrSimple)this.abstraction).addDistributionSet(n, distributionSet);
                    break;
                }
                default: {
                    throw new PrismNotSupportedException("Cannot handle model type " + String.valueOf((Object)this.modelType));
                }
            }
            List<Set<Integer>> list = this.abstractToConcrete.get(n);
            if (n5 >= list.size()) {
                list.add(new HashSet(1));
            }
            list.get(n5).add(n2);
        }
    }

    protected Distribution buildAbstractDistribution(int n, DTMCSimple<Double> dTMCSimple) {
        return dTMCSimple.getTransitions(n).map(this.concreteToAbstract);
    }

    protected DistributionSet buildAbstractDistributionSet(int n, MDPSimple<Double> mDPSimple, STPG sTPG) {
        DistributionSet distributionSet = ((STPGAbstrSimple)sTPG).newDistributionSet(null);
        for (Distribution<Double> distribution : mDPSimple.getChoices(n)) {
            distributionSet.add(distribution.map(this.concreteToAbstract));
        }
        return distributionSet;
    }

    @Override
    protected int splitState(int n, List<List<Integer>> list, Set<Integer> set, Set<Integer> set2) throws PrismException {
        if (this.verbosity >= 1) {
            this.mainLog.println("Splitting: #" + n);
        }
        this.addRemainderIntoChoiceLists(n, list);
        int n2 = this.abstraction.getNumStates();
        int n3 = list.size();
        List<Set<Integer>> list2 = this.abstractToConcrete.get(n);
        int n4 = 0;
        for (List<Integer> list3 : list) {
            int n5;
            ArrayList arrayList = new ArrayList(1);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            arrayList.add(hashSet);
            if (n4 == 0) {
                n5 = n;
                this.abstractToConcrete.set(n5, arrayList);
            } else {
                n5 = n2 + n4 - 1;
                this.abstractToConcrete.add(arrayList);
            }
            for (int n6 : list3) {
                Set<Integer> set3 = list2.get(n6);
                for (int n7 : set3) {
                    this.concreteToAbstract[n7] = n5;
                    hashSet.add(n7);
                }
            }
            ++n4;
        }
        if (this.verbosity >= 10) {
            this.mainLog.print("New concreteToAbstract: ");
            this.mainLog.println(this.concreteToAbstract);
        }
        this.abstraction.addStates(n3 - 1);
        if (this.abstraction.isInitialState(n)) {
            for (n4 = 1; n4 < n3; ++n4) {
                this.abstraction.addInitialState(n2 + n4 - 1);
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            if (n4 != n && !this.abstraction.isSuccessor(n4, n)) continue;
            if (this.rebuildImmed) {
                this.rebuildAbstractionState(n4);
                set.add(n4);
                continue;
            }
            set2.add(n4);
        }
        for (n4 = 1; n4 < n3; ++n4) {
            if (this.rebuildImmed) {
                this.rebuildAbstractionState(n2 + n4 - 1);
                set.add(n4);
                continue;
            }
            set2.add(n2 + n4 - 1);
        }
        return n3;
    }

    @Override
    protected void rebuildAbstraction(Set<Integer> set) throws PrismException {
        for (int n : set) {
            this.rebuildAbstractionState(n);
        }
    }

    protected void rebuildAbstractionState(int n) throws PrismException {
        List<Set<Integer>> list = this.abstractToConcrete.get(n);
        ArrayList arrayList = new ArrayList();
        this.abstraction.clearState(n);
        for (Set<Integer> set : list) {
            for (int n2 : set) {
                int n3;
                int n4 = this.concreteToAbstract[n2];
                if (n4 != n) {
                    throw new PrismException("Oops");
                }
                switch (this.modelType) {
                    case DTMC: {
                        Distribution distribution = this.buildAbstractDistribution(n2, (DTMCSimple)this.modelConcrete);
                        n3 = ((MDPSimple)this.abstraction).addChoice(n4, distribution);
                        break;
                    }
                    case CTMC: {
                        Distribution distribution = this.buildAbstractDistribution(n2, (CTMCSimple)this.modelConcrete);
                        n3 = ((CTMDPSimple)this.abstraction).addChoice(n4, distribution);
                        break;
                    }
                    case MDP: {
                        DistributionSet distributionSet = this.buildAbstractDistributionSet(n2, (MDPSimple)this.modelConcrete, (STPG)((Object)this.abstraction));
                        n3 = ((STPGAbstrSimple)this.abstraction).addDistributionSet(n4, distributionSet);
                        break;
                    }
                    default: {
                        throw new PrismNotSupportedException("Cannot handle model type " + String.valueOf((Object)this.modelType));
                    }
                }
                if (n3 >= arrayList.size()) {
                    arrayList.add(new HashSet(1));
                }
                ((Set)arrayList.get(n3)).add(n2);
            }
        }
        this.abstractToConcrete.set(n, arrayList);
    }

    public void doExactModelChecking() throws PrismException {
        Iterator<Integer> iterator;
        ModelCheckerResult modelCheckerResult = null;
        block0 : switch (this.modelType) {
            case DTMC: {
                iterator = new DTMCModelChecker(null);
                ((ProbModelChecker)((Object)iterator)).inheritSettings(this.mcOptions);
                switch (this.propertyType) {
                    case PROB_REACH: {
                        modelCheckerResult = ((DTMCModelChecker)((Object)iterator)).computeReachProbs((DTMC)((Object)this.modelConcrete), this.targetConcrete);
                        break block0;
                    }
                    case PROB_REACH_BOUNDED: {
                        modelCheckerResult = ((DTMCModelChecker)((Object)iterator)).computeBoundedReachProbs((DTMC)((Object)this.modelConcrete), this.targetConcrete, this.reachBound);
                        break block0;
                    }
                }
                break;
            }
            case CTMC: {
                CTMCModelChecker cTMCModelChecker = new CTMCModelChecker(null);
                cTMCModelChecker.inheritSettings(this.mcOptions);
                switch (this.propertyType) {
                    // Empty switch
                }
                break;
            }
            case MDP: {
                MDPModelChecker mDPModelChecker = new MDPModelChecker(null);
                mDPModelChecker.inheritSettings(this.mcOptions);
                switch (this.propertyType) {
                    case PROB_REACH: {
                        modelCheckerResult = mDPModelChecker.computeReachProbs((MDP)((Object)this.modelConcrete), this.targetConcrete, this.min);
                        break block0;
                    }
                    case PROB_REACH_BOUNDED: {
                        modelCheckerResult = mDPModelChecker.computeBoundedReachProbs((MDP)((Object)this.modelConcrete), this.targetConcrete, this.reachBound, this.min);
                        break block0;
                    }
                }
            }
        }
        if (modelCheckerResult == null) {
            iterator = "Cannot do exact model checking for";
            iterator = iterator + " model type " + String.valueOf((Object)this.modelType) + " and property type " + String.valueOf((Object)this.propertyType);
            throw new PrismException((String)((Object)iterator));
        }
        this.mainLog.print("Results for initial state(s):");
        iterator = this.modelConcrete.getInitialStates().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.mainLog.print(" " + modelCheckerResult.soln[n]);
        }
        this.mainLog.println();
        this.exactInit = this.min ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        for (int n : this.modelConcrete.getInitialStates()) {
            if (this.min) {
                this.exactInit = Math.min(this.exactInit, modelCheckerResult.soln[n]);
                continue;
            }
            this.exactInit = Math.max(this.exactInit, modelCheckerResult.soln[n]);
        }
    }

    @Override
    protected void printFinalSummary(String string, boolean bl) {
        this.mainLog.println("\nConcrete " + String.valueOf((Object)this.modelType) + ": " + this.modelConcrete.infoString());
        super.printFinalSummary(string, bl);
        this.mainLog.print("Exact (concrete) result: " + this.exactInit);
        this.mainLog.println(" (diff = " + Math.abs(this.exactInit - (this.lbInit + this.ubInit) / 2.0) + ")");
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            int n;
            PrismSTPGAbstractRefine prismSTPGAbstractRefine = new PrismSTPGAbstractRefine(null);
            prismSTPGAbstractRefine.sanityChecks = true;
            if (stringArray.length < 3) {
                System.err.println("Usage: java ... [options] <tra file> <lab file> <target label>");
                System.exit(1);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < stringArray.length; ++n) {
                String string;
                String string2;
                String string3 = stringArray[n];
                if (string3.charAt(0) != '-') {
                    arrayList.add(string3);
                    continue;
                }
                int n2 = (string3 = string3.substring(1)).indexOf(61);
                if (n2 != -1) {
                    string2 = string3.substring(n2 + 1);
                    string = string3.substring(0, n2);
                } else {
                    string2 = null;
                    string = string3;
                }
                if (string.equals("min")) {
                    bl = true;
                    continue;
                }
                if (string.equals("max")) {
                    bl = false;
                    continue;
                }
                if (string.equals("dtmc")) {
                    prismSTPGAbstractRefine.setModelType(ModelType.DTMC);
                    continue;
                }
                if (string.equals("ctmc")) {
                    prismSTPGAbstractRefine.setModelType(ModelType.CTMC);
                    continue;
                }
                if (string.equals("mdp")) {
                    prismSTPGAbstractRefine.setModelType(ModelType.MDP);
                    continue;
                }
                if (string.equals("probreach")) {
                    prismSTPGAbstractRefine.setPropertyType(QuantAbstractRefine.PropertyType.PROB_REACH);
                    continue;
                }
                if (string.equals("expreach")) {
                    prismSTPGAbstractRefine.setPropertyType(QuantAbstractRefine.PropertyType.EXP_REACH);
                    continue;
                }
                if (string.equals("probreachbnd")) {
                    prismSTPGAbstractRefine.setPropertyType(QuantAbstractRefine.PropertyType.PROB_REACH_BOUNDED);
                    if (string2 == null) continue;
                    prismSTPGAbstractRefine.setReachBound(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("exact")) {
                    prismSTPGAbstractRefine.exact = true;
                    continue;
                }
                if (string.equals("exactcheck")) {
                    prismSTPGAbstractRefine.exact = true;
                    prismSTPGAbstractRefine.exactCheck = true;
                    continue;
                }
                if (string.equals("rebuild") && string2.equals("immed")) {
                    prismSTPGAbstractRefine.rebuildImmed = true;
                    continue;
                }
                prismSTPGAbstractRefine.parseOption(string3);
            }
            String string = (String)arrayList.get(0);
            prismSTPGAbstractRefine.targetLabel = (String)arrayList.get(1);
            prismSTPGAbstractRefine.traFile = string + ".tra";
            prismSTPGAbstractRefine.labFile = string + ".lab";
            prismSTPGAbstractRefine.rewsFile = string + ".rews";
            prismSTPGAbstractRefine.rewtFile = string + ".rewt";
            System.out.print("Command:");
            for (n = 0; n < stringArray.length; ++n) {
                System.out.print(" " + stringArray[n]);
            }
            System.out.println();
            prismSTPGAbstractRefine.printSettings();
            prismSTPGAbstractRefine.abstractRefine(bl);
        }
        catch (PrismException prismException) {
            System.out.println("Error: " + prismException.getMessage() + ".");
            System.exit(1);
        }
    }
}

