/*
 * Decompiled with CFR 0.152.
 */
package automata;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceType;
import automata.DA;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import jltl2dstar.LTL2Rabin;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.visitor.ASTTraverse;
import parser.visitor.ASTTraverseModify;
import prism.IntegerBound;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;

public class LTL2RabinLibrary {
    private static ArrayList<String> labels;
    private static HashMap<String, String> dras;

    public static DA<BitSet, ? extends AcceptanceOmega> getDAforLTL(Expression expression, Values values, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        Object object;
        DA<BitSet, AcceptanceRabin> dA;
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.RABIN)) {
            return LTL2RabinLibrary.getDRAforLTL(expression, values);
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.STREETT) && (dA = LTL2RabinLibrary.getDRAforLTL((Expression)(object = Expression.Not(expression)), values)) != null) {
            DA.switchAcceptance(dA, dA.getAcceptance().complementToStreett());
            return dA;
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            object = LTL2RabinLibrary.getDRAforLTL(expression, values);
            DA.switchAcceptance((DA)object, ((AcceptanceRabin)((DA)object).getAcceptance()).toAcceptanceGeneric());
            return object;
        }
        return null;
    }

    public static DA<BitSet, AcceptanceRabin> getDRAforLTL(Expression expression, Values values) throws PrismException {
        labels = new ArrayList();
        expression.accept(new ASTTraverse(){

            @Override
            public Object visit(ExpressionLabel expressionLabel) throws PrismLangException {
                labels.add(expressionLabel.getName());
                return null;
            }
        });
        Expression expression2 = expression.deepCopy();
        expression2.accept(new ASTTraverseModify(){

            @Override
            public Object visit(ExpressionLabel expressionLabel) throws PrismLangException {
                int n = labels.indexOf(expressionLabel.getName());
                return new ExpressionLabel("L" + n);
            }
        });
        String string = dras.get(expression2.toString());
        if (string != null) {
            return LTL2RabinLibrary.createDRAFromString(string, labels);
        }
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (!expression.isSimplePathFormula()) {
                throw new PrismNotSupportedException("Unsupported LTL formula with time bounds: " + String.valueOf(expression));
            }
            expression = Expression.convertSimplePathFormulaToCanonicalForm(expression);
            boolean bl = false;
            if (expression instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
                bl = true;
                expression = ((ExpressionUnaryOp)expression).getOperand();
            }
            if (expression instanceof ExpressionTemporal && ((ExpressionTemporal)expression).getOperator() == 2) {
                return LTL2RabinLibrary.constructDRAForSimpleUntilFormula((ExpressionTemporal)expression, values, bl);
            }
            throw new PrismException("Implementation error");
        }
        return null;
    }

    public static DA<BitSet, AcceptanceRabin> constructDRAForSimpleUntilFormula(ExpressionTemporal expressionTemporal, Values values, boolean bl) throws PrismException {
        DA<BitSet, AcceptanceRabin> dA;
        if (expressionTemporal.getOperator() != 2) {
            throw new PrismException("ConstructDRAForSimpleUntilFormula: Not an Until operator!");
        }
        IntegerBound integerBound = IntegerBound.fromExpressionTemporal(expressionTemporal, values, true);
        OperandInfo operandInfo = OperandInfo.constructFrom(expressionTemporal.getOperand1());
        OperandInfo operandInfo2 = OperandInfo.constructFrom(expressionTemporal.getOperand2());
        if (!operandInfo.isProperLabel() && !operandInfo2.isProperLabel()) {
            boolean bl2 = operandInfo2.isFalse() ? false : (operandInfo.isTrue() ? true : integerBound.isInBounds(0));
            dA = LTL2RabinLibrary.constructDRAForTrue(null);
            if (!bl2) {
                bl = !bl;
            }
        } else if (!operandInfo.isProperLabel()) {
            if (operandInfo.isTrue()) {
                dA = LTL2RabinLibrary.constructDRAForFinally(operandInfo2.getLabel(), operandInfo2.isLabelNegated(), integerBound);
            } else if (integerBound.isInBounds(0)) {
                dA = LTL2RabinLibrary.constructDRAForInitialStateLabel(operandInfo2.getLabel(), operandInfo2.isLabelNegated());
            } else {
                dA = LTL2RabinLibrary.constructDRAForTrue(operandInfo2.getLabel());
                bl = !bl;
            }
        } else if (!operandInfo2.isProperLabel()) {
            if (operandInfo2.isFalse()) {
                dA = LTL2RabinLibrary.constructDRAForTrue(operandInfo.getLabel());
                bl = !bl;
            } else if (!integerBound.hasLowerBound() || integerBound.isInBounds(0)) {
                dA = LTL2RabinLibrary.constructDRAForTrue(operandInfo.getLabel());
            } else {
                IntegerBound integerBound2 = new IntegerBound(null, false, integerBound.getLowestInteger(), true);
                dA = LTL2RabinLibrary.constructDRAForFinally(operandInfo.getLabel(), !operandInfo.isLabelNegated(), integerBound2);
                bl = !bl;
            }
        } else {
            dA = LTL2RabinLibrary.constructDRAForUntil(operandInfo.getLabel(), operandInfo.isLabelNegated(), operandInfo2.getLabel(), operandInfo2.isLabelNegated(), integerBound);
        }
        if (bl) {
            BitSet bitSet = (BitSet)((AcceptanceRabin.RabinPair)dA.getAcceptance().get(0)).getL().clone();
            BitSet bitSet2 = (BitSet)((AcceptanceRabin.RabinPair)dA.getAcceptance().get(0)).getK().clone();
            ((AcceptanceRabin.RabinPair)dA.getAcceptance().get(0)).getL().clear();
            ((AcceptanceRabin.RabinPair)dA.getAcceptance().get(0)).getL().or(bitSet2);
            ((AcceptanceRabin.RabinPair)dA.getAcceptance().get(0)).getK().clear();
            ((AcceptanceRabin.RabinPair)dA.getAcceptance().get(0)).getK().or(bitSet);
        }
        return dA;
    }

    public static DA<BitSet, AcceptanceRabin> constructDRAForUntil(String string, boolean bl, String string2, boolean bl2, IntegerBound integerBound) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        BitSet bitSet3 = null;
        BitSet bitSet4 = null;
        int n = integerBound.getMaximalInterestingValue();
        int n2 = n + 3;
        arrayList.add(string);
        if (!string.equals(string2)) {
            arrayList.add(string2);
        }
        DA<BitSet, AcceptanceRabin> dA = new DA<BitSet, AcceptanceRabin>(n2);
        dA.setAcceptance(new AcceptanceRabin());
        dA.setAPList(arrayList);
        dA.setStartState(0);
        if (string.equals(string2)) {
            if (bl == bl2) {
                bitSet = new BitSet();
                bitSet.set(0, bl);
                bitSet4 = new BitSet();
                bitSet4.set(0, !bl);
                bitSet2 = null;
                bitSet3 = null;
            } else {
                bitSet3 = new BitSet();
                bitSet3.set(0, bl);
                bitSet2 = new BitSet();
                bitSet2.set(0, !bl);
            }
        } else {
            bitSet = new BitSet();
            bitSet.set(0, bl);
            bitSet.set(1, bl2);
            bitSet2 = new BitSet();
            bitSet2.set(0, !bl);
            bitSet2.set(1, bl2);
            bitSet3 = new BitSet();
            bitSet3.set(0, bl);
            bitSet3.set(1, !bl2);
            bitSet4 = new BitSet();
            bitSet4.set(0, !bl);
            bitSet4.set(1, !bl2);
        }
        int n3 = n2 - 2;
        int n4 = n2 - 1;
        for (int i = 0; i <= n; ++i) {
            int n5 = i + 1;
            if (n5 > n) {
                n5 = n;
            }
            if (integerBound.isInBounds(i)) {
                if (bitSet3 != null) {
                    dA.addEdge(i, bitSet3, n3);
                }
                if (bitSet4 != null) {
                    dA.addEdge(i, bitSet4, n3);
                }
                if (bitSet != null) {
                    dA.addEdge(i, bitSet, n4);
                }
                if (bitSet2 == null) continue;
                dA.addEdge(i, bitSet2, n5);
                continue;
            }
            if (bitSet3 != null) {
                dA.addEdge(i, bitSet3, n4);
            }
            if (bitSet != null) {
                dA.addEdge(i, bitSet, n4);
            }
            if (bitSet2 != null) {
                dA.addEdge(i, bitSet2, n5);
            }
            if (bitSet4 == null) continue;
            dA.addEdge(i, bitSet4, n5);
        }
        if (bitSet != null) {
            dA.addEdge(n3, bitSet, n3);
        }
        if (bitSet3 != null) {
            dA.addEdge(n3, bitSet3, n3);
        }
        if (bitSet2 != null) {
            dA.addEdge(n3, bitSet2, n3);
        }
        if (bitSet4 != null) {
            dA.addEdge(n3, bitSet4, n3);
        }
        if (bitSet != null) {
            dA.addEdge(n4, bitSet, n4);
        }
        if (bitSet3 != null) {
            dA.addEdge(n4, bitSet3, n4);
        }
        if (bitSet2 != null) {
            dA.addEdge(n4, bitSet2, n4);
        }
        if (bitSet4 != null) {
            dA.addEdge(n4, bitSet4, n4);
        }
        BitSet bitSet5 = new BitSet();
        bitSet5.set(n4);
        bitSet5.set(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(n3);
        ((AcceptanceRabin)dA.getAcceptance()).add(new AcceptanceRabin.RabinPair(bitSet5, bitSet6));
        return dA;
    }

    public static DA<BitSet, AcceptanceRabin> constructDRAForFinally(String string, boolean bl, IntegerBound integerBound) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = integerBound.getMaximalInterestingValue();
        int n2 = n + 2;
        arrayList.add(string);
        DA<BitSet, AcceptanceRabin> dA = new DA<BitSet, AcceptanceRabin>(n2);
        dA.setAcceptance(new AcceptanceRabin());
        dA.setAPList(arrayList);
        dA.setStartState(0);
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        if (bl) {
            bitSet2.set(0);
        } else {
            bitSet.set(0);
        }
        int n3 = n2 - 1;
        for (int i = 0; i <= n; ++i) {
            int n4 = i + 1;
            if (n4 > n) {
                n4 = n;
            }
            if (integerBound.isInBounds(i)) {
                dA.addEdge(i, bitSet, n3);
                dA.addEdge(i, bitSet2, n4);
                continue;
            }
            dA.addEdge(i, bitSet2, n4);
            dA.addEdge(i, bitSet, n4);
        }
        dA.addEdge(n3, bitSet2, n3);
        dA.addEdge(n3, bitSet, n3);
        BitSet bitSet3 = new BitSet();
        bitSet3.set(n);
        BitSet bitSet4 = new BitSet();
        bitSet4.set(n3);
        ((AcceptanceRabin)dA.getAcceptance()).add(new AcceptanceRabin.RabinPair(bitSet3, bitSet4));
        return dA;
    }

    public static DA<BitSet, AcceptanceRabin> constructDRAForTrue(String string) throws PrismException {
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            return LTL2RabinLibrary.createDRAFromString("1 states (start 0), 1 labels: 0-{}->0 0-{0}->0; 1 acceptance pairs: ({},{0})", arrayList);
        }
        return LTL2RabinLibrary.createDRAFromString("1 states (start 0), 0 labels: 0-{}->0; 1 acceptance pairs: ({},{0})", new ArrayList<String>());
    }

    public static DA<BitSet, AcceptanceRabin> constructDRAForInitialStateLabel(String string, boolean bl) throws PrismException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (bl) {
            return LTL2RabinLibrary.createDRAFromString("3 states (start 0), 1 labels: 0-{ }->1 0-{0}->2 1-{0}->1 1-{ }->1 2-{}->2 2-{0}->2; 1 acceptance pairs: ({2},{1})", arrayList);
        }
        return LTL2RabinLibrary.createDRAFromString("3 states (start 0), 1 labels: 0-{0}->1 0-{ }->2 1-{ }->1 1-{0}->1 2-{}->2 2-{0}->2; 1 acceptance pairs: ({2},{1})", arrayList);
    }

    private static DA<BitSet, AcceptanceRabin> createDRAFromString(String string, List<String> list) throws PrismException {
        DA<BitSet, AcceptanceRabin> dA;
        int n = 0;
        AcceptanceRabin acceptanceRabin = new AcceptanceRabin();
        try {
            int n2 = string.indexOf("states", n);
            int n3 = Integer.parseInt(string.substring(0, n2).trim());
            dA = new DA<BitSet, AcceptanceRabin>(n3);
            dA.setAcceptance(acceptanceRabin);
            dA.setAPList(list);
            int n4 = string.indexOf("start", n2) + 6;
            n2 = string.indexOf(")", n4);
            n3 = Integer.parseInt(string.substring(n4, n2).trim());
            dA.setStartState(n3);
            n4 = string.indexOf("labels", n2) + 8;
            n2 = string.indexOf("-{", n4);
            while (n2 != -1) {
                int n5 = Integer.parseInt(string.substring(n4, n2).trim());
                n4 = n2 + 2;
                n2 = string.indexOf("}", n4);
                String string2 = string.substring(n4, n2);
                n4 = n2 + 3;
                n2 = Math.min(string.indexOf(";", n4), string.indexOf(" ", n4));
                int n6 = Integer.parseInt(string.substring(n4, n2).trim());
                dA.addEdge(n5, LTL2RabinLibrary.createBitSetFromString(string2), n6);
                n4 = n2 + 1;
                n2 = string.indexOf("-{", n4);
            }
            n4 = string.indexOf("({", n4);
            while (n4 != -1) {
                n2 = string.indexOf("},{", n4);
                int n7 = string.indexOf("})", n2);
                BitSet bitSet = LTL2RabinLibrary.createBitSetFromString(string.substring(n4 + 2, n2));
                BitSet bitSet2 = LTL2RabinLibrary.createBitSetFromString(string.substring(n2 + 3, n7));
                acceptanceRabin.add(new AcceptanceRabin.RabinPair(bitSet, bitSet2));
                n4 = string.indexOf("({", n7);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error in DRA string format");
        }
        return dA;
    }

    private static BitSet createBitSetFromString(String string) throws PrismException {
        BitSet bitSet = new BitSet();
        String[] stringArray = string.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            string = stringArray[i].trim();
            if (string.length() == 0) continue;
            bitSet.set(Integer.parseInt(string));
        }
        return bitSet;
    }

    public static DA<BitSet, AcceptanceRabin> draForNotFaCb(String string, String string2) throws PrismException {
        int n = 4;
        DA<BitSet, AcceptanceRabin> dA = new DA<BitSet, AcceptanceRabin>(n);
        dA.setAcceptance(new AcceptanceRabin());
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string);
        arrayList.add(string2);
        dA.setAPList(arrayList);
        dA.setStartState(3);
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        bitSet2.set(0);
        BitSet bitSet3 = new BitSet();
        bitSet3.set(1);
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0);
        bitSet4.set(1);
        dA.addEdge(0, bitSet3, 0);
        dA.addEdge(0, bitSet4, 1);
        dA.addEdge(0, bitSet, 0);
        dA.addEdge(0, bitSet2, 1);
        dA.addEdge(1, bitSet3, 2);
        dA.addEdge(1, bitSet4, 2);
        dA.addEdge(1, bitSet, 0);
        dA.addEdge(1, bitSet2, 1);
        dA.addEdge(2, bitSet3, 2);
        dA.addEdge(2, bitSet4, 2);
        dA.addEdge(2, bitSet, 2);
        dA.addEdge(2, bitSet2, 2);
        dA.addEdge(3, bitSet3, 0);
        dA.addEdge(3, bitSet4, 1);
        dA.addEdge(3, bitSet, 0);
        dA.addEdge(3, bitSet2, 1);
        BitSet bitSet5 = new BitSet();
        bitSet5.set(2);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(1);
        bitSet6.set(1);
        ((AcceptanceRabin)dA.getAcceptance()).add(new AcceptanceRabin.RabinPair(bitSet5, bitSet6));
        return dA;
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 ? stringArray[0] : "G F \"L0\"";
            String string2 = "P=?[" + string + "]";
            PropertiesFile propertiesFile = Prism.getPrismParser().parsePropertiesFile(new ModulesFile(), new ByteArrayInputStream(string2.getBytes()));
            Prism.releasePrismParser();
            Expression expression = propertiesFile.getProperty(0);
            expression = ((ExpressionProb)expression).getExpression();
            System.out.println(string);
            System.out.println(expression.toString());
            System.out.println(string.equals(expression.toString()));
            DA<BitSet, AcceptanceRabin> dA = LTL2Rabin.ltl2rabin(expression.convertForJltl2ba());
            System.out.println(dA);
            DA<BitSet, AcceptanceRabin> dA2 = LTL2RabinLibrary.getDRAforLTL(expression, null);
            if (dA2 == null) {
                dA2 = LTL2Rabin.ltl2rabin(expression.convertForJltl2ba());
            }
            System.out.println(dA2);
            System.out.println(dA.toString().equals(dA2.toString()));
        }
        catch (Exception exception) {
            System.err.print("Error: " + String.valueOf(exception));
        }
    }

    static {
        dras = new HashMap();
        dras.put("F \"L0\"", "2 states (start 0), 1 labels: 0-{}->0 0-{0}->1 1-{}->1 1-{0}->1; 1 acceptance pairs: ({},{1})");
        dras.put("G \"L0\"", "2 states (start 0), 1 labels: 0-{}->1 0-{0}->0 1-{}->1 1-{0}->1; 1 acceptance pairs: ({1},{0})");
        dras.put("G F \"L0\"", "2 states (start 0), 1 labels: 0-{0}->1 0-{}->0 1-{0}->1 1-{}->0; 1 acceptance pairs: ({},{1})");
        dras.put("!(G F \"L0\")", "2 states (start 0), 1 labels: 0-{}->1 0-{0}->0 1-{}->1 1-{0}->0; 1 acceptance pairs: ({0},{1})");
        dras.put("F G \"L0\"", "2 states (start 0), 1 labels: 0-{0}->1 0-{}->0 1-{0}->1 1-{}->0; 1 acceptance pairs: ({0},{1})");
        dras.put("!(F G \"L0\")", "2 states (start 0), 1 labels: 0-{}->1 0-{0}->0 1-{}->1 1-{0}->0; 1 acceptance pairs: ({},{1})");
    }

    static class OperandInfo {
        private String label;
        private boolean notNegated;

        public OperandInfo(boolean bl) {
            this.label = null;
            this.notNegated = bl;
        }

        public OperandInfo(String string, boolean bl) {
            this.label = string;
            this.notNegated = bl;
        }

        public static OperandInfo constructFrom(Expression expression) throws PrismException {
            if (expression instanceof ExpressionLabel) {
                return new OperandInfo(((ExpressionLabel)expression).getName(), true);
            }
            if (Expression.isNot(expression)) {
                return OperandInfo.constructFrom(((ExpressionUnaryOp)expression).getOperand()).negated();
            }
            if (expression instanceof ExpressionLiteral && ((ExpressionLiteral)expression).getValue() instanceof Boolean) {
                boolean bl = (Boolean)((ExpressionLiteral)expression).getValue();
                return new OperandInfo(bl);
            }
            throw new PrismException("Unsupported expression " + String.valueOf(expression) + " in formula.");
        }

        public boolean isTrue() {
            return this.label == null && this.notNegated;
        }

        public boolean isFalse() {
            return this.label == null && !this.notNegated;
        }

        public boolean isProperLabel() {
            return this.label != null;
        }

        public String getLabel() {
            assert (this.label != null);
            return this.label;
        }

        public boolean isLabelNegated() {
            assert (this.label != null);
            return !this.notNegated;
        }

        public OperandInfo negated() {
            return new OperandInfo(this.label, !this.notNegated);
        }
    }
}

