/*
 * Decompiled with CFR 0.152.
 */
package automata;

import acceptance.AcceptanceBuchi;
import acceptance.AcceptanceGenRabin;
import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceStreett;
import automata.DA;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAIntermediateStoreAndManipulate;
import jhoafparser.parser.HOAFParser;
import jhoafparser.storage.StoredAutomatonManipulator;
import jhoafparser.transformations.ToStateAcceptance;
import jhoafparser.util.ImplicitEdgeHelper;
import jltl2ba.APElement;
import jltl2ba.APSet;
import jltl2dstar.APMonom;
import jltl2dstar.APMonom2APElements;
import prism.PrismException;

public class HOAF2DA
implements HOAConsumer {
    private DA<BitSet, ? extends AcceptanceOmega> da;
    private APSet aps = new APSet();
    private int size;
    private boolean knowSize = false;
    private int startState;
    private boolean knowStartState = false;
    private BooleanExpression<AtomAcceptance> accExpr = null;
    private String accName;
    private List<Object> extraInfo;
    private List<BitSet> acceptanceSets = null;
    private Set<Integer> negateAcceptanceSetMembership = null;
    private List<String> apList;
    private ImplicitEdgeHelper implicitEdgeHelper = null;
    private long expectedNumberOfEdgesPerState;
    private BitSet statesWithoutDefinition = null;

    private void ensureStateExists(int n) {
        while (n >= this.da.size()) {
            int n2 = this.da.addState();
            this.statesWithoutDefinition.set(n2);
        }
    }

    public void clear() {
        this.aps = new APSet();
        this.implicitEdgeHelper = null;
        this.size = 0;
        this.knowSize = false;
        this.startState = 0;
        this.knowStartState = false;
        this.accExpr = null;
        this.accName = null;
        this.extraInfo = null;
        this.acceptanceSets = null;
        this.negateAcceptanceSetMembership = null;
        this.apList = null;
        this.statesWithoutDefinition = null;
    }

    public boolean parserResolvesAliases() {
        return true;
    }

    public void notifyHeaderStart(String string) throws HOAConsumerException {
    }

    public void setNumberOfStates(int n) throws HOAConsumerException {
        this.size = n;
        this.knowSize = true;
        if (n == 0) {
            throw new HOAConsumerException("Automaton with zero states, need at least one state");
        }
    }

    public void addStartStates(List<Integer> list) throws HOAConsumerException {
        if (list.size() > 1 || this.knowStartState) {
            throw new HOAConsumerException("Not a deterministic automaton: More then one Start state");
        }
        this.startState = list.get(0);
        this.knowStartState = true;
    }

    public void addAlias(String string, BooleanExpression<AtomLabel> booleanExpression) throws HOAConsumerException {
    }

    public void setAPs(List<String> list) throws HOAConsumerException {
        if (list.size() > 30) {
            throw new HOAConsumerException("Automaton has " + list.size() + " atomic propositions, at most 30 are supported");
        }
        this.apList = list;
        this.expectedNumberOfEdgesPerState = 1L << this.apList.size();
        for (String string : list) {
            this.aps.addAP(string);
        }
    }

    public void setAcceptanceCondition(int n, BooleanExpression<AtomAcceptance> booleanExpression) throws HOAConsumerException {
        this.accExpr = booleanExpression;
    }

    public void provideAcceptanceName(String string, List<Object> list) throws HOAConsumerException {
        this.accName = string;
        this.extraInfo = list;
    }

    public void setName(String string) throws HOAConsumerException {
    }

    public void setTool(String string, String string2) throws HOAConsumerException {
    }

    public void addProperties(List<String> list) throws HOAConsumerException {
        if (!list.contains("deterministic")) {
            // empty if block
        }
        if (list.contains("univ-branch")) {
            throw new HOAConsumerException("A HOAF with universal branching is not deterministic");
        }
        if (list.contains("state-labels")) {
            throw new HOAConsumerException("Can't handle state labelling");
        }
    }

    public void addMiscHeader(String string, List<Object> list) throws HOAConsumerException {
        if (string.substring(0, 1).toUpperCase().equals(string.substring(0, 1))) {
            throw new HOAConsumerException("Unknown header " + string + " potentially containing semantic information, can not handle");
        }
    }

    public void notifyBodyStart() throws HOAConsumerException {
        if (!this.knowStartState) {
            throw new HOAConsumerException("Not a deterministic automaton: No initial state specified (Start header)");
        }
        if (this.knowSize && this.startState >= this.size) {
            throw new HOAConsumerException("Initial state " + this.startState + " is out of range");
        }
        if (this.knowSize) {
            this.da = new DA(this.size);
            this.da.setStartState(this.startState);
        } else {
            this.da = new DA();
            this.statesWithoutDefinition = new BitSet();
            this.ensureStateExists(this.startState);
            this.da.setStartState(this.startState);
        }
        if (this.apList == null) {
            this.apList = new ArrayList<String>(0);
        }
        this.da.setAPList(this.apList);
        this.implicitEdgeHelper = new ImplicitEdgeHelper(this.apList.size());
        DA.switchAcceptance(this.da, this.prepareAcceptance());
    }

    private AcceptanceOmega prepareAcceptance() throws HOAConsumerException {
        if (this.accName != null) {
            if (this.accName.equals("Rabin")) {
                return this.prepareAcceptanceRabin();
            }
            if (this.accName.equals("generalized-Rabin")) {
                return this.prepareAcceptanceGenRabin();
            }
            if (this.accName.equals("Streett")) {
                return this.prepareAcceptanceStreett();
            }
            if (this.accName.equals("Buchi")) {
                return this.prepareAcceptanceBuchi();
            }
        }
        this.acceptanceSets = new ArrayList<BitSet>();
        return this.prepareAcceptanceGeneric(this.accExpr);
    }

    private AcceptanceGeneric prepareAcceptanceGeneric(BooleanExpression<AtomAcceptance> booleanExpression) throws HOAConsumerException {
        switch (booleanExpression.getType()) {
            case EXP_TRUE: {
                return new AcceptanceGeneric(true);
            }
            case EXP_FALSE: {
                return new AcceptanceGeneric(false);
            }
            case EXP_AND: {
                return new AcceptanceGeneric(AcceptanceGeneric.ElementType.AND, this.prepareAcceptanceGeneric((BooleanExpression<AtomAcceptance>)booleanExpression.getLeft()), this.prepareAcceptanceGeneric((BooleanExpression<AtomAcceptance>)booleanExpression.getRight()));
            }
            case EXP_OR: {
                return new AcceptanceGeneric(AcceptanceGeneric.ElementType.OR, this.prepareAcceptanceGeneric((BooleanExpression<AtomAcceptance>)booleanExpression.getLeft()), this.prepareAcceptanceGeneric((BooleanExpression<AtomAcceptance>)booleanExpression.getRight()));
            }
            case EXP_NOT: {
                throw new HOAConsumerException("Boolean negation not allowed in acceptance expression");
            }
            case EXP_ATOM: {
                int n = ((AtomAcceptance)booleanExpression.getAtom()).getAcceptanceSet();
                while (n >= this.acceptanceSets.size()) {
                    this.acceptanceSets.add(null);
                }
                if (this.acceptanceSets.get(n) == null) {
                    this.acceptanceSets.set(n, new BitSet());
                }
                BitSet bitSet = this.acceptanceSets.get(n);
                switch (((AtomAcceptance)booleanExpression.getAtom()).getType()) {
                    case TEMPORAL_FIN: {
                        if (((AtomAcceptance)booleanExpression.getAtom()).isNegated()) {
                            return new AcceptanceGeneric(AcceptanceGeneric.ElementType.FIN_NOT, bitSet);
                        }
                        return new AcceptanceGeneric(AcceptanceGeneric.ElementType.FIN, bitSet);
                    }
                    case TEMPORAL_INF: {
                        if (((AtomAcceptance)booleanExpression.getAtom()).isNegated()) {
                            return new AcceptanceGeneric(AcceptanceGeneric.ElementType.INF_NOT, bitSet);
                        }
                        return new AcceptanceGeneric(AcceptanceGeneric.ElementType.INF, bitSet);
                    }
                }
            }
        }
        throw new UnsupportedOperationException("Unknown operator in acceptance condition: " + String.valueOf(booleanExpression));
    }

    private AcceptanceBuchi prepareAcceptanceBuchi() throws HOAConsumerException {
        if (this.extraInfo.size() != 0) {
            throw new HOAConsumerException("Invalid acc-name: Buchi header");
        }
        this.acceptanceSets = new ArrayList<BitSet>(1);
        BitSet bitSet = new BitSet();
        AcceptanceBuchi acceptanceBuchi = new AcceptanceBuchi(bitSet);
        this.acceptanceSets.add(bitSet);
        return acceptanceBuchi;
    }

    private AcceptanceRabin prepareAcceptanceRabin() throws HOAConsumerException {
        if (this.extraInfo.size() != 1 || !(this.extraInfo.get(0) instanceof Integer)) {
            throw new HOAConsumerException("Invalid acc-name: Rabin header");
        }
        int n = (Integer)this.extraInfo.get(0);
        AcceptanceRabin acceptanceRabin = new AcceptanceRabin();
        this.acceptanceSets = new ArrayList<BitSet>(n * 2);
        for (int i = 0; i < n; ++i) {
            BitSet bitSet = new BitSet();
            BitSet bitSet2 = new BitSet();
            this.acceptanceSets.add(bitSet);
            this.acceptanceSets.add(bitSet2);
            acceptanceRabin.add(new AcceptanceRabin.RabinPair(bitSet, bitSet2));
        }
        return acceptanceRabin;
    }

    private AcceptanceStreett prepareAcceptanceStreett() throws HOAConsumerException {
        if (this.extraInfo.size() != 1 || !(this.extraInfo.get(0) instanceof Integer)) {
            throw new HOAConsumerException("Invalid acc-name: Streett header");
        }
        int n = (Integer)this.extraInfo.get(0);
        AcceptanceStreett acceptanceStreett = new AcceptanceStreett();
        this.acceptanceSets = new ArrayList<BitSet>(n * 2);
        for (int i = 0; i < n; ++i) {
            BitSet bitSet = new BitSet();
            BitSet bitSet2 = new BitSet();
            this.acceptanceSets.add(bitSet);
            this.acceptanceSets.add(bitSet2);
            acceptanceStreett.add(new AcceptanceStreett.StreettPair(bitSet, bitSet2));
        }
        return acceptanceStreett;
    }

    private AcceptanceGenRabin prepareAcceptanceGenRabin() throws HOAConsumerException {
        if (this.extraInfo.size() < 1 || !(this.extraInfo.get(0) instanceof Integer)) {
            throw new HOAConsumerException("Invalid acc-name: generalized-Rabin header");
        }
        int n = (Integer)this.extraInfo.get(0);
        if (this.extraInfo.size() != n + 1) {
            throw new HOAConsumerException("Invalid acc-name: generalized-Rabin header");
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (!(this.extraInfo.get(i + 1) instanceof Integer)) {
                throw new HOAConsumerException("Invalid acc-name: generalized-Rabin header");
            }
            nArray[i] = (Integer)this.extraInfo.get(i + 1);
        }
        AcceptanceGenRabin acceptanceGenRabin = new AcceptanceGenRabin();
        this.acceptanceSets = new ArrayList<BitSet>(n * 2);
        for (int i = 0; i < n; ++i) {
            BitSet bitSet = new BitSet();
            this.acceptanceSets.add(bitSet);
            ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
            for (int j = 0; j < nArray[i]; ++j) {
                BitSet bitSet2 = new BitSet();
                arrayList.add(bitSet2);
                this.acceptanceSets.add(bitSet2);
            }
            acceptanceGenRabin.add(new AcceptanceGenRabin.GenRabinPair(bitSet, arrayList));
        }
        return acceptanceGenRabin;
    }

    public void addState(int n, String string, BooleanExpression<AtomLabel> booleanExpression, List<Integer> list) throws HOAConsumerException {
        this.implicitEdgeHelper.startOfState(n);
        if (booleanExpression != null) {
            throw new HOAConsumerException("State " + n + " has a state label, currently only supports labels on transitions");
        }
        if (this.knowSize) {
            if (n >= this.size) {
                throw new HOAConsumerException("Illegal state index " + n + ", out of range");
            }
        } else {
            this.ensureStateExists(n);
            this.statesWithoutDefinition.clear(n);
        }
        if (list != null) {
            for (int n2 : list) {
                BitSet bitSet;
                if (n2 >= this.acceptanceSets.size() || (bitSet = this.acceptanceSets.get(n2)) == null) continue;
                bitSet.set(n);
            }
        }
    }

    public void addEdgeImplicit(int n, List<Integer> list, List<Integer> list2) throws HOAConsumerException {
        if (list.size() != 1) {
            throw new HOAConsumerException("Not a DA, state " + n + " has transition with conjunctive target");
        }
        if (list2 != null) {
            throw new TransitionBasedAcceptanceException("DA has transition-based acceptance (state " + n + ", currently only state-labeled acceptance is supported");
        }
        int n2 = list.get(0);
        if (this.knowSize) {
            if (n2 >= this.size) {
                throw new HOAConsumerException("Illegal state index " + n2 + " in edge from state " + n + ", out of range");
            }
        } else {
            this.ensureStateExists(n2);
        }
        BitSet bitSet = new BitSet();
        long l = this.implicitEdgeHelper.nextImplicitEdge();
        int n3 = 0;
        while (l != 0L) {
            if (l % 2L == 1L) {
                bitSet.set(n3);
            }
            l >>= 1;
            ++n3;
        }
        this.da.addEdge(n, bitSet, n2);
    }

    private List<APMonom> labelExpressionToAPMonom(BooleanExpression<AtomLabel> booleanExpression) throws HOAConsumerException {
        ArrayList<APMonom> arrayList = new ArrayList<APMonom>();
        switch (booleanExpression.getType()) {
            case EXP_AND: 
            case EXP_NOT: 
            case EXP_ATOM: {
                APMonom aPMonom = new APMonom();
                this.labelExpressionToAPMonom(booleanExpression, aPMonom);
                arrayList.add(aPMonom);
                return arrayList;
            }
            case EXP_TRUE: {
                arrayList.add(new APMonom(true));
                return arrayList;
            }
            case EXP_FALSE: {
                arrayList.add(new APMonom(false));
                return arrayList;
            }
            case EXP_OR: {
                arrayList.addAll(this.labelExpressionToAPMonom((BooleanExpression<AtomLabel>)booleanExpression.getLeft()));
                arrayList.addAll(this.labelExpressionToAPMonom((BooleanExpression<AtomLabel>)booleanExpression.getRight()));
                return arrayList;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in label expression: " + String.valueOf(booleanExpression));
    }

    private void labelExpressionToAPMonom(BooleanExpression<AtomLabel> booleanExpression, APMonom aPMonom) throws HOAConsumerException {
        try {
            switch (booleanExpression.getType()) {
                case EXP_TRUE: 
                case EXP_FALSE: 
                case EXP_OR: {
                    throw new HOAConsumerException("Complex transition labels are not yet supported, only disjunctive normal form: " + String.valueOf(booleanExpression));
                }
                case EXP_AND: {
                    this.labelExpressionToAPMonom((BooleanExpression<AtomLabel>)booleanExpression.getLeft(), aPMonom);
                    this.labelExpressionToAPMonom((BooleanExpression<AtomLabel>)booleanExpression.getRight(), aPMonom);
                    return;
                }
                case EXP_ATOM: {
                    int n = ((AtomLabel)booleanExpression.getAtom()).getAPIndex();
                    if (aPMonom.isSet(n) && !aPMonom.getValue(n)) {
                        throw new HOAConsumerException("Complex transition labels are not yet supported, transition label evaluates to false");
                    }
                    aPMonom.setValue(n, true);
                    return;
                }
                case EXP_NOT: {
                    if (!booleanExpression.getLeft().isAtom()) {
                        throw new HOAConsumerException("Complex transition labels are not yet supported, only conjunction of (negated) labels");
                    }
                    int n = ((AtomLabel)booleanExpression.getLeft().getAtom()).getAPIndex();
                    if (aPMonom.isSet(n) && aPMonom.getValue(n)) {
                        throw new HOAConsumerException("Complex transition labels are not yet supported, transition label evaluates to false");
                    }
                    aPMonom.setValue(n, false);
                    return;
                }
            }
        }
        catch (PrismException prismException) {
            throw new HOAConsumerException("While parsing, APMonom exception: " + prismException.getMessage());
        }
    }

    public void addEdgeWithLabel(int n, BooleanExpression<AtomLabel> booleanExpression, List<Integer> list, List<Integer> list2) throws HOAConsumerException {
        if (list.size() != 1) {
            throw new HOAConsumerException("Not a DA, state " + n + " has transition with conjunctive target");
        }
        if (list2 != null) {
            throw new TransitionBasedAcceptanceException("DA has transition-based acceptance (state " + n + ", currently only state-labeled acceptance is supported");
        }
        if (booleanExpression == null) {
            throw new HOAConsumerException("Missing label on transition");
        }
        int n2 = list.get(0);
        if (this.knowSize) {
            if (n2 >= this.size) {
                throw new HOAConsumerException("Illegal state index " + n2 + " in edge from state " + n + ", out of range");
            }
        } else {
            this.ensureStateExists(n2);
        }
        for (APMonom aPMonom : this.labelExpressionToAPMonom(booleanExpression)) {
            APMonom2APElements aPMonom2APElements = new APMonom2APElements(this.aps, aPMonom);
            while (aPMonom2APElements.hasNext()) {
                APElement aPElement = aPMonom2APElements.next();
                int n3 = this.da.getEdgeDestByLabel(n, aPElement);
                if (n3 == n2) continue;
                if (n3 != -1) {
                    throw new HOAConsumerException("Not a deterministic automaton, non-determinism detected (state " + n + ", label = " + String.valueOf(aPElement) + ", to=" + n2 + ", previously to " + n3 + ")");
                }
                this.da.addEdge(n, aPElement, n2);
            }
        }
    }

    public void notifyEndOfState(int n) throws HOAConsumerException {
        this.implicitEdgeHelper.endOfState();
        if ((long)this.da.getNumEdges(n) != this.expectedNumberOfEdgesPerState) {
            throw new HOAConsumerException("State " + n + " has " + this.da.getNumEdges(n) + " transitions, should have " + this.expectedNumberOfEdgesPerState + " (automaton is required to be complete and deterministic)");
        }
    }

    public void notifyEnd() throws HOAConsumerException {
        if (!this.knowSize && !this.statesWithoutDefinition.isEmpty()) {
            int n = this.statesWithoutDefinition.nextSetBit(0);
            throw new HOAConsumerException(this.statesWithoutDefinition.cardinality() + " states (e.g., state " + n + ") have no definition (automaton is required to be complete and deterministic)");
        }
        if (this.negateAcceptanceSetMembership != null) {
            for (int n : this.negateAcceptanceSetMembership) {
                this.acceptanceSets.get(n).flip(0, this.da.size());
            }
        }
        this.clear();
    }

    public void notifyAbort() {
        this.clear();
    }

    public DA<BitSet, ? extends AcceptanceOmega> getDA() {
        return this.da;
    }

    public void notifyWarning(String string) throws HOAConsumerException {
        throw new HOAConsumerException(string);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        InputStream inputStream = null;
        try {
            DA<BitSet, ? extends AcceptanceOmega> dA;
            if (stringArray.length != 2) {
                System.err.println("Usage: input-file output-file\n\n Filename can be '-' for standard input/output");
                System.exit(1);
            }
            inputStream = stringArray[0].equals("-") ? System.in : new FileInputStream(stringArray[0]);
            String string = stringArray[1];
            PrintStream printStream = string.equals("-") ? System.out : new PrintStream(string);
            try {
                HOAF2DA hOAF2DA = new HOAF2DA();
                HOAFParser.parseHOA((InputStream)inputStream, (HOAConsumer)hOAF2DA);
                dA = hOAF2DA.getDA();
            }
            catch (TransitionBasedAcceptanceException transitionBasedAcceptanceException) {
                if (inputStream == System.in) {
                    System.out.println("Automaton with transition-based acceptance, can only be (re)parsed from file");
                    System.exit(1);
                }
                System.out.println("Automaton with transition-based acceptance, automatically converting to state-based acceptance...");
                HOAF2DA hOAF2DA = new HOAF2DA();
                HOAIntermediateStoreAndManipulate hOAIntermediateStoreAndManipulate = new HOAIntermediateStoreAndManipulate((HOAConsumer)hOAF2DA, new StoredAutomatonManipulator[]{new ToStateAcceptance()});
                HOAFParser.parseHOA((InputStream)inputStream, (HOAConsumer)hOAIntermediateStoreAndManipulate);
                dA = hOAF2DA.getDA();
            }
            if (dA == null) {
                throw new PrismException("Could not construct DA");
            }
            dA.printHOA(printStream);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            n = 1;
        }
        if (n != 0) {
            System.exit(n);
        }
    }

    public class TransitionBasedAcceptanceException
    extends HOAConsumerException {
        public TransitionBasedAcceptanceException(String string) {
            super(string);
        }
    }
}

