/*
 * Decompiled with CFR 0.152.
 */
package com.sri.yices;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class Profiler {
    public static boolean enabled = false;
    private static final boolean distributions = false;
    private static long cost = 0L;
    private static Set<Long> threads = new HashSet<Long>();
    private static Map<String, Long> lineItems = new HashMap<String, Long>();
    private static int lineItemMax = 0;
    private static Map<String, Map<Integer, Integer>> distribution = new HashMap<String, Map<Integer, Integer>>();

    private static void addThread() {
        long l = Thread.currentThread().getId();
        threads.add(l);
    }

    private static void addLineItem(String string, long l) {
        Long l2 = lineItems.get(string);
        if (l2 == null) {
            int n = string.length();
            lineItems.put(string, l);
            lineItemMax = lineItemMax < n ? n : lineItemMax;
        } else {
            lineItems.put(string, l2 + l);
        }
    }

    private static void addDistribution(String string, int n) {
        n /= 100;
        Map<Integer, Integer> map = distribution.get(string);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            distribution.put(string, map);
        }
        int n2 = map.getOrDefault(n, 0);
        map.put(n, n2 + 1);
    }

    public static int getThreadCount() {
        return threads.size();
    }

    public static void configure(boolean bl) {
        enabled = bl;
    }

    public static void delta(String string, long l, long l2) {
        Profiler.delta(string, l, l2, false);
    }

    public static void delta(String string, long l, long l2, boolean bl) {
        long l3 = l2 >= l ? l2 - l : l - l2;
        Profiler.addThread();
        Profiler.addLineItem(string, l3);
        cost += l3;
    }

    public static void reset() {
        cost = 0L;
    }

    public static long get() {
        long l = cost;
        cost = 0L;
        return l;
    }

    public static String report() {
        StringBuilder stringBuilder = new StringBuilder();
        Profiler.toString(stringBuilder);
        return stringBuilder.toString();
    }

    private static String pad(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            char[] cArray = new char[n];
            char[] cArray2 = string.toCharArray();
            for (int i = 0; i < n; ++i) {
                cArray[i] = i < n2 ? cArray2[i] : 32;
            }
            return new String(cArray);
        }
        return string;
    }

    private static void lineItems2StringBuilder(StringBuilder stringBuilder) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        lineItems.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(entry -> linkedHashMap.put((String)entry.getKey(), (Long)entry.getValue()));
        int n = lineItemMax + 5;
        for (String string : linkedHashMap.keySet()) {
            stringBuilder.append(Profiler.pad(string, n)).append(lineItems.get(string) / 1000000L).append(" milliseconds\n");
        }
    }

    private static void distribution2StringBuilder(String string, StringBuilder stringBuilder) {
        Map<Integer, Integer> map = distribution.get(string);
        stringBuilder.append("[");
        for (int i = 0; i < 100; ++i) {
            stringBuilder.append(map.getOrDefault(i, 0));
            if (i >= 99) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]\n");
    }

    private static void distribution2StringBuilder(StringBuilder stringBuilder) {
        for (String string : distribution.keySet()) {
            stringBuilder.append("\n").append(string).append(" Distribution").append("\n\n");
            Profiler.distribution2StringBuilder(string, stringBuilder);
        }
    }

    public static void toString(StringBuilder stringBuilder) {
        if (enabled) {
            stringBuilder.append("\n--- PROFILING SUMMARY ---\n\n");
            stringBuilder.append("Calling thread count: ").append(Profiler.getThreadCount()).append("\n\n");
            Profiler.lineItems2StringBuilder(stringBuilder);
        }
    }
}

