/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LinAlg<C extends RingElem<C>>
implements Serializable {
    private static final Logger logger = LogManager.getLogger(LinAlg.class);

    public List<Integer> decompositionLU(GenMatrix<C> genMatrix) {
        if (genMatrix == null) {
            return null;
        }
        GenMatrixRing genMatrixRing = genMatrix.ring;
        int n = genMatrixRing.rows;
        int n2 = genMatrixRing.cols;
        int n3 = Math.min(n, n2);
        if (n != n2) {
            logger.warn("nosquare matrix");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n3 + 1);
        for (int i = 0; i <= n3; ++i) {
            arrayList.add(i);
        }
        ArrayList arrayList2 = genMatrix.matrix;
        for (int i = 0; i < n3; ++i) {
            Serializable serializable;
            int n4;
            int n5 = i;
            RingElem ringElem = (RingElem)genMatrixRing.coFac.getZERO();
            for (n4 = i; n4 < n; ++n4) {
                serializable = (RingElem)((RingElem)arrayList2.get(n4).get(i)).abs();
                if (serializable.compareTo(ringElem) <= 0) continue;
                ringElem = serializable;
                n5 = n4;
                break;
            }
            if (ringElem.isZERO()) {
                logger.warn("matrix is degenerate at col {}", (Object)i);
                arrayList2.get(i).set(i, (RingElem)genMatrixRing.coFac.getZERO());
                arrayList.clear();
                return arrayList;
            }
            if (n5 != i) {
                n4 = (Integer)arrayList.get(i);
                arrayList.set(i, (Integer)arrayList.get(n5));
                arrayList.set(n5, n4);
                serializable = arrayList2.get(i);
                arrayList2.set(i, arrayList2.get(n5));
                arrayList2.set(n5, serializable);
                arrayList.set(n3, (Integer)arrayList.get(n3) + 1);
            }
            RingElem ringElem2 = (RingElem)((RingElem)arrayList2.get(i).get(i)).inverse();
            for (int j = i + 1; j < n; ++j) {
                RingElem ringElem3 = ((RingElem)arrayList2.get(j).get(i)).multiply(ringElem2);
                arrayList2.get(j).set(i, ringElem3);
                for (int k = i + 1; k < n2; ++k) {
                    RingElem ringElem4 = ((RingElem)arrayList2.get(j).get(i)).multiply((RingElem)arrayList2.get(i).get(k));
                    arrayList2.get(j).set(k, ((RingElem)arrayList2.get(j).get(k)).subtract(ringElem4));
                }
            }
        }
        return arrayList;
    }

    public GenVector<C> solveLU(GenMatrix<C> genMatrix, List<Integer> list, GenVector<C> genVector) {
        RingElem ringElem;
        int n;
        RingElem ringElem2;
        int n2;
        if (genMatrix == null || genVector == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        GenMatrixRing genMatrixRing = genMatrix.ring;
        int n3 = genMatrixRing.rows;
        GenVectorModul genVectorModul = new GenVectorModul(genMatrixRing.coFac, n3);
        GenVector genVector2 = new GenVector(genVectorModul);
        List list2 = genVector2.val;
        ArrayList arrayList = genMatrix.matrix;
        for (n2 = 0; n2 < n3; ++n2) {
            list2.set(n2, genVector.get(list.get(n2)));
            ringElem2 = (RingElem)list2.get(n2);
            for (n = 0; n < n2; ++n) {
                ringElem = ((RingElem)arrayList.get(n2).get(n)).multiply((RingElem)list2.get(n));
                ringElem2 = ringElem2.subtract(ringElem);
            }
            list2.set(n2, ringElem2);
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            ringElem2 = (RingElem)list2.get(n2);
            for (n = n2 + 1; n < n3; ++n) {
                ringElem = ((RingElem)arrayList.get(n2).get(n)).multiply((RingElem)list2.get(n));
                ringElem2 = ringElem2.subtract(ringElem);
            }
            list2.set(n2, ringElem2);
            list2.set(n2, ringElem2.divide((RingElem)arrayList.get(n2).get(n2)));
        }
        return genVector2;
    }

    public GenVector<C> solve(GenMatrix<C> genMatrix, GenVector<C> genVector) {
        if (genMatrix == null || genVector == null) {
            return null;
        }
        Element element = genMatrix.copy();
        List<Integer> list = this.decompositionLU((GenMatrix<C>)element);
        if (list.size() == 0) {
            System.out.println("undecomposable");
            return genVector.modul.getZERO();
        }
        GenVector<C> genVector2 = this.solveLU((GenMatrix<C>)element, list, genVector);
        return genVector2;
    }

    public C determinantLU(GenMatrix<C> genMatrix, List<Integer> list) {
        int n;
        if (genMatrix == null) {
            return null;
        }
        if (list.size() == 0) {
            return (C)((RingElem)genMatrix.ring.coFac.getZERO());
        }
        int n2 = genMatrix.ring.rows;
        ArrayList arrayList = genMatrix.matrix;
        RingElem ringElem = (RingElem)arrayList.get(0).get(0);
        for (n = 1; n < n2; ++n) {
            ringElem = ringElem.multiply((RingElem)arrayList.get(n).get(n));
        }
        n = list.get(n2) - n2;
        if (n % 2 != 0) {
            ringElem = (RingElem)ringElem.negate();
        }
        return (C)ringElem;
    }

    public GenMatrix<C> inverseLU(GenMatrix<C> genMatrix, List<Integer> list) {
        GenMatrixRing genMatrixRing = genMatrix.ring;
        GenMatrix genMatrix2 = new GenMatrix(genMatrixRing);
        int n = genMatrixRing.rows;
        ArrayList arrayList = genMatrix.matrix;
        ArrayList arrayList2 = genMatrix2.matrix;
        for (int i = 0; i < n; ++i) {
            RingElem ringElem;
            RingElem ringElem2;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                ringElem2 = list.get(n2) == i ? (RingElem)genMatrixRing.coFac.getONE() : (RingElem)genMatrixRing.coFac.getZERO();
                arrayList2.get(n2).set(i, ringElem2);
                ringElem = ringElem2;
                for (int j = 0; j < n2; ++j) {
                    RingElem ringElem3 = ((RingElem)arrayList.get(n2).get(j)).multiply((RingElem)arrayList2.get(j).get(i));
                    ringElem = ringElem.subtract(ringElem3);
                }
                arrayList2.get(n2).set(i, ringElem);
            }
            for (n2 = n - 1; n2 >= 0; --n2) {
                ringElem2 = (RingElem)arrayList2.get(n2).get(i);
                for (int j = n2 + 1; j < n; ++j) {
                    RingElem ringElem4 = ((RingElem)arrayList.get(n2).get(j)).multiply((RingElem)arrayList2.get(j).get(i));
                    ringElem2 = ringElem2.subtract(ringElem4);
                }
                arrayList2.get(n2).set(i, ringElem2);
                ringElem = ringElem2;
                ringElem = ringElem.divide((RingElem)arrayList.get(n2).get(n2));
                arrayList2.get(n2).set(i, ringElem);
            }
        }
        return genMatrix2;
    }

    public List<GenVector<C>> nullSpaceBasis(GenMatrix<C> genMatrix) {
        Object object;
        int n;
        if (genMatrix == null) {
            return null;
        }
        GenMatrixRing genMatrixRing = genMatrix.ring;
        int n2 = genMatrixRing.rows;
        int n3 = genMatrixRing.cols;
        if (n2 != n3) {
            logger.warn("nosquare matrix");
        }
        ArrayList<GenVector<C>> arrayList = new ArrayList<GenVector<C>>();
        GenVectorModul genVectorModul = new GenVectorModul(genMatrixRing.coFac, n3);
        ArrayList arrayList2 = genMatrix.matrix;
        for (n = 0; n < n2; ++n) {
            RingElem ringElem;
            int n4;
            int n5;
            RingElem ringElem2;
            int n6;
            int n7 = n;
            object = (RingElem)genMatrixRing.coFac.getZERO();
            for (n6 = n; n6 < n3; ++n6) {
                ringElem2 = (RingElem)((RingElem)arrayList2.get(n).get(n6)).abs();
                if (ringElem2.compareTo(object) <= 0 || !object.isZERO()) continue;
                object = ringElem2;
                n7 = n6;
            }
            logger.info("pivot: {}, i = {}, maxA = {}", (Object)n7, (Object)n, object);
            if (object.isZERO()) {
                n6 = n;
                for (n5 = 0; n5 < n; ++n5) {
                    ringElem2 = (RingElem)((RingElem)arrayList2.get(n).get(n5)).abs();
                    if (ringElem2.compareTo(object) <= 0) continue;
                    n6 = n5;
                    boolean bl = true;
                    for (n4 = 0; n4 < n; ++n4) {
                        ringElem = (RingElem)((RingElem)arrayList2.get(n4).get(n6)).abs();
                        if (ringElem.isZERO()) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    n7 = n6;
                    logger.info("pivot*: {}, i = {}, absA = {}", (Object)n7, (Object)n, (Object)ringElem2);
                    object = (RingElem)genMatrixRing.coFac.getONE();
                }
                if (object.isZERO()) continue;
            }
            if (n7 >= n3) continue;
            RingElem ringElem3 = (RingElem)((RingElem)arrayList2.get(n).get(n7)).inverse();
            for (n5 = 0; n5 < n2; ++n5) {
                RingElem ringElem4 = (RingElem)arrayList2.get(n5).get(n7);
                ringElem4 = ringElem4.multiply(ringElem3);
                arrayList2.get(n5).set(n7, ringElem4);
            }
            if (n7 != n) {
                for (n5 = 0; n5 < n2; ++n5) {
                    RingElem ringElem5 = (RingElem)arrayList2.get(n5).get(n);
                    arrayList2.get(n5).set(n, (RingElem)arrayList2.get(n5).get(n7));
                    arrayList2.get(n5).set(n7, ringElem5);
                }
            }
            for (n5 = 0; n5 < n3; ++n5) {
                if (n == n5) continue;
                RingElem ringElem6 = (RingElem)arrayList2.get(n).get(n5);
                for (n4 = 0; n4 < n2; ++n4) {
                    ringElem = (RingElem)arrayList2.get(n4).get(n5);
                    RingElem ringElem7 = (RingElem)arrayList2.get(n4).get(n);
                    RingElem ringElem8 = ringElem.subtract(ringElem7.multiply(ringElem6));
                    arrayList2.get(n4).set(n5, ringElem8);
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            object = (RingElem)arrayList2.get(n).get(n);
            object = object.subtract((RingElem)genMatrixRing.coFac.getONE());
            arrayList2.get(n).set(n, object);
        }
        for (n = 0; n < n2; ++n) {
            object = arrayList2.get(n);
            boolean bl = true;
            for (int i = 0; i < n3; ++i) {
                if (((RingElem)object.get(i)).isZERO()) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            GenVector genVector = new GenVector(genVectorModul, object);
            arrayList.add(genVector);
        }
        return arrayList;
    }

    public long rankNS(GenMatrix<C> genMatrix) {
        if (genMatrix == null) {
            return -1L;
        }
        Element element = genMatrix.copy();
        long l = Math.min(genMatrix.ring.rows, genMatrix.ring.cols);
        List<GenVector<C>> list = this.nullSpaceBasis((GenMatrix<C>)element);
        long l2 = list.size();
        return l - l2;
    }

    public GenMatrix<C> rowEchelonForm(GenMatrix<C> genMatrix) {
        if (genMatrix == null) {
            return null;
        }
        GenMatrixRing genMatrixRing = genMatrix.ring;
        int n = genMatrixRing.rows;
        int n2 = genMatrixRing.cols;
        if (n != n2) {
            logger.warn("nosquare matrix");
        }
        int n3 = 0;
        ArrayList arrayList = genMatrix.matrix;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6 = n4;
            RingElem ringElem = (RingElem)genMatrixRing.coFac.getZERO();
            for (int i = n4; i < n; ++i) {
                RingElem ringElem2 = (RingElem)((RingElem)arrayList.get(i).get(n3)).abs();
                if (ringElem2.compareTo(ringElem) <= 0) continue;
                ringElem = ringElem2;
                n6 = i;
                break;
            }
            if (ringElem.isZERO()) {
                if (++n3 < n2) continue;
                break;
            }
            if (n6 != n4) {
                ArrayList arrayList2 = arrayList.get(n4);
                arrayList.set(n4, arrayList.get(n6));
                arrayList.set(n6, arrayList2);
            }
            RingElem ringElem3 = (RingElem)((RingElem)arrayList.get(n4).get(n3)).inverse();
            for (n5 = n3; n5 < n2; ++n5) {
                RingElem ringElem4 = ((RingElem)arrayList.get(n4).get(n5)).multiply(ringElem3);
                arrayList.get(n4).set(n5, ringElem4);
            }
            for (n5 = n4 + 1; n5 < n; ++n5) {
                for (int i = n3; i < n2; ++i) {
                    RingElem ringElem5 = ((RingElem)arrayList.get(n5).get(i)).multiply((RingElem)arrayList.get(n4).get(i));
                    if (ringElem5.isZERO()) continue;
                    arrayList.get(n5).set(i, ((RingElem)arrayList.get(n5).get(i)).subtract(ringElem5));
                }
            }
            arrayList.get(n4).set(n3, (RingElem)genMatrixRing.coFac.getONE());
            ++n4;
            if (++n3 < n2) continue;
            break;
        }
        return genMatrix;
    }

    public long rankRE(GenMatrix<C> genMatrix) {
        if (genMatrix == null) {
            return -1L;
        }
        long l = genMatrix.ring.rows;
        long l2 = genMatrix.ring.cols;
        ArrayList arrayList = genMatrix.matrix;
        long l3 = 0L;
        int n = 0;
        while ((long)n < l) {
            ArrayList arrayList2 = arrayList.get(n);
            int n2 = n;
            while ((long)n2 < l2) {
                if (!((RingElem)arrayList2.get(n2)).isZERO()) {
                    ++l3;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return l3;
    }

    public GenMatrix<C> rowEchelonFormSparse(GenMatrix<C> genMatrix) {
        if (genMatrix == null) {
            return null;
        }
        GenMatrixRing genMatrixRing = genMatrix.ring;
        int n = genMatrixRing.rows;
        int n2 = genMatrixRing.cols;
        if (n != n2) {
            logger.warn("nosquare matrix");
        }
        ArrayList arrayList = genMatrix.matrix;
        for (int i = n - 1; i > 0; --i) {
            int n3;
            int n4 = i;
            RingElem ringElem = (RingElem)genMatrixRing.coFac.getZERO();
            int n5 = -1;
            for (n3 = i; n3 < n2; ++n3) {
                RingElem ringElem2 = (RingElem)((RingElem)arrayList.get(i).get(n3)).abs();
                if (ringElem2.compareTo(ringElem) <= 0) continue;
                ringElem = ringElem2;
                n5 = n3;
                break;
            }
            if (ringElem.isZERO()) continue;
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                for (int j = n5; j < n2; ++j) {
                    RingElem ringElem3;
                    RingElem ringElem4 = (RingElem)arrayList.get(n3).get(j);
                    if (ringElem4.isZERO() || (ringElem3 = (RingElem)arrayList.get(n4).get(j)).isZERO()) continue;
                    RingElem ringElem5 = ringElem3.multiply(ringElem4);
                    ringElem4 = ringElem4.subtract(ringElem5);
                    arrayList.get(n3).set(j, ringElem4);
                }
            }
        }
        return genMatrix;
    }

    public List<Integer> fractionfreeGaussElimination(GenMatrix<C> genMatrix) {
        int n;
        if (genMatrix == null) {
            return null;
        }
        GenMatrixRing genMatrixRing = genMatrix.ring;
        int n2 = genMatrixRing.rows;
        int n3 = genMatrixRing.cols;
        int n4 = Math.min(n2, n3);
        if (n2 != n3) {
            logger.warn("nosquare matrix");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n4 + 1);
        for (n = 0; n <= n4; ++n) {
            arrayList.add(n);
        }
        n = 0;
        RingElem ringElem = (RingElem)genMatrixRing.coFac.getONE();
        ArrayList arrayList2 = genMatrix.matrix;
        for (int i = 0; i < n4 && n < n2; ++n, ++i) {
            Serializable serializable;
            int n5;
            int n6 = i;
            RingElem ringElem2 = (RingElem)genMatrixRing.coFac.getZERO();
            for (n5 = i; n5 < n2; ++n5) {
                serializable = (RingElem)((RingElem)arrayList2.get(n5).get(i)).abs();
                if (serializable.compareTo(ringElem2) <= 0) continue;
                ringElem2 = serializable;
                n6 = n5;
                break;
            }
            if (ringElem2.isZERO()) {
                logger.warn("matrix is degenerate at col {}", (Object)i);
                arrayList2.get(i).set(i, (RingElem)genMatrixRing.coFac.getZERO());
                arrayList.clear();
                return arrayList;
            }
            if (n6 != i) {
                n5 = (Integer)arrayList.get(i);
                arrayList.set(i, (Integer)arrayList.get(n6));
                arrayList.set(n6, n5);
                serializable = arrayList2.get(i);
                arrayList2.set(i, arrayList2.get(n6));
                arrayList2.set(n6, serializable);
                arrayList.set(n4, (Integer)arrayList.get(n4) + 1);
            }
            for (n5 = n + 1; n5 < n2; ++n5) {
                for (int j = i + 1; j < n3; ++j) {
                    RingElem ringElem3 = ((RingElem)arrayList2.get(n).get(i)).multiply((RingElem)arrayList2.get(n5).get(j));
                    RingElem ringElem4 = ((RingElem)arrayList2.get(n).get(j)).multiply((RingElem)arrayList2.get(n5).get(i));
                    RingElem ringElem5 = ringElem3.subtract(ringElem4).divide(ringElem);
                    arrayList2.get(n5).set(j, ringElem5);
                }
            }
            for (n5 = n + 1; n5 < n2; ++n5) {
                arrayList2.get(n5).set(i, (RingElem)genMatrixRing.coFac.getZERO());
            }
            ringElem = (RingElem)arrayList2.get(n).get(i);
        }
        return arrayList;
    }
}

