/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenSolvablePolynomialTest
extends TestCase {
    int rl = 6;
    int kl = 10;
    int ll = 7;
    int el = 4;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenSolvablePolynomialTest.suite());
    }

    public GenSolvablePolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GenSolvablePolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstructors() {
        BigRational bigRational = new BigRational();
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(bigRational, 2);
        GenPolynomial genPolynomial = genSolvablePolynomialRing.getONE();
        genPolynomial = genSolvablePolynomialRing.random(9);
        genPolynomial = genSolvablePolynomialRing.getZERO();
        RingElem ringElem = new GenSolvablePolynomial<BigRational>(genSolvablePolynomialRing);
        GenSolvablePolynomialTest.assertTrue((String)"p.equals(pe) = ", (boolean)((GenSolvablePolynomial)genPolynomial).equals(ringElem));
        GenSolvablePolynomialTest.assertTrue((String)"p.equals(p) = ", (boolean)((GenSolvablePolynomial)genPolynomial).equals(genPolynomial));
        ringElem = ringElem.sum(genPolynomial);
        GenSolvablePolynomialTest.assertTrue((String)"pe.isZERO() = ", (boolean)ringElem.isZERO());
        genPolynomial = genSolvablePolynomialRing.random(9);
        genPolynomial = (GenSolvablePolynomial)genPolynomial.subtract(genPolynomial);
        GenSolvablePolynomialTest.assertTrue((String)"p.isZERO() = ", (boolean)genPolynomial.isZERO());
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing2 = new GenSolvablePolynomialRing<BigRational>(genSolvablePolynomialRing, 3);
        GenPolynomial genPolynomial2 = genSolvablePolynomialRing2.getONE();
        genPolynomial2 = genSolvablePolynomialRing2.random(2);
        genPolynomial2 = genSolvablePolynomialRing2.getZERO();
        RingElem ringElem2 = new GenSolvablePolynomial<BigRational>(genSolvablePolynomialRing2);
        GenSolvablePolynomialTest.assertTrue((String)"pp.equals(ppe) = ", (boolean)((GenSolvablePolynomial)genPolynomial2).equals(ringElem2));
        GenSolvablePolynomialTest.assertTrue((String)"pp.equals(pp) = ", (boolean)((GenSolvablePolynomial)genPolynomial2).equals(genPolynomial2));
        ringElem2 = ringElem2.sum(genPolynomial2);
        GenSolvablePolynomialTest.assertTrue((String)"ppe.isZERO() = ", (boolean)ringElem2.isZERO());
        genPolynomial2 = genSolvablePolynomialRing2.random(2);
        genPolynomial2 = (GenSolvablePolynomial)genPolynomial2.subtract(genPolynomial2);
        GenSolvablePolynomialTest.assertTrue((String)"pp.isZERO() = ", (boolean)genPolynomial2.isZERO());
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing3 = new GenSolvablePolynomialRing<BigRational>(genSolvablePolynomialRing2, 4);
        GenPolynomial genPolynomial3 = genSolvablePolynomialRing3.getONE();
        genPolynomial3 = genSolvablePolynomialRing3.random(2);
        genPolynomial3 = genSolvablePolynomialRing3.getZERO();
        RingElem ringElem3 = new GenSolvablePolynomial<BigRational>(genSolvablePolynomialRing3);
        GenSolvablePolynomialTest.assertTrue((String)"ppp.equals(pppe) = ", (boolean)((GenSolvablePolynomial)genPolynomial3).equals(ringElem3));
        GenSolvablePolynomialTest.assertTrue((String)"ppp.equals(ppp) = ", (boolean)((GenSolvablePolynomial)genPolynomial3).equals(genPolynomial3));
        ringElem3 = ringElem3.sum(genPolynomial3);
        GenSolvablePolynomialTest.assertTrue((String)"pppe.isZERO() = ", (boolean)ringElem3.isZERO());
        genPolynomial3 = genSolvablePolynomialRing3.random(2);
        genPolynomial3 = (GenSolvablePolynomial)genPolynomial3.subtract(genPolynomial3);
        GenSolvablePolynomialTest.assertTrue((String)"ppp.isZERO() = ", (boolean)genPolynomial3.isZERO());
    }

    public void testExtendContract() {
        BigRational bigRational = new BigRational(99L);
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl);
        GenPolynomial genPolynomial = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
        int n = this.rl;
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.extend(n);
        GenPolynomialRing genPolynomialRing2 = ((GenSolvablePolynomialRing)genPolynomialRing).contract(n);
        GenSolvablePolynomialTest.assertEquals((String)"pf == pfec", genSolvablePolynomialRing, (Object)genPolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.extend(genPolynomialRing, 0, 0L);
        Map map = genSolvablePolynomial.contract(genPolynomialRing2);
        ArrayList arrayList = new ArrayList(map.values());
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)arrayList.get(0);
        GenSolvablePolynomialTest.assertEquals((String)"a == aec", (Object)genPolynomial, (Object)genSolvablePolynomial2);
    }

    public void testExtendContractWeyl() {
        BigRational bigRational = new BigRational(99L);
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl);
        WeylRelations weylRelations = new WeylRelations();
        genSolvablePolynomialRing.addRelations(weylRelations);
        GenPolynomial genPolynomial = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
        int n = this.rl;
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.extend(n);
        GenPolynomialRing genPolynomialRing2 = ((GenSolvablePolynomialRing)genPolynomialRing).contract(n);
        GenSolvablePolynomialTest.assertEquals((String)"pf == pfec", genSolvablePolynomialRing, (Object)genPolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.extend(genPolynomialRing, 0, 0L);
        Map map = genSolvablePolynomial.contract(genPolynomialRing2);
        ArrayList arrayList = new ArrayList(map.values());
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)arrayList.get(0);
        GenSolvablePolynomialTest.assertEquals((String)"a == aec", (Object)genPolynomial, (Object)genSolvablePolynomial2);
    }

    public void testReverse() {
        BigRational bigRational = new BigRational(99L);
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl);
        GenPolynomial genPolynomial = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.reverse();
        GenPolynomialRing genPolynomialRing2 = ((GenSolvablePolynomialRing)genPolynomialRing).reverse();
        GenSolvablePolynomialTest.assertEquals((String)"pf == pfrr", genSolvablePolynomialRing, (Object)genPolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.reverse(genPolynomialRing);
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.reverse(genPolynomialRing2);
        GenSolvablePolynomialTest.assertEquals((String)"a == arr", (Object)genPolynomial, (Object)genSolvablePolynomial2);
    }

    public void testReverseWeyl() {
        BigRational bigRational = new BigRational(99L);
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(genSolvablePolynomialRing);
        GenPolynomial genPolynomial = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.reverse();
        GenPolynomialRing genPolynomialRing2 = ((GenSolvablePolynomialRing)genPolynomialRing).reverse();
        GenSolvablePolynomialTest.assertEquals((String)"pf == pfrr", genSolvablePolynomialRing, (Object)genPolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.reverse(genPolynomialRing);
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.reverse(genPolynomialRing2);
        GenSolvablePolynomialTest.assertEquals((String)"a == arr", (Object)genPolynomial, (Object)genSolvablePolynomial2);
    }

    public void testRecursion() {
        BigRational bigRational = new BigRational();
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        TermOrder termOrder = new TermOrder(2);
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(bigRational, 4, termOrder, stringArray);
        WeylRelations weylRelations = new WeylRelations();
        genSolvablePolynomialRing.addRelations(weylRelations);
        GenPolynomial genPolynomial = genSolvablePolynomialRing.random(5);
        genPolynomial = (GenSolvablePolynomial)genPolynomial.subtract(genPolynomial);
        GenSolvablePolynomialTest.assertTrue((String)"sp == 0 ", (boolean)genPolynomial.isZERO());
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing2 = new GenSolvablePolynomialRing<BigRational>(genSolvablePolynomialRing, 2);
        WeylRelations weylRelations2 = new WeylRelations();
        genSolvablePolynomialRing2.addRelations(weylRelations2);
        GenPolynomial genPolynomial2 = genSolvablePolynomialRing2.random(5);
        genPolynomial2 = (GenSolvablePolynomial)genPolynomial2.subtract(genPolynomial2);
        GenSolvablePolynomialTest.assertTrue((String)"rsp == 0 ", (boolean)genPolynomial2.isZERO());
    }
}

