/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import parser.State;
import parser.Values;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismSettings;
import prism.PrismSettingsListener;
import prism.PrismUtils;
import prism.UndefinedConstants;
import simulator.PathFullInfo;
import simulator.SimulatorEngine;
import userinterface.GUIConstantsPicker;
import userinterface.GUIPlugin;
import userinterface.GUIPrism;
import userinterface.graph.Graph;
import userinterface.model.GUIModelEvent;
import userinterface.model.GUIMultiModel;
import userinterface.properties.GUIMultiProperties;
import userinterface.properties.GUIPropertiesEvent;
import userinterface.properties.GUIPropertiesList;
import userinterface.properties.GUIProperty;
import userinterface.simulator.GUIInitialStatePicker;
import userinterface.simulator.GUIPathPlotDialog;
import userinterface.simulator.GUISimLabelList;
import userinterface.simulator.GUISimPathFormulaeList;
import userinterface.simulator.GUISimulatorPathTable;
import userinterface.simulator.GUISimulatorPathTableModel;
import userinterface.simulator.GUISimulatorUpdatesTable;
import userinterface.simulator.GUITimeDialog;
import userinterface.simulator.GUIViewDialog;
import userinterface.simulator.SimPathPlotThread;
import userinterface.simulator.SimulationView;
import userinterface.util.GUIComputationEvent;
import userinterface.util.GUIEvent;
import userinterface.util.GUIExitEvent;

public class GUISimulator
extends GUIPlugin
implements MouseListener,
ListSelectionListener,
PrismSettingsListener {
    private static final long serialVersionUID = 1L;
    private GUIMultiProperties guiProp;
    private GUIMultiModel guiMultiModel;
    private SimulatorEngine engine;
    private UpdateTableModel updateTableModel;
    private GUISimulatorPathTableModel pathTableModel;
    private JMenu simulatorMenu;
    private JPopupMenu pathPopupMenu;
    private FileFilter textFilter;
    private Action randomExploration;
    private Action backtrack;
    private Action backtrackToHere;
    private Action removeToHere;
    private Action newPath;
    private Action newPathFromState;
    private Action newPathPlot;
    private Action newPathPlotFromState;
    private Action resetPath;
    private Action exportPath;
    private Action plotPath;
    private Action configureView;
    private boolean pathActive;
    private ModulesFile parsedModel;
    private boolean newPathAfterReceiveParseNotification;
    private boolean newPathPlotAfterReceiveParseNotification;
    private boolean chooseInitialState;
    private boolean stratShow;
    private Values lastPropertyConstants;
    private Values lastInitialStateValues;
    private boolean computing;
    private boolean displayStyleFast;
    private boolean displayPathLoops;
    private SimulationView view;
    private JPanel allPanel;
    private JCheckBox autoTimeCheck;
    private JPanel autoTimeCheckPanel;
    private JPanel automaticExplorationPanel;
    JButton backtrackButton;
    private JPanel backtrackPanel;
    private JPanel strategyPanel;
    private JPanel bottomLabels;
    private JPanel bottomPanel;
    private JPanel bottomValues;
    private ButtonGroup buttonGroup1;
    JButton configureViewButton;
    JTable currentUpdatesTable;
    private JLabel definedConstants;
    private JLabel definedConstantsLabel;
    JButton exportPathButton;
    private JSplitPane horizontalSplit;
    private JPanel informationPanel;
    private JPanel innerAutomaticExplorationPanel;
    private JPanel innerBacktrackPanel;
    private JPanel innerStrategyPanel;
    private JPanel innerButtonPanel;
    private JPanel innerInformationPanel;
    private JPanel innerManualUpdatesPanel;
    private JPanel innerTopLeftPanel;
    JTextField inputBacktrackField;
    JTextField inputExploreField;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSplitPane jSplitPane1;
    private JPanel leftExplorePanel;
    private JScrollPane manualUpdateTableScrollPane;
    private JPanel manualUpdatesPanel;
    private JLabel modelType;
    private JLabel modelTypeLabel;
    JButton newPathButton;
    private JPanel noStepsBacktrackPanel;
    private JPanel noStepsExplorePanel;
    private JPanel outerBottomPanel;
    private JPanel outerLeftExplorePanel;
    private JPanel outerPathFormulaePanel;
    private JPanel outerStateLabelPanel;
    private JPanel outerTopLeftPanel;
    JList pathFormulaeList;
    private JScrollPane pathFormulaeScrollPane;
    private JLabel pathLength;
    private JLabel pathLengthLabel;
    private JTable pathTable;
    private JPanel pathTablePlaceHolder;
    JButton randomExplorationButton;
    JButton resetPathButton;
    private JList stateLabelList;
    private JScrollPane stateLabelScrollPane;
    private JTabbedPane tabbedPane;
    private JScrollPane tableScroll;
    private JPanel topLabels;
    private JPanel topLeftPanel;
    private JPanel topPanel;
    private JSplitPane topSplit;
    private JPanel topValues;
    private JLabel totalTime;
    private JLabel totalTimeLabel;
    private JComboBox typeBacktrackCombo;
    private JComboBox typeExploreCombo;
    private JComboBox<String> stratCombo;

    public GUISimulator(GUIPrism gUIPrism) {
        super(gUIPrism, true);
        this.engine = gUIPrism.getPrism().getSimulator();
        this.view = new SimulationView(this, gUIPrism.getPrism().getSettings());
        this.pathTableModel = new GUISimulatorPathTableModel(this, this.view);
        this.updateTableModel = new UpdateTableModel();
        this.initComponents();
        this.initPopups();
        this.doEnables();
        this.horizontalSplit.setDividerLocation((int)this.leftExplorePanel.getPreferredSize().getHeight() + 11);
        this.randomExplorationButton.setIcon(GUIPrism.getIconFromImage("smallPlayerFwd.png"));
        this.backtrackButton.setIcon(GUIPrism.getIconFromImage("smallPlayerRew.png"));
        this.pathTable.getSelectionModel().addListSelectionListener(this);
        this.pathTable.addMouseListener(this);
        this.pathTable.getTableHeader().addMouseListener(this);
        this.tableScroll.addMouseListener(this);
        this.pathTable.getTableHeader().setReorderingAllowed(true);
        this.pathTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GUISimulator.this.sortOutColumnSizes();
            }
        });
        this.pathTablePlaceHolder.addMouseListener(this);
        this.view.refreshToDefaultView(this.pathActive, this.parsedModel);
        this.setPathActive(false);
        this.doEnables();
        this.currentUpdatesTable.setModel(this.updateTableModel);
        this.currentUpdatesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && GUISimulator.this.currentUpdatesTable.isEnabled()) {
                    GUISimulator.this.a_manualUpdate();
                    GUISimulator.this.currentUpdatesTable.requestFocus();
                } else if (mouseEvent.getClickCount() == 2 && !GUISimulator.this.currentUpdatesTable.isEnabled()) {
                    GUISimulator.this.warning("Simulation", "These are updates from earlier in the path.\nSelect the last state in the path table to continue exploration");
                }
            }
        });
        this.currentUpdatesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && GUISimulator.this.currentUpdatesTable.isEnabled()) {
                    GUISimulator.this.a_manualUpdate();
                    GUISimulator.this.currentUpdatesTable.requestFocus();
                }
            }
        });
        this.pathTable.setModel(this.pathTableModel);
        this.lastPropertyConstants = null;
        this.lastInitialStateValues = null;
        this.tableScroll.setRowHeaderView(((GUISimulatorPathTable)this.pathTable).getPathLoopIndicator());
        this.manualUpdateTableScrollPane.setRowHeaderView(((GUISimulatorUpdatesTable)this.currentUpdatesTable).getUpdateRowHeader());
        this.tableScroll.setHorizontalScrollBarPolicy(30);
        this.stateLabelList.setSelectionMode(0);
        this.stateLabelList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GUISimulator.this.pathTable.repaint();
            }
        });
        this.modelTypeLabel.setText("Unknown");
        this.totalTimeLabel.setText(this.formatDouble(0.0));
        this.pathLengthLabel.setText("0");
        this.textFilter = new FileNameExtensionFilter("Plain text files (*.txt)", "txt");
        this.displayStyleFast = true;
        this.displayPathLoops = true;
        this.autoTimeCheck.setSelected(true);
        this.currentUpdatesTable.requestFocus();
        this.manualUpdateTableScrollPane.setToolTipText("Double-click or right-click below to create a new path");
    }

    public void setGUIMultiModel(GUIMultiModel gUIMultiModel) {
        this.guiMultiModel = gUIMultiModel;
    }

    public void setGUIProb(GUIMultiProperties gUIMultiProperties) {
        this.guiProp = gUIMultiProperties;
    }

    public SimulatorEngine getSimulatorEngine() {
        return this.engine;
    }

    public JList getStateLabelList() {
        return this.stateLabelList;
    }

    public String getTotalRewardLabelString() {
        int n = this.parsedModel.getNumRewardStructs();
        Object object = "<html>";
        for (int i = 0; i < n; ++i) {
            object = (String)object + this.engine.getTotalCumulativeRewardForPath(i);
            if (i >= n - 1) continue;
            object = (String)object + ",<br>";
        }
        object = (String)object + "</html>";
        return object;
    }

    private void updatePathInfoAll(UndefinedConstants undefinedConstants) {
        this.modelTypeLabel.setText(this.parsedModel == null ? "Unknown" : this.parsedModel.getTypeString());
        String string = undefinedConstants == null ? "" : undefinedConstants.getDefinedConstantsString();
        this.definedConstantsLabel.setText(string.length() == 0 ? "None" : string);
        this.pathLengthLabel.setText((String)(this.pathActive ? "" + this.engine.getPathSize() : "0"));
        this.totalTimeLabel.setText(this.pathActive ? this.formatDouble(this.engine.getTotalTimeForPath()) : "0");
    }

    private void updatePathInfo() {
        this.pathLengthLabel.setText((String)(this.pathActive ? "" + this.engine.getPathSize() : "0"));
        this.totalTimeLabel.setText(this.pathActive ? this.formatDouble(this.engine.getTotalTimeForPath()) : "0");
    }

    private void repaintLists() {
        this.stateLabelList.repaint();
        this.pathFormulaeList.repaint();
    }

    public void a_clearModel() {
        this.tableScroll.setViewportView(this.pathTablePlaceHolder);
        this.setPathActive(false);
        this.setParsedModel(null);
        this.pathTableModel.restartPathTable();
        this.updateTableModel.restartUpdatesTable();
        ((GUISimLabelList)this.stateLabelList).clearLabels();
        ((GUISimPathFormulaeList)this.pathFormulaeList).clearList();
        this.repaintLists();
        this.updatePathInfoAll(null);
        this.doEnables();
    }

    public void a_loadModulesFile(ModulesFile modulesFile) {
        this.setPathActive(false);
        this.setParsedModel(modulesFile);
        this.pathTableModel.restartPathTable();
        this.updateTableModel.restartUpdatesTable();
        ((GUISimLabelList)this.stateLabelList).clearLabels();
        ((GUISimPathFormulaeList)this.pathFormulaeList).clearList();
        this.repaintLists();
        this.updatePathInfoAll(null);
        this.doEnables();
        this.typeExploreCombo.removeAllItems();
        this.typeExploreCombo.addItem("Steps");
        this.typeExploreCombo.addItem("Up to step");
        if (modulesFile != null && modulesFile.getModelType().continuousTime()) {
            this.typeExploreCombo.addItem("Time");
            this.typeExploreCombo.addItem("Up to time");
        }
        this.typeBacktrackCombo.setEnabled(false);
        this.typeBacktrackCombo.removeAllItems();
        this.typeBacktrackCombo.addItem("Steps");
        this.typeBacktrackCombo.addItem("Back to step");
        if (modulesFile != null && modulesFile.getModelType().continuousTime()) {
            this.typeBacktrackCombo.addItem("Time");
            this.typeBacktrackCombo.addItem("Back to time");
        }
    }

    public void a_clearPath() {
        this.setPathActive(false);
        this.pathTableModel.restartPathTable();
        this.updateTableModel.restartUpdatesTable();
        ((GUISimLabelList)this.stateLabelList).clearLabels();
        ((GUISimPathFormulaeList)this.pathFormulaeList).clearList();
        this.repaintLists();
        this.updatePathInfoAll(null);
        this.doEnables();
    }

    public void a_newPath(boolean bl) {
        this.newPathAfterReceiveParseNotification = true;
        this.chooseInitialState = bl;
        this.notifyEventListeners(new GUIPropertiesEvent(1));
    }

    public void newPathAfterParse() {
        block12: {
            this.newPathAfterReceiveParseNotification = false;
            try {
                State state;
                PropertiesFile propertiesFile;
                this.getPrism().checkModelForSimulation();
                try {
                    propertiesFile = this.getPrism().parsePropertiesString(this.guiProp.getConstantsString().toString() + this.guiProp.getLabelsString());
                }
                catch (PrismLangException prismLangException) {
                    propertiesFile = null;
                }
                UndefinedConstants undefinedConstants = new UndefinedConstants(this.parsedModel, propertiesFile, true);
                if (undefinedConstants.getMFNumUndefined() + undefinedConstants.getPFNumUndefined() > 0) {
                    Values values = this.getPrism().getUndefinedModelValues();
                    int n = GUIConstantsPicker.defineConstantsWithDialog(this.getGUI(), undefinedConstants, values, this.lastPropertyConstants);
                    if (n != 1) {
                        return;
                    }
                }
                this.lastPropertyConstants = undefinedConstants.getPFConstantValues();
                this.getPrism().setPRISMModelConstants(undefinedConstants.getMFConstantValues(), false);
                propertiesFile.setSomeUndefinedConstants(this.lastPropertyConstants, false);
                if (this.parsedModel.getInitialStates() != null) {
                    throw new PrismException("The simulator does not yet handle models with multiple initial states");
                }
                this.getPrism().loadModelIntoSimulator();
                this.getPrism().loadStrategyIntoSimulator();
                if (!this.chooseInitialState) {
                    state = null;
                } else {
                    state = this.a_chooseInitialState();
                    if (state == null) {
                        return;
                    }
                }
                this.tableScroll.setViewportView(this.pathTable);
                this.displayPathLoops = true;
                this.engine.createNewPath();
                this.setPathActive(true);
                this.repopulateFormulae(propertiesFile);
                this.engine.initialisePath(state);
                this.engine.getNumTransitions();
                if (this.engine.hasStrategyInfo()) {
                    this.stratCombo.setSelectedItem("Enforce");
                }
                this.pathTableModel.setPath(this.engine.getPathFull());
                this.pathTableModel.restartPathTable();
                this.pathTable.getSelectionModel().setSelectionInterval(0, 0);
                this.updateTableModel.restartUpdatesTable();
                this.repaintLists();
                this.updatePathInfoAll(undefinedConstants);
                this.doEnables();
                this.lastInitialStateValues = new Values(state, this.engine.getModel());
                if (this.getPrism().getSettings().getBoolean("simulator.newPathAskView")) {
                    new GUIViewDialog(this.getGUI(), this.pathTableModel.getView(), this.pathTableModel);
                }
            }
            catch (PrismException prismException) {
                this.setPathActive(false);
                this.error(prismException.getMessage());
                if (!(prismException instanceof PrismLangException)) break block12;
                this.guiMultiModel.getHandler().modelParseFailed((PrismLangException)prismException, false);
                this.guiMultiModel.tabToFront();
            }
        }
    }

    public State a_chooseInitialState() throws PrismLangException {
        return GUIInitialStatePicker.defineInitalValuesWithDialog(this.getGUI(), this.engine, this.lastInitialStateValues);
    }

    public void a_autoStep(int n) {
        if (this.stopBecausePathLooping()) {
            return;
        }
        try {
            this.setComputing(true);
            if (this.isOldUpdate()) {
                this.engine.computeTransitionsForCurrentState();
            }
            this.engine.automaticTransitions(n, this.displayPathLoops);
        }
        catch (PrismException prismException) {
            this.updatePathDisplay(true);
            this.updateTableModel.updateUpdatesTable();
            this.reportErrorDuringSimulation(prismException);
            return;
        }
        finally {
            this.setComputing(false);
        }
        this.updatePathDisplay(true);
        this.updateTableModel.updateUpdatesTable();
        this.checkForErrorsInTransitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a_autoStep(double d) {
        if (this.stopBecausePathLooping()) {
            return;
        }
        try {
            this.setComputing(true);
            if (this.isOldUpdate()) {
                this.engine.computeTransitionsForCurrentState();
            }
            this.engine.automaticTransitions(d, this.displayPathLoops);
        }
        catch (PrismException prismException) {
            this.updatePathDisplay(true);
            this.updateTableModel.updateUpdatesTable();
            this.reportErrorDuringSimulation(prismException);
            return;
        }
        finally {
            this.setComputing(false);
        }
        this.updatePathDisplay(true);
        this.updateTableModel.updateUpdatesTable();
        this.checkForErrorsInTransitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a_backTrack(double d) {
        try {
            this.setComputing(true);
            this.engine.backtrackTo(d);
        }
        catch (PrismException prismException) {
            this.reportErrorDuringSimulation(prismException);
        }
        finally {
            this.setComputing(false);
        }
        this.updatePathDisplay(false);
        this.updateTableModel.updateUpdatesTable();
    }

    public void a_backTrack(int n) {
        try {
            this.setComputing(true);
            this.engine.backtrackTo(n);
        }
        catch (PrismException prismException) {
            this.reportErrorDuringSimulation(prismException);
        }
        finally {
            this.setComputing(false);
        }
        this.updatePathDisplay(false);
        this.updateTableModel.updateUpdatesTable();
    }

    public void a_restartPath() {
        try {
            this.setComputing(true);
            this.engine.backtrackTo(0);
        }
        catch (PrismException prismException) {
            this.reportErrorDuringSimulation(prismException);
        }
        finally {
            this.setComputing(false);
        }
        this.updatePathDisplay(false);
        this.updateTableModel.updateUpdatesTable();
    }

    public void a_removePreceding(int n) {
        try {
            this.setComputing(true);
            this.engine.removePrecedingStates(n);
        }
        catch (PrismException prismException) {
            this.reportErrorDuringSimulation(prismException);
        }
        finally {
            this.setComputing(false);
        }
        this.updatePathDisplay(false);
        this.updateTableModel.updateUpdatesTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a_manualUpdate() {
        if (this.currentUpdatesTable.getSelectedRow() == -1) {
            this.reportErrorDuringSimulation(new PrismException("No current update is selected"));
            return;
        }
        if (this.engine.hasStrategyInfo() && this.engine.isStrategyEnforced()) {
            try {
                if (!this.engine.isTransitionEnabledByStrategy(this.currentUpdatesTable.getSelectedRow()) && this.questionYesNo("This update is not selected by the current strategy. Execute it anyway?") != 0) {
                    return;
                }
            }
            catch (PrismException prismException) {
                this.reportErrorDuringSimulation(prismException);
                return;
            }
        }
        if (this.stopBecausePathLooping()) {
            return;
        }
        double d = -1.0;
        if (this.parsedModel.getModelType().continuousTime() && !this.autoTimeCheck.isSelected() && (d = GUITimeDialog.askTime(this.getGUI(), this)) < 0.0) {
            return;
        }
        try {
            this.setComputing(true);
            if (this.parsedModel.getModelType().continuousTime() && d != -1.0) {
                this.engine.manualTransition(this.currentUpdatesTable.getSelectedRow(), d);
            } else {
                this.engine.manualTransition(this.currentUpdatesTable.getSelectedRow());
            }
        }
        catch (PrismException prismException) {
            this.reportErrorDuringSimulation(prismException);
        }
        finally {
            this.setComputing(false);
        }
        this.updatePathDisplay(true);
        this.updateTableModel.updateUpdatesTable();
        this.checkForErrorsInTransitions();
    }

    public void a_loadPath(PathFullInfo pathFullInfo) {
        try {
            PropertiesFile propertiesFile;
            try {
                propertiesFile = this.getPrism().parsePropertiesString(this.guiProp.getConstantsString().toString() + this.guiProp.getLabelsString());
            }
            catch (PrismLangException prismLangException) {
                propertiesFile = null;
            }
            this.tableScroll.setViewportView(this.pathTable);
            this.displayPathLoops = true;
            this.getPrism().loadModelIntoSimulator();
            this.engine.createNewPath();
            this.setPathActive(true);
            this.repopulateFormulae(propertiesFile);
            this.engine.loadPath(pathFullInfo);
            this.pathTableModel.setPath(this.engine.getPathFull());
            this.pathTableModel.restartPathTable();
            int n = this.pathTable.getRowCount() - 1;
            this.pathTable.getSelectionModel().setSelectionInterval(n, n);
            this.updateTableModel.restartUpdatesTable();
            this.repaintLists();
            this.updatePathInfoAll(null);
            this.doEnables();
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
            this.setComputing(false);
        }
    }

    public void a_exportPath() {
        try {
            boolean bl = false;
            if (this.parsedModel != null && this.parsedModel.getNumRewardStructs() > 0) {
                boolean bl2 = bl = this.question("Export the path with or without reward information?", new String[]{"With rewards", "Without rewards"}) == 0;
            }
            if (this.showSaveFileDialog(this.textFilter) != 0) {
                return;
            }
            this.setComputing(true);
            this.engine.exportPath(this.getChooserFile(), bl);
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
        }
        finally {
            this.setComputing(false);
        }
    }

    public void a_plotPath() {
        try {
            this.setComputing(true);
            this.guiProp.tabToFront();
            Graph graph = new Graph();
            this.guiProp.getGraphHandler().addGraph(graph);
            this.engine.plotPath(graph);
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
        }
        finally {
            this.setComputing(false);
        }
    }

    public void a_newPathPlot(boolean bl) {
        this.newPathPlotAfterReceiveParseNotification = true;
        this.chooseInitialState = bl;
        this.notifyEventListeners(new GUIPropertiesEvent(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newPathPlotAfterParse() {
        this.newPathPlotAfterReceiveParseNotification = false;
        try {
            State state;
            Object object;
            this.getPrism().checkModelForSimulation();
            UndefinedConstants undefinedConstants = new UndefinedConstants(this.parsedModel, null);
            if (undefinedConstants.getMFNumUndefined() > 0) {
                object = this.getPrism().getUndefinedModelValues();
                int n = GUIConstantsPicker.defineConstantsWithDialog(this.getGUI(), undefinedConstants, (Values)object, this.lastPropertyConstants);
                if (n != 1) {
                    return;
                }
            }
            this.getPrism().setPRISMModelConstants(undefinedConstants.getMFConstantValues(), false);
            this.getPrism().loadModelIntoSimulator();
            this.getPrism().loadStrategyIntoSimulator();
            if (!this.chooseInitialState) {
                state = null;
            } else {
                state = this.a_chooseInitialState();
                if (state == null) {
                    return;
                }
            }
            object = GUIPathPlotDialog.showDialog(this.getGUI(), this, this.parsedModel);
            if (object == null) {
                return;
            }
            String string = ((GUIPathPlotDialog)object).getSimPathString();
            if (string == null) {
                return;
            }
            long l = ((GUIPathPlotDialog)object).getMaxPathLength();
            this.a_clearPath();
            this.setComputing(true);
            this.guiProp.tabToFront();
            Graph graph = new Graph();
            this.guiProp.getGraphHandler().addGraph(graph);
            this.getPrism().getMainLog().resetNumberOfWarnings();
            new SimPathPlotThread(this, this.engine, state, string, l, graph).start();
            this.lastInitialStateValues = new Values(state, this.engine.getModel());
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
            if (prismException instanceof PrismLangException) {
                this.guiMultiModel.getHandler().modelParseFailed((PrismLangException)prismException, false);
                this.guiMultiModel.tabToFront();
            }
        }
        finally {
            this.setComputing(false);
        }
    }

    public void a_configureView() {
        new GUIViewDialog(this.getGUI(), this.pathTableModel.getView(), this.pathTableModel);
    }

    private boolean stopBecausePathLooping() {
        if (this.displayPathLoops && this.pathTableModel.isPathLooping()) {
            if (this.questionYesNo("The current path contains a deterministic loop. \nDo you wish to disable detection of such loops and extend the path anyway?") == 0) {
                this.displayPathLoops = false;
                this.pathTable.repaint();
                return false;
            }
            return true;
        }
        return false;
    }

    private void updatePathDisplay(boolean bl) {
        this.pathTableModel.updatePathTable();
        if (bl) {
            int n = (int)this.pathTable.getPreferredSize().getHeight();
            int n2 = (int)this.pathTable.getPreferredSize().getWidth();
            this.pathTable.scrollRectToVisible(new Rectangle(0, n - 10, n2, n));
        }
        this.repaintLists();
        this.updatePathInfo();
    }

    private void checkForErrorsInTransitions() {
        try {
            this.engine.getNumTransitions();
        }
        catch (PrismException prismException) {
            this.reportErrorDuringSimulation(prismException);
        }
    }

    private void reportErrorDuringSimulation(PrismException prismException) {
        this.error(prismException.getMessage());
        if (prismException instanceof PrismLangException && ((PrismLangException)prismException).getASTElement().hasPosition()) {
            this.guiMultiModel.getHandler().modelParseFailed((PrismLangException)prismException, false);
            this.guiMultiModel.tabToFront();
        }
    }

    private void repopulateFormulae(PropertiesFile propertiesFile) {
        int n;
        Object object;
        Object object2;
        GUISimLabelList gUISimLabelList = (GUISimLabelList)this.stateLabelList;
        gUISimLabelList.clearLabels();
        if (this.pathActive) {
            gUISimLabelList.addDeadlockAndInit();
            if (this.parsedModel != null) {
                object2 = this.parsedModel.getLabelList();
                for (int i = 0; i < ((LabelList)object2).size(); ++i) {
                    gUISimLabelList.addModelLabel(((LabelList)object2).getLabelName(i), ((LabelList)object2).getLabel(i));
                }
                object = propertiesFile.getLabelList();
                for (n = 0; n < ((LabelList)object).size(); ++n) {
                    gUISimLabelList.addPropertyLabel(((LabelList)object).getLabelName(n), ((LabelList)object).getLabel(n), propertiesFile);
                }
            }
        }
        object2 = (GUISimPathFormulaeList)this.pathFormulaeList;
        ((GUISimPathFormulaeList)object2).clearList();
        if (this.pathActive) {
            object = this.guiProp.getPropList();
            for (n = 0; n < ((GUIPropertiesList)object).getNumProperties(); ++n) {
                GUIProperty gUIProperty = ((GUIPropertiesList)object).getProperty(n);
                List<String> list = gUIProperty.getProperty().getAllConstants();
                boolean bl = true;
                for (String string : list) {
                    if (this.parsedModel.isDefinedConstant(string) || propertiesFile.isDefinedConstant(string)) continue;
                    bl = false;
                    break;
                }
                if (!bl || !gUIProperty.isValidForSimulation()) continue;
                ((GUISimPathFormulaeList)object2).addProperty(gUIProperty.getProperty(), propertiesFile);
            }
        }
    }

    @Override
    public boolean displaysTab() {
        return true;
    }

    @Override
    public JMenu getMenu() {
        return this.simulatorMenu;
    }

    @Override
    public String getTabText() {
        return "Simulator";
    }

    @Override
    public JToolBar getToolBar() {
        return null;
    }

    @Override
    public String getXMLIDTag() {
        return "";
    }

    @Override
    public Object getXMLSaveTree() {
        return null;
    }

    @Override
    public void loadXML(Object object) {
    }

    @Override
    public boolean processGUIEvent(GUIEvent gUIEvent) {
        if (gUIEvent instanceof GUIModelEvent) {
            GUIModelEvent gUIModelEvent = (GUIModelEvent)gUIEvent;
            if (gUIModelEvent.getID() == 0) {
                this.a_clearModel();
            } else if (gUIModelEvent.getID() == 3) {
                this.a_loadModulesFile(gUIModelEvent.getModulesFile());
                this.doEnables();
                if (this.newPathAfterReceiveParseNotification) {
                    this.newPathAfterParse();
                }
                if (this.newPathPlotAfterReceiveParseNotification) {
                    this.newPathPlotAfterParse();
                }
            } else if (gUIModelEvent.getID() == 7) {
                this.newPathAfterReceiveParseNotification = false;
                this.newPathPlotAfterReceiveParseNotification = false;
            }
        } else if (gUIEvent instanceof GUIComputationEvent) {
            if (gUIEvent.getID() == 0) {
                this.setComputing(true);
            } else if (gUIEvent.getID() == 1) {
                this.setComputing(false);
            } else if (gUIEvent.getID() == 2) {
                this.setComputing(false);
            }
        } else if (gUIEvent instanceof GUIPropertiesEvent ? gUIEvent.getID() == 5 : !(gUIEvent instanceof GUIExitEvent) || gUIEvent.getID() == 0) {
            // empty if block
        }
        return false;
    }

    @Override
    public void takeCLArgs(String[] stringArray) {
    }

    protected void doEnables() {
        this.newPath.setEnabled(this.parsedModel != null && !this.computing);
        this.newPathFromState.setEnabled(this.parsedModel != null && !this.computing);
        this.newPathPlot.setEnabled(this.parsedModel != null && !this.computing);
        this.newPathPlotFromState.setEnabled(this.parsedModel != null && !this.computing);
        this.resetPath.setEnabled(this.pathActive && !this.computing);
        this.exportPath.setEnabled(this.pathActive && !this.computing);
        this.plotPath.setEnabled(this.pathActive && !this.computing);
        this.randomExploration.setEnabled(this.pathActive && !this.computing);
        this.backtrack.setEnabled(this.pathActive && !this.computing);
        this.configureView.setEnabled(this.pathActive && !this.computing);
        this.randomExplorationButton.setEnabled(this.pathActive && !this.computing);
        this.backtrackButton.setEnabled(this.pathActive && !this.computing);
        this.inputExploreField.setEnabled(this.pathActive);
        this.inputBacktrackField.setEnabled(this.pathActive);
        this.typeExploreCombo.setEnabled(this.pathActive);
        this.typeBacktrackCombo.setEnabled(this.pathActive);
        this.stratCombo.setEnabled(this.parsedModel != null && !this.computing && this.engine.hasStrategyInfo());
        this.currentUpdatesTable.setEnabled(this.pathActive && !this.computing);
        this.currentUpdatesTable.setToolTipText(this.currentUpdatesTable.isEnabled() ? "Double click on an update to manually execute it" : null);
        this.autoTimeCheck.setEnabled(this.pathActive && this.parsedModel != null && this.parsedModel.getModelType().continuousTime());
        this.modelType.setEnabled(this.parsedModel != null);
        this.modelTypeLabel.setEnabled(this.parsedModel != null);
        this.totalTime.setEnabled(this.pathActive && this.parsedModel != null && this.parsedModel.getModelType().continuousTime());
        this.totalTimeLabel.setEnabled(this.pathActive && this.parsedModel != null && this.parsedModel.getModelType().continuousTime());
        this.pathLength.setEnabled(this.pathActive);
        this.pathLengthLabel.setEnabled(this.pathActive);
        this.definedConstants.setEnabled(this.pathActive);
        this.definedConstantsLabel.setEnabled(this.pathActive);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.innerButtonPanel = new JPanel();
        this.newPathButton = new JButton();
        this.resetPathButton = new JButton();
        this.exportPathButton = new JButton();
        this.configureViewButton = new JButton();
        this.pathTable = new JTable();
        this.pathTable = new GUISimulatorPathTable(this, this.pathTableModel, this.engine);
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.allPanel = new JPanel();
        this.horizontalSplit = new JSplitPane();
        this.topPanel = new JPanel();
        this.topSplit = new JSplitPane();
        this.tabbedPane = new JTabbedPane();
        this.outerStateLabelPanel = new JPanel();
        this.stateLabelScrollPane = new JScrollPane();
        this.stateLabelList = new GUISimLabelList(this);
        this.outerPathFormulaePanel = new JPanel();
        this.pathFormulaeScrollPane = new JScrollPane();
        this.pathFormulaeList = new JList();
        this.pathFormulaeList = new GUISimPathFormulaeList(this);
        this.informationPanel = new JPanel();
        this.innerInformationPanel = new JPanel();
        this.topLabels = new JPanel();
        this.modelType = new JLabel();
        this.definedConstants = new JLabel();
        this.topValues = new JPanel();
        this.modelTypeLabel = new JLabel();
        this.definedConstantsLabel = new JLabel();
        this.bottomLabels = new JPanel();
        this.pathLength = new JLabel();
        this.totalTime = new JLabel();
        this.bottomValues = new JPanel();
        this.pathLengthLabel = new JLabel();
        this.totalTimeLabel = new JLabel();
        this.outerTopLeftPanel = new JPanel();
        this.topLeftPanel = new JPanel();
        this.innerTopLeftPanel = new JPanel();
        this.outerLeftExplorePanel = new JPanel();
        this.leftExplorePanel = new JPanel();
        this.automaticExplorationPanel = new JPanel();
        this.innerAutomaticExplorationPanel = new JPanel();
        this.randomExplorationButton = new JButton();
        this.noStepsExplorePanel = new JPanel();
        this.typeExploreCombo = new JComboBox();
        this.inputExploreField = new JTextField();
        this.backtrackPanel = new JPanel();
        this.innerBacktrackPanel = new JPanel();
        this.backtrackButton = new JButton();
        this.noStepsBacktrackPanel = new JPanel();
        this.typeBacktrackCombo = new JComboBox();
        this.inputBacktrackField = new JTextField();
        this.strategyPanel = new JPanel();
        this.innerStrategyPanel = new JPanel();
        this.stratCombo = new JComboBox();
        this.manualUpdatesPanel = new JPanel();
        this.innerManualUpdatesPanel = new JPanel();
        this.manualUpdateTableScrollPane = new JScrollPane();
        this.currentUpdatesTable = new JTable();
        this.currentUpdatesTable = new GUISimulatorUpdatesTable(this.updateTableModel, this);
        this.autoTimeCheckPanel = new JPanel();
        this.autoTimeCheck = new JCheckBox();
        this.outerBottomPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.tableScroll = new JScrollPane();
        this.pathTablePlaceHolder = new JPanel();
        this.innerButtonPanel.setLayout(new GridLayout(2, 2, 10, 10));
        this.newPathButton.setIcon(new ImageIcon(""));
        this.newPathButton.setText("New path");
        this.newPathButton.setToolTipText("New path");
        this.newPathButton.setHorizontalAlignment(10);
        this.newPathButton.setPreferredSize(new Dimension(119, 28));
        this.newPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.newPathButtonActionPerformed(actionEvent);
            }
        });
        this.innerButtonPanel.add(this.newPathButton);
        this.resetPathButton.setIcon(new ImageIcon(""));
        this.resetPathButton.setText("Reset path");
        this.resetPathButton.setToolTipText("Reset path");
        this.resetPathButton.setHorizontalAlignment(10);
        this.resetPathButton.setPreferredSize(new Dimension(119, 28));
        this.resetPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.resetPathButtonActionPerformed(actionEvent);
            }
        });
        this.innerButtonPanel.add(this.resetPathButton);
        this.exportPathButton.setIcon(new ImageIcon(""));
        this.exportPathButton.setText("Export path");
        this.exportPathButton.setToolTipText("Export path");
        this.exportPathButton.setHorizontalAlignment(10);
        this.exportPathButton.setPreferredSize(new Dimension(119, 28));
        this.exportPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.exportPathButtonActionPerformed(actionEvent);
            }
        });
        this.innerButtonPanel.add(this.exportPathButton);
        this.configureViewButton.setIcon(new ImageIcon(""));
        this.configureViewButton.setToolTipText("Export path");
        this.configureViewButton.setActionCommand("Configure view");
        this.configureViewButton.setHorizontalAlignment(10);
        this.configureViewButton.setText("Configure view");
        this.configureViewButton.setPreferredSize(new Dimension(119, 28));
        this.configureViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.configureViewButtonActionPerformed(actionEvent);
            }
        });
        this.innerButtonPanel.add(this.configureViewButton);
        this.pathTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jSplitPane1.setLeftComponent(this.jPanel3);
        this.jSplitPane1.setRightComponent(this.jPanel4);
        this.jPanel2.add(this.jSplitPane1);
        this.setLayout(new BorderLayout());
        this.allPanel.setLayout(new BorderLayout());
        this.allPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.horizontalSplit.setDividerLocation(211);
        this.horizontalSplit.setOrientation(0);
        this.horizontalSplit.setMinimumSize(new Dimension(0, 0));
        this.horizontalSplit.setOneTouchExpandable(true);
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.topPanel.setMinimumSize(new Dimension(300, 10));
        this.topPanel.setPreferredSize(new Dimension(302, 591));
        this.topSplit.setBorder(null);
        this.topSplit.setDividerLocation(600);
        this.topSplit.setResizeWeight(0.75);
        this.topSplit.setContinuousLayout(true);
        this.topSplit.setDoubleBuffered(true);
        this.topSplit.setMinimumSize(new Dimension(0, 0));
        this.topSplit.setOneTouchExpandable(true);
        this.topSplit.setPreferredSize(new Dimension(0, 0));
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.tabbedPane.setMinimumSize(new Dimension(0, 0));
        this.tabbedPane.setPreferredSize(new Dimension(0, 50));
        this.outerStateLabelPanel.setLayout(new BorderLayout());
        this.outerStateLabelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.outerStateLabelPanel.setMinimumSize(new Dimension(34, 0));
        this.stateLabelScrollPane.setMinimumSize(new Dimension(24, 0));
        this.stateLabelScrollPane.setViewportView(this.stateLabelList);
        this.outerStateLabelPanel.add((Component)this.stateLabelScrollPane, "Center");
        this.tabbedPane.addTab("State labels", this.outerStateLabelPanel);
        this.outerPathFormulaePanel.setLayout(new BorderLayout());
        this.outerPathFormulaePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.outerPathFormulaePanel.setMinimumSize(new Dimension(34, 0));
        this.pathFormulaeScrollPane.setMinimumSize(new Dimension(24, 0));
        this.pathFormulaeScrollPane.setViewportView(this.pathFormulaeList);
        this.outerPathFormulaePanel.add((Component)this.pathFormulaeScrollPane, "Center");
        this.tabbedPane.addTab("Path formulae", this.outerPathFormulaePanel);
        this.informationPanel.setLayout(new BorderLayout());
        this.informationPanel.setMinimumSize(new Dimension(211, 0));
        this.innerInformationPanel.setLayout(new BoxLayout(this.innerInformationPanel, 1));
        this.innerInformationPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerInformationPanel.setMinimumSize(new Dimension(211, 0));
        this.topLabels.setLayout(new GridLayout(1, 3, 5, 0));
        this.topLabels.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.topLabels.setMinimumSize(new Dimension(201, 0));
        this.modelType.setText("Model Type:");
        this.modelType.setFont(this.getFont().deriveFont(1));
        this.topLabels.add(this.modelType);
        this.definedConstants.setText("Defined Constants:");
        this.definedConstants.setFont(this.getFont().deriveFont(1));
        this.topLabels.add(this.definedConstants);
        this.innerInformationPanel.add(this.topLabels);
        this.topValues.setLayout(new GridLayout(1, 3, 5, 0));
        this.topValues.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.modelTypeLabel.setText("Unknown");
        this.modelTypeLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.topValues.add(this.modelTypeLabel);
        this.definedConstantsLabel.setText("Unknown");
        this.definedConstantsLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.topValues.add(this.definedConstantsLabel);
        this.innerInformationPanel.add(this.topValues);
        this.bottomLabels.setLayout(new GridLayout(1, 3, 5, 0));
        this.bottomLabels.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.pathLength.setText("Path Length:");
        this.pathLength.setFont(this.getFont().deriveFont(1));
        this.bottomLabels.add(this.pathLength);
        this.totalTime.setText("Total Time:");
        this.totalTime.setFont(this.getFont().deriveFont(1));
        this.bottomLabels.add(this.totalTime);
        this.innerInformationPanel.add(this.bottomLabels);
        this.bottomValues.setLayout(new GridLayout(1, 3, 5, 0));
        this.bottomValues.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.pathLengthLabel.setText("0");
        this.pathLengthLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.bottomValues.add(this.pathLengthLabel);
        this.totalTimeLabel.setText("0.0");
        this.totalTimeLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.bottomValues.add(this.totalTimeLabel);
        this.innerInformationPanel.add(this.bottomValues);
        this.informationPanel.add((Component)this.innerInformationPanel, "North");
        this.tabbedPane.addTab("Path information", this.informationPanel);
        this.topSplit.setRightComponent(this.tabbedPane);
        this.outerTopLeftPanel.setLayout(new BorderLayout());
        this.topLeftPanel.setLayout(new BorderLayout());
        this.topLeftPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.topLeftPanel.setMinimumSize(new Dimension(0, 0));
        this.topLeftPanel.setPreferredSize(new Dimension(0, 0));
        this.innerTopLeftPanel.setLayout(new BorderLayout(5, 5));
        this.innerTopLeftPanel.setMinimumSize(new Dimension(50, 0));
        this.innerTopLeftPanel.setPreferredSize(new Dimension(302, 50));
        this.outerLeftExplorePanel.setLayout(new BorderLayout());
        this.outerLeftExplorePanel.setMinimumSize(new Dimension(129, 0));
        this.leftExplorePanel.setLayout(new BoxLayout(this.leftExplorePanel, 1));
        this.leftExplorePanel.setMinimumSize(new Dimension(129, 0));
        this.automaticExplorationPanel.setLayout(new BorderLayout());
        this.automaticExplorationPanel.setBorder(BorderFactory.createTitledBorder("Automatic exploration"));
        this.automaticExplorationPanel.setMinimumSize(new Dimension(129, 0));
        this.innerAutomaticExplorationPanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.innerAutomaticExplorationPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerAutomaticExplorationPanel.setMinimumSize(new Dimension(117, 0));
        this.randomExplorationButton.setIcon(new ImageIcon(""));
        this.randomExplorationButton.setToolTipText("Make a number of random automatic updates");
        this.randomExplorationButton.setHorizontalAlignment(10);
        this.randomExplorationButton.setText("Simulate");
        this.randomExplorationButton.setMaximumSize(new Dimension(220, 23));
        this.randomExplorationButton.setMinimumSize(new Dimension(50, 23));
        this.randomExplorationButton.setPreferredSize(new Dimension(160, 23));
        this.randomExplorationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.randomExplorationButtonActionPerformed(actionEvent);
            }
        });
        this.innerAutomaticExplorationPanel.add(this.randomExplorationButton);
        this.noStepsExplorePanel.setLayout(new GridBagLayout());
        this.noStepsExplorePanel.setMinimumSize(new Dimension(107, 0));
        this.typeExploreCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Num. steps", "Upto state", "Max. time"}));
        this.typeExploreCombo.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.noStepsExplorePanel.add((Component)this.typeExploreCombo, gridBagConstraints);
        this.inputExploreField.setText("1");
        this.inputExploreField.setToolTipText("");
        this.inputExploreField.setPreferredSize(new Dimension(60, 19));
        this.inputExploreField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.inputExploreFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.25;
        this.noStepsExplorePanel.add((Component)this.inputExploreField, gridBagConstraints);
        this.innerAutomaticExplorationPanel.add(this.noStepsExplorePanel);
        this.automaticExplorationPanel.add((Component)this.innerAutomaticExplorationPanel, "North");
        this.leftExplorePanel.add(this.automaticExplorationPanel);
        this.backtrackPanel.setLayout(new BorderLayout());
        this.backtrackPanel.setBorder(BorderFactory.createTitledBorder("Backtracking"));
        this.backtrackPanel.setMinimumSize(new Dimension(129, 0));
        this.innerBacktrackPanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.innerBacktrackPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerBacktrackPanel.setMinimumSize(new Dimension(117, 0));
        this.backtrackButton.setIcon(new ImageIcon(""));
        this.backtrackButton.setText("Backtrack");
        this.backtrackButton.setToolTipText("Backtrack to a certain state in your path");
        this.backtrackButton.setHorizontalAlignment(10);
        this.backtrackButton.setMaximumSize(new Dimension(220, 23));
        this.backtrackButton.setMinimumSize(new Dimension(50, 23));
        this.backtrackButton.setPreferredSize(new Dimension(160, 23));
        this.backtrackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.backtrackButtonActionPerformed(actionEvent);
            }
        });
        this.innerBacktrackPanel.add(this.backtrackButton);
        this.noStepsBacktrackPanel.setLayout(new GridBagLayout());
        this.noStepsBacktrackPanel.setMinimumSize(new Dimension(107, 0));
        this.typeBacktrackCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Num. steps", "To state"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.noStepsBacktrackPanel.add((Component)this.typeBacktrackCombo, gridBagConstraints);
        this.inputBacktrackField.setText("1");
        this.inputBacktrackField.setToolTipText("");
        this.inputBacktrackField.setPreferredSize(new Dimension(60, 19));
        this.inputBacktrackField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.inputBacktrackFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.25;
        this.noStepsBacktrackPanel.add((Component)this.inputBacktrackField, gridBagConstraints);
        this.innerBacktrackPanel.add(this.noStepsBacktrackPanel);
        this.backtrackPanel.add((Component)this.innerBacktrackPanel, "Center");
        this.leftExplorePanel.add(this.backtrackPanel);
        this.strategyPanel.setLayout(new BorderLayout());
        this.strategyPanel.setBorder(BorderFactory.createTitledBorder("Strategy"));
        this.strategyPanel.setMinimumSize(new Dimension(129, 0));
        this.innerStrategyPanel.setLayout(new GridLayout(1, 1, 5, 5));
        this.innerStrategyPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerStrategyPanel.setMinimumSize(new Dimension(117, 0));
        this.stratCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Hide", "Show", "Enforce"}));
        this.stratCombo.setToolTipText("How to treat current strategy");
        this.stratCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    switch (itemEvent.getItem().toString()) {
                        case "Hide": {
                            GUISimulator.this.stratShow = false;
                            GUISimulator.this.engine.setStrategyEnforced(false);
                            break;
                        }
                        case "Show": {
                            GUISimulator.this.stratShow = true;
                            GUISimulator.this.engine.setStrategyEnforced(false);
                            break;
                        }
                        case "Enforce": {
                            GUISimulator.this.stratShow = true;
                            GUISimulator.this.engine.setStrategyEnforced(true);
                        }
                    }
                }
                GUISimulator.this.updateTableModel.updateUpdatesTable(GUISimulator.this.pathTable);
                GUISimulator.this.pathTableModel.updatePathTable();
            }
        });
        this.innerStrategyPanel.add(this.stratCombo);
        this.strategyPanel.add((Component)this.innerStrategyPanel, "Center");
        this.leftExplorePanel.add(this.strategyPanel);
        this.outerLeftExplorePanel.add((Component)this.leftExplorePanel, "North");
        this.innerTopLeftPanel.add((Component)this.outerLeftExplorePanel, "West");
        this.manualUpdatesPanel.setLayout(new BorderLayout());
        this.manualUpdatesPanel.setBorder(BorderFactory.createTitledBorder("Manual exploration"));
        this.manualUpdatesPanel.setPreferredSize(new Dimension(60, 60));
        this.innerManualUpdatesPanel.setLayout(new BorderLayout());
        this.innerManualUpdatesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.manualUpdateTableScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.currentUpdatesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.manualUpdateTableScrollPane.setViewportView(this.currentUpdatesTable);
        this.innerManualUpdatesPanel.add((Component)this.manualUpdateTableScrollPane, "Center");
        this.autoTimeCheckPanel.setLayout(new BorderLayout());
        this.autoTimeCheckPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.autoTimeCheck.setText("Generate time automatically");
        this.autoTimeCheck.setToolTipText("When not selected, you will be prompted to manually enter the time spent in states");
        this.autoTimeCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoTimeCheck.setHorizontalAlignment(4);
        this.autoTimeCheck.setMargin(new Insets(0, 0, 0, 0));
        this.autoTimeCheckPanel.add((Component)this.autoTimeCheck, "East");
        this.innerManualUpdatesPanel.add((Component)this.autoTimeCheckPanel, "South");
        this.manualUpdatesPanel.add((Component)this.innerManualUpdatesPanel, "Center");
        this.innerTopLeftPanel.add((Component)this.manualUpdatesPanel, "Center");
        this.topLeftPanel.add((Component)this.innerTopLeftPanel, "Center");
        this.outerTopLeftPanel.add((Component)this.topLeftPanel, "Center");
        this.topSplit.setLeftComponent(this.outerTopLeftPanel);
        this.topPanel.add((Component)this.topSplit, "Center");
        this.horizontalSplit.setLeftComponent(this.topPanel);
        this.outerBottomPanel.setLayout(new BorderLayout());
        this.outerBottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.setBorder(BorderFactory.createTitledBorder("Path"));
        this.bottomPanel.setMinimumSize(new Dimension(42, 0));
        this.tableScroll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pathTablePlaceHolder.setToolTipText("Double-click or right-click to create a new path");
        this.tableScroll.setViewportView(this.pathTablePlaceHolder);
        this.bottomPanel.add((Component)this.tableScroll, "Center");
        this.outerBottomPanel.add((Component)this.bottomPanel, "Center");
        this.horizontalSplit.setBottomComponent(this.outerBottomPanel);
        this.allPanel.add((Component)this.horizontalSplit, "Center");
        this.add((Component)this.allPanel, "Center");
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.pathTable != null) {
            this.pathTable.setFont(font);
        }
    }

    private void inputBacktrackFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void backtrackButtonActionPerformed(ActionEvent actionEvent) {
        block21: {
            try {
                if (this.typeBacktrackCombo.getSelectedIndex() == 0) {
                    try {
                        int n = Integer.parseInt(this.inputBacktrackField.getText().trim());
                        if (n < 0) {
                            throw new NumberFormatException();
                        }
                        if ((long)n > this.engine.getPathSize()) {
                            n = (int)this.engine.getPathSize();
                        } else if (n == 0) {
                            return;
                        }
                        this.a_backTrack((int)(this.engine.getPathSize() - (long)n));
                        break block21;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "The \"" + String.valueOf(this.typeBacktrackCombo.getSelectedItem()) + "\" parameter is invalid: ";
                        string = string + "it should be a positive integer";
                        throw new PrismException(string);
                    }
                }
                if (this.typeBacktrackCombo.getSelectedIndex() == 1) {
                    try {
                        int n = Integer.parseInt(this.inputBacktrackField.getText().trim());
                        if (n < 0 || (long)n > this.engine.getPathSize()) {
                            throw new NumberFormatException();
                        }
                        this.a_backTrack(n);
                        break block21;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "The \"" + String.valueOf(this.typeBacktrackCombo.getSelectedItem()) + "\" parameter is invalid: ";
                        string = string + "it should be between 0 and " + (this.engine.getPathSize() - 1L);
                        throw new PrismException(string);
                    }
                }
                if (this.typeBacktrackCombo.getSelectedIndex() == 2) {
                    try {
                        double d = Double.parseDouble(this.inputBacktrackField.getText().trim());
                        if (d < 0.0) {
                            throw new NumberFormatException();
                        }
                        if (d >= this.engine.getTotalTimeForPath()) {
                            d = this.engine.getTotalTimeForPath();
                        }
                        this.a_backTrack(this.engine.getTotalTimeForPath() - d);
                        break block21;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "The \"" + String.valueOf(this.typeBacktrackCombo.getSelectedItem()) + "\" parameter is invalid: ";
                        string = string + "it should be a positive double";
                        throw new PrismException(string);
                    }
                }
                if (this.typeBacktrackCombo.getSelectedIndex() != 3) break block21;
                try {
                    double d = Double.parseDouble(this.inputBacktrackField.getText().trim());
                    if (d < 0.0 || d >= this.engine.getTotalTimeForPath()) {
                        throw new NumberFormatException();
                    }
                    this.a_backTrack(d);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "The \"" + String.valueOf(this.typeBacktrackCombo.getSelectedItem()) + "\" parameter is invalid: ";
                    string = string + "it should be between 0 and " + this.engine.getTotalTimeForPath();
                    throw new PrismException(string);
                }
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
    }

    private void configureViewButtonActionPerformed(ActionEvent actionEvent) {
        this.a_configureView();
    }

    private void initPopups() {
        this.newPath = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.tabToFront();
                GUISimulator.this.a_newPath(false);
            }
        };
        this.newPath.putValue("LongDescription", "Creates a new path.");
        this.newPath.putValue("MnemonicKey", 78);
        this.newPath.putValue("Name", "New path");
        this.newPath.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.newPath.putValue("AcceleratorKey", KeyStroke.getKeyStroke(119, 0));
        this.newPathFromState = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.tabToFront();
                GUISimulator.this.a_newPath(true);
            }
        };
        this.newPathFromState.putValue("LongDescription", "Creates a new path from a chosen state.");
        this.newPathFromState.putValue("Name", "New path from state");
        this.newPathFromState.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.newPathPlot = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.a_newPathPlot(false);
            }
        };
        this.newPathPlot.putValue("LongDescription", "Creates and plots a new path.");
        this.newPathPlot.putValue("Name", "Plot new path");
        this.newPathPlot.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileGraph.png"));
        this.newPathPlot.putValue("AcceleratorKey", KeyStroke.getKeyStroke(119, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.newPathPlotFromState = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.a_newPathPlot(true);
            }
        };
        this.newPathPlotFromState.putValue("LongDescription", "Creates and plots a new path from a chosen state.");
        this.newPathPlotFromState.putValue("Name", "Plot new path from state");
        this.newPathPlotFromState.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileGraph.png"));
        this.resetPath = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.a_restartPath();
            }
        };
        this.resetPath.putValue("LongDescription", "Resets the path.");
        this.resetPath.putValue("MnemonicKey", 82);
        this.resetPath.putValue("Name", "Reset path");
        this.resetPath.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPlayerStart.png"));
        this.resetPath.putValue("AcceleratorKey", KeyStroke.getKeyStroke(119, 64));
        this.exportPath = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.a_exportPath();
            }
        };
        this.exportPath.putValue("LongDescription", "Exports the path.");
        this.exportPath.putValue("MnemonicKey", 88);
        this.exportPath.putValue("Name", "Export path");
        this.exportPath.putValue("SmallIcon", GUIPrism.getIconFromImage("smallExport.png"));
        this.plotPath = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.a_plotPath();
            }
        };
        this.plotPath.putValue("LongDescription", "Plots the path on a graph.");
        this.plotPath.putValue("MnemonicKey", 80);
        this.plotPath.putValue("Name", "Plot path");
        this.plotPath.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileGraph.png"));
        this.randomExploration = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.randomExplorationButtonActionPerformed(actionEvent);
            }
        };
        this.randomExploration.putValue("LongDescription", "Extends the path by simulating.");
        this.randomExploration.putValue("MnemonicKey", 83);
        this.randomExploration.putValue("Name", "Simulate");
        this.randomExploration.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPlayerFwd.png"));
        this.randomExploration.putValue("AcceleratorKey", KeyStroke.getKeyStroke(120, 0));
        this.backtrack = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.backtrackButtonActionPerformed(actionEvent);
            }
        };
        this.backtrack.putValue("LongDescription", "Backtracks the path.");
        this.backtrack.putValue("MnemonicKey", 75);
        this.backtrack.putValue("Name", "Backtrack");
        this.backtrack.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPlayerRew.png"));
        this.backtrack.putValue("AcceleratorKey", KeyStroke.getKeyStroke(120, 64));
        this.backtrackToHere = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.a_backTrack(GUISimulator.this.pathTable.getSelectedRow());
            }
        };
        this.backtrackToHere.putValue("LongDescription", "Backtracks the path to the selected state.");
        this.backtrackToHere.putValue("MnemonicKey", 66);
        this.backtrackToHere.putValue("Name", "Backtrack to here");
        this.backtrackToHere.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPlayerRew.png"));
        this.removeToHere = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.a_removePreceding(GUISimulator.this.pathTable.getSelectedRow());
            }
        };
        this.removeToHere.putValue("LongDescription", "Removes states preceding the selected state from the path.");
        this.removeToHere.putValue("MnemonicKey", 82);
        this.removeToHere.putValue("Name", "Remove preceding steps");
        this.removeToHere.putValue("SmallIcon", GUIPrism.getIconFromImage("smallRemove.png"));
        this.configureView = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulator.this.a_configureView();
            }
        };
        this.configureView.putValue("LongDescription", "Configures the view.");
        this.configureView.putValue("MnemonicKey", 67);
        this.configureView.putValue("Name", "Configure view");
        this.configureView.putValue("SmallIcon", GUIPrism.getIconFromImage("smallOptions.png"));
        this.pathPopupMenu = new JPopupMenu();
        this.pathPopupMenu.add(this.newPath);
        this.pathPopupMenu.add(this.newPathFromState);
        this.pathPopupMenu.add(this.newPathPlot);
        this.pathPopupMenu.add(this.newPathPlotFromState);
        this.pathPopupMenu.addSeparator();
        this.pathPopupMenu.add(this.resetPath);
        this.pathPopupMenu.add(this.exportPath);
        this.pathPopupMenu.add(this.plotPath);
        this.pathPopupMenu.addSeparator();
        this.pathPopupMenu.add(this.randomExploration);
        this.pathPopupMenu.add(this.backtrack);
        this.pathPopupMenu.add(this.backtrackToHere);
        this.pathPopupMenu.add(this.removeToHere);
        this.pathPopupMenu.addSeparator();
        this.pathPopupMenu.add(this.configureView);
        this.simulatorMenu = new JMenu("Simulator");
        this.simulatorMenu.add(this.newPath);
        this.simulatorMenu.add(this.newPathFromState);
        this.simulatorMenu.add(this.newPathPlot);
        this.simulatorMenu.add(this.newPathPlotFromState);
        this.simulatorMenu.addSeparator();
        this.simulatorMenu.add(this.resetPath);
        this.simulatorMenu.add(this.exportPath);
        this.simulatorMenu.add(this.plotPath);
        this.simulatorMenu.addSeparator();
        this.simulatorMenu.add(this.randomExploration);
        this.simulatorMenu.add(this.backtrack);
        this.simulatorMenu.addSeparator();
        this.simulatorMenu.add(this.configureView);
        this.simulatorMenu.setMnemonic('S');
    }

    private void exportPathButtonActionPerformed(ActionEvent actionEvent) {
        this.a_exportPath();
    }

    private void resetPathButtonActionPerformed(ActionEvent actionEvent) {
        this.a_restartPath();
    }

    private void inputExploreFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void randomExplorationButtonActionPerformed(ActionEvent actionEvent) {
        block17: {
            try {
                if (this.typeExploreCombo.getSelectedIndex() == 0) {
                    try {
                        int n = Integer.parseInt(this.inputExploreField.getText().trim());
                        if (n <= 0) {
                            throw new NumberFormatException();
                        }
                        this.a_autoStep(n);
                        break block17;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "The \"" + String.valueOf(this.typeExploreCombo.getSelectedItem()) + "\" parameter is invalid: ";
                        string = string + "it should be a positive integer";
                        throw new PrismException(string);
                    }
                }
                if (this.typeExploreCombo.getSelectedIndex() == 1) {
                    try {
                        int n = Integer.parseInt(this.inputExploreField.getText().trim());
                        if ((long)n <= this.engine.getPathSize()) {
                            throw new NumberFormatException();
                        }
                        this.a_autoStep((int)((long)n - this.engine.getPathSize()));
                        break block17;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "The \"" + String.valueOf(this.typeExploreCombo.getSelectedItem()) + "\" parameter is invalid: ";
                        string = string + "it should be greater than " + this.engine.getPathSize();
                        throw new PrismException(string);
                    }
                }
                if (this.typeExploreCombo.getSelectedIndex() == 2) {
                    try {
                        double d = Double.parseDouble(this.inputExploreField.getText().trim());
                        if (d < 0.0) {
                            throw new NumberFormatException();
                        }
                        this.a_autoStep(d);
                        break block17;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "The \"" + String.valueOf(this.typeExploreCombo.getSelectedItem()) + "\" parameter is invalid: ";
                        string = string + "it should be a positive double";
                        throw new PrismException(string);
                    }
                }
                if (this.typeExploreCombo.getSelectedIndex() != 3) break block17;
                double d = this.engine.getTotalTimeForPath();
                try {
                    double d2 = Double.parseDouble(this.inputExploreField.getText().trim());
                    if (d2 <= d) {
                        throw new NumberFormatException();
                    }
                    this.a_autoStep(d2 - d);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "The \"" + String.valueOf(this.typeExploreCombo.getSelectedItem()) + "\" parameter is invalid: ";
                    string = string + "it should be greater than " + d;
                    throw new PrismException(string);
                }
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
    }

    private void newPathButtonActionPerformed(ActionEvent actionEvent) {
        this.a_newPath(false);
    }

    public boolean isPathActive() {
        return this.pathActive;
    }

    public void setPathActive(boolean bl) {
        this.pathActive = bl;
        this.pathTableModel.setPathActive(bl);
    }

    public void setParsedModel(ModulesFile modulesFile) {
        this.parsedModel = modulesFile;
        this.pathTableModel.setParsedModel(modulesFile);
        this.pathTableModel.setModelInfo(modulesFile);
    }

    public boolean isComputing() {
        return this.computing;
    }

    public void setComputing(boolean bl) {
        this.computing = bl;
        this.doEnables();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.doPopupDetection(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.doPopupDetection(mouseEvent);
    }

    public void doPopupDetection(MouseEvent mouseEvent) {
        if (!this.computing) {
            if (mouseEvent.getClickCount() == 2 && (mouseEvent.getSource() == this.pathTablePlaceHolder || mouseEvent.getSource() == this.tableScroll)) {
                if (this.newPath.isEnabled()) {
                    this.a_newPath(false);
                }
            } else if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == this.pathTablePlaceHolder || mouseEvent.getSource() == this.pathTable || mouseEvent.getSource() == this.pathTable.getTableHeader() || mouseEvent.getSource() == this.tableScroll)) {
                this.randomExploration.setEnabled(mouseEvent.getSource() != this.pathTable.getTableHeader() && mouseEvent.getSource() != this.pathTablePlaceHolder && mouseEvent.getSource() != this.tableScroll);
                this.backtrack.setEnabled(mouseEvent.getSource() != this.pathTable.getTableHeader() && mouseEvent.getSource() != this.pathTablePlaceHolder && mouseEvent.getSource() != this.tableScroll);
                this.backtrackToHere.setEnabled(mouseEvent.getSource() != this.pathTable.getTableHeader() && mouseEvent.getSource() != this.pathTablePlaceHolder && mouseEvent.getSource() != this.tableScroll);
                this.removeToHere.setEnabled(mouseEvent.getSource() != this.pathTable.getTableHeader() && mouseEvent.getSource() != this.pathTablePlaceHolder && mouseEvent.getSource() != this.tableScroll);
                this.doEnables();
                int n = this.pathTable.rowAtPoint(mouseEvent.getPoint());
                this.pathTable.getSelectionModel().setSelectionInterval(n, n);
                this.pathPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void insertTableColumn(TableColumn tableColumn) {
        int n = 1;
        int n2 = 1;
        String string = (String)tableColumn.getHeaderValue();
        while (n2 <= this.pathTable.getColumnCount() && n < this.pathTableModel.getColumnCount()) {
            if (n2 == this.pathTable.getColumnCount()) {
                this.pathTable.addColumn(tableColumn);
                break;
            }
            String string2 = this.pathTable.getColumnName(n2);
            String string3 = this.pathTableModel.getColumnName(n);
            if (string3.equals(string)) {
                this.pathTable.addColumn(tableColumn);
                if (n2 == this.pathTable.getColumnCount() - 1) break;
                this.pathTable.moveColumn(this.pathTable.getColumnCount() - 1, n2);
                break;
            }
            ++n;
            if (!string3.equals(string2)) continue;
            ++n2;
        }
    }

    public void showColumn(int n) {
    }

    public boolean isDisplayStyle() {
        return this.displayStyleFast;
    }

    public void setDisplayStyle(boolean bl) throws PrismException {
        this.getPrism().getSettings().set("simulator.renderAllValues", bl ? 0 : 1);
    }

    public boolean isDisplayPathLoops() {
        return this.displayPathLoops;
    }

    public void setDisplayPathLoops(boolean bl) throws PrismException {
        this.displayPathLoops = bl;
    }

    public ModulesFile getModulesFile() {
        return this.parsedModel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.pathTable.getSelectedRowCount() == 0) {
            int n = this.pathTable.getRowCount() - 1;
            this.pathTable.getSelectionModel().setSelectionInterval(n, n);
        }
        this.updateTableModel.updateUpdatesTable(this.pathTable);
        this.stateLabelList.repaint();
        this.pathFormulaeList.repaint();
    }

    public void sortOutColumnSizes() {
        int n = this.pathTable.getWidth();
        TableColumnModel tableColumnModel = this.pathTable.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setMinWidth(50);
        }
        if (50 * tableColumnModel.getColumnCount() > this.tableScroll.getWidth()) {
            this.pathTable.setAutoResizeMode(0);
        } else {
            this.pathTable.setAutoResizeMode(2);
        }
    }

    public boolean isOldUpdate() {
        return this.updateTableModel.oldUpdate;
    }

    public int getOldUpdateStep() {
        return this.updateTableModel.oldStep;
    }

    public boolean usingChangeRenderer() {
        return ((GUISimulatorPathTable)this.pathTable).usingChangeRenderer();
    }

    public void setRenderer(boolean bl) {
        if (bl) {
            ((GUISimulatorPathTable)this.pathTable).switchToChangeRenderer();
        } else {
            ((GUISimulatorPathTable)this.pathTable).switchToBoringRenderer();
        }
        this.repaint();
    }

    public boolean isStrategyShown() {
        return this.stratShow;
    }

    @Override
    public void notifySettings(PrismSettings prismSettings) {
        this.displayStyleFast = prismSettings.getInteger("simulator.renderAllValues") == 0;
    }

    public String formatDouble(double d) {
        return PrismUtils.formatDouble(6, d);
    }

    class UpdateTableModel
    extends AbstractTableModel {
        private List<UpdateTableModelColumn> visibleColumns = new ArrayList<UpdateTableModelColumn>();
        public boolean oldUpdate = false;
        private int oldStep = -1;

        @Override
        public int getColumnCount() {
            if (GUISimulator.this.pathActive) {
                return this.visibleColumns.size();
            }
            return 0;
        }

        @Override
        public int getRowCount() {
            try {
                return GUISimulator.this.pathActive ? GUISimulator.this.engine.getNumTransitions() : 0;
            }
            catch (PrismException prismException) {
                return 0;
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (GUISimulator.this.pathActive && n2 < this.visibleColumns.size()) {
                try {
                    switch (this.visibleColumns.get(n2)) {
                        case PLAYER: {
                            return GUISimulator.this.engine.getNameOfPlayerOwningState();
                        }
                        case STRAT: {
                            return GUISimulator.this.engine.getStrategyDecisionString(n);
                        }
                        case ACTION: {
                            return GUISimulator.this.engine.getTransitionActionDescription(n);
                        }
                        case PROB: {
                            return GUISimulator.this.engine.getTransitionProbabilityString(n);
                        }
                        case UPDATE: {
                            return GUISimulator.this.engine.getTransitionUpdateString(n);
                        }
                    }
                    return "";
                }
                catch (PrismException prismException) {
                    return "";
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int n) {
            if (GUISimulator.this.pathActive && n < this.visibleColumns.size()) {
                switch (this.visibleColumns.get(n)) {
                    case PLAYER: {
                        return "Player";
                    }
                    case STRAT: {
                        return "Strategy";
                    }
                    case ACTION: {
                        return GUISimulator.this.engine.getModel().getActionStringDescription();
                    }
                    case PROB: {
                        return GUISimulator.this.parsedModel == null ? "Probability" : GUISimulator.this.parsedModel.getModelType().probabilityOrRate();
                    }
                    case UPDATE: {
                        return "Update";
                    }
                }
                return "";
            }
            return "";
        }

        public void updateUpdatesTable() {
            if (GUISimulator.this.isOldUpdate()) {
                try {
                    this.oldUpdate = false;
                    this.oldStep = -1;
                    GUISimulator.this.engine.computeTransitionsForCurrentState();
                }
                catch (PrismException prismException) {
                    // empty catch block
                }
            }
            this.setVisibleColumns();
            GUISimulator.this.doEnables();
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
            GUISimulator.this.currentUpdatesTable.setEnabled(true);
            GUISimulator.this.currentUpdatesTable.setToolTipText("Double click on an update to manually execute it");
            if (this.getRowCount() > 0) {
                GUISimulator.this.currentUpdatesTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        public void updateUpdatesTable(JTable jTable) {
            int n = jTable.getSelectedRow();
            if (n == -1 || n == jTable.getRowCount() - 1) {
                this.updateUpdatesTable();
            } else {
                this.oldUpdate = true;
                this.oldStep = n;
                try {
                    GUISimulator.this.engine.computeTransitionsForStep(this.oldStep);
                }
                catch (PrismException prismException) {
                    // empty catch block
                }
                this.setVisibleColumns();
                GUISimulator.this.doEnables();
                this.fireTableStructureChanged();
                this.fireTableDataChanged();
                GUISimulator.this.currentUpdatesTable.setEnabled(false);
                GUISimulator.this.currentUpdatesTable.setToolTipText(null);
                if (this.getRowCount() > 0) {
                    int n2 = GUISimulator.this.engine.getChoiceOfPathStep(this.oldStep);
                    GUISimulator.this.currentUpdatesTable.getSelectionModel().setSelectionInterval(n2, n2);
                }
            }
        }

        public void setVisibleColumns() {
            this.visibleColumns.clear();
            if (GUISimulator.this.parsedModel != null && GUISimulator.this.parsedModel.getModelType().multiplePlayers() && !GUISimulator.this.parsedModel.getModelType().concurrent()) {
                this.visibleColumns.add(UpdateTableModelColumn.PLAYER);
            }
            if (GUISimulator.this.stratShow && GUISimulator.this.engine.hasStrategyInfo()) {
                this.visibleColumns.add(UpdateTableModelColumn.STRAT);
            }
            this.visibleColumns.add(UpdateTableModelColumn.ACTION);
            if (GUISimulator.this.parsedModel != null && GUISimulator.this.parsedModel.getModelType().isProbabilistic()) {
                this.visibleColumns.add(UpdateTableModelColumn.PROB);
            }
            this.visibleColumns.add(UpdateTableModelColumn.UPDATE);
        }

        public void restartUpdatesTable() {
            this.fireTableStructureChanged();
            if (this.getRowCount() > 0) {
                this.oldUpdate = false;
                this.oldStep = -1;
                GUISimulator.this.currentUpdatesTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        public int getChoiceIndexOf(int n) {
            try {
                return GUISimulator.this.engine.getChoiceIndexOfTransition(n);
            }
            catch (PrismException prismException) {
                return -1;
            }
        }

        public boolean isEnabledByStrategy(int n) {
            try {
                return GUISimulator.this.engine.isTransitionEnabledByStrategy(n);
            }
            catch (PrismException prismException) {
                return true;
            }
        }

        public boolean isNondetModel() {
            return GUISimulator.this.engine.getModel().getModelType().nondeterministic();
        }
    }

    static enum UpdateTableModelColumn {
        PLAYER,
        STRAT,
        ACTION,
        PROB,
        UPDATE;

    }
}

