/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model;

import io.ModelExportTask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import parser.Values;
import parser.ast.ModulesFile;
import prism.Model;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismModelListener;
import prism.PrismSettings;
import prism.UndefinedConstants;
import userinterface.GUIConstantsPicker;
import userinterface.GUIPlugin;
import userinterface.model.GUIModelEditor;
import userinterface.model.GUIModelEvent;
import userinterface.model.GUIMultiModel;
import userinterface.model.GUIMultiModelTree;
import userinterface.model.GUITextModelEditor;
import userinterface.model.Style;
import userinterface.model.computation.BuildModelThread;
import userinterface.model.computation.ComputeSteadyStateThread;
import userinterface.model.computation.ComputeTransientThread;
import userinterface.model.computation.ExportBuiltModelThread;
import userinterface.model.computation.LoadPEPAModelThread;
import userinterface.model.computation.LoadPRISMModelThread;
import userinterface.model.computation.ParseModelThread;
import userinterface.model.pepaModel.GUIPepaModelEditor;
import userinterface.util.GUIUndoManager;

public class GUIMultiModelHandler
extends JPanel
implements PrismModelListener {
    public static final int PRISM_MODE = 1;
    public static final int PEPA_MODE = 2;
    private GUIMultiModel theModel;
    private GUIMultiModelTree tree;
    private GUIModelEditor editor;
    private Prism prism;
    private int currentMode;
    private boolean modified;
    private boolean modifiedSinceParse;
    private File activeFile;
    private ModulesFile parsedModel;
    private Values lastMFConstants = null;
    private PrismException lastBuildError = null;
    private boolean busy = false;
    private boolean autoParse;
    private Font prismEditorFontFast;
    private Color prismEditorColourFast;
    private Color prismEditorBGColourFast;
    private Style prismEditorNumericFast = Style.defaultStyle();
    private Style prismEditorVariableFast = Style.defaultStyle();
    private Style prismEditorKeywordFast = Style.defaultStyle();
    private Style prismEditorCommentFast = Style.defaultStyle();
    private Font pepaEditorFontFast;
    private Color pepaEditorColourFast;
    private Color pepaEditorBGColourFast;
    private Style pepaEditorCommentFast = Style.defaultStyle();
    private boolean startupCompleted = false;
    private WaitParseThread waiter;
    private boolean parsing = false;
    private boolean parseAfterParse = false;
    private String lastError;
    private boolean buildAfterReceiveParseNotification = false;
    private boolean exportAfterReceiveParseNotification = false;
    private boolean computeSSAfterReceiveParseNotification = false;
    private boolean computeTransientAfterReceiveParseNotification = false;
    private ModelExportTask exportTask;
    private String transientTimeSpec;
    private JSplitPane splitter;
    private JPanel leftHandSide;
    private JPanel treeAndBuild;
    private JLabel builtNoStates;
    private JLabel builtNoInitStates;
    private JLabel builtNoTransitions;

    public GUIMultiModelHandler(GUIMultiModel gUIMultiModel) {
        this.theModel = gUIMultiModel;
        this.prism = gUIMultiModel.getPrism();
        this.prism.addModelListener(this);
        this.editor = new GUITextModelEditor("", this);
        this.tree = new GUIMultiModelTree(this);
        this.splitter = new JSplitPane();
        this.initComponents();
        this.newPRISMModel();
        this.notifySettings(gUIMultiModel.getPrism().getSettings());
        this.splitter.setBorder(null);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    private void initComponents() {
        this.treeAndBuild = new JPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.tree, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new CompoundBorder(new EmptyBorder(5, 0, 0, 0), new TitledBorder("Built Model")));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 2, 5, 5));
        JLabel jLabel = new JLabel("States:");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setHorizontalAlignment(4);
        this.builtNoStates = new JLabel("...");
        JLabel jLabel2 = new JLabel("Initial states:");
        jLabel2.setFont(jLabel2.getFont().deriveFont(1));
        jLabel2.setHorizontalAlignment(4);
        this.builtNoInitStates = new JLabel("...");
        JLabel jLabel3 = new JLabel("Transitions:");
        jLabel3.setFont(jLabel3.getFont().deriveFont(1));
        jLabel3.setHorizontalAlignment(4);
        this.builtNoTransitions = new JLabel("...");
        jPanel3.add(jLabel);
        jPanel3.add(this.builtNoStates);
        jPanel3.add(jLabel2);
        jPanel3.add(this.builtNoInitStates);
        jPanel3.add(jLabel3);
        jPanel3.add(this.builtNoTransitions);
        jPanel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel2.add((Component)jPanel3, "Center");
        this.treeAndBuild.setLayout(new BorderLayout());
        this.treeAndBuild.add((Component)jPanel, "Center");
        this.treeAndBuild.add((Component)jPanel2, "South");
        this.treeAndBuild.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.splitter.setOrientation(1);
        this.leftHandSide = new JPanel();
        this.leftHandSide.setLayout(new BorderLayout());
        this.leftHandSide.add((Component)this.treeAndBuild, "Center");
        this.splitter.setLeftComponent(this.leftHandSide);
        this.splitter.setRightComponent(this.editor);
        this.splitter.setDividerLocation(0.5);
        this.splitter.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitter, "Center");
    }

    private synchronized void restartWaitParseThread() {
        if (!this.startupCompleted) {
            return;
        }
        if (this.editor.getParseText().trim().isEmpty()) {
            return;
        }
        if (this.waiter != null) {
            this.waiter.interrupt();
        }
        int n = this.theModel.getPrism().getSettings().getInteger("model.parseDelay");
        this.waiter = new WaitParseThread(n, this);
        this.waiter.start();
    }

    public void onInitComponentsCompleted() {
        this.startupCompleted = true;
        this.restartWaitParseThread();
    }

    public void newPRISMModel() {
        this.activeFile = null;
        this.modified = false;
        this.modifiedSinceParse = false;
        this.parsedModel = null;
        this.updateBuiltModelDisplay();
        if (this.currentMode == 1) {
            this.editor.newModel();
        } else {
            this.editor = new GUITextModelEditor("", this);
            this.editor.newModel();
            this.splitter.setRightComponent(this.editor);
        }
        this.tree.newTree(false);
        this.tree.update(this.parsedModel);
        this.currentMode = 1;
        this.theModel.doEnables();
        this.lastError = "";
        this.theModel.notifyEventListeners(new GUIModelEvent(0));
        this.theModel.notifyEventListeners(new GUIModelEvent(9));
    }

    public void newPEPAModel() {
        this.activeFile = null;
        this.modified = false;
        this.modifiedSinceParse = false;
        this.parsedModel = null;
        this.updateBuiltModelDisplay();
        if (this.currentMode == 2) {
            this.editor.newModel();
        } else {
            this.editor.newModel();
        }
        this.tree.newTree(false);
        this.tree.update(this.parsedModel);
        this.currentMode = 2;
        this.theModel.doEnables();
        this.lastError = "";
        this.theModel.notifyEventListeners(new GUIModelEvent(0));
        this.theModel.notifyEventListeners(new GUIModelEvent(9));
    }

    public void convertViewToPRISM() {
        this.theModel.doEnables();
    }

    public void convertViewToPEPA() {
        this.theModel.doEnables();
    }

    public void loadModel(File file) {
        this.loadModel(file, true);
    }

    public void loadModel(File file, boolean bl) {
        String string = file.getName();
        if (string.endsWith("pm") | string.endsWith("nm") | string.endsWith("sm")) {
            this.loadPRISMModel(file, bl);
        } else if (string.endsWith("pepa")) {
            this.loadPEPAModel(file, bl);
        } else {
            this.loadPRISMModel(file, bl);
        }
    }

    public void loadPRISMModel(File file) {
        this.loadPRISMModel(file, true);
    }

    public void loadPRISMModel(File file, boolean bl) {
        this.lastError = "";
        LoadPRISMModelThread loadPRISMModelThread = new LoadPRISMModelThread(this, this.editor, file, false);
        loadPRISMModelThread.start();
        if (!bl) {
            try {
                loadPRISMModelThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.theModel.doEnables();
    }

    public synchronized void prismModelLoaded(GUITextModelEditor gUITextModelEditor, File file, boolean bl) {
        this.theModel.notifyEventListeners(new GUIModelEvent(0));
        this.theModel.notifyEventListeners(new GUIModelEvent(9));
        this.activeFile = file;
        this.modified = false;
        this.modifiedSinceParse = false;
        this.parsedModel = null;
        this.updateBuiltModelDisplay();
        if (bl) {
            this.editor = gUITextModelEditor;
            this.splitter.setRightComponent(this.editor);
        }
        this.tree.newTree(false);
        this.tree.update(this.parsedModel);
        this.tree.makeNotUpToDate();
        this.currentMode = 1;
        this.updateAutoParse();
        this.lastError = "";
        new ParseModelThread(this, this.editor.getParseText(), false, this.isAutoParse()).start();
        this.tree.startParsing();
        this.parsing = true;
        this.theModel.doEnables();
        this.theModel.tabToFront();
    }

    public void loadPEPAModel(File file) {
        this.loadPEPAModel(file, true);
    }

    public void loadPEPAModel(File file, boolean bl) {
        this.lastError = "";
        LoadPEPAModelThread loadPEPAModelThread = new LoadPEPAModelThread(this, this.editor, file, false);
        loadPEPAModelThread.start();
        if (!bl) {
            try {
                loadPEPAModelThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.theModel.doEnables();
    }

    public synchronized void pepaModelLoaded(GUIPepaModelEditor gUIPepaModelEditor, File file, boolean bl) {
        this.theModel.notifyEventListeners(new GUIModelEvent(0));
        this.theModel.notifyEventListeners(new GUIModelEvent(9));
        this.activeFile = file;
        this.modified = false;
        this.modifiedSinceParse = false;
        this.parsedModel = null;
        this.updateBuiltModelDisplay();
        if (bl) {
            this.editor = gUIPepaModelEditor;
            this.splitter.setRightComponent(this.editor);
        }
        this.tree.newTree(false);
        this.tree.update(this.parsedModel);
        this.tree.makeNotUpToDate();
        this.currentMode = 2;
        this.updateAutoParse();
        this.lastError = "";
        new ParseModelThread(this, this.editor.getParseText(), true, this.isAutoParse()).start();
        this.tree.startParsing();
        this.theModel.doEnables();
        this.theModel.tabToFront();
    }

    public void reloadActiveFile() {
        if (this.activeFile != null) {
            if (this.currentMode == 1) {
                new LoadPRISMModelThread(this, this.editor, this.activeFile, true).start();
            } else if (this.currentMode == 2) {
                new LoadPEPAModelThread(this, this.editor, this.activeFile, true).start();
            }
        }
        this.theModel.doEnables();
    }

    public synchronized void prismModelReLoaded(File file) {
        this.theModel.notifyEventListeners(new GUIModelEvent(0));
        this.activeFile = file;
        this.modified = false;
        this.parsedModel = null;
        this.modifiedSinceParse = false;
        this.updateBuiltModelDisplay();
        this.currentMode = 1;
        this.updateAutoParse();
        if (!this.parsing) {
            this.parsing = true;
            this.tree.makeNotUpToDate();
            this.lastError = "";
            new ParseModelThread(this, this.editor.getParseText(), false, this.isAutoParse()).start();
            this.tree.startParsing();
        } else {
            this.parseAfterParse = true;
        }
        this.theModel.doEnables();
        this.theModel.tabToFront();
    }

    public synchronized void pepaModelReLoaded(File file) {
        this.theModel.notifyEventListeners(new GUIModelEvent(0));
        this.activeFile = file;
        this.modified = false;
        this.parsedModel = null;
        this.modifiedSinceParse = false;
        this.updateBuiltModelDisplay();
        this.currentMode = 2;
        this.updateAutoParse();
        if (!this.parsing) {
            this.parsing = true;
            this.tree.makeNotUpToDate();
            this.lastError = "";
            new ParseModelThread(this, this.editor.getParseText(), true, this.isAutoParse()).start();
            this.tree.startParsing();
        } else {
            this.parseAfterParse = true;
        }
        this.theModel.doEnables();
        this.theModel.tabToFront();
    }

    public int saveToActiveFile() {
        return this.saveToFile(this.activeFile);
    }

    public int saveToFile(File file) {
        try {
            this.theModel.setTaskBarText("Saving model...");
            if (this.currentMode == 1) {
                ((GUITextModelEditor)this.editor).write(new FileWriter(file));
            } else {
                ((GUIPepaModelEditor)this.editor).write(new FileWriter(file));
            }
        }
        catch (IOException iOException) {
            this.theModel.setTaskBarText("Saving model... error.");
            this.theModel.error("Could not save to file \"" + String.valueOf(file) + "\"");
            return 1;
        }
        catch (ClassCastException classCastException) {
            this.theModel.setTaskBarText("Saving model... error.");
            this.theModel.error("Could not save to file \"" + String.valueOf(file) + "\"");
            return 1;
        }
        this.theModel.setTaskBarText("Saving model... done.");
        if (this.currentMode == 1) {
            this.prismFileWasSaved(file);
        } else {
            this.pepaFileWasSaved(file);
        }
        return 0;
    }

    public void prismFileWasSaved(File file) {
        this.activeFile = file;
        this.modified = false;
        this.tree.update(this.parsedModel);
        this.theModel.doEnables();
    }

    public void pepaFileWasSaved(File file) {
        this.activeFile = file;
        this.modified = false;
        this.tree.update(this.parsedModel);
        this.theModel.doEnables();
    }

    public void requestParse(boolean bl) {
        if (this.modifiedSinceParse || this.parsedModel == null || bl) {
            if (!this.parsing) {
                this.lastError = "";
                this.tree.makeNotUpToDate();
                new ParseModelThread(this, this.editor.getParseText(), this.currentMode == 2, false).start();
                this.tree.startParsing();
                this.parsing = true;
            } else {
                this.parseAfterParse = true;
            }
            this.theModel.doEnables();
        } else {
            this.modelParsedSuccessful(this.parsedModel);
        }
    }

    public synchronized void modelParsedSuccessful(ModulesFile modulesFile) {
        this.tree.stopParsing();
        this.parsing = false;
        this.parsedModel = modulesFile;
        this.modifiedSinceParse = false;
        this.lastError = "Parse Successful";
        this.editor.modelParseSuccessful();
        if (this.parseAfterParse) {
            this.parseAfterParse = false;
            this.tree.makeNotUpToDate();
            if (this.isAutoParse()) {
                this.restartWaitParseThread();
            }
        } else if (this.buildAfterReceiveParseNotification) {
            this.buildAfterParse();
        } else if (this.exportAfterReceiveParseNotification) {
            this.exportAfterParse();
        } else if (this.computeSSAfterReceiveParseNotification) {
            this.computeSteadyStateAfterParse();
        } else if (this.computeTransientAfterReceiveParseNotification) {
            this.computeTransientAfterParse();
        } else {
            this.tree.update(this.parsedModel);
        }
        this.tree.repaint();
        this.theModel.doEnables();
        this.theModel.notifyEventListeners(new GUIModelEvent(3, this.parsedModel));
    }

    public synchronized void modelParseFailed(PrismException prismException, boolean bl) {
        this.lastError = prismException.getMessage();
        if (prismException instanceof PrismLangException) {
            this.editor.modelParseFailed((PrismLangException)prismException, bl);
        }
        this.tree.stopParsing();
        this.parsing = false;
        this.tree.lastParseFailed();
        if (this.parseAfterParse) {
            this.parseAfterParse = false;
            this.tree.makeNotUpToDate();
            if (this.isAutoParse()) {
                this.restartWaitParseThread();
            }
        } else {
            this.buildAfterReceiveParseNotification = false;
            this.exportAfterReceiveParseNotification = false;
            this.computeSSAfterReceiveParseNotification = false;
            this.computeTransientAfterReceiveParseNotification = false;
        }
        this.tree.repaint();
        this.theModel.doEnables();
        this.theModel.notifyEventListeners(new GUIModelEvent(7));
    }

    public void forceBuild() {
        this.buildAfterReceiveParseNotification = true;
        this.requestParse(false);
    }

    private void buildAfterParse() {
        int n;
        this.buildAfterReceiveParseNotification = false;
        UndefinedConstants undefinedConstants = new UndefinedConstants(this.parsedModel, null);
        if (undefinedConstants.getMFNumUndefined() > 0) {
            n = GUIConstantsPicker.defineConstantsWithDialog(this.theModel.getGUI(), undefinedConstants, this.lastMFConstants, null);
            if (!n) {
                return;
            }
            this.lastMFConstants = undefinedConstants.getMFConstantValues();
        }
        try {
            n = this.prism.getSettings().getBoolean("prism.exact.enabled");
            this.prism.setPRISMModelConstants(undefinedConstants.getMFConstantValues(), n != 0);
        }
        catch (PrismException prismException) {
            this.theModel.error(prismException.getMessage());
            return;
        }
        new BuildModelThread(this).start();
    }

    @Override
    public synchronized void notifyModelBuildSuccessful() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIMultiModelHandler.this.editor.modelParseSuccessful();
                GUIMultiModelHandler.this.updateBuiltModelDisplay();
                GUIMultiModelHandler.this.theModel.doEnables();
                GUIMultiModelHandler.this.theModel.notifyEventListeners(new GUIModelEvent(6, GUIMultiModelHandler.this.lastMFConstants));
            }
        });
    }

    private void updateBuiltModelDisplay() {
        this.builtNoStates.setText("?");
        this.builtNoInitStates.setText("?");
        this.builtNoTransitions.setText("?");
        Model<?> model = this.prism.getBuiltModel();
        if (model != null) {
            this.builtNoStates.setText(model.getNumStatesString());
            this.builtNoInitStates.setText(model.getNumInitialStatesString());
            this.builtNoTransitions.setText(model.getNumTransitionsString());
        }
    }

    @Override
    public synchronized void notifyModelBuildFailed(PrismException prismException) {
        this.lastBuildError = prismException;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GUIMultiModelHandler.this.lastBuildError != null && GUIMultiModelHandler.this.lastBuildError instanceof PrismLangException) {
                    GUIMultiModelHandler.this.editor.modelParseFailed((PrismLangException)GUIMultiModelHandler.this.lastBuildError, false);
                    if (!GUIMultiModelHandler.this.theModel.getComputing()) {
                        GUIMultiModelHandler.this.theModel.tabToFront();
                    }
                }
                GUIMultiModelHandler.this.updateBuiltModelDisplay();
                GUIMultiModelHandler.this.theModel.doEnables();
                GUIMultiModelHandler.this.theModel.notifyEventListeners(new GUIModelEvent(8));
            }
        });
    }

    public void export(ModelExportTask modelExportTask) {
        this.exportAfterReceiveParseNotification = true;
        this.exportTask = modelExportTask;
        this.requestParse(false);
    }

    private void exportAfterParse() {
        int n;
        this.exportAfterReceiveParseNotification = false;
        UndefinedConstants undefinedConstants = new UndefinedConstants(this.parsedModel, null);
        if (undefinedConstants.getMFNumUndefined() > 0) {
            n = GUIConstantsPicker.defineConstantsWithDialog(this.theModel.getGUI(), undefinedConstants, this.lastMFConstants, null);
            if (!n) {
                return;
            }
            this.lastMFConstants = undefinedConstants.getMFConstantValues();
        }
        try {
            n = this.prism.getSettings().getBoolean("prism.exact.enabled");
            this.prism.setPRISMModelConstants(undefinedConstants.getMFConstantValues(), n != 0);
        }
        catch (PrismException prismException) {
            this.theModel.error(prismException.getMessage());
            return;
        }
        if (this.exportTask.getFile() == null) {
            this.theModel.logToFront();
        }
        new ExportBuiltModelThread(this, this.exportTask).start();
    }

    public void computeSteadyState(ModelExportTask modelExportTask) {
        this.computeSSAfterReceiveParseNotification = true;
        this.exportTask = modelExportTask;
        this.requestParse(false);
    }

    private void computeSteadyStateAfterParse() {
        int n;
        this.computeSSAfterReceiveParseNotification = false;
        UndefinedConstants undefinedConstants = new UndefinedConstants(this.parsedModel, null);
        if (undefinedConstants.getMFNumUndefined() > 0) {
            n = GUIConstantsPicker.defineConstantsWithDialog(this.theModel.getGUI(), undefinedConstants, this.lastMFConstants, null);
            if (!n) {
                return;
            }
            this.lastMFConstants = undefinedConstants.getMFConstantValues();
        }
        try {
            n = this.prism.getSettings().getBoolean("prism.exact.enabled");
            this.prism.setPRISMModelConstants(undefinedConstants.getMFConstantValues(), n != 0);
        }
        catch (PrismException prismException) {
            this.theModel.error(prismException.getMessage());
            return;
        }
        if (this.exportTask.getFile() == null) {
            this.theModel.logToFront();
        }
        new ComputeSteadyStateThread(this, this.exportTask).start();
    }

    public void computeTransient(String string, ModelExportTask modelExportTask) {
        this.computeTransientAfterReceiveParseNotification = true;
        this.transientTimeSpec = string;
        this.exportTask = modelExportTask;
        this.requestParse(false);
    }

    private void computeTransientAfterParse() {
        int n;
        this.computeTransientAfterReceiveParseNotification = false;
        UndefinedConstants undefinedConstants = new UndefinedConstants(this.parsedModel, null);
        if (undefinedConstants.getMFNumUndefined() > 0) {
            n = GUIConstantsPicker.defineConstantsWithDialog(this.theModel.getGUI(), undefinedConstants, this.lastMFConstants, null);
            if (!n) {
                return;
            }
            this.lastMFConstants = undefinedConstants.getMFConstantValues();
        }
        try {
            n = this.prism.getSettings().getBoolean("prism.exact.enabled");
            this.prism.setPRISMModelConstants(undefinedConstants.getMFConstantValues(), n != 0);
        }
        catch (PrismException prismException) {
            this.theModel.error(prismException.getMessage());
            return;
        }
        if (this.exportTask.getFile() == null) {
            this.theModel.logToFront();
        }
        new ComputeTransientThread(this, this.transientTimeSpec, this.exportTask).start();
    }

    public void requestViewModel() {
        if (this.parsedModel != null) {
            this.theModel.showModel(this.parsedModel.toString());
        }
        this.theModel.doEnables();
    }

    public void hasModified(boolean bl) {
        this.modified = true;
        if (this.isBusy()) {
            this.theModel.doEnables();
            return;
        }
        this.tree.makeNotUpToDate();
        this.theModel.notifyEventListeners(new GUIModelEvent(4));
        this.modifiedSinceParse = true;
        if (!this.parsing) {
            if (this.isAutoParse() && bl) {
                this.restartWaitParseThread();
            }
        } else {
            this.parseAfterParse = true;
        }
        this.theModel.doEnables();
    }

    public void undo() {
        this.editor.undo();
    }

    public void redo() {
        this.editor.redo();
    }

    public void cut() {
        this.editor.cut();
    }

    public void copy() {
        this.editor.copy();
    }

    public void paste() {
        this.editor.paste();
    }

    public void delete() {
        this.editor.delete();
    }

    public void selectAll() {
        this.editor.selectAll();
    }

    public synchronized int getModelMode() {
        return this.currentMode;
    }

    public synchronized boolean hasActiveFile() {
        return this.activeFile != null;
    }

    public synchronized boolean modified() {
        return this.modified;
    }

    public synchronized String getActiveFileName() {
        if (this.hasActiveFile()) {
            return this.activeFile.getPath();
        }
        return "<Untitled>";
    }

    public synchronized String getShortActiveFileName() {
        if (this.hasActiveFile()) {
            return this.activeFile.getName();
        }
        return "<Untitled>";
    }

    public synchronized boolean isAutoParse() {
        return this.autoParse;
    }

    public synchronized void updateAutoParse() {
        boolean bl = this.autoParse;
        this.autoParse = this.theModel.getPrism().getSettings().getBoolean("model.autoParse");
        if (this.isSwitchOnLarge() && this.autoParse && (this.currentMode == 1 || this.currentMode == 2) && this.editor.getParseText().length() > 25000) {
            this.autoParse = false;
        }
        if (!bl && this.autoParse) {
            this.tree.makeNotUpToDate();
            this.theModel.notifyEventListeners(new GUIModelEvent(4));
            if (!this.parsing) {
                if (this.isAutoParse()) {
                    this.restartWaitParseThread();
                }
            } else {
                this.parseAfterParse = true;
            }
            this.theModel.doEnables();
        }
    }

    public synchronized boolean isSwitchOnLarge() {
        return this.theModel.getPrism().getSettings().getBoolean("model.autoManual");
    }

    public synchronized ModelType getParsedModelType() {
        if (this.parsedModel != null) {
            return this.parsedModel.getModelType();
        }
        return ModelType.MDP;
    }

    public synchronized String getParseErrorMessage() {
        return this.lastError;
    }

    public GUIPlugin getGUIPlugin() {
        return this.theModel;
    }

    public int getParseState() {
        return this.tree.getParseSynchState();
    }

    public GUIMultiModelTree getTree() {
        return this.tree;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean bl) {
        this.busy = bl;
    }

    public void notifySettings(PrismSettings prismSettings) {
        int n;
        this.updateAutoParse();
        this.prismEditorFontFast = prismSettings.getFontColorPair((String)"model.prismEditor.font").f;
        if (this.editor instanceof GUITextModelEditor) {
            ((GUITextModelEditor)this.editor).setEditorFont(this.prismEditorFontFast);
        }
        this.prismEditorColourFast = prismSettings.getFontColorPair((String)"model.prismEditor.font").c;
        this.prismEditorBGColourFast = prismSettings.getColor("model.prismEditor.bgColour");
        if (this.editor instanceof GUITextModelEditor) {
            ((GUITextModelEditor)this.editor).setEditorBackground(this.prismEditorBGColourFast);
        }
        switch (prismSettings.getInteger("model.prismEditor.numericStyle")) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 3;
            }
        }
        this.prismEditorNumericFast = new Style(prismSettings.getColor("model.prismEditor.numericColour"), n);
        switch (prismSettings.getInteger("model.prismEditor.identifierStyle")) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 3;
            }
        }
        this.prismEditorVariableFast = new Style(prismSettings.getColor("model.prismEditor.identifierColour"), n);
        switch (prismSettings.getInteger("model.prismEditor.keywordStyle")) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 3;
            }
        }
        this.prismEditorKeywordFast = new Style(prismSettings.getColor("model.prismEditor.keywordColour"), n);
        switch (prismSettings.getInteger("model.prismEditor.commentStyle")) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 3;
            }
        }
        this.prismEditorCommentFast = new Style(prismSettings.getColor("model.prismEditor.commentColour"), n);
        this.pepaEditorFontFast = prismSettings.getFontColorPair((String)"model.pepaEditor.font").f;
        if (this.editor instanceof GUIPepaModelEditor) {
            ((GUIPepaModelEditor)this.editor).setEditorFont(this.pepaEditorFontFast);
        }
        this.pepaEditorColourFast = prismSettings.getColor("model.pepaEditor.commentColour");
        this.pepaEditorBGColourFast = prismSettings.getColor("model.pepaEditor.bgColour");
        if (this.editor instanceof GUIPepaModelEditor) {
            ((GUIPepaModelEditor)this.editor).setEditorBackground(this.pepaEditorBGColourFast);
        }
        this.pepaEditorCommentFast = new Style(prismSettings.getColor("model.pepaEditor.commentColour"), prismSettings.getInteger("model.pepaEditor.commentStyle"));
    }

    public Font getPrismEditorFontFast() {
        return this.prismEditorFontFast;
    }

    public Color getPrismEditorColourFast() {
        return this.prismEditorColourFast;
    }

    public Color getPrismEditorBGColourFast() {
        return this.prismEditorBGColourFast;
    }

    public Font getPepaEditorFontFast() {
        return this.pepaEditorFontFast;
    }

    public Color getPepaEditorColourFast() {
        return this.pepaEditorColourFast;
    }

    public Color getPepaEditorBGColourFast() {
        return this.pepaEditorBGColourFast;
    }

    public Style getPrismEditorNumericFast() {
        return this.prismEditorNumericFast;
    }

    public Style getPrismEditorVariableFast() {
        return this.prismEditorVariableFast;
    }

    public Style getPrismEditorKeywordFast() {
        return this.prismEditorKeywordFast;
    }

    public Style getPrismEditorCommentFast() {
        return this.prismEditorCommentFast;
    }

    public Style getPepaEditorCommentFast() {
        return this.pepaEditorCommentFast;
    }

    public GUIUndoManager getUndoManager() {
        return this.editor.getUndoManager();
    }

    public boolean canDoClipBoardAction(Action action) {
        return this.editor.canDoClipBoardAction(action);
    }

    public void jumpToError() {
        if (this.editor != null && this.editor instanceof GUITextModelEditor) {
            ((GUITextModelEditor)this.editor).jumpToError();
        }
    }

    class WaitParseThread
    extends Thread {
        int time;
        GUIMultiModelHandler handler;
        ParseModelThread parseThread;

        public WaitParseThread(int n, GUIMultiModelHandler gUIMultiModelHandler2) {
            this.time = n;
            this.handler = gUIMultiModelHandler2;
        }

        @Override
        public void run() {
            try {
                WaitParseThread.sleep(this.time);
                this.parseThread = new ParseModelThread(this.handler, GUIMultiModelHandler.this.editor.getParseText(), GUIMultiModelHandler.this.currentMode == 2, GUIMultiModelHandler.this.isAutoParse());
                GUIMultiModelHandler.this.parsing = true;
                GUIMultiModelHandler.this.tree.startParsing();
                this.parseThread.start();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

