/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class PrismLogarithmicAxis
extends ValueAxis {
    private double base = 10.0;
    private double baseLog = Math.log(10.0);
    private double smallestValue = 1.0E-100;
    private NumberTickUnit tickUnit;
    private NumberFormat numberFormatOverride;
    private boolean baseAndExponentFormatOverride;
    private int minorTickCount;

    public PrismLogarithmicAxis() {
        this(null);
    }

    public PrismLogarithmicAxis(String string) {
        super(string, NumberAxis.createIntegerTickUnits());
        this.setDefaultAutoRange(new Range(0.01, 1.0));
        this.tickUnit = new NumberTickUnit(1.0);
        this.minorTickCount = 10;
        this.setTickMarksVisible(false);
        this.baseAndExponentFormatOverride = true;
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double d) {
        if (d <= 1.0) {
            throw new IllegalArgumentException("Requires 'base' > 1.0.");
        }
        this.base = d;
        this.baseLog = Math.log(d);
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public boolean isBaseAndExponentFormatOverride() {
        return this.baseAndExponentFormatOverride;
    }

    public void setBaseAndExponentFormatOverride(boolean bl) {
        this.baseAndExponentFormatOverride = bl;
    }

    public double getSmallestValue() {
        return this.smallestValue;
    }

    public void setSmallestValue(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Requires 'value' > 0.0.");
        }
        this.smallestValue = d;
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.setTickUnit(numberTickUnit, true, true);
    }

    public void setTickUnit(NumberTickUnit numberTickUnit, boolean bl, boolean bl2) {
        if (numberTickUnit == null) {
            throw new IllegalArgumentException("Null 'unit' argument.");
        }
        this.tickUnit = numberTickUnit;
        if (bl2) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl) {
            this.notifyListeners(new AxisChangeEvent((Axis)this));
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat numberFormat) {
        this.numberFormatOverride = numberFormat;
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }

    public void setMinorTickCount(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Requires 'count' > 0.");
        }
        this.minorTickCount = n;
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public double calculateLog(double d) {
        return Math.log(d) / this.baseLog;
    }

    public double calculateValue(double d) {
        return Math.pow(this.base, d);
    }

    public double java2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.calculateLog(range.getLowerBound());
        double d3 = this.calculateLog(range.getUpperBound());
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getY();
        }
        double d6 = 0.0;
        d6 = this.isInverted() ? d3 - (d - d4) / (d5 - d4) * (d3 - d2) : d2 + (d - d4) / (d5 - d4) * (d3 - d2);
        return this.calculateValue(d6);
    }

    public double valueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.calculateLog(range.getLowerBound());
        double d3 = this.calculateLog(range.getUpperBound());
        d = this.calculateLog(d);
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d5 = rectangle2D.getMinY();
            d4 = rectangle2D.getMaxY();
        }
        if (this.isInverted()) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)plot;
            Range range = valueAxisPlot.getDataRange((ValueAxis)this);
            if (range == null) {
                range = this.getDefaultAutoRange();
            }
            double d = range.getUpperBound();
            double d2 = range.getLowerBound();
            double d3 = d - d2;
            double d4 = this.getFixedAutoRange();
            if (d4 > 0.0) {
                d2 = Math.max(d - d4, this.smallestValue);
            } else {
                double d5 = this.getAutoRangeMinimumSize();
                if (d3 < d5) {
                    double d6 = (d5 - d3) / 2.0;
                    d += d6;
                    d2 -= d6;
                }
            }
            this.setRange(new Range(d2, d), false, false);
        }
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState = null;
        if (!this.isVisible()) {
            axisState = new AxisState(d);
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            return axisState;
        }
        axisState = this.drawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        List list = new ArrayList();
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, rectangle2D, rectangleEdge);
        }
        return list;
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        double d = Math.floor(this.calculateLog(this.getLowerBound()));
        double d2 = Math.ceil(this.calculateLog(this.getUpperBound()));
        for (double d3 = d; d3 <= d2; d3 += this.tickUnit.getSize()) {
            double d4 = this.calculateValue(d3);
            if (range.contains(d4)) {
                arrayList.add(new NumberTick((Number)d4, this.createTickLabel(d4), TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
            }
            double d5 = Math.pow(this.base, d3 + this.tickUnit.getSize());
            for (int i = 1; i < this.minorTickCount; ++i) {
                double d6 = d4 + (double)i * ((d5 - d4) / (double)this.minorTickCount);
                if (!range.contains(d6)) continue;
                arrayList.add(new NumberTick((Number)d6, "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
            }
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        double d = Math.floor(this.calculateLog(this.getLowerBound()));
        double d2 = Math.ceil(this.calculateLog(this.getUpperBound()));
        for (double d3 = d; d3 <= d2; d3 += this.tickUnit.getSize()) {
            double d4 = this.calculateValue(d3);
            if (range.contains(d4)) {
                arrayList.add(new NumberTick((Number)d4, this.createTickLabel(d4), TextAnchor.CENTER_RIGHT, TextAnchor.CENTER, 0.0));
            }
            double d5 = Math.pow(this.base, d3 + this.tickUnit.getSize());
            for (int i = 1; i < this.minorTickCount; ++i) {
                double d6 = d4 + (double)i * ((d5 - d4) / (double)this.minorTickCount);
                if (!range.contains(d6)) continue;
                arrayList.add(new NumberTick((Number)d6, "", TextAnchor.CENTER_RIGHT, TextAnchor.CENTER, 0.0));
            }
        }
        return arrayList;
    }

    private String createTickLabel(double d) {
        if (this.baseAndExponentFormatOverride) {
            if ((double)Math.round(this.base) == this.base) {
                return Math.round(this.base) + "^" + Math.round(this.calculateLog(d));
            }
            return this.base + "^" + Math.round(this.calculateLog(d));
        }
        if (this.numberFormatOverride != null) {
            return this.numberFormatOverride.format(d);
        }
        return this.tickUnit.valueToString(d);
    }
}

