/*
 * Decompiled with CFR 0.152.
 */
package symbolic.comp;

import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.SanityJDD;
import prism.PrismComponent;
import prism.PrismException;
import symbolic.comp.ECComputerDefault;
import symbolic.model.NondetModel;

public abstract class ECComputer
extends PrismComponent {
    protected double sumRoundOff;
    protected JDDNode trans;
    protected JDDNode trans01;
    protected JDDNode reach;
    protected JDDVars allDDRowVars;
    protected JDDVars allDDColVars;
    protected JDDVars allDDNondetVars;
    protected List<JDDNode> mecs;

    public static ECComputer createECComputer(PrismComponent prismComponent, NondetModel nondetModel) throws PrismException {
        return ECComputer.createECComputer(prismComponent, nondetModel.getReach(), nondetModel.getTrans(), nondetModel.getTrans01(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars());
    }

    public static ECComputer createECComputer(PrismComponent prismComponent, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3) throws PrismException {
        return new ECComputerDefault(prismComponent, jDDNode, jDDNode2, jDDNode3, jDDVars, jDDVars2, jDDVars3);
    }

    public ECComputer(PrismComponent prismComponent, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3) throws PrismException {
        super(prismComponent);
        this.reach = jDDNode;
        this.trans = jDDNode2;
        this.trans01 = jDDNode3;
        this.allDDRowVars = jDDVars;
        this.allDDColVars = jDDVars2;
        this.allDDNondetVars = jDDVars3;
        this.sumRoundOff = this.settings.getDouble("prism.sumRoundOff");
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode2, jDDVars, jDDVars2, jDDVars3);
            SanityJDD.checkIsDDOverVars(jDDNode3, jDDVars, jDDVars2, jDDVars3);
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars);
        }
    }

    public abstract void computeMECStates() throws PrismException;

    public abstract void computeMECStates(JDDNode var1) throws PrismException;

    public abstract void computeMECStates(JDDNode var1, JDDNode var2) throws PrismException;

    public List<JDDNode> getMECStates() {
        return this.mecs;
    }

    public JDDNode findMaximalStableSet(JDDNode jDDNode) {
        JDDNode jDDNode2 = jDDNode;
        JDDNode jDDNode3 = JDD.Constant(0.0);
        while (!jDDNode2.equals(jDDNode3)) {
            JDD.Deref(jDDNode3);
            JDD.Ref(jDDNode2);
            jDDNode3 = jDDNode2;
            JDD.Ref(this.trans01);
            JDD.Ref(jDDNode2);
            JDDNode jDDNode4 = JDD.Apply(3, this.trans01, jDDNode2);
            jDDNode2 = JDD.PermuteVariables(jDDNode2, this.allDDRowVars, this.allDDColVars);
            JDD.Ref(jDDNode4);
            JDDNode jDDNode5 = JDD.Apply(3, jDDNode4, jDDNode2);
            JDD.Ref(jDDNode5);
            jDDNode4 = JDD.And(jDDNode4, JDD.Not(jDDNode5));
            jDDNode4 = JDD.ThereExists(jDDNode4, this.allDDColVars);
            jDDNode5 = JDD.ThereExists(jDDNode5, this.allDDColVars);
            jDDNode5 = JDD.And(jDDNode5, JDD.Not(jDDNode4));
            jDDNode2 = JDD.ThereExists(jDDNode5, this.allDDNondetVars);
        }
        JDD.Deref(jDDNode3);
        return jDDNode2;
    }

    public JDDNode getStableTransReln(JDDNode jDDNode) {
        return JDD.ThereExists(this.getStableTransitions(jDDNode), this.allDDNondetVars);
    }

    public JDDNode getStableTransitions(JDDNode jDDNode) {
        JDDNode jDDNode2 = JDD.And(jDDNode.copy(), this.trans01.copy());
        JDDNode jDDNode3 = JDD.And(jDDNode2.copy(), JDD.PermuteVariables(jDDNode.copy(), this.allDDRowVars, this.allDDColVars));
        JDDNode jDDNode4 = JDD.ThereExists(jDDNode3, this.allDDColVars);
        JDDNode jDDNode5 = JDD.And(jDDNode2, jDDNode4);
        JDDNode jDDNode6 = JDD.And(jDDNode5.copy(), JDD.Not(JDD.PermuteVariables(jDDNode.copy(), this.allDDRowVars, this.allDDColVars)));
        JDDNode jDDNode7 = JDD.ThereExists(jDDNode6, this.allDDColVars);
        JDDNode jDDNode8 = JDD.And(jDDNode5, JDD.Not(jDDNode7));
        JDD.Deref(jDDNode);
        return jDDNode8;
    }
}

