/*
 * Decompiled with CFR 0.152.
 */
package strat;

import explicit.Distribution;
import explicit.PPLSupport;
import explicit.Pareto;
import explicit.SMG;
import explicit.rewards.Rewards;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.optim.MaxIter;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.linear.UnboundedSolutionException;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import parma_polyhedra_library.Generator_System;
import parma_polyhedra_library.Generator_Type;
import parma_polyhedra_library.Linear_Expression;
import parma_polyhedra_library.Variable;
import prism.Model;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import strat.InvalidStrategyStateException;
import strat.StrategyExplicit;
import strat.StrategyExportOptions;
import strat.StrategyInfo;

public class StochasticUpdateStrategy
extends StrategyExplicit<Double> {
    private boolean log_problem = false;
    private boolean logStrategy = false;
    private PrismLog mainLog = null;
    protected String info = "No information available.";
    protected int initial_state;
    protected int lastState;
    protected int lastCorner;
    protected Distribution<Double> alpha;
    protected Map<Integer, Map<Integer, Distribution<Double>>>[] pi_t;
    protected Map<Integer, Map<Integer, Map<Integer, Distribution<Double>>>>[] pi_u;
    protected Map<Integer, Distribution<Double>>[] pi_n;
    protected int memorySize = -1;
    protected double varepsilon;
    private static Comparator<double[]> COMPARATOR = new Comparator<double[]>(){

        @Override
        public int compare(double[] dArray, double[] dArray2) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * dArray[i];
                d2 += dArray2[i] * dArray2[i];
            }
            return Double.compare(d2, d);
        }
    };

    @Override
    public StrategyInfo.Memory memory() {
        return StrategyInfo.Memory.FINITE;
    }

    @Override
    public Object getChoiceAction(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getChoiceIndex(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMemorySize() {
        return this.memorySize;
    }

    @Override
    public int getInitialMemory(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUpdatedMemory(int n, Object object, int n2) {
        throw new UnsupportedOperationException();
    }

    public void init(int n) throws InvalidStrategyStateException {
        if (n != this.initial_state) {
            throw new InvalidStrategyStateException(String.format("Strategy tailored to initial state %d, but asked to start from %d", this.initial_state, n));
        }
        this.lastState = this.initial_state;
        try {
            this.lastCorner = this.alpha.sampleFromDistribution();
        }
        catch (PrismException prismException) {
            throw new InvalidStrategyStateException("Initial distribution invalid. Recompute.");
        }
    }

    public Distribution<Double> getNextMove(int n) throws InvalidStrategyStateException {
        if (this.log_problem) {
            System.out.printf("getting next move: %d (last_state=%d, last_corner=%d)\n", n, this.lastState, this.lastCorner);
            System.out.printf("pi_n[state]: %s\n", this.pi_n[n].toString());
        }
        if (n != this.lastState) {
            throw new InvalidStrategyStateException(String.format("Strategy thinks game is at %d, but you ask to proceed from %d", this.lastState, n));
        }
        if (this.pi_n.length <= n || this.pi_n[n] == null) {
            throw new InvalidStrategyStateException(String.format("No choice for state %i specified", n));
        }
        Distribution distribution = this.pi_n[n].get(this.lastCorner);
        return distribution == null ? new Distribution() : distribution;
    }

    public void updateMemory(int n, int n2) throws InvalidStrategyStateException {
        if (this.log_problem) {
            System.out.printf("update mem: current state: %d, current mem: %d, action: %d, next state: %d\n", this.lastState, this.lastCorner, n, n2);
        }
        try {
            if (this.pi_t.length <= this.lastState || this.pi_t[this.lastState] == null || this.pi_t[this.lastState].get(this.lastCorner) == null || this.pi_t[this.lastState].get(this.lastCorner).get(n) == null) {
                throw new InvalidStrategyStateException("Cannot proceed to states not selected by the strategy. No stochastic memory update present");
            }
            int n3 = this.pi_t[this.lastState].get(this.lastCorner).get(n).sampleFromDistribution();
            if (this.pi_u.length <= this.lastState || this.pi_u[this.lastState] == null || this.pi_u[this.lastState].get(n) == null || this.pi_u[this.lastState].get(n).get(n3) == null || this.pi_u[this.lastState].get(n).get(n3).get(n2) == null) {
                throw new InvalidStrategyStateException("Cannot proceed to states not selected by the strategy. No stochastic memory update present");
            }
            this.lastCorner = this.pi_u[this.lastState].get(n).get(n3).get(n2).sampleFromDistribution();
            this.lastState = n2;
        }
        catch (PrismException prismException) {
            throw new InvalidStrategyStateException("Something went wrong when sampling from the memory distribution");
        }
    }

    public Distribution<Double> memoryUpdate(int n, int n2) throws InvalidStrategyStateException {
        if (this.pi_t.length <= this.lastState || this.pi_t[this.lastState] == null || this.pi_t[this.lastState].get(this.lastCorner) == null || this.pi_t[this.lastState].get(this.lastCorner).get(n) == null) {
            throw new InvalidStrategyStateException("Cannot proceed to states not selected by the strategy. No stochastic memory update present");
        }
        Distribution<Double> distribution = new Distribution<Double>();
        Distribution<Double> distribution2 = this.pi_t[this.lastState].get(this.lastCorner).get(n);
        for (Integer n3 : distribution2.getSupport()) {
            double d = distribution2.get(n3);
            if (this.pi_u.length <= this.lastState || this.pi_u[this.lastState] == null || this.pi_u[this.lastState].get(n) == null || this.pi_u[this.lastState].get(n).get(n3) == null || this.pi_u[this.lastState].get(n).get(n3).get(n2) == null) {
                throw new InvalidStrategyStateException("Cannot proceed to states not selected by the strategy. No stochastic memory update present");
            }
            Distribution<Double> distribution3 = this.pi_u[this.lastState].get(n).get(n3).get(n2);
            if (distribution3 == null) continue;
            for (Integer n4 : distribution3.getSupport()) {
                double d2 = distribution3.get(n4);
                distribution.add(n4, d * d2);
            }
        }
        return distribution;
    }

    public String memoryUpdateString(int n, int n2, int n3, NumberFormat numberFormat) throws InvalidStrategyStateException {
        Distribution<Double> distribution = this.getNextMove(n);
        Distribution<Double> distribution2 = this.memoryUpdate(n2, n3);
        String string = numberFormat.format(distribution.get(n2)) + " mu: {";
        boolean bl = true;
        for (Integer n4 : distribution2.getSupport()) {
            if (bl) {
                bl = false;
            } else {
                string = string + ", ";
            }
            string = string + String.format("(%d, %d)=", n3, n4) + numberFormat.format(distribution2.get(n4));
        }
        string = string + "}";
        return string;
    }

    public void reset() {
        this.lastCorner = -1;
        this.lastState = -1;
    }

    public Distribution<Double> parseDistribution(String string) {
        Distribution<Double> distribution = new Distribution<Double>();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",={}");
        while (stringTokenizer.hasMoreTokens()) {
            distribution.add(Integer.parseInt(stringTokenizer.nextToken().trim()), Double.parseDouble(stringTokenizer.nextToken().trim()));
        }
        return distribution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToFile(String string) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            fileWriter.write(this.toString());
            fileWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object getCurrentMemoryElement() {
        AbstractMap.SimpleEntry<Integer, Integer> simpleEntry = new AbstractMap.SimpleEntry<Integer, Integer>(this.lastState, this.lastCorner);
        return simpleEntry;
    }

    public void setMemory(Object object) throws InvalidStrategyStateException {
        if (!(object instanceof Map.Entry)) {
            throw new InvalidStrategyStateException("Memory has to be integer for this strategy.");
        }
        this.lastState = (Integer)((Map.Entry)object).getKey();
        this.lastCorner = (Integer)((Map.Entry)object).getValue();
    }

    private List<List<double[]>> selectMultiGenerator(List<List<double[]>> list, List<List<double[]>> list2, int n) throws PrismException {
        int n2;
        ArrayList<List<double[]>> arrayList = new ArrayList<List<double[]>>();
        if (list2 == null) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(this.selectGenerator(list.get(i), null, n));
            }
            return arrayList;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            List<double[]> list3 = this.selectGenerator(list.get(n2), list2.get(n2), n);
            if (list3 == null) {
                list3 = this.selectGenerator(list.get(n2), null, n);
                arrayList.add(list3);
                continue;
            }
            arrayList.add(list3);
            for (int i = n2 + 1; i < list.size(); ++i) {
                arrayList.add(list2.get(i));
            }
        }
        if (n2 == list.size()) {
            return null;
        }
        return arrayList;
    }

    private List<double[]> selectGenerator(List<double[]> list, List<double[]> list2, int n) throws PrismException {
        for (int i = n; i >= 1; --i) {
            try {
                List<double[]> list3 = this.selectGeneratorCandidate(list, list2, i);
                if (list3 == null) {
                    return null;
                }
                if (i < n) {
                    for (int j = list3.size(); j < n; ++j) {
                        list3.add(list3.get(0));
                    }
                    return list3;
                }
                return list3;
            }
            catch (PrismException prismException) {
                continue;
            }
        }
        return null;
    }

    private List<double[]> selectGeneratorCandidate(List<double[]> list, List<double[]> list2, int n) throws PrismException {
        int n2;
        int n3;
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        if (list2 == null) {
            if (n <= list.size()) {
                for (int i = 0; i < n; ++i) {
                    arrayList.add(list.get(i));
                }
                return arrayList;
            }
            throw new PrismLangException("Too many generators required");
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n);
        for (n3 = 0; n3 < list.size(); ++n3) {
            if (!list2.contains(list.get(n3))) continue;
            arrayList2.add(n3);
        }
        n3 = -1;
        for (n2 = arrayList2.size() - 1; n2 >= 0; --n2) {
            if ((Integer)arrayList2.get(n2) == list.size() - 1) continue;
            if (n2 == arrayList2.size() - 1) {
                n3 = n2;
                break;
            }
            if ((Integer)arrayList2.get(n2) + 1 >= (Integer)arrayList2.get(n2 + 1)) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            return null;
        }
        arrayList2.set(n3, (Integer)arrayList2.get(n3) + 1);
        n2 = 1;
        for (int i = n3 + 1; i < arrayList2.size(); ++i) {
            arrayList2.set(i, (Integer)arrayList2.get(n3) + n2);
            ++n2;
        }
        for (Integer n4 : arrayList2) {
            arrayList.add(list.get(n4));
        }
        return arrayList;
    }

    private List<double[]> gsToList(Generator_System generator_System, int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<double[]> arrayList = new ArrayList<double[]>(generator_System.size());
        for (Object object5 : generator_System) {
            if (object5.type() != Generator_Type.POINT) continue;
            object4 = new double[n];
            object3 = object5.linear_expression();
            object2 = object5.divisor().getBigInteger();
            object = new HashMap<Variable, BigInteger>();
            PPLSupport.getCoefficientsFromLinearExpression(object3, false, BigInteger.ONE, object);
            for (Variable variable : object.keySet()) {
                if (variable == null) continue;
                BigFraction bigFraction = new BigFraction((BigInteger)object.get(variable), (BigInteger)object2);
                object4[(int)variable.id()] = bigFraction.doubleValue();
            }
            arrayList.add((double[])object4);
        }
        boolean bl = true;
        while (bl) {
            Object object5;
            bl = false;
            object5 = new ArrayList();
            object4 = arrayList.iterator();
            block3: while (object4.hasNext()) {
                object3 = (double[])object4.next();
                object2 = arrayList.iterator();
                block4: while (object2.hasNext()) {
                    object = (double[])object2.next();
                    if (object3 == object) continue;
                    for (int i = 0; i < ((Linear_Expression)object3).length; ++i) {
                        if (object3[i] > object[i]) continue block4;
                    }
                    object5.add(object3);
                    continue block3;
                }
            }
            if (object5.size() <= 0) continue;
            arrayList.removeAll((Collection<?>)object5);
            bl = true;
        }
        Collections.sort(arrayList, COMPARATOR);
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public StochasticUpdateStrategy(SMG<Double> sMG, double[] dArray, Pareto[] paretoArray, List<Pareto>[] listArray, List<Rewards<Double>> list, double[] dArray2, long l, boolean bl, boolean bl2, double d, boolean bl3, PrismLog prismLog) throws PrismException {
        super(sMG);
        int n;
        int n2;
        this.logStrategy = bl3;
        this.mainLog = prismLog;
        if (bl3) {
            prismLog.print("Constructing SU Strategy from the following sets:");
        }
        if (bl3) {
            PPLSupport.printReachabilityPolyhedra(paretoArray, listArray, dArray.length, prismLog);
        }
        int n3 = sMG.getFirstInitialState();
        this.varepsilon = d;
        this.initial_state = n3;
        this.memorySize = 0;
        int n4 = sMG.getNumStates();
        int n5 = list.size();
        long[] lArray = new long[n5];
        if (bl2) {
            for (int i = 0; i < n5; ++i) {
                lArray[i] = Math.max(1L, (long)((double)l / dArray2[i]));
            }
        }
        SimplexSolver simplexSolver = null;
        simplexSolver = bl2 ? new SimplexSolver(1.0 / (double)l) : new SimplexSolver();
        List[] listArray2 = new List[n4];
        BitSet[] bitSetArray = bl ? new BitSet[n4] : null;
        Map[] mapArray = bl ? new Map[n4] : null;
        for (int i = 0; i < n4; ++i) {
            listArray2[i] = this.gsToList(paretoArray[i].get().minimized_generators(), n5);
            if (!bl) continue;
            bitSetArray[i] = new BitSet(listArray2[i].size());
        }
        this.alpha = new Distribution();
        double[] dArray3 = new double[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            dArray3[n2] = bl2 ? Math.floor((dArray[n2] - d) * (double)lArray[n2]) / (double)lArray[n2] : dArray[n2] - d;
        }
        n2 = 1;
        block5: for (n = 1; n < n5 + 1; ++n) {
            void i;
            List<double[]> object;
            Object var26_28 = null;
            double[] dArray4 = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray4[j] = 1.0;
            }
            n2 = 1;
            while ((object = this.selectGenerator(listArray2[n3], (List<double[]>)i, n)) != null) {
                int n6;
                int n7;
                LinearObjectiveFunction linearObjectiveFunction = new LinearObjectiveFunction(dArray4, 0.0);
                ArrayList<LinearConstraint> arrayList = new ArrayList<LinearConstraint>();
                double[][] dArray5 = new double[n5][n];
                for (n7 = 0; n7 < n; ++n7) {
                    for (n6 = 0; n6 < n5; ++n6) {
                        dArray5[n6][n7] = object.get(n7)[n6];
                    }
                }
                for (n7 = 0; n7 < n5; ++n7) {
                    arrayList.add(new LinearConstraint(dArray5[n7], Relationship.GEQ, dArray3[n7]));
                }
                double[][] dArray6 = new double[n][n];
                for (n6 = 0; n6 < n; ++n6) {
                    dArray6[n6][n6] = 1.0;
                    arrayList.add(new LinearConstraint(dArray6[n6], Relationship.GEQ, 0.0));
                }
                arrayList.add(new LinearConstraint(dArray4, Relationship.EQ, 1.0));
                PointValuePair pointValuePair = null;
                try {
                    pointValuePair = simplexSolver.optimize(new OptimizationData[]{linearObjectiveFunction, new LinearConstraintSet(arrayList), GoalType.MAXIMIZE, new MaxIter(10000)});
                }
                catch (NoFeasibleSolutionException noFeasibleSolutionException) {
                    continue;
                }
                n2 = 0;
                for (int j = 0; j < n; ++j) {
                    this.alpha.add(listArray2[n3].indexOf(object.get(j)), pointValuePair.getPoint()[j]);
                }
                break block5;
            }
        }
        if (n2 != 0) {
            throw new PrismLangException("Goal not realizable");
        }
        this.alpha = this.renormDistribution(this.alpha);
        if (bl) {
            for (Integer n8 : this.alpha.getSupport()) {
                bitSetArray[n3].set(n8);
            }
        }
        n = 1;
        this.pi_n = new Map[sMG.getNumStates()];
        this.pi_t = new Map[sMG.getNumStates()];
        this.pi_u = new Map[sMG.getNumStates()];
        while (n != 0) {
            n = 0;
            for (int i = 0; i < sMG.getNumStates(); ++i) {
                if (this.log_problem) {
                    this.printCorners(bitSetArray);
                }
                if (bl && bitSetArray[i].cardinality() == 0) continue;
                if (this.pi_n[i] == null) {
                    this.pi_n[i] = new HashMap<Integer, Distribution<Double>>();
                }
                if (this.pi_t[i] == null) {
                    this.pi_t[i] = new HashMap<Integer, Map<Integer, Distribution<Double>>>();
                }
                if (this.pi_u[i] == null) {
                    this.pi_u[i] = new HashMap<Integer, Map<Integer, Map<Integer, Distribution<Double>>>>();
                }
                if (bl && mapArray[i] == null) {
                    mapArray[i] = new HashMap();
                }
                if (sMG.getPlayer(i) == 1) {
                    n |= this.getP1Choices(sMG, i, listArray, listArray2, bitSetArray, mapArray, list, lArray, simplexSolver, bl, bl2);
                    continue;
                }
                n |= this.getP2Choices(sMG, i, listArray, listArray2, bitSetArray, mapArray, list, lArray, simplexSolver, bl, bl2);
            }
        }
    }

    private void printCorners(BitSet[] bitSetArray) {
        System.out.printf("corners to cover: ", new Object[0]);
        boolean bl = false;
        for (int i = 0; i < bitSetArray.length; ++i) {
            if (bl) {
                System.out.printf(", ", new Object[0]);
                bl = false;
            }
            if (bitSetArray[i].length() <= 0) continue;
            System.out.printf("%d=%s", i, bitSetArray[i]);
            bl = true;
        }
        System.out.printf("\n", new Object[0]);
    }

    private boolean getP1Choices(SMG<Double> sMG, int n, List<Pareto>[] listArray, List<double[]>[] listArray2, BitSet[] bitSetArray, Map<Integer, BitSet>[] mapArray, List<Rewards<Double>> list, long[] lArray, SimplexSolver simplexSolver, boolean bl, boolean bl2) throws PrismException {
        int n2 = list.size();
        int n3 = sMG.getNumChoices(n);
        boolean bl3 = false;
        boolean bl4 = false;
        BitSet bitSet = bl ? new BitSet() : null;
        do {
            bl4 = false;
            block6: for (int i = 0; i < listArray2[n].size(); ++i) {
                int n4;
                if (bl && !bitSetArray[n].get(i) && !bitSet.get(i)) continue;
                if (this.log_problem) {
                    System.out.printf("looking for: t:%d p:%d(%s) ----> \n", n, i, Arrays.toString(listArray2[n].get(i)));
                }
                if (this.logStrategy) {
                    this.mainLog.print(String.format("looking for: t:%d p:%d(%s) ----> \n", n, i, Arrays.toString(listArray2[n].get(i))));
                }
                if (!this.pi_t[n].containsKey(i)) {
                    this.pi_t[n].put(i, new HashMap());
                }
                double[] dArray = new double[n2];
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray[n4] = bl2 ? Math.floor((listArray2[n].get(i)[n4] - list.get(n4).getStateReward(n) - this.varepsilon) * (double)lArray[n4]) / (double)lArray[n4] : listArray2[n].get(i)[n4] - list.get(n4).getStateReward(n) - this.varepsilon;
                }
                n4 = 1;
                for (int j = 1; j < n2 + 1; ++j) {
                    int n5;
                    Object object;
                    Object object2;
                    ArrayList<LinearConstraint> arrayList = new ArrayList<LinearConstraint>();
                    ArrayList<List<double[]>> arrayList2 = new ArrayList<List<double[]>>();
                    int n6 = 0;
                    for (int k = 0; k < n3; ++k) {
                        object2 = this.gsToList(listArray[n].get(k).get().minimized_generators(), n2);
                        ArrayList<double[]> arrayList3 = new ArrayList<double[]>();
                        Iterator iterator = object2.iterator();
                        block10: while (iterator.hasNext()) {
                            object = (double[])iterator.next();
                            for (int i2 = 0; i2 < n2; ++i2) {
                                if (!(object[i2] >= dArray[i2] - PrismUtils.epsilonDouble)) continue;
                                arrayList3.add((double[])object);
                                continue block10;
                            }
                        }
                        if (arrayList3.size() > 0) {
                            ++n6;
                        }
                        arrayList2.add(arrayList3);
                    }
                    List<List<double[]>> list2 = null;
                    object2 = new double[n6 * j];
                    for (n5 = 0; n5 < j; ++n5) {
                        for (int k = 0; k < n6; ++k) {
                            object2[k * j + n5] = 1.0;
                        }
                    }
                    n5 = 0;
                    while ((list2 = this.selectMultiGenerator(arrayList2, list2, j)) != null) {
                        int n7;
                        int n8;
                        int n9;
                        int n10;
                        ++n5;
                        LinearObjectiveFunction linearObjectiveFunction = new LinearObjectiveFunction((double[])object2, 0.0);
                        arrayList.clear();
                        object = new double[n2][n6 * j];
                        for (n10 = 0; n10 < j; ++n10) {
                            for (n9 = 0; n9 < n2; ++n9) {
                                int n11 = 0;
                                for (n8 = 0; n8 < n3; ++n8) {
                                    if (list2.get(n8) == null || list2.get(n8).get(n10) == null) continue;
                                    object[n9][n11 * j + n10] = list2.get(n8).get(n10)[n9];
                                    ++n11;
                                }
                            }
                        }
                        for (n10 = 0; n10 < n2; ++n10) {
                            arrayList.add(new LinearConstraint((double[])object[n10], Relationship.GEQ, dArray[n10]));
                        }
                        double[][] dArray2 = new double[j * n6][j * n6];
                        for (n9 = 0; n9 < j * n6; ++n9) {
                            dArray2[n9][n9] = 1.0;
                            arrayList.add(new LinearConstraint(dArray2[n9], Relationship.GEQ, 0.0));
                        }
                        arrayList.add(new LinearConstraint((double[])object2, Relationship.EQ, 1.0));
                        PointValuePair pointValuePair = null;
                        try {
                            if (this.log_problem) {
                                this.mainLog.print(String.format("----\ngoal: %s\n\nbounds: %s\n\ncoeffs: %s\n\ncoeffs_indiv: %s\n\nonlyone: %s\n----\n", Arrays.toString((double[])object2), Arrays.toString(dArray), Arrays.deepToString(object), "", Arrays.deepToString((Object[])dArray2)));
                            }
                            pointValuePair = simplexSolver.optimize(new OptimizationData[]{linearObjectiveFunction, new LinearConstraintSet(arrayList), GoalType.MAXIMIZE, new MaxIter(10000)});
                        }
                        catch (NoFeasibleSolutionException noFeasibleSolutionException) {
                            continue;
                        }
                        catch (UnboundedSolutionException unboundedSolutionException) {
                            throw unboundedSolutionException;
                        }
                        n4 = 0;
                        if (bl) {
                            bitSetArray[n].clear(i);
                        }
                        double[] dArray3 = new double[j * n3];
                        for (n8 = 0; n8 < j; ++n8) {
                            n7 = 0;
                            for (int k = 0; k < n3; ++k) {
                                if (list2.get(k) == null || list2.get(k).get(n8) == null) continue;
                                dArray3[j * k + n8] = pointValuePair.getPoint()[j * n7 + n8];
                                ++n7;
                            }
                        }
                        Distribution<Double> distribution = new Distribution<Double>();
                        for (n7 = 0; n7 < n3; ++n7) {
                            double d = 0.0;
                            for (int k = 0; k < j; ++k) {
                                d += dArray3[j * n7 + k];
                            }
                            if (PrismUtils.doublesAreEqual(d, 0.0)) continue;
                            distribution.add(n7, d);
                            Distribution<Double> distribution2 = new Distribution<Double>();
                            for (int k = 0; k < j; ++k) {
                                Integer n12 = ((List)arrayList2.get(n7)).indexOf(list2.get(n7).get(k));
                                double d2 = dArray3[j * n7 + k] / d;
                                d2 = d2 > 1.0 ? 1.0 : d2;
                                d2 = d2 < 0.0 ? 0.0 : d2;
                                distribution2.add(n12, d2);
                            }
                            this.pi_t[n].get(i).put(n7, this.renormDistribution(distribution2));
                            this.memorySize += distribution2.size();
                            if (this.log_problem) {
                                System.out.printf("pi_t(%d)\tt:%d, p:%d --u:%d--> %s \n", sMG.getPlayer(n), n, i, n7, distribution2.toString());
                            }
                            if (this.logStrategy) {
                                this.mainLog.print(String.format("pi_t(%d)\tt:%d, p:%d --u:%d--> %s \n", sMG.getPlayer(n), n, i, n7, distribution2.toString()));
                            }
                            List<double[]> list3 = this.gsToList(listArray[n].get(n7).get().minimized_generators(), n2);
                            if (bl) {
                                if (mapArray[n].get(n7) == null) {
                                    mapArray[n].put(n7, new BitSet(list3.size()));
                                }
                                for (Integer n13 : distribution2.getSupport()) {
                                    if (this.pi_u[n] != null && this.pi_u[n].get(n7) != null && this.pi_u[n].get(n7).get(n13) != null) continue;
                                    mapArray[n].get(n7).set(n13);
                                    bl3 = true;
                                }
                            }
                            if (this.pi_u[n].get(n7) == null) {
                                this.pi_u[n].put(n7, new HashMap());
                            }
                            int n14 = sMG.getNumTransitions(n, n7);
                            if (bl && mapArray[n].get(n7).cardinality() == 0) continue;
                            for (int k = 0; k < list3.size(); ++k) {
                                int n15;
                                if (bl && !mapArray[n].get(n7).get(k)) continue;
                                if (bl) {
                                    mapArray[n].get(n7).clear(k);
                                }
                                if (this.pi_u[n].get(n7).get(k) == null) {
                                    this.pi_u[n].get(n7).put(k, new HashMap());
                                }
                                Distribution<Double>[] distributionArray = null;
                                for (n15 = 1; n15 < n2 + 1; ++n15) {
                                    try {
                                        distributionArray = this.getActions(sMG, n14, n7, n, k, n15, list, lArray, simplexSolver, list3, listArray2, bl2);
                                        break;
                                    }
                                    catch (PrismException prismException) {
                                        continue;
                                    }
                                }
                                if (distributionArray != null) {
                                    Iterator iterator = sMG.getTransitionsIterator(n, n7);
                                    for (n15 = 0; n15 < n14; ++n15) {
                                        Map.Entry entry = iterator.next();
                                        int n16 = entry.getKey();
                                        double d3 = (Double)entry.getValue();
                                        Distribution<Double> distribution3 = this.renormDistribution(distributionArray[n15]);
                                        this.pi_u[n].get(n7).get(k).put(n16, distribution3);
                                        this.memorySize += distributionArray[n15].size();
                                        if (this.log_problem) {
                                            System.out.printf("pi_u(%d)\tt:%d, u:%d, q:%d --w:%d--> %s \n", sMG.getPlayer(n), n, n7, k, n16, distributionArray[n15].toString());
                                        }
                                        if (this.logStrategy) {
                                            this.mainLog.print(String.format("pi_u(%d)\tt:%d, u:%d, q:%d --w:%d--> %s \n", sMG.getPlayer(n), n, n7, k, n16, distributionArray[n15].toString()));
                                        }
                                        if (!bl) continue;
                                        for (Integer n17 : distribution3.getSupport()) {
                                            if (this.pi_t[n16] != null && this.pi_t[n16].get(n17) != null) continue;
                                            if (n16 == n) {
                                                if (this.log_problem) {
                                                    System.out.printf("selfloop: key_w=%d, r=%d\n", n16, n17);
                                                }
                                                bitSet.set(n17);
                                                bl4 = true;
                                                continue;
                                            }
                                            if (this.log_problem) {
                                                System.out.printf("explore: key_w=%d, r=%d\n", n16, n17);
                                            }
                                            bitSetArray[n16].set(n17);
                                            bl3 = true;
                                        }
                                    }
                                    continue;
                                }
                                if (this.log_problem) {
                                    System.out.printf("PROBLEM(P1):t:%d, u:%d, q:%d --w:?--> ? \n", n, n7, k);
                                }
                                if (this.logStrategy) {
                                    this.mainLog.print(String.format("PROBLEM(P1):t:%d, u:%d, q:%d --w:?--> ? \n", n, n7, k));
                                }
                                throw new PrismLangException("No distributions for move found");
                            }
                        }
                        this.pi_n[n].put(i, this.renormDistribution(distribution));
                        continue block6;
                    }
                }
                if (n4 == 0) continue;
                throw new PrismLangException("No distribution found for corner");
            }
        } while (bl4);
        if (this.log_problem) {
            System.out.printf("resetting c_X[%d]\n", n);
        }
        if (bl) {
            bitSetArray[n].clear();
        }
        return bl3;
    }

    private boolean getP2Choices(SMG<Double> sMG, int n, List<Pareto>[] listArray, List<double[]>[] listArray2, BitSet[] bitSetArray, Map<Integer, BitSet>[] mapArray, List<Rewards<Double>> list, long[] lArray, SimplexSolver simplexSolver, boolean bl, boolean bl2) throws PrismException {
        int n2 = list.size();
        boolean bl3 = false;
        boolean bl4 = false;
        BitSet bitSet = bl ? new BitSet() : null;
        do {
            bl4 = false;
            for (int i = 0; i < sMG.getNumChoices(n); ++i) {
                Object object;
                int n3;
                Object object2;
                int n4;
                if (this.pi_u[n].get(i) == null) {
                    this.pi_u[n].put(i, new HashMap());
                }
                if (this.log_problem) {
                    System.out.printf("looking for: t:%d --u:%d--> \n", n, i);
                }
                if (this.logStrategy) {
                    this.mainLog.print(String.format("looking for: t:%d --u:%d--> \n", n, i));
                }
                List<double[]> list2 = this.gsToList(listArray[n].get(i).get().minimized_generators(), n2);
                if (bl && mapArray[n].get(i) == null) {
                    mapArray[n].put(i, new BitSet(list2.size()));
                }
                int n5 = sMG.getNumTransitions(n, i);
                block7: for (n4 = 0; n4 < listArray2[n].size(); ++n4) {
                    int n6;
                    if (bl && !bitSetArray[n].get(n4) && !bitSet.get(n4)) continue;
                    if (this.log_problem) {
                        System.out.printf("looking for: t:%d p:%d(%s) --u:%d--> \n", n, n4, Arrays.toString(listArray2[n].get(n4)), i);
                    }
                    if (this.logStrategy) {
                        this.mainLog.print(String.format("looking for: t:%d p:%d(%s) --u:%d--> \n", n, n4, Arrays.toString(listArray2[n].get(n4)), i));
                    }
                    if (!this.pi_t[n].containsKey(n4)) {
                        this.pi_t[n].put(n4, new HashMap());
                    }
                    double[] dArray = new double[n2];
                    for (n6 = 0; n6 < n2; ++n6) {
                        dArray[n6] = bl2 ? Math.floor((listArray2[n].get(n4)[n6] - list.get(n6).getStateReward(n) - this.varepsilon) * (double)lArray[n6]) / (double)lArray[n6] : listArray2[n].get(n4)[n6] - list.get(n6).getStateReward(n) - this.varepsilon;
                    }
                    for (n6 = 1; n6 < n2 + 1; ++n6) {
                        List<double[]> list3 = null;
                        object2 = new double[n6];
                        for (n3 = 0; n3 < n6; ++n3) {
                            object2[n3] = 1.0;
                        }
                        while ((list3 = this.selectGenerator(list2, list3, n6)) != null) {
                            int n7;
                            int n8;
                            LinearObjectiveFunction linearObjectiveFunction = new LinearObjectiveFunction((double[])object2, 0.0);
                            ArrayList<LinearConstraint> arrayList = new ArrayList<LinearConstraint>();
                            double[][] dArray2 = new double[n2][n6];
                            for (n8 = 0; n8 < n6; ++n8) {
                                for (n7 = 0; n7 < n2; ++n7) {
                                    dArray2[n7][n8] = list3.get(n8)[n7];
                                }
                            }
                            for (n8 = 0; n8 < n2; ++n8) {
                                arrayList.add(new LinearConstraint(dArray2[n8], Relationship.GEQ, dArray[n8]));
                            }
                            object = new double[n6][n6];
                            for (n7 = 0; n7 < n6; ++n7) {
                                object[n7][n7] = 1.0;
                                arrayList.add(new LinearConstraint((double[])object[n7], Relationship.GEQ, 0.0));
                            }
                            arrayList.add(new LinearConstraint((double[])object2, Relationship.EQ, 1.0));
                            PointValuePair pointValuePair = null;
                            try {
                                if (this.log_problem) {
                                    this.mainLog.print(String.format("----\ngoal: %s\n\nbounds: %s\n\ncoeffs: %s\n\ncoeffs_indiv: %s\n\nonlyone: %s\n----\n", Arrays.toString((double[])object2), Arrays.toString(dArray), Arrays.deepToString((Object[])dArray2), "", Arrays.deepToString((Object[])object)));
                                }
                                pointValuePair = simplexSolver.optimize(new OptimizationData[]{linearObjectiveFunction, new LinearConstraintSet(arrayList), GoalType.MAXIMIZE, new MaxIter(10000)});
                            }
                            catch (NoFeasibleSolutionException noFeasibleSolutionException) {
                                continue;
                            }
                            catch (Exception exception) {
                                throw new PrismLangException(exception.toString());
                            }
                            Distribution<Double> distribution = new Distribution<Double>();
                            for (int j = 0; j < n6; ++j) {
                                Integer n9 = list2.indexOf(list3.get(j));
                                double d = pointValuePair.getPoint()[j];
                                d = d > 1.0 ? 1.0 : d;
                                d = d < 0.0 ? 0.0 : d;
                                distribution.add(n9, d);
                            }
                            this.pi_t[n].get(n4).put(i, this.renormDistribution(distribution));
                            this.memorySize += distribution.size();
                            if (this.log_problem) {
                                System.out.printf("pi_t(%d)\tt:%d, p:%d --u:%d--> %s \n", sMG.getPlayer(n), n, n4, i, distribution.toString());
                            }
                            if (this.logStrategy) {
                                this.mainLog.print(String.format("pi_t(%d)\tt:%d, p:%d --u:%d--> %s \n", sMG.getPlayer(n), n, n4, i, distribution.toString()));
                            }
                            if (!bl) continue block7;
                            for (Integer n9 : distribution.getSupport()) {
                                if (this.pi_u[n] != null && this.pi_u[n].get(i) != null && this.pi_u[n].get(i).get(n9) != null) continue;
                                mapArray[n].get(i).set(n9);
                                bl3 = true;
                            }
                            continue block7;
                        }
                    }
                }
                if (bl && mapArray[n].get(i).cardinality() == 0) continue;
                for (n4 = 0; n4 < list2.size(); ++n4) {
                    int n10;
                    if (bl && !mapArray[n].get(i).get(n4)) continue;
                    if (bl) {
                        mapArray[n].get(i).clear(n4);
                    }
                    if (this.pi_u[n].get(i).get(n4) == null) {
                        this.pi_u[n].get(i).put(n4, new HashMap());
                    }
                    Distribution<Double>[] distributionArray = null;
                    for (n10 = 1; n10 < n2 + 1; ++n10) {
                        try {
                            distributionArray = this.getActions(sMG, n5, i, n, n4, n10, list, lArray, simplexSolver, list2, listArray2, bl2);
                            break;
                        }
                        catch (PrismException prismException) {
                            if (!this.log_problem) continue;
                            System.out.printf("Nothing found for ll=%d\n", n10);
                            continue;
                        }
                    }
                    if (distributionArray != null) {
                        Iterator iterator = sMG.getTransitionsIterator(n, i);
                        for (n10 = 0; n10 < n5; ++n10) {
                            object2 = iterator.next();
                            n3 = (Integer)object2.getKey();
                            double d = (Double)object2.getValue();
                            object = this.renormDistribution(distributionArray[n10]);
                            this.pi_u[n].get(i).get(n4).put(n3, (Distribution<Double>)object);
                            this.memorySize += distributionArray[n10].size();
                            if (this.log_problem) {
                                System.out.printf("pi_u(%d)\tt:%d, u:%d, q:%d --w:%d--> %s \n", sMG.getPlayer(n), n, i, n4, n3, distributionArray[n10].toString());
                            }
                            if (this.logStrategy) {
                                this.mainLog.print(String.format("pi_u(%d)\tt:%d, u:%d, q:%d --w:%d--> %s \n", sMG.getPlayer(n), n, i, n4, n3, distributionArray[n10].toString()));
                            }
                            if (!bl) continue;
                            for (Integer n11 : ((Distribution)object).getSupport()) {
                                if (this.pi_t[n3] != null && this.pi_t[n3].get(n11) != null) continue;
                                if (n3 == n) {
                                    if (this.log_problem) {
                                        System.out.printf("selfloop: key_w=%d, r=%d\n", n3, n11);
                                    }
                                    bl4 = true;
                                    bitSet.set(n11);
                                    continue;
                                }
                                if (this.log_problem) {
                                    System.out.printf("explore: key_w=%d, r=%d\n", n3, n11);
                                }
                                bitSetArray[n3].set(n11);
                                bl3 = true;
                            }
                        }
                        continue;
                    }
                    if (this.log_problem) {
                        System.out.printf("PROBLEM(P2):t:%d, u:%d, q:%d --w:?--> ? \n", n, i, n4);
                    }
                    if (this.logStrategy) {
                        this.mainLog.print(String.format("PROBLEM(P2):t:%d, u:%d, q:%d --w:?--> ? \n", n, i, n4));
                    }
                    throw new PrismLangException("No distributions for move found");
                }
            }
        } while (bl4);
        if (this.log_problem) {
            System.out.printf("resetting c_X[%d]\n", n);
        }
        if (bl) {
            bitSetArray[n].clear();
        }
        return bl3;
    }

    private Distribution<Double>[] getActions(SMG<Double> sMG, int n, int n2, int n3, int n4, int n5, List<Rewards<Double>> list, long[] lArray, SimplexSolver simplexSolver, List<double[]> list2, List<double[]>[] listArray, boolean bl) throws PrismException {
        int n6;
        Distribution[] distributionArray = new Distribution[n];
        int n7 = list.size();
        double[] dArray = new double[n7];
        for (int i = 0; i < n7; ++i) {
            dArray[i] = bl ? Math.floor((list2.get(n4)[i] - list.get(i).getTransitionReward(n3, n2) - this.varepsilon) * (double)lArray[i]) / (double)lArray[i] : list2.get(n4)[i] - list.get(i).getTransitionReward(n3, n2) - this.varepsilon;
        }
        double[] dArray2 = new double[n * n5];
        double[][] dArray3 = new double[n][n5 * n];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[j][j * n5 + i] = 1.0;
                dArray2[j * n5 + i] = 1.0;
            }
        }
        ArrayList<LinearConstraint> arrayList = new ArrayList<LinearConstraint>();
        ArrayList<List<double[]>> arrayList2 = new ArrayList<List<double[]>>();
        Iterator iterator = sMG.getTransitionsIterator(n3, n2);
        for (int i = 0; i < n; ++i) {
            n6 = iterator.next().getKey();
            arrayList2.add(listArray[n6]);
        }
        List<List<double[]>> list3 = null;
        n6 = 0;
        boolean bl2 = true;
        while ((list3 = this.selectMultiGenerator(arrayList2, list3, n5)) != null) {
            int n8;
            int n9;
            int n10;
            int n11;
            LinearObjectiveFunction linearObjectiveFunction = new LinearObjectiveFunction(dArray2, 0.0);
            arrayList.clear();
            double[][] dArray4 = new double[n7][n * n5];
            iterator = sMG.getTransitionsIterator(n3, n2);
            for (n11 = 0; n11 < n; ++n11) {
                double d = (Double)iterator.next().getValue();
                for (n10 = 0; n10 < n5; ++n10) {
                    for (n9 = 0; n9 < n7; ++n9) {
                        dArray4[n9][n11 * n5 + n10] = d * list3.get(n11).get(n10)[n9];
                    }
                }
            }
            for (n11 = 0; n11 < n7; ++n11) {
                arrayList.add(new LinearConstraint(dArray4[n11], Relationship.GEQ, dArray[n11]));
            }
            double[][] dArray5 = new double[n5 * n][n5 * n];
            for (n8 = 0; n8 < n5 * n; ++n8) {
                dArray5[n8][n8] = 1.0;
                arrayList.add(new LinearConstraint(dArray5[n8], Relationship.GEQ, 0.0));
            }
            for (n8 = 0; n8 < n; ++n8) {
                arrayList.add(new LinearConstraint(dArray3[n8], Relationship.EQ, 1.0));
            }
            PointValuePair pointValuePair = null;
            try {
                if (this.log_problem) {
                    System.out.printf("----\ngoal: %s\n\nbounds: %s\n\ncoeffs: %s\n\ncoeffs_indiv: %s\n\nonlyone: %s\n\nsolution: %s\n----\n", Arrays.toString(dArray2), Arrays.toString(dArray), Arrays.deepToString((Object[])dArray4), Arrays.deepToString((Object[])dArray3), Arrays.deepToString((Object[])dArray5), pointValuePair == null ? "null" : Arrays.toString(pointValuePair.getPoint()));
                }
                pointValuePair = simplexSolver.optimize(new OptimizationData[]{linearObjectiveFunction, new LinearConstraintSet(arrayList), GoalType.MAXIMIZE, new MaxIter(10000)});
            }
            catch (NoFeasibleSolutionException noFeasibleSolutionException) {
                continue;
            }
            catch (UnboundedSolutionException unboundedSolutionException) {
                throw unboundedSolutionException;
            }
            bl2 = false;
            iterator = sMG.getTransitionsIterator(n3, n2);
            for (int i = 0; i < n; ++i) {
                distributionArray[i] = new Distribution();
                n10 = iterator.next().getKey();
                for (n9 = 0; n9 < n5; ++n9) {
                    Integer n12 = listArray[n10].indexOf(list3.get(i).get(n9));
                    double d = pointValuePair.getPoint()[n5 * i + n9];
                    d = d > 1.0 ? 1.0 : d;
                    d = d < 0.0 ? 0.0 : d;
                    distributionArray[i].add(n12, d);
                }
            }
        }
        if (bl2) {
            throw new PrismLangException("Nothing found for L");
        }
        return distributionArray;
    }

    private Distribution<Double> renormDistribution(Distribution<Double> distribution) {
        Distribution<Double> distribution2 = new Distribution<Double>();
        double d = 0.0;
        for (Map.Entry entry : distribution) {
            d += ((Double)entry.getValue()).doubleValue();
        }
        for (Map.Entry entry : distribution) {
            distribution2.add((Integer)entry.getKey(), (Double)entry.getValue() / d);
        }
        return distribution2;
    }

    @Override
    public Model<Double> constructInducedModel(StrategyExportOptions strategyExportOptions) throws PrismException {
        throw new PrismNotSupportedException("Strategy product not yet supported");
    }

    @Override
    public void exportActions(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
        prismLog.print(this.toString());
    }

    @Override
    public void exportIndices(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
    }

    @Override
    public void exportInducedModel(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
    }

    @Override
    public void clear() {
    }

    @Override
    public void exportDotFile(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
    }
}

