/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import explicit.Utils;
import java.util.Iterator;
import parser.State;
import prism.ModelInfo;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.RewardGenerator;
import simulator.PathDisplayer;

public class PathToText
extends PathDisplayer {
    private PrismLog log;
    private ModelInfo modelInfo;
    private int numVars;
    private boolean contTime;
    private RewardGenerator rewardGen;
    private int numRewardStructs;
    private boolean showTimeCumul = true;
    private boolean showTimeSpent = false;
    private String colSep = " ";
    private boolean firstCol;
    private State lastState;
    private double[] lastStateRewards;
    private double[] lastTransitionRewards;
    private boolean changed;

    public PathToText(PrismLog prismLog, ModelInfo modelInfo, RewardGenerator rewardGenerator) {
        this.log = prismLog;
        this.modelInfo = modelInfo;
        this.rewardGen = rewardGenerator;
        this.numVars = modelInfo.getNumVars();
        this.contTime = modelInfo.getModelType().continuousTime();
        this.numRewardStructs = rewardGenerator.getNumRewardStructs();
    }

    public void setShowTimeCumul(boolean bl) {
        this.showTimeCumul = bl;
    }

    public void setShowTimeSpent(boolean bl) {
        this.showTimeSpent = bl;
    }

    public void setColSep(String string) {
        this.colSep = string;
    }

    @Override
    public void startDisplay(State state, double[] dArray) {
        int n;
        this.firstCol = true;
        if (!this.getShowSnapshots()) {
            this.log.print(this.getColSep() + "action");
            if (this.showProbs) {
                this.log.print(this.getColSep() + "probability");
            }
        }
        this.log.print(this.getColSep() + "step");
        if (this.contTime && this.showTimeCumul) {
            this.log.print(this.getColSep() + "time");
        }
        if (this.varsToShow == null) {
            for (n = 0; n < this.numVars; ++n) {
                this.log.print(this.getColSep() + this.modelInfo.getVarName(n));
            }
        } else {
            Iterator iterator = this.varsToShow.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                this.log.print(this.getColSep() + this.modelInfo.getVarName(n2));
            }
        }
        if (this.getShowRewards()) {
            if (this.numRewardStructs == 1) {
                this.log.print(this.getColSep() + "state_reward");
                if (!this.getShowSnapshots()) {
                    this.log.print(this.getColSep() + "transition_reward");
                }
            } else {
                for (n = 0; n < this.numRewardStructs; ++n) {
                    this.log.print(this.getColSep() + "state_reward" + (n + 1));
                    if (this.getShowSnapshots()) continue;
                    this.log.print(this.getColSep() + "transition_reward" + (n + 1));
                }
            }
        }
        if (!this.getShowSnapshots() && this.contTime && this.showTimeSpent) {
            this.log.print(this.getColSep() + "time_in_state");
        }
        this.log.println();
        this.changed = true;
        this.firstCol = true;
        if (!this.getShowSnapshots()) {
            this.log.print(this.getColSep() + "-");
            if (this.showProbs) {
                this.log.print(this.getColSep() + "-");
            }
        }
        this.log.print(this.getColSep() + "0");
        if (this.contTime && this.showTimeCumul) {
            this.log.print(this.getColSep() + "0.0");
        }
        this.lastState = new State(state.varValues.length);
        this.displayState(state);
        if (this.getShowRewards()) {
            this.lastStateRewards = Utils.cloneDoubleArray(dArray);
            this.lastTransitionRewards = new double[dArray.length];
        }
        if (this.getShowSnapshots()) {
            this.log.println();
        }
    }

    @Override
    public void displayStep(double d, double d2, String string, Object object, double[] dArray, long l, State state, double[] dArray2) {
        if (!this.showChangesOnly || this.changed) {
            if (this.getShowRewards()) {
                for (int i = 0; i < this.numRewardStructs; ++i) {
                    this.log.print(this.getColSep() + this.lastStateRewards[i]);
                    this.log.print(this.getColSep() + dArray[i]);
                }
            }
            if (this.contTime && this.showTimeSpent) {
                this.log.print(this.getColSep() + d);
            }
            this.log.println();
        }
        if (this.showChangesOnly) {
            if (this.showTransitionRewards) {
                this.changed = this.stateChanged(this.lastState, state) || this.rewardsChanged(this.lastTransitionRewards, dArray2) || this.rewardsChanged(dArray2, dArray);
            } else {
                boolean bl = this.changed = this.stateChanged(this.lastState, state) || this.rewardsChanged(this.lastStateRewards, dArray2);
            }
            if (!this.changed) {
                return;
            }
        }
        this.firstCol = true;
        this.log.print(this.getColSep() + string);
        if (this.showProbs) {
            this.log.print(this.getColSep() + String.valueOf(object));
        }
        this.log.print(this.getColSep() + l);
        if (this.contTime && this.showTimeCumul) {
            this.log.print(this.getColSep() + d2);
        }
        this.displayState(state);
        if (this.getShowRewards()) {
            Utils.copyDoubleArray(dArray2, this.lastStateRewards);
            Utils.copyDoubleArray(dArray, this.lastTransitionRewards);
        }
    }

    @Override
    public void displaySnapshot(double d, double[] dArray, long l, State state, double[] dArray2) {
        this.firstCol = true;
        this.log.print(this.getColSep() + l);
        if (this.contTime && this.showTimeCumul) {
            this.log.print(this.getColSep() + d);
        }
        this.displayState(state);
        if (this.getShowRewards()) {
            for (int i = 0; i < this.numRewardStructs; ++i) {
                this.log.print(this.getColSep() + dArray2[i]);
                this.log.print(this.getColSep() + dArray[i]);
            }
        }
        this.log.println();
    }

    private void displayState(State state) {
        if (this.varsToShow == null) {
            for (int i = 0; i < this.numVars; ++i) {
                this.log.print(this.getColSep());
                this.log.print(state.varValues[i]);
            }
        } else {
            Iterator iterator = this.varsToShow.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                this.log.print(this.getColSep());
                this.log.print(state.varValues[n]);
            }
        }
        this.lastState.copy(state);
    }

    private String getColSep() {
        if (this.firstCol) {
            this.firstCol = false;
            return "";
        }
        return this.colSep;
    }

    private boolean stateChanged(State state, State state2) {
        if (this.varsToShow == null) {
            for (int i = 0; i < this.numVars; ++i) {
                if (state2.varValues[i].equals(state.varValues[i])) continue;
                return true;
            }
        } else {
            Iterator iterator = this.varsToShow.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (state2.varValues[n].equals(state.varValues[n])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean rewardsChanged(double[] dArray, double[] dArray2) {
        if (!this.showRewards) {
            return false;
        }
        for (int i = 0; i < this.numRewardStructs; ++i) {
            if (dArray2[i] == dArray[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endDisplay() {
        if (!(this.getShowSnapshots() || this.showChangesOnly && !this.changed)) {
            if (this.getShowRewards()) {
                for (int i = 0; i < this.numRewardStructs; ++i) {
                    this.log.print(this.getColSep() + this.lastStateRewards[i]);
                    this.log.print(this.getColSep() + "?");
                }
            }
            if (this.contTime && this.showTimeSpent) {
                this.log.print(this.getColSep() + "0.0");
            }
            this.log.println();
        }
    }

    @Override
    public void close() {
        if (this.log instanceof PrismFileLog) {
            this.log.close();
        }
    }
}

