/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import param.BigRational;
import param.ParamResult;
import parser.EvaluateContext;
import parser.Values;
import parser.ast.Expression;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.type.TypeVoid;
import prism.Accuracy;
import prism.Point;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.Result;
import prism.TileList;

public class ResultTesting {
    public static final Accuracy DEFAULT_TESTING_ACCURACY = new Accuracy(Accuracy.AccuracyLevel.BOUNDED, 1.0E-5, Accuracy.AccuracyType.RELATIVE);

    public static Accuracy getTestingAccuracy(Accuracy accuracy) {
        if (accuracy == null || accuracy.getLevel() == Accuracy.AccuracyLevel.ESTIMATED_BOUNDED) {
            return DEFAULT_TESTING_ACCURACY;
        }
        return accuracy;
    }

    public static boolean checkAgainstExpectedResultString(String string, Values values, List<String> list, Type type, Result result) throws PrismException {
        Object object = result.getResult();
        if (string.equals("?")) {
            return false;
        }
        if (string.startsWith("Error") && !(object instanceof Exception)) {
            throw new PrismException("Was expecting an error");
        }
        if (object instanceof Exception) {
            return ResultTesting.checkExceptionAgainstExpectedResultString(string, (Exception)object);
        }
        if (object instanceof ParamResult) {
            return ((ParamResult)object).test(type, string, values, list);
        }
        if (type instanceof TypeBool) {
            ResultTesting.checkBooleanAgainstExpectedResultString(string, values, result);
        } else if (type instanceof TypeInt && !(object instanceof BigRational)) {
            ResultTesting.checkIntAgainstExpectedResultString(string, values, result);
        } else if (type instanceof TypeDouble && !(object instanceof BigRational)) {
            ResultTesting.checkDoubleAgainstExpectedResultString(string, values, result);
        } else if ((type instanceof TypeDouble || type instanceof TypeInt) && object instanceof BigRational) {
            ResultTesting.checkExactAgainstExpectedResultString(string, values, type, result);
        } else if (type instanceof TypeVoid && object instanceof TileList) {
            ResultTesting.checkParetoAgainstExpectedResultString(string, values, result);
        } else {
            throw new PrismException("Don't know how to test properties of type " + String.valueOf(type));
        }
        return true;
    }

    private static boolean checkExceptionAgainstExpectedResultString(String string, Exception exception) throws PrismException {
        if (exception instanceof PrismNotSupportedException) {
            throw (PrismNotSupportedException)exception;
        }
        String string2 = exception.getMessage();
        if (string.startsWith("Error")) {
            if (string.startsWith("Error:")) {
                String[] stringArray;
                for (String string3 : stringArray = string.substring(6).split(",")) {
                    if (string3.length() == 0) {
                        throw new PrismException("Invalid RESULT specification: no expected words immediately following 'Error:'");
                    }
                    if (string2.toLowerCase().contains(string3.toLowerCase())) continue;
                    throw new PrismException("Error message should contain \"" + string3 + "\"");
                }
            }
            return true;
        }
        throw new PrismException("Unexpected error: " + string2);
    }

    private static void checkBooleanAgainstExpectedResultString(String object, Values values, Result result) throws PrismException {
        boolean bl;
        Object object2 = result.getResult();
        if (!(object2 instanceof Boolean)) {
            throw new PrismException("Result is wrong type (" + String.valueOf(object2.getClass()) + ") for (boolean-valued) property");
        }
        boolean bl2 = (Boolean)object2;
        if (((String)object).toLowerCase().equals("true")) {
            bl = true;
        } else if (((String)object).toLowerCase().equals("false")) {
            bl = false;
        } else {
            bl = ResultTesting.parseExpectedResultString((String)object, values).evaluateBoolean(values);
            object = (String)object + " = " + bl;
        }
        if (bl2 != bl) {
            throw new PrismException("Wrong result (expected " + (String)object + ", got " + bl2 + ")");
        }
    }

    private static Expression parseExpectedResultString(String string, Values values) throws PrismException {
        try {
            Expression expression = Prism.parseSingleExpressionString(string);
            expression = (Expression)expression.findAllConstants(values.getNames(), values.getTypes());
            expression.typeCheck();
            return expression;
        }
        catch (PrismLangException prismLangException) {
            throw new PrismException("Invalid RESULT specification \"" + string + "\": " + prismLangException.getMessage());
        }
    }

    private static void checkIntAgainstExpectedResultString(String object, Values values, Result result) throws PrismException {
        int n;
        Object object2 = result.getResult();
        if (!(object2 instanceof Integer)) {
            throw new PrismException("Result is wrong type (" + String.valueOf(object2.getClass()) + ") for (integer-valued) property");
        }
        int n2 = (Integer)object2;
        try {
            n = Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            n = ResultTesting.parseExpectedResultString((String)object, values).evaluateInt(values);
            object = (String)object + " = " + n;
        }
        if (n2 != n) {
            throw new PrismException("Wrong result (expected " + (String)object + ", got " + n2 + ")");
        }
    }

    private static void checkDoubleAgainstExpectedResultString(String object, Values values, Result result) throws PrismException {
        if (((String)object).startsWith("~")) {
            object = ((String)object).substring(1);
        }
        if (((String)object).equals("NaN")) {
            double d = Double.NaN;
            ResultTesting.checkDoubleAgainstExpectedResult((String)object, d, result);
        } else {
            if (((String)object).matches("\\[[^,]+,[^,]+\\]")) {
                String[] stringArray = ((String)object).substring(1, ((String)object).length() - 1).split(",");
                try {
                    double d = Double.parseDouble(stringArray[0]);
                    double d2 = Double.parseDouble(stringArray[1]);
                    ResultTesting.checkDoubleAgainstExpectedResultInterval((String)object, d, d2, result);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Invalid RESULT specification \"" + (String)object + "\": " + numberFormatException.getMessage());
                }
            }
            if (((String)object).matches("-?[0-9]+/[0-9]+")) {
                double d = new BigRational((String)object).doubleValue();
                object = (String)object + " = " + d;
                ResultTesting.checkDoubleAgainstExpectedResult((String)object, d, result);
            } else {
                try {
                    double d = Double.parseDouble((String)object);
                    ResultTesting.checkDoubleAgainstExpectedResult((String)object, d, result);
                }
                catch (NumberFormatException numberFormatException) {
                    double d = ResultTesting.parseExpectedResultString((String)object, values).evaluateDouble(values);
                    object = (String)object + " = " + d;
                    ResultTesting.checkDoubleAgainstExpectedResult((String)object, d, result);
                }
            }
        }
    }

    private static void checkDoubleAgainstExpectedResult(String string, double d, Result result) throws PrismException {
        Object object = result.getResult();
        if (!(object instanceof Double)) {
            throw new PrismException("Result is wrong type (" + String.valueOf(object.getClass()) + ") for (double-valued) property");
        }
        double d2 = (Double)object;
        if (Double.isNaN(d2) || Double.isNaN(d)) {
            if (Double.isNaN(d2) != Double.isNaN(d)) {
                throw new PrismException("Wrong result (expected " + string + ", got " + d2 + ")");
            }
        } else if (Double.isInfinite(d2) || Double.isInfinite(d)) {
            if (d2 != d) {
                throw new PrismException("Wrong result (expected " + string + ", got " + d2 + ")");
            }
        } else {
            Accuracy accuracy = ResultTesting.getTestingAccuracy(result.getAccuracy());
            double d3 = accuracy.getResultLowerBound(d2, true);
            double d4 = accuracy.getResultUpperBound(d2, true);
            if (!(d3 <= d) || !(d <= d4)) {
                throw new PrismException("Wrong result (expected " + string + ", abs err = " + Math.abs(d2 - d) + " > " + accuracy.getAbsoluteErrorBound(d2) + ")");
            }
        }
    }

    private static void checkDoubleAgainstExpectedResultInterval(String string, double d, double d2, Result result) throws PrismException {
        Object object = result.getResult();
        if (!(object instanceof Double)) {
            throw new PrismException("Result is wrong type (" + String.valueOf(object.getClass()) + ") for (double-valued) property");
        }
        double d3 = (Double)object;
        Accuracy accuracy = ResultTesting.getTestingAccuracy(result.getAccuracy());
        double d4 = accuracy.getResultLowerBound(d3, true);
        double d5 = accuracy.getResultUpperBound(d3, true);
        if (!(d4 <= d2) || !(d <= d5)) {
            throw new PrismException("Wrong result (expected " + string + ", got " + d3 + ")");
        }
    }

    private static void checkExactAgainstExpectedResultString(String string, Values values, Type type, Result result) throws PrismException {
        Object object = result.getResult();
        if (!(object instanceof BigRational)) {
            throw new PrismException("Result is wrong type (" + String.valueOf(object.getClass()) + ") for exact property");
        }
        BigRational bigRational = (BigRational)object;
        BigRational bigRational2 = null;
        if (string.equals("NaN")) {
            if (bigRational.isNaN()) {
                return;
            }
            throw new PrismException("Wrong result (expected NaN, got " + String.valueOf(bigRational) + ")");
        }
        boolean bl = false;
        if (string.startsWith("~")) {
            bl = true;
            string = string.substring(1);
        }
        try {
            bigRational2 = new BigRational(string);
        }
        catch (NumberFormatException numberFormatException) {
            bigRational2 = ResultTesting.parseExpectedResultString(string, values).evaluateBigRational(EvaluateContext.create(values, EvaluateContext.EvalMode.EXACT));
        }
        if (!bigRational.equals(bigRational2)) {
            boolean bl2;
            block12: {
                bl2 = false;
                if (type instanceof TypeDouble) {
                    try {
                        boolean bl3;
                        double d = Double.parseDouble(string);
                        double d2 = DEFAULT_TESTING_ACCURACY.getResultLowerBound(bigRational.doubleValue(), true);
                        double d3 = DEFAULT_TESTING_ACCURACY.getResultUpperBound(bigRational.doubleValue(), true);
                        boolean bl4 = bl3 = d2 <= d && d <= d3;
                        if (!bl3) break block12;
                        if (bl) {
                            bl2 = true;
                            break block12;
                        }
                        throw new PrismException("Inexact, but close result (expected '" + string + "' = " + String.valueOf(bigRational2) + " (" + bigRational2.toApproximateString() + "), got " + String.valueOf(bigRational) + " (" + bigRational.toApproximateString() + "))");
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (!bl2) {
                throw new PrismException("Wrong result (expected '" + string + "' = " + String.valueOf(bigRational2) + " (" + bigRational2.toApproximateString() + "), got " + String.valueOf(bigRational) + " (" + bigRational.toApproximateString() + "))");
            }
        }
    }

    private static void checkParetoAgainstExpectedResultString(String string, Values values, Result result) throws PrismException {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Pattern pattern = Pattern.compile("\\(([^,]*),([^)]*)\\)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            throw new PrismException("The expected result does not contain any points, or does not have the required format.");
        }
        do {
            double d = Double.parseDouble(matcher.group(1));
            double d2 = Double.parseDouble(matcher.group(2));
            Point point = new Point(new double[]{d, d2});
            arrayList.add(point);
        } while (matcher.find());
        Object object = result.getResult();
        List<Point> list = ((TileList)object).getRealPoints();
        if (list.size() != arrayList.size()) {
            throw new PrismException("The expected Pareto curve and the computed Pareto curve have a different number of points.");
        }
        for (Point point : arrayList) {
            boolean bl = false;
            for (Point point2 : list) {
                if (!point2.isCloseTo(point)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new PrismException("The point " + String.valueOf(point) + " in the expected Pareto curve has no match among the points in the computed Pareto curve.");
        }
        for (Point point : list) {
            boolean bl = false;
            for (Point point2 : arrayList) {
                if (!point2.isCloseTo(point)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new PrismException("The point " + String.valueOf(point) + " in the computed Pareto curve has no match among the points in the expected Pareto curve");
        }
    }
}

