/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ExpressionVar
extends Expression {
    private String name;
    private int index;
    private boolean prime;

    public ExpressionVar(String string, Type type) {
        this.setType(type);
        this.name = string;
        this.index = -1;
        this.prime = false;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setPrime(boolean bl) {
        this.prime = bl;
    }

    public boolean getPrime() {
        return this.prime;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        Object object;
        Object object2 = object = this.prime ? evaluateContext.getPrimedVarValue(this.name, this.index) : evaluateContext.getVarValue(this.name, this.index);
        if (object == null) {
            throw new PrismLangException("Could not evaluate variable", this);
        }
        return this.getType().castValueTo(object, evaluateContext.getEvaluationMode());
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionVar deepCopy(DeepCopy deepCopy) {
        return this;
    }

    @Override
    public ExpressionVar clone() {
        return (ExpressionVar)super.clone();
    }

    @Override
    public String toString() {
        return this.name + (this.prime ? "'" : "");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.index;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.prime ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionVar expressionVar = (ExpressionVar)object;
        if (this.index != expressionVar.index) {
            return false;
        }
        if (this.name == null ? expressionVar.name != null : !this.name.equals(expressionVar.name)) {
            return false;
        }
        return this.prime == expressionVar.prime;
    }
}

