/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import jltl2ba.SimpleLTL;
import param.BigRational;
import parser.BooleanUtils;
import parser.EvaluateContext;
import parser.EvaluateContextConstants;
import parser.EvaluateContextState;
import parser.EvaluateContextStateAndNextState;
import parser.EvaluateContextSubstate;
import parser.EvaluateContextValues;
import parser.State;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionExists;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionForAll;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.type.TypePathBool;
import parser.visitor.ASTTraverse;
import parser.visitor.CheckValid;
import parser.visitor.ConvertForJltl2ba;
import parser.visitor.DeepCopy;
import parser.visitor.ExpressionTraverseNonNested;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;

public abstract class Expression
extends ASTElement {
    public abstract boolean isConstant();

    public abstract boolean isProposition();

    public abstract Object evaluate(EvaluateContext var1) throws PrismLangException;

    public BigRational evaluateExact(final EvaluateContext evaluateContext) throws PrismLangException {
        return BigRational.from(this.evaluate(new EvaluateContext(){

            @Override
            public EvaluateContext.EvalMode getEvaluationMode() {
                return EvaluateContext.EvalMode.EXACT;
            }

            @Override
            public Object getVarValue(String string, int n) {
                return evaluateContext.getVarValue(string, n);
            }

            @Override
            public Object getConstantValue(String string) {
                return evaluateContext.getConstantValue(string);
            }
        }));
    }

    public String getResultName() {
        return "Result";
    }

    public abstract boolean returnsSingleValue();

    public Precedence getPrecedence() {
        return Precedence.BASIC;
    }

    public static boolean hasPrecedenceLessThan(Expression expression, Expression expression2) {
        return expression2.getPrecedence() != Precedence.BASIC && expression.getPrecedence().ordinal() < expression2.getPrecedence().ordinal();
    }

    public static boolean hasPrecedenceLessThanOrEquals(Expression expression, Expression expression2) {
        return expression2.getPrecedence() != Precedence.BASIC && expression.getPrecedence().ordinal() <= expression2.getPrecedence().ordinal();
    }

    @Override
    public abstract Expression deepCopy(DeepCopy var1) throws PrismLangException;

    @Override
    public Expression deepCopy() {
        return (Expression)super.deepCopy();
    }

    @Override
    public Expression clone() {
        return (Expression)super.clone();
    }

    public void checkValid(ModelType modelType) throws PrismLangException {
        CheckValid checkValid = new CheckValid(modelType);
        this.accept(checkValid);
    }

    public boolean isSimplePathFormula() throws PrismLangException {
        if (this instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)this;
            int n = expressionUnaryOp.getOperator();
            if (n == 1 || n == 3) {
                return expressionUnaryOp.getOperand().isSimplePathFormula();
            }
            return false;
        }
        if (this instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)this;
            if (expressionTemporal.getOperand1() != null && !(expressionTemporal.getOperand1().getType() instanceof TypeBool)) {
                return false;
            }
            return expressionTemporal.getOperand2() == null || expressionTemporal.getOperand2().getType() instanceof TypeBool;
        }
        return false;
    }

    public boolean isPathFormula(boolean bl) {
        try {
            if (this.getType() == null) {
                this.typeCheck();
            }
            if (this.getType() == TypePathBool.getInstance() || this.getType() == TypeBool.getInstance()) {
                return bl || this.computeProbNesting() < 1;
            }
            return false;
        }
        catch (PrismLangException prismLangException) {
            return false;
        }
    }

    public SimpleLTL convertForJltl2ba() throws PrismLangException {
        ConvertForJltl2ba convertForJltl2ba = new ConvertForJltl2ba();
        return convertForJltl2ba.convert(this);
    }

    public Object evaluate() throws PrismLangException {
        return this.evaluate(new EvaluateContextConstants(null));
    }

    public Object evaluate(Values values) throws PrismLangException {
        return this.evaluate(new EvaluateContextConstants(values));
    }

    public Object evaluate(Values values, Values values2) throws PrismLangException {
        return this.evaluate(new EvaluateContextValues(values, values2));
    }

    public Object evaluate(State state) throws PrismLangException {
        return this.evaluate(new EvaluateContextState(state));
    }

    public Object evaluate(Values values, State state) throws PrismLangException {
        return this.evaluate(new EvaluateContextState(values, state));
    }

    public Object evaluate(State state, State state2) throws PrismLangException {
        return this.evaluate(new EvaluateContextStateAndNextState(state, state2));
    }

    public Object evaluate(State state, int[] nArray) throws PrismLangException {
        return this.evaluate(new EvaluateContextSubstate(state, nArray));
    }

    public Object evaluate(Values values, State state, int[] nArray) throws PrismLangException {
        return this.evaluate(new EvaluateContextSubstate(values, state, nArray));
    }

    public int evaluateInt(EvaluateContext evaluateContext) throws PrismLangException {
        return (Integer)TypeInt.getInstance().castValueTo(this.evaluate(evaluateContext), EvaluateContext.EvalMode.FP);
    }

    public int evaluateInt() throws PrismLangException {
        return this.evaluateInt(new EvaluateContextConstants(null));
    }

    public int evaluateInt(Values values) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextConstants(values));
    }

    public int evaluateInt(Values values, Values values2) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextValues(values, values2));
    }

    public int evaluateInt(State state) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextState(state));
    }

    public int evaluateInt(Values values, State state) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextState(values, state));
    }

    public int evaluateInt(State state, int[] nArray) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextSubstate(state, nArray));
    }

    public int evaluateInt(Values values, State state, int[] nArray) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextSubstate(values, state, nArray));
    }

    public static int evaluateObjectAsInt(Object object) throws PrismLangException {
        return (Integer)TypeInt.getInstance().castValueTo(object, EvaluateContext.EvalMode.FP);
    }

    public double evaluateDouble(EvaluateContext evaluateContext) throws PrismLangException {
        return (Double)TypeDouble.getInstance().castValueTo(this.evaluate(evaluateContext), EvaluateContext.EvalMode.FP);
    }

    public double evaluateDouble() throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextConstants(null));
    }

    public double evaluateDouble(Values values) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextConstants(values));
    }

    public double evaluateDouble(Values values, Values values2) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextValues(values, values2));
    }

    public double evaluateDouble(State state) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextState(state));
    }

    public double evaluateDouble(Values values, State state) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextState(values, state));
    }

    public double evaluateDouble(State state, int[] nArray) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextSubstate(state, nArray));
    }

    public double evaluateDouble(Values values, State state, int[] nArray) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextSubstate(values, state, nArray));
    }

    public BigRational evaluateBigRational(EvaluateContext evaluateContext) throws PrismLangException {
        return (BigRational)TypeDouble.getInstance().castValueTo(this.evaluate(evaluateContext), EvaluateContext.EvalMode.EXACT);
    }

    public boolean evaluateBoolean(EvaluateContext evaluateContext) throws PrismLangException {
        return TypeBool.getInstance().castValueTo(this.evaluate(evaluateContext), EvaluateContext.EvalMode.FP);
    }

    public boolean evaluateBoolean() throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextConstants(null));
    }

    public boolean evaluateBoolean(Values values) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextConstants(values));
    }

    public boolean evaluateBoolean(Values values, Values values2) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextValues(values, values2));
    }

    public boolean evaluateBoolean(State state) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextState(state));
    }

    public boolean evaluateBoolean(Values values, State state) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextState(values, state));
    }

    public boolean evaluateBoolean(State state, int[] nArray) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextSubstate(state, nArray));
    }

    public boolean evaluateBoolean(Values values, State state, int[] nArray) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextSubstate(values, state, nArray));
    }

    public BigRational evaluateExact() throws PrismLangException {
        return this.evaluateExact(new EvaluateContextConstants(null));
    }

    public BigRational evaluateExact(Values values) throws PrismLangException {
        return this.evaluateExact(new EvaluateContextConstants(values));
    }

    public BigRational evaluateExact(Values values, Values values2) throws PrismLangException {
        return this.evaluateExact(new EvaluateContextValues(values, values2));
    }

    public BigRational evaluateExact(State state) throws PrismLangException {
        return this.evaluateExact(new EvaluateContextState(state));
    }

    public BigRational evaluateExact(Values values, State state) throws PrismLangException {
        return this.evaluateExact(new EvaluateContextState(values, state));
    }

    public BigRational evaluateExact(State state, int[] nArray) throws PrismLangException {
        return this.evaluateExact(new EvaluateContextSubstate(state, nArray));
    }

    public BigRational evaluateExact(Values values, State state, int[] nArray) throws PrismLangException {
        return this.evaluateExact(new EvaluateContextSubstate(values, state, nArray));
    }

    public static ExpressionLiteral True() {
        return new ExpressionLiteral(TypeBool.getInstance(), true);
    }

    public static ExpressionLiteral False() {
        return new ExpressionLiteral(TypeBool.getInstance(), false);
    }

    public static ExpressionLiteral Int(int n) {
        return new ExpressionLiteral(TypeInt.getInstance(), n);
    }

    public static ExpressionLiteral Double(double d) {
        return new ExpressionLiteral(TypeDouble.getInstance(), d);
    }

    public static ExpressionLiteral Literal(Object object) throws PrismLangException {
        if (object instanceof Integer) {
            return Expression.Int((Integer)object);
        }
        if (object instanceof Double) {
            return Expression.Double((Double)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? Expression.True() : Expression.False();
        }
        throw new PrismLangException("Unknown object type " + String.valueOf(object.getClass()));
    }

    public static ExpressionUnaryOp Not(Expression expression) {
        return new ExpressionUnaryOp(1, expression);
    }

    public static ExpressionBinaryOp And(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(4, expression, expression2);
    }

    public static ExpressionBinaryOp Or(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(3, expression, expression2);
    }

    public static ExpressionBinaryOp Iff(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(2, expression, expression2);
    }

    public static ExpressionBinaryOp Implies(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(1, expression, expression2);
    }

    public static ExpressionBinaryOp Plus(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(11, expression, expression2);
    }

    public static ExpressionUnaryOp Minus(Expression expression) {
        return new ExpressionUnaryOp(2, expression);
    }

    public static ExpressionBinaryOp Minus(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(12, expression, expression2);
    }

    public static ExpressionBinaryOp Times(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(13, expression, expression2);
    }

    public static ExpressionBinaryOp Divide(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(14, expression, expression2);
    }

    public static ExpressionBinaryOp Pow(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(15, expression, expression2);
    }

    public static ExpressionUnaryOp Parenth(Expression expression) {
        return new ExpressionUnaryOp(3, expression);
    }

    public static ExpressionTemporal Next(Expression expression) {
        return new ExpressionTemporal(1, null, expression);
    }

    public static boolean isTrue(Expression expression) {
        return expression instanceof ExpressionLiteral && ((ExpressionLiteral)expression).getValue().equals(true);
    }

    public static boolean isFalse(Expression expression) {
        return expression instanceof ExpressionLiteral && ((ExpressionLiteral)expression).getValue().equals(false);
    }

    public static boolean isInt(Expression expression) {
        return expression instanceof ExpressionLiteral && expression.getType() instanceof TypeInt;
    }

    public static boolean isDouble(Expression expression) {
        return expression instanceof ExpressionLiteral && expression.getType() instanceof TypeDouble;
    }

    public static boolean isNot(Expression expression) {
        return expression instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1;
    }

    public static boolean isAnd(Expression expression) {
        return expression instanceof ExpressionBinaryOp && ((ExpressionBinaryOp)expression).getOperator() == 4;
    }

    public static boolean isOr(Expression expression) {
        return expression instanceof ExpressionBinaryOp && ((ExpressionBinaryOp)expression).getOperator() == 3;
    }

    public static boolean isIff(Expression expression) {
        return expression instanceof ExpressionBinaryOp && ((ExpressionBinaryOp)expression).getOperator() == 2;
    }

    public static boolean isImplies(Expression expression) {
        return expression instanceof ExpressionBinaryOp && ((ExpressionBinaryOp)expression).getOperator() == 1;
    }

    public static boolean isParenth(Expression expression) {
        return expression instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 3;
    }

    public static boolean isRelOp(Expression expression) {
        return expression instanceof ExpressionBinaryOp && ExpressionBinaryOp.isRelOp(((ExpressionBinaryOp)expression).getOperator());
    }

    public static boolean isFilter(Expression expression, ExpressionFilter.FilterOperator filterOperator) {
        return expression instanceof ExpressionFilter && ((ExpressionFilter)expression).getOperatorType() == filterOperator;
    }

    public static boolean isFunc(Expression expression, int n) {
        return expression instanceof ExpressionFunc && ((ExpressionFunc)expression).getNameCode() == n;
    }

    public static boolean isPareto(Expression expression) {
        return expression instanceof ExpressionFunc && ((ExpressionFunc)expression).isPareto();
    }

    public static boolean isQuantitative(Expression expression) {
        if (expression instanceof ExpressionProb) {
            return ((ExpressionProb)expression).getProb() == null;
        }
        if (expression instanceof ExpressionReward) {
            return ((ExpressionReward)expression).getReward() == null;
        }
        if (expression instanceof ExpressionSS) {
            return ((ExpressionSS)expression).getProb() == null;
        }
        return false;
    }

    public static boolean isReach(Expression expression) {
        if (expression instanceof ExpressionTemporal && ((ExpressionTemporal)expression).getOperator() == 3) {
            return ((ExpressionTemporal)expression).getOperand2().getType() instanceof TypeBool;
        }
        return false;
    }

    public static boolean containsTemporalTimeBounds(Expression expression) {
        try {
            expression.accept(new ExpressionTraverseNonNested(){

                @Override
                public void visitPre(ExpressionTemporal expressionTemporal) throws PrismLangException {
                    if (expressionTemporal.hasBounds()) {
                        throw new PrismLangException("");
                    }
                }
            });
        }
        catch (PrismLangException prismLangException) {
            return true;
        }
        return false;
    }

    public static boolean usesInstantaneousReward(Expression expression) {
        return expression instanceof ExpressionTemporal && ((ExpressionTemporal)expression).getOperator() == 12;
    }

    public static boolean containsRewardBoundedPathFormula(Expression expression) {
        try {
            expression.accept(new ASTTraverse(){

                @Override
                public void visitPre(ExpressionReward expressionReward) throws PrismLangException {
                    if ("path".equals(expressionReward.getModifier())) {
                        throw new PrismLangException("Found one");
                    }
                }
            });
        }
        catch (PrismLangException prismLangException) {
            return true;
        }
        return false;
    }

    public static boolean containsMinReward(Expression expression) {
        try {
            ASTTraverse aSTTraverse = new ASTTraverse(){

                @Override
                public void visitPost(ExpressionReward expressionReward) throws PrismLangException {
                    if (expressionReward.isMin()) {
                        throw new PrismLangException("Found one", expressionReward);
                    }
                }
            };
            expression.accept(aSTTraverse);
        }
        catch (PrismLangException prismLangException) {
            return true;
        }
        return false;
    }

    public static boolean containsNonProbLTLFormula(Expression expression) {
        try {
            ASTTraverse aSTTraverse = new ASTTraverse(){

                @Override
                public void visitPost(ExpressionForAll expressionForAll) throws PrismLangException {
                    if (!expressionForAll.getExpression().isSimplePathFormula()) {
                        throw new PrismLangException("Found one", expressionForAll);
                    }
                }

                @Override
                public void visitPost(ExpressionExists expressionExists) throws PrismLangException {
                    if (!expressionExists.getExpression().isSimplePathFormula()) {
                        throw new PrismLangException("Found one", expressionExists);
                    }
                }
            };
            expression.accept(aSTTraverse);
        }
        catch (PrismLangException prismLangException) {
            return true;
        }
        return false;
    }

    public static boolean containsMultiObjective(Expression expression) {
        try {
            ASTTraverse aSTTraverse = new ASTTraverse(){

                @Override
                public void visitPost(ExpressionFunc expressionFunc) throws PrismLangException {
                    if (expressionFunc.getNameCode() == 8) {
                        throw new PrismLangException("Found one", expressionFunc);
                    }
                }
            };
            expression.accept(aSTTraverse);
        }
        catch (PrismLangException prismLangException) {
            return true;
        }
        return false;
    }

    public static boolean isPositiveNormalFormLTL(Expression expression) {
        if (expression.getType() instanceof TypeBool) {
            return true;
        }
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            int n = expressionUnaryOp.getOperator();
            switch (n) {
                case 1: {
                    return false;
                }
            }
            return Expression.isPositiveNormalFormLTL(expressionUnaryOp.getOperand());
        }
        if (expression instanceof ExpressionBinaryOp) {
            ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
            int n = expressionBinaryOp.getOperator();
            switch (n) {
                case 1: 
                case 2: {
                    return false;
                }
            }
            return Expression.isPositiveNormalFormLTL(expressionBinaryOp.getOperand1()) && Expression.isPositiveNormalFormLTL(expressionBinaryOp.getOperand2());
        }
        if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperand1() != null && !Expression.isPositiveNormalFormLTL(expressionTemporal.getOperand1())) {
                return false;
            }
            return expressionTemporal.getOperand2() == null || Expression.isPositiveNormalFormLTL(expressionTemporal.getOperand2());
        }
        return false;
    }

    public static boolean isCoSafeLTLSyntactic(Expression expression) {
        return Expression.isCoSafeLTLSyntactic(expression, false);
    }

    public static boolean isCoSafeLTLSyntactic(Expression expression, boolean bl) {
        if (bl) {
            expression = BooleanUtils.convertLTLToPositiveNormalForm(expression.deepCopy());
        } else if (!Expression.isPositiveNormalFormLTL(expression)) {
            return false;
        }
        try {
            ExpressionTraverseNonNested expressionTraverseNonNested = new ExpressionTraverseNonNested(){

                @Override
                public void visitPost(ExpressionTemporal expressionTemporal) throws PrismLangException {
                    if (expressionTemporal.getOperator() == 1) {
                        return;
                    }
                    if (expressionTemporal.getOperator() == 3) {
                        return;
                    }
                    if (expressionTemporal.getOperator() == 2) {
                        return;
                    }
                    throw new PrismLangException("Found non-X/F/U", expressionTemporal);
                }
            };
            expression.accept(expressionTraverseNonNested);
        }
        catch (PrismLangException prismLangException) {
            return false;
        }
        return true;
    }

    public static Expression convertSimplePathFormulaToCanonicalForm(Expression expression) throws PrismLangException {
        Expression expression2;
        boolean bl = false;
        if (!expression.isSimplePathFormula()) {
            throw new PrismLangException("Expression is not a simple path formula.");
        }
        while (expression instanceof ExpressionUnaryOp) {
            expression2 = (ExpressionUnaryOp)expression;
            if (((ExpressionUnaryOp)expression2).getOperator() == 3) {
                expression = ((ExpressionUnaryOp)expression2).getOperand();
                continue;
            }
            if (((ExpressionUnaryOp)expression2).getOperator() == 1) {
                bl = !bl;
                expression = ((ExpressionUnaryOp)expression2).getOperand();
                continue;
            }
            throw new PrismLangException("Expression is not a simple path formula: Unexpected unary operator " + ((ExpressionUnaryOp)expression2).getOperatorSymbol());
        }
        if (expression instanceof ExpressionTemporal) {
            expression2 = (ExpressionTemporal)expression;
            if (((ExpressionTemporal)expression2).getOperator() == 1) {
                if (bl) {
                    if (((ExpressionTemporal)expression2).hasBounds()) {
                        throw new PrismLangException("Next-Step operator should not have bounds!");
                    }
                    return new ExpressionTemporal(1, null, Expression.Not(Expression.Parenth(((ExpressionTemporal)expression2).getOperand2())));
                }
                return expression2;
            }
            expression = ((ExpressionTemporal)expression2).getOperator() == 2 ? expression2 : ((ExpressionTemporal)expression2).convertToUntilForm();
        } else {
            throw new PrismLangException("Expression is not a simple path formula: Unsupported expression " + expression.toString());
        }
        if (bl) {
            if (expression instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
                return ((ExpressionUnaryOp)expression).getOperand();
            }
            return Expression.Not(expression);
        }
        return expression;
    }

    public static Expression createFromJltl2ba(SimpleLTL simpleLTL) throws PrismException {
        switch (simpleLTL.kind) {
            case AND: {
                return Expression.And(Expression.createFromJltl2ba(simpleLTL.left), Expression.createFromJltl2ba(simpleLTL.right));
            }
            case AP: {
                return new ExpressionLabel(simpleLTL.ap);
            }
            case EQUIV: {
                return Expression.Iff(Expression.createFromJltl2ba(simpleLTL.left), Expression.createFromJltl2ba(simpleLTL.right));
            }
            case FALSE: {
                return Expression.False();
            }
            case FINALLY: {
                return new ExpressionTemporal(3, null, Expression.createFromJltl2ba(simpleLTL.left));
            }
            case GLOBALLY: {
                return new ExpressionTemporal(4, null, Expression.createFromJltl2ba(simpleLTL.left));
            }
            case IMPLIES: {
                return Expression.Implies(Expression.createFromJltl2ba(simpleLTL.left), Expression.createFromJltl2ba(simpleLTL.right));
            }
            case NEXT: {
                return new ExpressionTemporal(1, null, Expression.createFromJltl2ba(simpleLTL.left));
            }
            case NOT: {
                return Expression.Not(Expression.createFromJltl2ba(simpleLTL.left));
            }
            case OR: {
                return Expression.Or(Expression.createFromJltl2ba(simpleLTL.left), Expression.createFromJltl2ba(simpleLTL.right));
            }
            case RELEASE: {
                return new ExpressionTemporal(6, Expression.createFromJltl2ba(simpleLTL.left), Expression.createFromJltl2ba(simpleLTL.right));
            }
            case TRUE: {
                return Expression.True();
            }
            case UNTIL: {
                return new ExpressionTemporal(2, Expression.createFromJltl2ba(simpleLTL.left), Expression.createFromJltl2ba(simpleLTL.right));
            }
        }
        throw new PrismException("Cannot convert jltl2ba formula " + String.valueOf(simpleLTL));
    }

    public static String toStringPrecLt(Expression expression, Expression expression2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(expression.toString());
        if (Expression.hasPrecedenceLessThan(expression, expression2)) {
            stringBuilder.insert(0, "(");
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static String toStringPrecLeq(Expression expression, Expression expression2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(expression.toString());
        if (Expression.hasPrecedenceLessThanOrEquals(expression, expression2)) {
            stringBuilder.insert(0, "(");
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    static enum Precedence {
        TEMPORAL_BINARY,
        TEMPORAL_UNARY,
        ITE,
        IMPLIES,
        IFF,
        OR,
        AND,
        NOT,
        EQUALITY,
        RELOP,
        PLUS_MINUS,
        TIMES_DIVIDE,
        POW,
        UNARY_MINUS,
        BASIC;

    }
}

