/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import jltl2ba.SimpleLTL;
import parser.BooleanUtils;
import parser.ParseException;
import parser.PrismParserConstants;
import parser.PrismParserTokenManager;
import parser.SimpleCharStream;
import parser.Token;
import parser.ast.Coalition;
import parser.ast.Command;
import parser.ast.ConstantList;
import parser.ast.Declaration;
import parser.ast.DeclarationBool;
import parser.ast.DeclarationClock;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationIntUnbounded;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionExists;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionForAll;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionInterval;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionMultiNash;
import parser.ast.ExpressionMultiNashProb;
import parser.ast.ExpressionMultiNashReward;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionQuant;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionStrategy;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.ExpressionVar;
import parser.ast.Filter;
import parser.ast.ForLoop;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.Observable;
import parser.ast.ObservableVars;
import parser.ast.Player;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.ast.RenamedModule;
import parser.ast.RewardStruct;
import parser.ast.RewardStructItem;
import parser.ast.SystemBrackets;
import parser.ast.SystemDefn;
import parser.ast.SystemFullParallel;
import parser.ast.SystemHide;
import parser.ast.SystemInterleaved;
import parser.ast.SystemModule;
import parser.ast.SystemParallel;
import parser.ast.SystemReference;
import parser.ast.SystemRename;
import parser.ast.Update;
import parser.ast.UpdateElement;
import parser.ast.Updates;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.visitor.ASTTraverseModify;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismLangException;

public class PrismParser
implements PrismParserConstants {
    private static ModelInfo modelInfo;
    private static ArrayList<String> keywordList;
    private static boolean jj_initialized_once;
    public static PrismParserTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static Token jj_scanpos;
    private static Token jj_lastpos;
    private static int jj_la;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static final JJCalls[] jj_2_rtns;
    private static boolean jj_rescan;
    private static int jj_gc;
    private static final LookaheadSuccess jj_ls;
    private static List<int[]> jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;
    private static int[] jj_lasttokens;
    private static int jj_endpos;
    private static boolean trace_enabled;

    public static void main(String[] stringArray) {
        PrismParser prismParser = null;
        InputStream inputStream = null;
        String string = null;
        try {
            if (stringArray.length == 0) {
                System.out.println("Usage: java parser.PrismParser <switch> [<file>]");
                System.out.println("Where: <switch> = -modulesfile or -mf");
                System.out.println("                  -propertiesfile or -pf");
                System.out.println("                  -expression or -e");
                System.out.println("                  -ltl or -l");
                System.exit(1);
            }
            prismParser = new PrismParser();
            inputStream = stringArray.length > 1 ? new FileInputStream(stringArray[1]) : System.in;
            string = stringArray.length > 1 ? "file " + stringArray[1] : "stdin";
            System.out.println("Reading from " + string + "...\n");
            if (stringArray[0].equals("-modulesfile") || stringArray[0].equals("-mf")) {
                ModulesFile modulesFile = prismParser.parseModulesFile(inputStream);
                System.out.print("Modules file:\n=============\n\n" + String.valueOf(modulesFile));
                System.out.print("\nTree:\n=====\n" + modulesFile.toTreeString());
                modulesFile.tidyUp();
                System.out.print("\nAnd after expansion:\n====================\n\n" + String.valueOf(modulesFile));
            } else if (stringArray[0].equals("-propertiesfile") || stringArray[0].equals("-pf")) {
                PropertiesFile propertiesFile = prismParser.parsePropertiesFile(new ModulesFile(), inputStream);
                System.out.print("Properties file:\n================\n\n" + String.valueOf(propertiesFile));
                System.out.print("\nTree:\n=====\n" + propertiesFile.toTreeString());
                propertiesFile.tidyUp();
                System.out.print("\nAnd after expansion:\n====================\n\n" + String.valueOf(propertiesFile));
            } else if (stringArray[0].equals("-expression") || stringArray[0].equals("-e")) {
                Expression expression = prismParser.parseSingleExpression(inputStream);
                System.out.println("Expression: " + expression.toString());
                System.out.print("Tree:\n=====\n" + expression.toTreeString());
                expression.typeCheck();
                expression.semanticCheck();
                System.out.println("Type: " + expression.getType().getTypeString());
                System.out.println("Eval: " + String.valueOf(expression.evaluate()));
            } else if (stringArray[0].equals("-ltl") || stringArray[0].equals("-l")) {
                Expression expression;
                Expression expression2 = prismParser.parseSingleLTLFormula(inputStream);
                expression2 = (Expression)expression2.accept(new ASTTraverseModify(){

                    @Override
                    public Object visit(ExpressionIdent expressionIdent) throws PrismLangException {
                        return new ExpressionVar(expressionIdent.getName(), TypeBool.getInstance());
                    }
                });
                System.out.println("LTL formula: " + expression2.toString());
                System.out.print("Tree:\n=====\n" + expression2.toTreeString());
                expression2.typeCheck();
                System.out.println("Type: " + expression2.getType().getTypeString());
                boolean bl = Expression.isPositiveNormalFormLTL(expression2);
                System.out.println("Positive normal form: " + bl);
                System.out.println("Syntactically co-safe: " + Expression.isCoSafeLTLSyntactic(expression2));
                if (!bl) {
                    expression = BooleanUtils.convertLTLToPositiveNormalForm(expression2.deepCopy());
                    System.out.println("Positive normal form conversion: " + String.valueOf(expression));
                    System.out.println("Syntactically co-safe: " + Expression.isCoSafeLTLSyntactic(expression));
                }
                expression = (Expression)expression2.deepCopy().accept(new ASTTraverseModify(){

                    @Override
                    public Object visit(ExpressionVar expressionVar) throws PrismLangException {
                        return new ExpressionLabel(expressionVar.getName());
                    }
                });
                SimpleLTL simpleLTL = expression.convertForJltl2ba();
                System.out.println("LBT: " + simpleLTL.toStringLBT());
                System.out.println("Spot: " + simpleLTL.toStringSpot());
                System.out.println("Spin: " + simpleLTL.toStringSpin());
            } else {
                System.out.println("Unknown switch");
                System.exit(1);
            }
        }
        catch (PrismLangException prismLangException) {
            System.out.println("Error in " + string + ": " + prismLangException.getMessage() + ".");
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            System.exit(1);
        }
    }

    public PrismParser() {
        this(System.in);
        this.setTabSize(8);
    }

    public ModulesFile parseModulesFile(InputStream inputStream) throws PrismLangException {
        return this.parseModulesFile(inputStream, null);
    }

    public ModulesFile parseModulesFile(InputStream inputStream, ModelType modelType) throws PrismLangException {
        ModulesFile modulesFile = null;
        PrismParser.ReInit(inputStream);
        try {
            modulesFile = PrismParser.ModulesFile();
        }
        catch (ParseException parseException) {
            throw this.generateSyntaxError(parseException);
        }
        if (modelType != null) {
            modulesFile.setModelTypeInFile(modelType);
        }
        return modulesFile;
    }

    public PropertiesFile parsePropertiesFile(ModelInfo modelInfo, InputStream inputStream) throws PrismLangException {
        return this.parsePropertiesFile(modelInfo, inputStream, false);
    }

    public PropertiesFile parsePropertiesFile(ModelInfo modelInfo, InputStream inputStream, boolean bl) throws PrismLangException {
        PropertiesFile propertiesFile = null;
        PrismParser.ReInit(inputStream);
        PrismParser.modelInfo = modelInfo;
        try {
            propertiesFile = bl ? PrismParser.PropertiesFile() : PrismParser.PropertiesFileSemicolonless();
        }
        catch (ParseException parseException) {
            throw this.generateSyntaxError(parseException);
        }
        return propertiesFile;
    }

    public Expression parseSingleExpression(InputStream inputStream) throws PrismLangException {
        Expression expression = null;
        PrismParser.ReInit(inputStream);
        try {
            expression = PrismParser.SingleExpression();
        }
        catch (ParseException parseException) {
            throw this.generateSyntaxError(parseException);
        }
        return expression;
    }

    public Expression parseSingleLTLFormula(InputStream inputStream) throws PrismLangException {
        Expression expression = null;
        PrismParser.ReInit(inputStream);
        try {
            expression = PrismParser.SingleLTLFormula();
        }
        catch (ParseException parseException) {
            throw this.generateSyntaxError(parseException);
        }
        return expression;
    }

    public ForLoop parseForLoop(InputStream inputStream) throws PrismLangException {
        ForLoop forLoop = null;
        PrismParser.ReInit(inputStream);
        try {
            forLoop = PrismParser.ForLoop();
        }
        catch (ParseException parseException) {
            throw this.generateSyntaxError(parseException);
        }
        return forLoop;
    }

    public static String getPrecedingCommentBlock(Token token) {
        Object object = "";
        Token token2 = token;
        if (!(token2.specialToken == null || token2.specialToken.kind == 1 && token2.specialToken.image.matches("[\\n\\r]*"))) {
            token2 = token2.specialToken;
            while (!(token2.specialToken == null || token2.specialToken.kind == 1 && token2.specialToken.image.matches("[\\n\\r]*"))) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                String string = token2.image;
                string = string.replaceAll("\r", "");
                if (token2.kind == 2) {
                    while (((String)object).length() > 0 && ("" + ((String)object).charAt(((String)object).length() - 1)).matches("[ \t]")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    string = string.substring(2);
                    string = string.replaceFirst("[ \t]*", "");
                }
                object = (String)object + string;
                token2 = token2.next;
            }
        }
        if (((String)object).length() > 0 && ((String)object).charAt(((String)object).length() - 1) == '\n') {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return object;
    }

    public static String slashCommentBlock(String string) {
        int n;
        Object object = "";
        while ((n = string.indexOf("\n")) != -1) {
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            if (string2.trim().length() > 0) {
                object = (String)object + "// " + string2;
            }
            object = (String)object + "\n";
        }
        if (string.trim().length() > 0) {
            object = (String)object + "// " + string + "\n";
        }
        return object;
    }

    public static boolean isKeyword(String string) {
        return keywordList.contains(string);
    }

    public static List<String> getListOfKeywords() {
        return keywordList;
    }

    public void setTabSize(int n) {
        SimpleCharStream.setTabSize(n);
    }

    public int getTabSize() {
        return SimpleCharStream.getTabSize();
    }

    protected PrismLangException generateSyntaxError(ParseException parseException) {
        ExpressionIdent expressionIdent;
        if (parseException == null) {
            return new PrismLangException("Syntax error");
        }
        if (parseException.currentToken == null) {
            String string = parseException.getMessage();
            Object object = "Syntax error";
            if (string != null && string.length() > 0) {
                object = (String)object + ": " + string;
            }
            return new PrismLangException((String)object);
        }
        if (parseException.currentToken.next == null) {
            expressionIdent = new ExpressionIdent(parseException.currentToken.image);
            expressionIdent.setPosition(parseException.currentToken);
        } else {
            expressionIdent = new ExpressionIdent(parseException.currentToken.next.image);
            expressionIdent.setPosition(parseException.currentToken.next);
        }
        String string = parseException.getMessage();
        Object object = "Syntax error";
        if (string != null && string.length() > 0 && string.length() < 20) {
            object = (String)object + ": " + string;
        }
        return new PrismLangException((String)object, expressionIdent);
    }

    public static final ModulesFile ModulesFile() throws ParseException, PrismLangException {
        Token token;
        ModulesFile modulesFile;
        Expression expression;
        Token token2;
        ModelType modelType;
        block23: {
            modelType = null;
            int n = 0;
            token2 = null;
            Module module = null;
            RenamedModule renamedModule = null;
            RewardStruct rewardStruct = null;
            Expression expression2 = null;
            ObservableVars observableVars = null;
            Observable observable = null;
            int n2 = 0;
            expression = null;
            Player player = null;
            modulesFile = new ModulesFile();
            token = null;
            block19: while (true) {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 13: 
                    case 23: 
                    case 29: 
                    case 31: 
                    case 35: 
                    case 39: 
                    case 43: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: {
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[0] = jj_gen;
                        break block23;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 13: 
                    case 39: 
                    case 45: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 60: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 75: {
                        token = PrismParser.getToken(1);
                        modelType = PrismParser.ModulesFileType();
                        if (++n != 2) continue block19;
                        token2 = PrismParser.getToken(0);
                        continue block19;
                    }
                    case 23: {
                        PrismParser.FormulaDef(modulesFile.getFormulaList());
                        continue block19;
                    }
                    case 35: {
                        PrismParser.LabelDef(modulesFile.getLabelList());
                        continue block19;
                    }
                    case 6: 
                    case 59: 
                    case 61: {
                        PrismParser.ConstantDef(modulesFile.getConstantList());
                        continue block19;
                    }
                    case 29: {
                        Declaration declaration = PrismParser.GlobalDecl();
                        modulesFile.addGlobal(declaration);
                        continue block19;
                    }
                }
                PrismParser.jj_la1[1] = jj_gen;
                if (PrismParser.jj_2_1(Integer.MAX_VALUE)) {
                    renamedModule = PrismParser.RenamedModule();
                    modulesFile.addRenamedModule(renamedModule);
                    continue;
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 43: {
                        module = PrismParser.Module();
                        modulesFile.addModule(module);
                        continue block19;
                    }
                    case 62: {
                        rewardStruct = PrismParser.RewardStruct();
                        modulesFile.addRewardStruct(rewardStruct);
                        continue block19;
                    }
                    case 31: {
                        expression2 = PrismParser.Init();
                        modulesFile.setInitialStates(expression2);
                        if (++n2 != 2) continue block19;
                        expression = expression2;
                        continue block19;
                    }
                    case 47: {
                        observableVars = PrismParser.ObservableVars();
                        modulesFile.addObservableVarList(observableVars);
                        continue block19;
                    }
                    case 46: {
                        observable = PrismParser.Observable();
                        modulesFile.addObservableDefinition(observable);
                        continue block19;
                    }
                    case 74: {
                        PrismParser.SystemEndsystem(modulesFile);
                        continue block19;
                    }
                    case 55: {
                        player = PrismParser.Player();
                        modulesFile.addPlayer(player);
                        continue block19;
                    }
                }
                break;
            }
            PrismParser.jj_la1[2] = jj_gen;
            PrismParser.jj_consume_token(-1);
            throw new ParseException();
        }
        PrismParser.jj_consume_token(0);
        if (token2 != null) {
            ExpressionIdent expressionIdent = new ExpressionIdent(token2.image);
            expressionIdent.setPosition(token2);
            throw new PrismLangException("There were multiple model type declarations", expressionIdent);
        }
        if (expression != null) {
            throw new PrismLangException("There were multiple init...endinit constructs", expression);
        }
        modulesFile.setModelTypeInFile(modelType);
        modulesFile.setPosition(token != null ? token : PrismParser.getToken(0), PrismParser.getToken(0));
        return modulesFile;
    }

    public static final PropertiesFile PropertiesFile() throws ParseException, PrismLangException {
        Token token;
        PropertiesFile propertiesFile;
        block13: {
            propertiesFile = new PropertiesFile(modelInfo);
            token = null;
            token = PrismParser.getToken(1);
            block11: while (true) {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 3: 
                    case 6: 
                    case 14: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 35: 
                    case 38: 
                    case 42: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 59: 
                    case 61: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 76: 
                    case 79: 
                    case 89: 
                    case 93: 
                    case 101: 
                    case 106: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: {
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[3] = jj_gen;
                        break block13;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 3: 
                    case 14: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 38: 
                    case 42: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 76: 
                    case 79: 
                    case 89: 
                    case 93: 
                    case 101: 
                    case 106: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: {
                        Property property = PrismParser.Property();
                        propertiesFile.addProperty(property);
                        block12: while (true) {
                            PrismParser.jj_consume_token(86);
                            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                                case 86: {
                                    continue block12;
                                }
                            }
                            break;
                        }
                        PrismParser.jj_la1[4] = jj_gen;
                        continue block11;
                    }
                    case 35: {
                        PrismParser.LabelDef(propertiesFile.getLabelList());
                        continue block11;
                    }
                    case 6: 
                    case 59: 
                    case 61: {
                        PrismParser.ConstantDef(propertiesFile.getConstantList());
                        continue block11;
                    }
                }
                break;
            }
            PrismParser.jj_la1[5] = jj_gen;
            PrismParser.jj_consume_token(-1);
            throw new ParseException();
        }
        PrismParser.jj_consume_token(0);
        propertiesFile.setPosition(token, PrismParser.getToken(0));
        return propertiesFile;
    }

    public static final PropertiesFile PropertiesFileSemicolonless() throws ParseException, PrismLangException {
        Token token;
        PropertiesFile propertiesFile;
        block13: {
            propertiesFile = new PropertiesFile(modelInfo);
            token = null;
            token = PrismParser.getToken(1);
            block11: while (true) {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 3: 
                    case 6: 
                    case 14: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 35: 
                    case 38: 
                    case 42: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 59: 
                    case 61: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 76: 
                    case 79: 
                    case 89: 
                    case 93: 
                    case 101: 
                    case 106: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: {
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[6] = jj_gen;
                        break block13;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 3: 
                    case 14: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 38: 
                    case 42: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 76: 
                    case 79: 
                    case 89: 
                    case 93: 
                    case 101: 
                    case 106: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: {
                        Property property = PrismParser.Property();
                        block12: while (true) {
                            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                                case 86: {
                                    break;
                                }
                                default: {
                                    PrismParser.jj_la1[7] = jj_gen;
                                    break block12;
                                }
                            }
                            PrismParser.jj_consume_token(86);
                        }
                        propertiesFile.addProperty(property);
                        continue block11;
                    }
                    case 35: {
                        PrismParser.LabelDef(propertiesFile.getLabelList());
                        continue block11;
                    }
                    case 6: 
                    case 59: 
                    case 61: {
                        PrismParser.ConstantDef(propertiesFile.getConstantList());
                        continue block11;
                    }
                }
                break;
            }
            PrismParser.jj_la1[8] = jj_gen;
            PrismParser.jj_consume_token(-1);
            throw new ParseException();
        }
        PrismParser.jj_consume_token(0);
        propertiesFile.setPosition(token, PrismParser.getToken(0));
        return propertiesFile;
    }

    public static final Property Property() throws ParseException, PrismLangException {
        String string = null;
        Token token = null;
        token = PrismParser.getToken(1);
        if (PrismParser.jj_2_2(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(113);
            string = PrismParser.Identifier();
            PrismParser.jj_consume_token(113);
            PrismParser.jj_consume_token(85);
        }
        Expression expression = PrismParser.ExpressionITE(true, false);
        Property property = new Property(expression, string, PrismParser.getPrecedingCommentBlock(token));
        property.setPosition(token, PrismParser.getToken(0));
        return property;
    }

    public static final Expression SingleExpression() throws ParseException, PrismLangException {
        Expression expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(0);
        return expression;
    }

    public static final Expression SingleLTLFormula() throws ParseException, PrismLangException {
        Expression expression = PrismParser.Expression(true, true);
        PrismParser.jj_consume_token(0);
        return expression;
    }

    public static final ModelType ModulesFileType() throws ParseException {
        ModelType modelType = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 13: 
            case 58: {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 13: {
                        PrismParser.jj_consume_token(13);
                        break;
                    }
                    case 58: {
                        PrismParser.jj_consume_token(58);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[9] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                modelType = ModelType.DTMC;
                break;
            }
            case 39: 
            case 45: {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 39: {
                        PrismParser.jj_consume_token(39);
                        break;
                    }
                    case 45: {
                        PrismParser.jj_consume_token(45);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[10] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                modelType = ModelType.MDP;
                break;
            }
            case 8: 
            case 71: {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 8: {
                        PrismParser.jj_consume_token(8);
                        break;
                    }
                    case 71: {
                        PrismParser.jj_consume_token(71);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[11] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                modelType = ModelType.CTMC;
                break;
            }
            case 9: {
                PrismParser.jj_consume_token(9);
                modelType = ModelType.CTMDP;
                break;
            }
            case 60: {
                PrismParser.jj_consume_token(60);
                modelType = ModelType.PTA;
                break;
            }
            case 56: {
                PrismParser.jj_consume_token(56);
                modelType = ModelType.POMDP;
                break;
            }
            case 57: {
                PrismParser.jj_consume_token(57);
                modelType = ModelType.POPTA;
                break;
            }
            case 72: {
                PrismParser.jj_consume_token(72);
                modelType = ModelType.STPG;
                break;
            }
            case 73: {
                PrismParser.jj_consume_token(73);
                modelType = ModelType.SMG;
                break;
            }
            case 75: {
                PrismParser.jj_consume_token(75);
                modelType = ModelType.TPTG;
                break;
            }
            case 7: {
                PrismParser.jj_consume_token(7);
                modelType = ModelType.CSG;
                break;
            }
            default: {
                PrismParser.jj_la1[12] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return modelType;
    }

    public static final void FormulaDef(FormulaList formulaList) throws ParseException, PrismLangException {
        ExpressionIdent expressionIdent = null;
        Expression expression = null;
        PrismParser.jj_consume_token(23);
        expressionIdent = PrismParser.IdentifierExpression();
        PrismParser.jj_consume_token(97);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(86);
        formulaList.addFormula(expressionIdent, expression);
    }

    public static final void LabelDef(LabelList labelList) throws ParseException, PrismLangException {
        ExpressionIdent expressionIdent = null;
        Expression expression = null;
        if (!PrismParser.jj_2_3(Integer.MAX_VALUE)) {
            if (PrismParser.jj_2_4(Integer.MAX_VALUE)) {
                PrismParser.jj_consume_token(35);
                expressionIdent = PrismParser.IdentifierExpression();
                throw new PrismLangException("Label names must be enclosed in double-quotes", expressionIdent);
            }
            PrismParser.jj_consume_token(-1);
            throw new ParseException();
        }
        PrismParser.jj_consume_token(35);
        PrismParser.jj_consume_token(113);
        expressionIdent = PrismParser.IdentifierExpression();
        PrismParser.jj_consume_token(113);
        PrismParser.jj_consume_token(97);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(86);
        labelList.addLabel(expressionIdent, expression);
    }

    public static final void ConstantDef(ConstantList constantList) throws ParseException, PrismLangException {
        Type type = TypeInt.getInstance();
        ExpressionIdent expressionIdent = null;
        Expression expression = null;
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 6: {
                PrismParser.jj_consume_token(6);
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 4: 
                    case 12: 
                    case 34: {
                        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                            case 34: {
                                PrismParser.jj_consume_token(34);
                                type = TypeInt.getInstance();
                                break block0;
                            }
                            case 12: {
                                PrismParser.jj_consume_token(12);
                                type = TypeDouble.getInstance();
                                break block0;
                            }
                            case 4: {
                                PrismParser.jj_consume_token(4);
                                type = TypeBool.getInstance();
                                break block0;
                            }
                        }
                        PrismParser.jj_la1[13] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                PrismParser.jj_la1[14] = jj_gen;
                break;
            }
            case 59: 
            case 61: {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 61: {
                        PrismParser.jj_consume_token(61);
                        break;
                    }
                    case 59: {
                        PrismParser.jj_consume_token(59);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[15] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                type = TypeDouble.getInstance();
                break;
            }
            default: {
                PrismParser.jj_la1[16] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expressionIdent = PrismParser.IdentifierExpression();
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 97: {
                PrismParser.jj_consume_token(97);
                expression = PrismParser.Expression(false, false);
                break;
            }
            default: {
                PrismParser.jj_la1[17] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(86);
        constantList.addConstant(expressionIdent, expression, type);
    }

    public static final Declaration GlobalDecl() throws ParseException, PrismLangException {
        Declaration declaration = null;
        PrismParser.jj_consume_token(29);
        declaration = PrismParser.Declaration();
        return declaration;
    }

    public static final Declaration Declaration() throws ParseException, PrismLangException {
        String string = null;
        Expression expression = null;
        Token token = null;
        token = PrismParser.getToken(1);
        string = PrismParser.Identifier();
        PrismParser.jj_consume_token(85);
        DeclarationType declarationType = PrismParser.DeclarationVarType();
        Declaration declaration = new Declaration(string, declarationType);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 31: {
                PrismParser.jj_consume_token(31);
                expression = PrismParser.Expression(false, false);
                declaration.setStart(expression);
                break;
            }
            default: {
                PrismParser.jj_la1[18] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(86);
        declaration.setPosition(token, PrismParser.getToken(0));
        return declaration;
    }

    public static final DeclarationType DeclarationVarType() throws ParseException, PrismLangException {
        DeclarationType declarationType;
        Expression expression = null;
        Expression expression2 = null;
        Token token = null;
        token = PrismParser.getToken(1);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 91: {
                PrismParser.jj_consume_token(91);
                expression = PrismParser.Expression(false, false);
                PrismParser.jj_consume_token(88);
                expression2 = PrismParser.Expression(false, false);
                PrismParser.jj_consume_token(92);
                declarationType = new DeclarationInt(expression, expression2);
                break;
            }
            case 34: {
                PrismParser.jj_consume_token(34);
                declarationType = new DeclarationIntUnbounded();
                break;
            }
            case 4: {
                PrismParser.jj_consume_token(4);
                declarationType = new DeclarationBool();
                break;
            }
            case 5: {
                PrismParser.jj_consume_token(5);
                declarationType = new DeclarationClock();
                break;
            }
            default: {
                PrismParser.jj_la1[19] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        declarationType.setPosition(token, PrismParser.getToken(0));
        return declarationType;
    }

    public static final Module Module() throws ParseException, PrismLangException {
        ExpressionIdent expressionIdent = null;
        Declaration declaration = null;
        Command command = null;
        Module module = null;
        Token token = null;
        token = PrismParser.jj_consume_token(43);
        expressionIdent = PrismParser.IdentifierExpression();
        module = new Module(expressionIdent.getName());
        block9: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 117: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[20] = jj_gen;
                    break block9;
                }
            }
            declaration = PrismParser.Declaration();
            module.addDeclaration(declaration);
        }
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 32: {
                PrismParser.jj_consume_token(32);
                Expression expression = PrismParser.Expression(false, false);
                PrismParser.jj_consume_token(16);
                module.setInvariant(expression);
                break;
            }
            default: {
                PrismParser.jj_la1[21] = jj_gen;
            }
        }
        block10: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 91: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[22] = jj_gen;
                    break block10;
                }
            }
            command = PrismParser.Command();
            module.addCommand(command);
        }
        PrismParser.jj_consume_token(17);
        module.setPosition(token, PrismParser.getToken(0));
        module.setNameASTElement(expressionIdent);
        return module;
    }

    public static final Command Command() throws ParseException, PrismLangException {
        List<String> list = null;
        Expression expression = null;
        Updates updates = null;
        Command command = new Command();
        Token token = null;
        token = PrismParser.jj_consume_token(91);
        list = PrismParser.ActionList();
        command.setSynchs(list);
        PrismParser.jj_consume_token(92);
        expression = PrismParser.Expression(false, false);
        command.setGuard(expression);
        PrismParser.jj_consume_token(84);
        updates = PrismParser.Updates();
        command.setUpdates(updates);
        PrismParser.jj_consume_token(86);
        command.setPosition(token, PrismParser.getToken(0));
        return command;
    }

    public static final Updates Updates() throws ParseException, PrismLangException {
        Updates updates = new Updates();
        Token token = null;
        token = PrismParser.getToken(1);
        if (PrismParser.jj_2_5(Integer.MAX_VALUE)) {
            Update update = PrismParser.Update();
            updates.addUpdate(null, update);
        } else {
            block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 3: 
                case 14: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 30: 
                case 38: 
                case 42: 
                case 44: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 76: 
                case 79: 
                case 89: 
                case 91: 
                case 93: 
                case 101: 
                case 106: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    Expression expression = PrismParser.ProbOrRateOrInterval();
                    PrismParser.jj_consume_token(85);
                    Update update = PrismParser.Update();
                    updates.addUpdate(expression, update);
                    while (true) {
                        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                            case 105: {
                                break;
                            }
                            default: {
                                PrismParser.jj_la1[23] = jj_gen;
                                break block0;
                            }
                        }
                        PrismParser.jj_consume_token(105);
                        expression = PrismParser.ProbOrRateOrInterval();
                        PrismParser.jj_consume_token(85);
                        update = PrismParser.Update();
                        updates.addUpdate(expression, update);
                    }
                }
                default: {
                    PrismParser.jj_la1[24] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        updates.setPosition(token, PrismParser.getToken(0));
        return updates;
    }

    public static final Expression ProbOrRateOrInterval() throws ParseException, PrismLangException {
        Expression expression;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 3: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 38: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 76: 
            case 79: 
            case 89: 
            case 93: 
            case 101: 
            case 106: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                expression = PrismParser.Expression(false, false);
                break;
            }
            case 91: {
                expression = PrismParser.ExpressionInterval(false, false);
                break;
            }
            default: {
                PrismParser.jj_la1[25] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final Update Update() throws ParseException, PrismLangException {
        Update update = new Update();
        Token token = null;
        token = PrismParser.getToken(1);
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 89: {
                PrismParser.UpdateElement(update);
                while (true) {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 80: {
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[26] = jj_gen;
                            break block0;
                        }
                    }
                    PrismParser.jj_consume_token(80);
                    PrismParser.UpdateElement(update);
                }
            }
            case 76: {
                PrismParser.jj_consume_token(76);
                break;
            }
            default: {
                PrismParser.jj_la1[27] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        update.setPosition(token, PrismParser.getToken(0));
        return update;
    }

    public static final void UpdateElement(Update update) throws ParseException, PrismLangException {
        ExpressionIdent expressionIdent = null;
        Expression expression = null;
        Token token = null;
        token = PrismParser.jj_consume_token(89);
        expressionIdent = PrismParser.IdentifierPrime();
        PrismParser.jj_consume_token(97);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(90);
        UpdateElement updateElement = new UpdateElement(expressionIdent, expression);
        updateElement.setPosition(token, PrismParser.getToken(0));
        update.addElement(updateElement);
    }

    public static final RenamedModule RenamedModule() throws ParseException, PrismLangException {
        ExpressionIdent expressionIdent = null;
        ExpressionIdent expressionIdent2 = null;
        RenamedModule renamedModule = null;
        Token token = null;
        token = PrismParser.jj_consume_token(43);
        expressionIdent = PrismParser.IdentifierExpression();
        PrismParser.jj_consume_token(97);
        expressionIdent2 = PrismParser.IdentifierExpression();
        renamedModule = new RenamedModule(expressionIdent.getName(), expressionIdent2.getName());
        PrismParser.jj_consume_token(91);
        PrismParser.Rename(renamedModule);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 87: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[28] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(87);
            PrismParser.Rename(renamedModule);
        }
        PrismParser.jj_consume_token(92);
        PrismParser.jj_consume_token(17);
        renamedModule.setPosition(token, PrismParser.getToken(0));
        renamedModule.setNameASTElement(expressionIdent);
        renamedModule.setBaseModuleASTElement(expressionIdent2);
        return renamedModule;
    }

    public static final void Rename(RenamedModule renamedModule) throws ParseException {
        ExpressionIdent expressionIdent = null;
        ExpressionIdent expressionIdent2 = null;
        expressionIdent = PrismParser.IdentifierExpressionMinMax();
        PrismParser.jj_consume_token(97);
        expressionIdent2 = PrismParser.IdentifierExpressionMinMax();
        renamedModule.addRename(expressionIdent.getName(), expressionIdent2.getName(), expressionIdent, expressionIdent2);
    }

    public static final RewardStruct RewardStruct() throws ParseException, PrismLangException {
        String string = null;
        Object var1_1 = null;
        Expression expression = null;
        Expression expression2 = null;
        RewardStruct rewardStruct = new RewardStruct();
        Token token = null;
        Token token2 = null;
        List<String> list = null;
        token = PrismParser.jj_consume_token(62);
        if (PrismParser.jj_2_6(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(113);
            string = PrismParser.Identifier();
            PrismParser.jj_consume_token(113);
            rewardStruct.setName(string);
        }
        block6: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 3: 
                case 14: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 30: 
                case 38: 
                case 42: 
                case 44: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 76: 
                case 79: 
                case 89: 
                case 91: 
                case 93: 
                case 101: 
                case 106: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[29] = jj_gen;
                    break block6;
                }
            }
            token2 = PrismParser.getToken(1);
            list = null;
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 91: {
                    PrismParser.jj_consume_token(91);
                    list = PrismParser.ActionList();
                    PrismParser.jj_consume_token(92);
                    break;
                }
                default: {
                    PrismParser.jj_la1[30] = jj_gen;
                }
            }
            expression = PrismParser.Expression(false, false);
            PrismParser.jj_consume_token(85);
            expression2 = PrismParser.Expression(false, false);
            PrismParser.jj_consume_token(86);
            RewardStructItem rewardStructItem = new RewardStructItem(list, expression, expression2);
            rewardStructItem.setPosition(token2, PrismParser.getToken(0));
            rewardStruct.addItem(rewardStructItem);
        }
        PrismParser.jj_consume_token(20);
        rewardStruct.setPosition(token, PrismParser.getToken(0));
        return rewardStruct;
    }

    public static final List<String> ActionList() throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 117: {
                String string = PrismParser.Identifier();
                arrayList.add(string);
                while (true) {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 87: {
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[31] = jj_gen;
                            break block0;
                        }
                    }
                    PrismParser.jj_consume_token(87);
                    string = PrismParser.Identifier();
                    arrayList.add(string);
                }
            }
            default: {
                PrismParser.jj_la1[32] = jj_gen;
            }
        }
        return arrayList;
    }

    public static final Expression Init() throws ParseException, PrismLangException {
        Expression expression = null;
        PrismParser.jj_consume_token(31);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(15);
        return expression;
    }

    public static final ObservableVars ObservableVars() throws ParseException {
        Token token = null;
        ObservableVars observableVars = null;
        ExpressionIdent expressionIdent = null;
        token = PrismParser.getToken(1);
        PrismParser.jj_consume_token(47);
        observableVars = new ObservableVars();
        expressionIdent = PrismParser.IdentifierExpression();
        observableVars.addVar(expressionIdent);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 87: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[33] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(87);
            expressionIdent = PrismParser.IdentifierExpression();
            observableVars.addVar(expressionIdent);
        }
        PrismParser.jj_consume_token(18);
        observableVars.setPosition(token, PrismParser.getToken(0));
        return observableVars;
    }

    public static final Observable Observable() throws ParseException, PrismLangException {
        Token token = null;
        String string = null;
        Expression expression = null;
        token = PrismParser.getToken(1);
        PrismParser.jj_consume_token(46);
        PrismParser.jj_consume_token(113);
        string = PrismParser.Identifier();
        PrismParser.jj_consume_token(113);
        PrismParser.jj_consume_token(97);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(86);
        Observable observable = new Observable(string, expression);
        observable.setPosition(token, PrismParser.getToken(0));
        return observable;
    }

    public static final void SystemEndsystem(ModulesFile modulesFile) throws ParseException {
        String string = null;
        PrismParser.jj_consume_token(74);
        if (PrismParser.jj_2_7(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(113);
            string = PrismParser.Identifier();
            PrismParser.jj_consume_token(113);
        }
        SystemDefn systemDefn = PrismParser.SystemDefn();
        PrismParser.jj_consume_token(21);
        modulesFile.addSystemDefn(systemDefn, string);
    }

    public static final SystemDefn SystemDefn() throws ParseException {
        SystemDefn systemDefn = PrismParser.SystemFullParallel();
        return systemDefn;
    }

    public static final SystemDefn SystemFullParallel() throws ParseException {
        SystemDefn systemDefn = null;
        SystemDefn systemDefn2 = null;
        SystemFullParallel systemFullParallel = null;
        Token token = PrismParser.getToken(1);
        systemDefn = PrismParser.SystemInterleaved();
        systemFullParallel = new SystemFullParallel();
        systemFullParallel.addOperand(systemDefn);
        while (PrismParser.jj_2_8(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(81);
            PrismParser.jj_consume_token(81);
            systemDefn2 = PrismParser.SystemParallel();
            systemFullParallel.addOperand(systemDefn2);
        }
        if (systemFullParallel == null || systemFullParallel.getNumOperands() == 1) {
            return systemDefn;
        }
        systemFullParallel.setPosition(token, PrismParser.getToken(0));
        return systemFullParallel;
    }

    public static final SystemDefn SystemInterleaved() throws ParseException {
        SystemDefn systemDefn = null;
        SystemDefn systemDefn2 = null;
        SystemInterleaved systemInterleaved = null;
        Token token = PrismParser.getToken(1);
        systemDefn = PrismParser.SystemParallel();
        systemInterleaved = new SystemInterleaved();
        systemInterleaved.addOperand(systemDefn);
        while (PrismParser.jj_2_9(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(81);
            PrismParser.jj_consume_token(81);
            PrismParser.jj_consume_token(81);
            systemDefn2 = PrismParser.SystemFullParallel();
            systemInterleaved.addOperand(systemDefn2);
        }
        if (systemInterleaved == null || systemInterleaved.getNumOperands() == 1) {
            return systemDefn;
        }
        systemInterleaved.setPosition(token, PrismParser.getToken(0));
        return systemInterleaved;
    }

    public static final SystemDefn SystemParallel() throws ParseException {
        SystemDefn systemDefn = null;
        SystemDefn systemDefn2 = null;
        SystemParallel systemParallel = null;
        Token token = PrismParser.getToken(1);
        systemDefn = PrismParser.SystemHideRename();
        if (PrismParser.jj_2_10(Integer.MAX_VALUE)) {
            systemParallel = new SystemParallel();
            systemParallel.setOperand1(systemDefn);
            PrismParser.jj_consume_token(81);
            PrismParser.jj_consume_token(91);
            String string = PrismParser.Identifier();
            systemParallel.addAction(string);
            block3: while (true) {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 87: {
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[34] = jj_gen;
                        break block3;
                    }
                }
                PrismParser.jj_consume_token(87);
                string = PrismParser.Identifier();
                systemParallel.addAction(string);
            }
            PrismParser.jj_consume_token(92);
            PrismParser.jj_consume_token(81);
            systemDefn2 = PrismParser.SystemHideRename();
            systemParallel.setOperand2(systemDefn2);
        }
        if (systemParallel == null) {
            return systemDefn;
        }
        systemParallel.setPosition(token, PrismParser.getToken(0));
        return systemParallel;
    }

    public static final SystemDefn SystemHideRename() throws ParseException {
        Token token;
        SystemDefn systemDefn;
        block16: {
            systemDefn = null;
            SystemHide systemHide = null;
            SystemRename systemRename = null;
            String string = null;
            String string2 = null;
            token = PrismParser.getToken(1);
            systemDefn = PrismParser.SystemAtomic();
            block13: while (true) {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 95: 
                    case 108: {
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[35] = jj_gen;
                        break block16;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 108: {
                        systemHide = new SystemHide(systemDefn);
                        PrismParser.jj_consume_token(108);
                        PrismParser.jj_consume_token(95);
                        string = PrismParser.Identifier();
                        systemHide.addAction(string);
                        block14: while (true) {
                            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                                case 87: {
                                    break;
                                }
                                default: {
                                    PrismParser.jj_la1[36] = jj_gen;
                                    break block14;
                                }
                            }
                            PrismParser.jj_consume_token(87);
                            string = PrismParser.Identifier();
                            systemHide.addAction(string);
                        }
                        PrismParser.jj_consume_token(96);
                        systemDefn = systemHide;
                        continue block13;
                    }
                    case 95: {
                        systemRename = new SystemRename(systemDefn);
                        PrismParser.jj_consume_token(95);
                        string = PrismParser.Identifier();
                        PrismParser.jj_consume_token(111);
                        string2 = PrismParser.Identifier();
                        systemRename.addRename(string, string2);
                        block15: while (true) {
                            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                                case 87: {
                                    break;
                                }
                                default: {
                                    PrismParser.jj_la1[37] = jj_gen;
                                    break block15;
                                }
                            }
                            PrismParser.jj_consume_token(87);
                            string = PrismParser.Identifier();
                            PrismParser.jj_consume_token(111);
                            string2 = PrismParser.Identifier();
                            systemRename.addRename(string, string2);
                        }
                        PrismParser.jj_consume_token(96);
                        systemDefn = systemRename;
                        continue block13;
                    }
                }
                break;
            }
            PrismParser.jj_la1[38] = jj_gen;
            PrismParser.jj_consume_token(-1);
            throw new ParseException();
        }
        systemDefn.setPosition(token, PrismParser.getToken(0));
        return systemDefn;
    }

    public static final SystemDefn SystemAtomic() throws ParseException {
        String string = null;
        SystemDefn systemDefn = null;
        Token token = PrismParser.getToken(1);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 117: {
                string = PrismParser.Identifier();
                systemDefn = new SystemModule(string);
                break;
            }
            case 113: {
                PrismParser.jj_consume_token(113);
                string = PrismParser.Identifier();
                PrismParser.jj_consume_token(113);
                systemDefn = new SystemReference(string);
                break;
            }
            case 89: {
                PrismParser.jj_consume_token(89);
                systemDefn = PrismParser.SystemDefn();
                PrismParser.jj_consume_token(90);
                systemDefn = new SystemBrackets(systemDefn);
                break;
            }
            default: {
                PrismParser.jj_la1[39] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        systemDefn.setPosition(token, PrismParser.getToken(0));
        return systemDefn;
    }

    public static final Player Player() throws ParseException {
        String string = null;
        Player player = null;
        Token token = PrismParser.getToken(1);
        PrismParser.jj_consume_token(55);
        string = PrismParser.Identifier();
        player = new Player(string);
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 91: 
            case 117: {
                PrismParser.PlayerItem(player);
                while (true) {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 87: {
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[40] = jj_gen;
                            break block0;
                        }
                    }
                    PrismParser.jj_consume_token(87);
                    PrismParser.PlayerItem(player);
                }
            }
            default: {
                PrismParser.jj_la1[41] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(19);
        player.setPosition(token, PrismParser.getToken(0));
        return player;
    }

    public static final void PlayerItem(Player player) throws ParseException {
        String string = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 91: {
                PrismParser.jj_consume_token(91);
                string = PrismParser.Identifier();
                PrismParser.jj_consume_token(92);
                player.addAction(string);
                break;
            }
            case 117: {
                string = PrismParser.Identifier();
                player.addModule(string);
                break;
            }
            default: {
                PrismParser.jj_la1[42] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final Expression Expression(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Expression expression = PrismParser.ExpressionTemporalBinary(bl, bl2);
        return expression;
    }

    public static final Expression ExpressionTemporalBinary(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionTemporalUnary(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 69: 
            case 77: 
            case 78: {
                if (!bl2) {
                    throw PrismParser.generateParseException();
                }
                ExpressionTemporal expressionTemporal = new ExpressionTemporal();
                expressionTemporal.setOperand1(expression);
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 77: {
                        PrismParser.jj_consume_token(77);
                        expressionTemporal.setOperator(2);
                        break;
                    }
                    case 78: {
                        PrismParser.jj_consume_token(78);
                        expressionTemporal.setOperator(5);
                        break;
                    }
                    case 69: {
                        PrismParser.jj_consume_token(69);
                        expressionTemporal.setOperator(6);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[43] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 91: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 103: 
                    case 104: {
                        PrismParser.TimeBound(expressionTemporal);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[44] = jj_gen;
                    }
                }
                Expression expression2 = PrismParser.ExpressionTemporalUnary(bl, bl2);
                expressionTemporal.setOperand2(expression2);
                expressionTemporal.setPosition(token, PrismParser.getToken(0));
                expression = expressionTemporal;
                break;
            }
            default: {
                PrismParser.jj_la1[45] = jj_gen;
            }
        }
        return expression;
    }

    public static final Expression ExpressionTemporalUnary(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Expression expression;
        Token token = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 26: 
            case 30: 
            case 44: {
                if (!bl2) {
                    throw PrismParser.generateParseException();
                }
                token = PrismParser.getToken(1);
                ExpressionTemporal expressionTemporal = new ExpressionTemporal();
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 44: {
                        PrismParser.jj_consume_token(44);
                        expressionTemporal.setOperator(1);
                        break;
                    }
                    case 26: {
                        PrismParser.jj_consume_token(26);
                        expressionTemporal.setOperator(3);
                        break;
                    }
                    case 30: {
                        PrismParser.jj_consume_token(30);
                        expressionTemporal.setOperator(4);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[46] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 91: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 103: 
                    case 104: {
                        PrismParser.TimeBound(expressionTemporal);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[47] = jj_gen;
                    }
                }
                Expression expression2 = PrismParser.ExpressionTemporalUnary(bl, bl2);
                expressionTemporal.setOperand2(expression2);
                expressionTemporal.setPosition(token, PrismParser.getToken(0));
                expression = expressionTemporal;
                break;
            }
            case 3: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 38: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 76: 
            case 79: 
            case 89: 
            case 93: 
            case 101: 
            case 106: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                expression = PrismParser.ExpressionITE(bl, bl2);
                break;
            }
            default: {
                PrismParser.jj_la1[48] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final void TimeBound(ExpressionTemporal expressionTemporal) throws ParseException, PrismLangException {
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 103: {
                Expression expression;
                PrismParser.jj_consume_token(103);
                if (PrismParser.jj_2_11(Integer.MAX_VALUE)) {
                    expression = PrismParser.IdentifierExpression();
                } else {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 3: 
                        case 14: 
                        case 22: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 30: 
                        case 38: 
                        case 42: 
                        case 44: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 76: 
                        case 79: 
                        case 89: 
                        case 93: 
                        case 101: 
                        case 106: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: {
                            expression = PrismParser.Expression(false, false);
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[49] = jj_gen;
                            PrismParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                expressionTemporal.setUpperBound(expression, false);
                break;
            }
            case 99: {
                Expression expression;
                PrismParser.jj_consume_token(99);
                if (PrismParser.jj_2_12(Integer.MAX_VALUE)) {
                    expression = PrismParser.IdentifierExpression();
                } else {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 3: 
                        case 14: 
                        case 22: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 30: 
                        case 38: 
                        case 42: 
                        case 44: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 76: 
                        case 79: 
                        case 89: 
                        case 93: 
                        case 101: 
                        case 106: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: {
                            expression = PrismParser.Expression(false, false);
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[50] = jj_gen;
                            PrismParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                expressionTemporal.setUpperBound(expression, true);
                break;
            }
            case 104: {
                Expression expression;
                PrismParser.jj_consume_token(104);
                if (PrismParser.jj_2_13(Integer.MAX_VALUE)) {
                    expression = PrismParser.IdentifierExpression();
                } else {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 3: 
                        case 14: 
                        case 22: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 30: 
                        case 38: 
                        case 42: 
                        case 44: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 76: 
                        case 79: 
                        case 89: 
                        case 93: 
                        case 101: 
                        case 106: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: {
                            expression = PrismParser.Expression(false, false);
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[51] = jj_gen;
                            PrismParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                expressionTemporal.setLowerBound(expression, false);
                break;
            }
            case 100: {
                Expression expression;
                PrismParser.jj_consume_token(100);
                if (PrismParser.jj_2_14(Integer.MAX_VALUE)) {
                    expression = PrismParser.IdentifierExpression();
                } else {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 3: 
                        case 14: 
                        case 22: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 30: 
                        case 38: 
                        case 42: 
                        case 44: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 76: 
                        case 79: 
                        case 89: 
                        case 93: 
                        case 101: 
                        case 106: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: {
                            expression = PrismParser.Expression(false, false);
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[52] = jj_gen;
                            PrismParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                expressionTemporal.setLowerBound(expression, true);
                break;
            }
            case 91: {
                PrismParser.jj_consume_token(91);
                Expression expression = PrismParser.Expression(false, false);
                PrismParser.jj_consume_token(87);
                Expression expression2 = PrismParser.Expression(false, false);
                PrismParser.jj_consume_token(92);
                expressionTemporal.setLowerBound(expression, false);
                expressionTemporal.setUpperBound(expression2, false);
                break;
            }
            case 97: {
                PrismParser.jj_consume_token(97);
                Expression expression = PrismParser.Expression(false, false);
                expressionTemporal.setEqualBounds(expression);
                break;
            }
            default: {
                PrismParser.jj_la1[53] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final Expression ExpressionITE(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionImplies(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 112: {
                PrismParser.jj_consume_token(112);
                Expression expression2 = PrismParser.ExpressionImplies(bl, bl2);
                PrismParser.jj_consume_token(85);
                Expression expression3 = PrismParser.ExpressionITE(bl, bl2);
                expression = new ExpressionITE(expression, expression2, expression3);
                expression.setPosition(token, PrismParser.getToken(0));
                break;
            }
            default: {
                PrismParser.jj_la1[54] = jj_gen;
            }
        }
        return expression;
    }

    public static final Expression ExpressionImplies(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionIff(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 82: {
                PrismParser.jj_consume_token(82);
                Expression expression2 = PrismParser.ExpressionImplies(bl, bl2);
                expression = new ExpressionBinaryOp(1, expression, expression2);
                expression.setPosition(token, PrismParser.getToken(0));
                break;
            }
            default: {
                PrismParser.jj_la1[55] = jj_gen;
            }
        }
        return expression;
    }

    public static final Expression ExpressionIff(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionOr(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 83: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[56] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(83);
            Expression expression2 = PrismParser.ExpressionOr(bl, bl2);
            expression = new ExpressionBinaryOp(2, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionOr(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionAnd(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 81: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[57] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(81);
            Expression expression2 = PrismParser.ExpressionAnd(bl, bl2);
            expression = new ExpressionBinaryOp(3, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionAnd(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionNot(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 80: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[58] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(80);
            Expression expression2 = PrismParser.ExpressionNot(bl, bl2);
            expression = new ExpressionBinaryOp(4, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionNot(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Expression expression;
        Token token = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 79: {
                token = PrismParser.jj_consume_token(79);
                Expression expression2 = PrismParser.ExpressionNot(bl, bl2);
                expression = new ExpressionUnaryOp(1, expression2);
                expression.setPosition(token, PrismParser.getToken(0));
                break;
            }
            case 3: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 38: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 76: 
            case 89: 
            case 93: 
            case 101: 
            case 106: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                expression = PrismParser.ExpressionEquality(bl, bl2);
                break;
            }
            default: {
                PrismParser.jj_la1[59] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final Expression ExpressionEquality(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionRelop(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 97: 
                case 98: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[60] = jj_gen;
                    break block3;
                }
            }
            int n = PrismParser.EqNeq();
            Expression expression2 = PrismParser.ExpressionRelop(bl, bl2);
            expression = new ExpressionBinaryOp(n, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionRelop(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionPlusMinus(bl, bl2);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 99: 
                case 100: 
                case 103: 
                case 104: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[61] = jj_gen;
                    break block3;
                }
            }
            int n = PrismParser.LtGt();
            Expression expression2 = PrismParser.ExpressionPlusMinus(bl, bl2);
            expression = new ExpressionBinaryOp(n, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionPlusMinus(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionTimesDivide(bl, bl2);
        block7: while (true) {
            int n;
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 105: 
                case 106: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[62] = jj_gen;
                    break block7;
                }
            }
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 105: {
                    PrismParser.jj_consume_token(105);
                    n = 11;
                    break;
                }
                case 106: {
                    PrismParser.jj_consume_token(106);
                    n = 12;
                    break;
                }
                default: {
                    PrismParser.jj_la1[63] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression expression2 = PrismParser.ExpressionTimesDivide(bl, bl2);
            expression = new ExpressionBinaryOp(n, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionTimesDivide(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionPower(bl, bl2);
        block7: while (true) {
            int n;
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 107: 
                case 108: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[64] = jj_gen;
                    break block7;
                }
            }
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 107: {
                    PrismParser.jj_consume_token(107);
                    n = 13;
                    break;
                }
                case 108: {
                    PrismParser.jj_consume_token(108);
                    n = 14;
                    break;
                }
                default: {
                    PrismParser.jj_la1[65] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression expression2 = PrismParser.ExpressionPower(bl, bl2);
            expression = new ExpressionBinaryOp(n, expression, expression2);
            expression.setPosition(token, PrismParser.getToken(0));
        }
        return expression;
    }

    public static final Expression ExpressionPower(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.getToken(1);
        Expression expression = PrismParser.ExpressionUnaryMinus(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 109: {
                PrismParser.jj_consume_token(109);
                Expression expression2 = PrismParser.ExpressionPower(bl, bl2);
                expression = new ExpressionBinaryOp(15, expression, expression2);
                expression.setPosition(token, PrismParser.getToken(0));
                break;
            }
            default: {
                PrismParser.jj_la1[66] = jj_gen;
            }
        }
        return expression;
    }

    public static final Expression ExpressionUnaryMinus(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Expression expression;
        Token token = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 106: {
                token = PrismParser.jj_consume_token(106);
                Expression expression2 = PrismParser.ExpressionUnaryMinus(bl, bl2);
                expression = new ExpressionUnaryOp(2, expression2);
                expression.setPosition(token, PrismParser.getToken(0));
                break;
            }
            case 3: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 38: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 76: 
            case 89: 
            case 93: 
            case 101: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                expression = PrismParser.ExpressionBasic(bl, bl2);
                break;
            }
            default: {
                PrismParser.jj_la1[67] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final Expression ExpressionBasic(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Expression expression;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 22: 
            case 76: 
            case 114: 
            case 115: {
                expression = PrismParser.ExpressionLiteral(bl, bl2);
                break;
            }
            case 116: 
            case 117: {
                expression = PrismParser.ExpressionFuncOrIdent(bl, bl2);
                break;
            }
            case 38: 
            case 42: {
                expression = PrismParser.ExpressionFuncMinMax(bl, bl2);
                break;
            }
            case 25: {
                expression = PrismParser.ExpressionFuncOldStyle(bl, bl2);
                break;
            }
            case 89: {
                expression = PrismParser.ExpressionParenth(bl, bl2);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                expression = PrismParser.ExpressionProb(bl, bl2);
                break;
            }
            case 70: {
                expression = PrismParser.ExpressionSS(bl, bl2);
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                expression = PrismParser.ExpressionReward(bl, bl2);
                break;
            }
            case 14: {
                expression = PrismParser.ExpressionExists(bl, bl2);
                break;
            }
            case 3: {
                expression = PrismParser.ExpressionForAll(bl, bl2);
                break;
            }
            case 93: 
            case 101: {
                expression = PrismParser.ExpressionStrategy(bl, bl2);
                break;
            }
            case 113: {
                expression = PrismParser.ExpressionLabel(bl, bl2);
                break;
            }
            case 24: {
                expression = PrismParser.ExpressionFilter(bl, bl2);
                break;
            }
            default: {
                PrismParser.jj_la1[68] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final Expression ExpressionFuncOrIdent(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        String string = null;
        Expression expression = null;
        Token token = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 117: {
                string = PrismParser.Identifier();
                expression = new ExpressionIdent(string);
                token = PrismParser.getToken(0);
                break;
            }
            case 116: {
                ExpressionIdent expressionIdent;
                expression = expressionIdent = PrismParser.IdentifierPrime();
                token = PrismParser.getToken(0);
                break;
            }
            default: {
                PrismParser.jj_la1[69] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 89: {
                PrismParser.jj_consume_token(89);
                expression = new ExpressionFunc(string);
                PrismParser.ExpressionFuncArgs(bl, bl2, (ExpressionFunc)expression);
                PrismParser.jj_consume_token(90);
                break;
            }
            default: {
                PrismParser.jj_la1[70] = jj_gen;
            }
        }
        expression.setPosition(token, PrismParser.getToken(0));
        return expression;
    }

    public static final Expression ExpressionFuncMinMax(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        String string = null;
        ExpressionFunc expressionFunc = null;
        Token token = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 42: {
                token = PrismParser.jj_consume_token(42);
                string = "min";
                break;
            }
            case 38: {
                token = PrismParser.jj_consume_token(38);
                string = "max";
                break;
            }
            default: {
                PrismParser.jj_la1[71] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expressionFunc = new ExpressionFunc(string);
        PrismParser.jj_consume_token(89);
        PrismParser.ExpressionFuncArgs(bl, bl2, expressionFunc);
        PrismParser.jj_consume_token(90);
        expressionFunc.setPosition(token, PrismParser.getToken(0));
        return expressionFunc;
    }

    public static final Expression ExpressionFuncOldStyle(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        String string = null;
        ExpressionFunc expressionFunc = null;
        Token token = null;
        token = PrismParser.jj_consume_token(25);
        PrismParser.jj_consume_token(89);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 42: {
                PrismParser.jj_consume_token(42);
                string = "min";
                break;
            }
            case 38: {
                PrismParser.jj_consume_token(38);
                string = "max";
                break;
            }
            case 117: {
                string = PrismParser.Identifier();
                break;
            }
            default: {
                PrismParser.jj_la1[72] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(87);
        expressionFunc = new ExpressionFunc(string);
        expressionFunc.setOldStyle(true);
        PrismParser.ExpressionFuncArgs(bl, bl2, expressionFunc);
        PrismParser.jj_consume_token(90);
        expressionFunc.setPosition(token, PrismParser.getToken(0));
        return expressionFunc;
    }

    public static final void ExpressionFuncArgs(boolean bl, boolean bl2, ExpressionFunc expressionFunc) throws ParseException, PrismLangException {
        Expression expression = PrismParser.Expression(bl, bl2);
        expressionFunc.addOperand(expression);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 87: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[73] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(87);
            expression = PrismParser.Expression(bl, bl2);
            expressionFunc.addOperand(expression);
        }
    }

    public static final Expression ExpressionLiteral(boolean bl, boolean bl2) throws ParseException {
        ExpressionLiteral expressionLiteral = null;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 114: {
                PrismParser.jj_consume_token(114);
                try {
                    int n = Integer.parseInt(PrismParser.getToken((int)0).image);
                    expressionLiteral = new ExpressionLiteral(TypeInt.getInstance(), n);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    ParseException parseException = new ParseException("Invalid integer literal");
                    parseException.currentToken = PrismParser.getToken(0);
                    throw parseException;
                }
            }
            case 115: {
                PrismParser.jj_consume_token(115);
                try {
                    double d = Double.parseDouble(PrismParser.getToken((int)0).image);
                    expressionLiteral = new ExpressionLiteral(TypeDouble.getInstance(), d, PrismParser.getToken((int)0).image);
                }
                catch (NumberFormatException numberFormatException) {
                    ParseException parseException = new ParseException("Invalid double literal");
                }
                break;
            }
            case 76: {
                PrismParser.jj_consume_token(76);
                expressionLiteral = new ExpressionLiteral(TypeBool.getInstance(), true);
                break;
            }
            case 22: {
                PrismParser.jj_consume_token(22);
                expressionLiteral = new ExpressionLiteral(TypeBool.getInstance(), false);
                break;
            }
            default: {
                PrismParser.jj_la1[74] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expressionLiteral.setPosition(PrismParser.getToken(0));
        return expressionLiteral;
    }

    public static final Expression ExpressionParenth(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.jj_consume_token(89);
        Expression expression = PrismParser.Expression(bl, bl2);
        PrismParser.jj_consume_token(90);
        ExpressionUnaryOp expressionUnaryOp = new ExpressionUnaryOp(3, expression);
        expressionUnaryOp.setPosition(token, PrismParser.getToken(0));
        return expressionUnaryOp;
    }

    public static final Expression ExpressionInterval(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        ExpressionInterval expressionInterval = null;
        Expression expression = null;
        Expression expression2 = null;
        Token token = null;
        token = PrismParser.jj_consume_token(91);
        expression = PrismParser.Expression(bl, bl2);
        PrismParser.jj_consume_token(87);
        expression2 = PrismParser.Expression(bl, bl2);
        PrismParser.jj_consume_token(92);
        expressionInterval = new ExpressionInterval(expression, expression2);
        expressionInterval.setPosition(token, PrismParser.getToken(0));
        return expressionInterval;
    }

    public static final Expression ExpressionProb(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        boolean bl3;
        ExpressionIdent expressionIdent = null;
        String string = null;
        Expression expression = null;
        Filter filter = null;
        ExpressionProb expressionProb = new ExpressionProb();
        Token token = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 54: {
                token = PrismParser.jj_consume_token(54);
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 89: {
                        PrismParser.jj_consume_token(89);
                        expressionIdent = PrismParser.IdentifierExpression();
                        PrismParser.jj_consume_token(90);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[75] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 99: 
                    case 100: 
                    case 103: 
                    case 104: {
                        int n = PrismParser.LtGt();
                        expression = PrismParser.Expression(false, false);
                        string = ExpressionBinaryOp.opSymbols[n];
                        bl3 = true;
                        break block0;
                    }
                    case 97: {
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "=";
                        bl3 = false;
                        break block0;
                    }
                    case 42: {
                        PrismParser.jj_consume_token(42);
                        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                            case 97: {
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "min=";
                                bl3 = false;
                                break block0;
                            }
                            case 42: {
                                PrismParser.jj_consume_token(42);
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "minmin=";
                                bl3 = false;
                                break block0;
                            }
                            case 38: {
                                PrismParser.jj_consume_token(38);
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "minmax=";
                                bl3 = false;
                                break block0;
                            }
                        }
                        PrismParser.jj_la1[76] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 38: {
                        PrismParser.jj_consume_token(38);
                        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                            case 97: {
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "max=";
                                bl3 = false;
                                break block0;
                            }
                            case 42: {
                                PrismParser.jj_consume_token(42);
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "maxmin=";
                                bl3 = false;
                                break block0;
                            }
                            case 38: {
                                PrismParser.jj_consume_token(38);
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "maxmax=";
                                bl3 = false;
                                break block0;
                            }
                        }
                        PrismParser.jj_la1[77] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 41: {
                        PrismParser.jj_consume_token(41);
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "minmin=";
                        bl3 = false;
                        break block0;
                    }
                    case 40: {
                        PrismParser.jj_consume_token(40);
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "minmax=";
                        bl3 = false;
                        break block0;
                    }
                    case 37: {
                        PrismParser.jj_consume_token(37);
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "maxmin=";
                        bl3 = false;
                        break block0;
                    }
                    case 36: {
                        PrismParser.jj_consume_token(36);
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "maxmax=";
                        bl3 = false;
                        break block0;
                    }
                }
                PrismParser.jj_la1[78] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
            case 53: {
                token = PrismParser.jj_consume_token(53);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "min=";
                bl3 = false;
                break;
            }
            case 50: {
                token = PrismParser.jj_consume_token(50);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "max=";
                bl3 = false;
                break;
            }
            case 52: {
                token = PrismParser.jj_consume_token(52);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "minmin=";
                bl3 = false;
                break;
            }
            case 51: {
                token = PrismParser.jj_consume_token(51);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "minmax=";
                bl3 = false;
                break;
            }
            case 49: {
                token = PrismParser.jj_consume_token(49);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "maxmin=";
                bl3 = false;
                break;
            }
            case 48: {
                token = PrismParser.jj_consume_token(48);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "maxmax=";
                bl3 = false;
                break;
            }
            default: {
                PrismParser.jj_la1[79] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(91);
        Expression expression2 = PrismParser.Expression(bl, true);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 95: {
                filter = PrismParser.Filter();
                break;
            }
            default: {
                PrismParser.jj_la1[80] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(92);
        expressionProb.setModifier(expressionIdent == null ? null : expressionIdent.getName());
        expressionProb.setRelOp(string);
        expressionProb.setProb(expression);
        expressionProb.setExpression(expression2);
        expressionProb.setFilter(filter);
        expressionProb.setPosition(token, PrismParser.getToken(0));
        if (filter != null) {
            String string2 = bl3 ? "&" : filter.getFilterOpString();
            ExpressionFilter expressionFilter = new ExpressionFilter(string2, expressionProb, filter.getExpression());
            expressionFilter.setInvisible(true);
            return expressionFilter;
        }
        return expressionProb;
    }

    public static final Filter Filter() throws ParseException, PrismLangException {
        Token token = null;
        token = PrismParser.jj_consume_token(95);
        Expression expression = PrismParser.Expression(true, false);
        Filter filter = new Filter(expression);
        PrismParser.jj_consume_token(96);
        block7: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 95: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[81] = jj_gen;
                    break block7;
                }
            }
            PrismParser.jj_consume_token(95);
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 42: {
                    PrismParser.jj_consume_token(42);
                    filter.setMinRequested(true);
                    break;
                }
                case 38: {
                    PrismParser.jj_consume_token(38);
                    filter.setMaxRequested(true);
                    break;
                }
                default: {
                    PrismParser.jj_la1[82] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            PrismParser.jj_consume_token(96);
        }
        filter.setPosition(token, PrismParser.getToken(0));
        return filter;
    }

    public static final Expression ExpressionSS(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        boolean bl3;
        ExpressionIdent expressionIdent = null;
        String string = null;
        Expression expression = null;
        Filter filter = null;
        ExpressionSS expressionSS = new ExpressionSS();
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        Token token = PrismParser.jj_consume_token(70);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 89: 
            case 99: 
            case 100: 
            case 103: 
            case 104: {
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 89: {
                        PrismParser.jj_consume_token(89);
                        expressionIdent = PrismParser.IdentifierExpression();
                        PrismParser.jj_consume_token(90);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[83] = jj_gen;
                    }
                }
                int n = PrismParser.LtGt();
                expression = PrismParser.Expression(false, false);
                string = ExpressionBinaryOp.opSymbols[n];
                bl3 = true;
                break;
            }
            case 97: {
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "=";
                bl3 = false;
                break;
            }
            default: {
                PrismParser.jj_la1[84] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(91);
        Expression expression2 = PrismParser.Expression(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 95: {
                filter = PrismParser.Filter();
                break;
            }
            default: {
                PrismParser.jj_la1[85] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(92);
        expressionSS.setModifier(expressionIdent == null ? null : expressionIdent.getName());
        expressionSS.setRelOp(string);
        expressionSS.setProb(expression);
        expressionSS.setExpression(expression2);
        expressionSS.setFilter(filter);
        expressionSS.setPosition(token, PrismParser.getToken(0));
        if (filter != null) {
            String string2 = bl3 ? "&" : filter.getFilterOpString();
            ExpressionFilter expressionFilter = new ExpressionFilter(string2, expressionSS, filter.getExpression());
            expressionFilter.setInvisible(true);
            return expressionFilter;
        }
        return expressionSS;
    }

    public static final Expression ExpressionReward(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        boolean bl3;
        Token token;
        ExpressionIdent expressionIdent = null;
        String string = null;
        Expression expression = null;
        Filter filter = null;
        ExpressionReward expressionReward = new ExpressionReward();
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 69: {
                token = PrismParser.jj_consume_token(69);
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 89: {
                        PrismParser.jj_consume_token(89);
                        expressionIdent = PrismParser.IdentifierExpression();
                        PrismParser.jj_consume_token(90);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[86] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 95: {
                        PrismParser.RewardIndex(expressionReward);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[87] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 99: 
                    case 100: 
                    case 103: 
                    case 104: {
                        int n = PrismParser.LtGt();
                        expression = PrismParser.Expression(false, false);
                        string = ExpressionBinaryOp.opSymbols[n];
                        bl3 = true;
                        break block0;
                    }
                    case 97: {
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "=";
                        bl3 = false;
                        break block0;
                    }
                    case 42: {
                        PrismParser.jj_consume_token(42);
                        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                            case 97: {
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "min=";
                                bl3 = false;
                                break block0;
                            }
                            case 42: {
                                PrismParser.jj_consume_token(42);
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "minmin=";
                                bl3 = false;
                                break block0;
                            }
                            case 38: {
                                PrismParser.jj_consume_token(38);
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "minmax=";
                                bl3 = false;
                                break block0;
                            }
                        }
                        PrismParser.jj_la1[88] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 38: {
                        PrismParser.jj_consume_token(38);
                        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                            case 97: {
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "max=";
                                bl3 = false;
                                break block0;
                            }
                            case 42: {
                                PrismParser.jj_consume_token(42);
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "maxmin=";
                                bl3 = false;
                                break block0;
                            }
                            case 38: {
                                PrismParser.jj_consume_token(38);
                                PrismParser.jj_consume_token(97);
                                PrismParser.jj_consume_token(112);
                                string = "maxmax=";
                                bl3 = false;
                                break block0;
                            }
                        }
                        PrismParser.jj_la1[89] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 41: {
                        PrismParser.jj_consume_token(41);
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "minmin=";
                        bl3 = false;
                        break block0;
                    }
                    case 40: {
                        PrismParser.jj_consume_token(40);
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "minmax=";
                        bl3 = false;
                        break block0;
                    }
                    case 37: {
                        PrismParser.jj_consume_token(37);
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "maxmin=";
                        bl3 = false;
                        break block0;
                    }
                    case 36: {
                        PrismParser.jj_consume_token(36);
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "maxmax=";
                        bl3 = false;
                        break block0;
                    }
                }
                PrismParser.jj_la1[90] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
            case 68: {
                token = PrismParser.jj_consume_token(68);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "min=";
                bl3 = false;
                break;
            }
            case 65: {
                token = PrismParser.jj_consume_token(65);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "max=";
                bl3 = false;
                break;
            }
            case 67: {
                token = PrismParser.jj_consume_token(67);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "minmin=";
                bl3 = false;
                break;
            }
            case 66: {
                token = PrismParser.jj_consume_token(66);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "minmax=";
                bl3 = false;
                break;
            }
            case 64: {
                token = PrismParser.jj_consume_token(64);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "maxmin=";
                bl3 = false;
                break;
            }
            case 63: {
                token = PrismParser.jj_consume_token(63);
                PrismParser.jj_consume_token(97);
                PrismParser.jj_consume_token(112);
                string = "maxmax=";
                bl3 = false;
                break;
            }
            default: {
                PrismParser.jj_la1[91] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(91);
        Expression expression2 = PrismParser.ExpressionRewardContents(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 95: {
                filter = PrismParser.Filter();
                break;
            }
            default: {
                PrismParser.jj_la1[92] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(92);
        expressionReward.setModifier(expressionIdent == null ? null : expressionIdent.getName());
        expressionReward.setRelOp(string);
        expressionReward.setReward(expression);
        expressionReward.setExpression(expression2);
        expressionReward.setFilter(filter);
        expressionReward.setPosition(token, PrismParser.getToken(0));
        if (filter != null) {
            String string2 = bl3 ? "&" : filter.getFilterOpString();
            ExpressionFilter expressionFilter = new ExpressionFilter(string2, expressionReward, filter.getExpression());
            expressionFilter.setInvisible(true);
            return expressionFilter;
        }
        return expressionReward;
    }

    public static final void RewardIndex(ExpressionReward expressionReward) throws ParseException, PrismLangException {
        Object object = null;
        Object object2 = null;
        Expression expression = null;
        PrismParser.jj_consume_token(95);
        if (PrismParser.jj_2_15(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(113);
            object = PrismParser.Identifier();
            PrismParser.jj_consume_token(113);
        } else {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 11: {
                    PrismParser.jj_consume_token(11);
                    PrismParser.jj_consume_token(97);
                    expression = PrismParser.Expression(false, false);
                    break;
                }
                case 3: 
                case 14: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 30: 
                case 38: 
                case 42: 
                case 44: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 76: 
                case 79: 
                case 89: 
                case 93: 
                case 101: 
                case 106: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    object = PrismParser.Expression(false, false);
                    break;
                }
                default: {
                    PrismParser.jj_la1[93] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 87: {
                PrismParser.jj_consume_token(87);
                PrismParser.jj_consume_token(11);
                PrismParser.jj_consume_token(97);
                expression = PrismParser.Expression(false, false);
                break;
            }
            default: {
                PrismParser.jj_la1[94] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(96);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 108: {
                PrismParser.jj_consume_token(108);
                PrismParser.jj_consume_token(95);
                if (PrismParser.jj_2_16(Integer.MAX_VALUE)) {
                    PrismParser.jj_consume_token(113);
                    object2 = PrismParser.Identifier();
                    PrismParser.jj_consume_token(113);
                } else {
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 3: 
                        case 14: 
                        case 22: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 30: 
                        case 38: 
                        case 42: 
                        case 44: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 76: 
                        case 79: 
                        case 89: 
                        case 93: 
                        case 101: 
                        case 106: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: {
                            object2 = PrismParser.Expression(false, false);
                            break;
                        }
                        default: {
                            PrismParser.jj_la1[95] = jj_gen;
                            PrismParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                PrismParser.jj_consume_token(96);
                break;
            }
            default: {
                PrismParser.jj_la1[96] = jj_gen;
            }
        }
        expressionReward.setRewardStructIndex(object);
        if (object2 != null) {
            expressionReward.setRewardStructIndexDiv(object2);
        }
        if (expression != null) {
            expressionReward.setDiscount(expression);
        }
    }

    public static final Expression ExpressionRewardContents(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        Expression expression = null;
        ExpressionTemporal expressionTemporal = null;
        Expression expression2 = null;
        Token token = PrismParser.getToken(1);
        if (PrismParser.jj_2_17(Integer.MAX_VALUE)) {
            expression2 = expression = PrismParser.ExpressionSS(bl, true);
        } else {
            block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 70: {
                    PrismParser.jj_consume_token(70);
                    expression2 = new ExpressionTemporal(14, null, null);
                    break;
                }
                default: {
                    PrismParser.jj_la1[97] = jj_gen;
                    if (PrismParser.jj_2_18(Integer.MAX_VALUE)) {
                        token = PrismParser.jj_consume_token(10);
                        PrismParser.jj_consume_token(103);
                        expression = PrismParser.Expression(false, false);
                        expressionTemporal = new ExpressionTemporal(11, null, null);
                        expressionTemporal.setUpperBound(expression);
                        expression2 = expressionTemporal;
                        break;
                    }
                    switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                        case 10: {
                            PrismParser.jj_consume_token(10);
                            expression2 = new ExpressionTemporal(11, null, null);
                            break block0;
                        }
                        case 33: {
                            PrismParser.jj_consume_token(33);
                            PrismParser.jj_consume_token(97);
                            expression = PrismParser.Expression(false, false);
                            expressionTemporal = new ExpressionTemporal(12, null, null);
                            expressionTemporal.setUpperBound(expression);
                            expression2 = expressionTemporal;
                            break block0;
                        }
                        case 27: {
                            PrismParser.jj_consume_token(27);
                            expression = PrismParser.Expression(bl, bl2);
                            expression2 = new ExpressionTemporal(15, null, expression);
                            break block0;
                        }
                        case 28: {
                            PrismParser.jj_consume_token(28);
                            expression = PrismParser.Expression(bl, bl2);
                            expression2 = new ExpressionTemporal(16, null, expression);
                            break block0;
                        }
                        case 3: 
                        case 14: 
                        case 22: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 30: 
                        case 38: 
                        case 42: 
                        case 44: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 76: 
                        case 79: 
                        case 89: 
                        case 93: 
                        case 101: 
                        case 106: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: {
                            expression2 = expression = PrismParser.Expression(bl, true);
                            break block0;
                        }
                    }
                    PrismParser.jj_la1[98] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        expression2.setPosition(token, PrismParser.getToken(0));
        return expression2;
    }

    public static final Expression ExpressionMultiNash(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        ExpressionQuant expressionQuant;
        ExpressionMultiNash expressionMultiNash = new ExpressionMultiNash();
        Expression expression = null;
        ArrayList arrayList = new ArrayList();
        String string = null;
        boolean bl3 = false;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 42: {
                boolean bl4;
                int n;
                PrismParser.jj_consume_token(42);
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 99: 
                    case 100: 
                    case 103: 
                    case 104: {
                        n = PrismParser.LtGt();
                        expression = PrismParser.Expression(false, false);
                        string = ExpressionBinaryOp.opSymbols[n];
                        bl4 = true;
                        break block0;
                    }
                    case 97: {
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "min=";
                        bl4 = false;
                        break block0;
                    }
                }
                PrismParser.jj_la1[99] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
            case 38: {
                boolean bl4;
                int n;
                PrismParser.jj_consume_token(38);
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 99: 
                    case 100: 
                    case 103: 
                    case 104: {
                        n = PrismParser.LtGt();
                        expression = PrismParser.Expression(false, false);
                        string = ExpressionBinaryOp.opSymbols[n];
                        bl4 = true;
                        break block0;
                    }
                    case 97: {
                        PrismParser.jj_consume_token(97);
                        PrismParser.jj_consume_token(112);
                        string = "max=";
                        bl4 = false;
                        break block0;
                    }
                }
                PrismParser.jj_la1[100] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                PrismParser.jj_la1[101] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(89);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 54: {
                expressionQuant = PrismParser.ExpressionMultiNashProb(bl, true);
                break;
            }
            case 69: {
                expressionQuant = PrismParser.ExpressionMultiNashReward(bl, true);
                break;
            }
            default: {
                PrismParser.jj_la1[102] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expressionMultiNash.addOperand(expressionQuant);
        block23: while (true) {
            PrismParser.jj_consume_token(105);
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 54: {
                    expressionQuant = PrismParser.ExpressionMultiNashProb(bl, true);
                    break;
                }
                case 69: {
                    expressionQuant = PrismParser.ExpressionMultiNashReward(bl, true);
                    break;
                }
                default: {
                    PrismParser.jj_la1[103] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            expressionMultiNash.addOperand(expressionQuant);
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 105: {
                    continue block23;
                }
            }
            break;
        }
        PrismParser.jj_la1[104] = jj_gen;
        PrismParser.jj_consume_token(90);
        expressionMultiNash.setBound(expression);
        expressionMultiNash.setRelOp(string);
        return expressionMultiNash;
    }

    public static final ExpressionQuant ExpressionMultiNashProb(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        ExpressionMultiNashProb expressionMultiNashProb = new ExpressionMultiNashProb();
        Expression expression = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        Token token = PrismParser.jj_consume_token(54);
        PrismParser.jj_consume_token(91);
        expression = PrismParser.Expression(bl, true);
        PrismParser.jj_consume_token(92);
        expressionMultiNashProb.setExpression(expression);
        expressionMultiNashProb.setPosition(token, PrismParser.getToken(0));
        return expressionMultiNashProb;
    }

    public static final ExpressionQuant ExpressionMultiNashReward(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        ExpressionMultiNashReward expressionMultiNashReward = new ExpressionMultiNashReward();
        Expression expression = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        Token token = PrismParser.jj_consume_token(69);
        PrismParser.MultiNashRewardIndexes(expressionMultiNashReward);
        PrismParser.jj_consume_token(91);
        expression = PrismParser.ExpressionRewardContents(bl, bl2);
        PrismParser.jj_consume_token(92);
        expressionMultiNashReward.setExpression(expression);
        expressionMultiNashReward.setPosition(token, PrismParser.getToken(0));
        return expressionMultiNashReward;
    }

    public static final void MultiNashRewardIndexes(ExpressionMultiNashReward expressionMultiNashReward) throws ParseException, PrismLangException {
        Object object = null;
        PrismParser.jj_consume_token(95);
        if (PrismParser.jj_2_19(Integer.MAX_VALUE)) {
            PrismParser.jj_consume_token(113);
            object = PrismParser.Identifier();
            PrismParser.jj_consume_token(113);
        } else {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 3: 
                case 14: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 30: 
                case 38: 
                case 42: 
                case 44: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 76: 
                case 79: 
                case 89: 
                case 93: 
                case 101: 
                case 106: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    object = PrismParser.Expression(false, false);
                    break;
                }
                default: {
                    PrismParser.jj_la1[105] = jj_gen;
                    PrismParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        PrismParser.jj_consume_token(96);
        expressionMultiNashReward.setRewardStructIndex(object);
    }

    public static final Expression ExpressionExists(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        ExpressionExists expressionExists = new ExpressionExists();
        Token token = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        token = PrismParser.jj_consume_token(14);
        PrismParser.jj_consume_token(91);
        Expression expression = PrismParser.Expression(bl, true);
        PrismParser.jj_consume_token(92);
        expressionExists.setExpression(expression);
        expressionExists.setPosition(token, PrismParser.getToken(0));
        return expressionExists;
    }

    public static final Expression ExpressionForAll(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        ExpressionForAll expressionForAll = new ExpressionForAll();
        Token token = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        token = PrismParser.jj_consume_token(3);
        PrismParser.jj_consume_token(91);
        Expression expression = PrismParser.Expression(bl, true);
        PrismParser.jj_consume_token(92);
        expressionForAll.setExpression(expression);
        expressionForAll.setPosition(token, PrismParser.getToken(0));
        return expressionForAll;
    }

    public static final Expression ExpressionStrategy(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        List<Coalition> list;
        ExpressionStrategy expressionStrategy;
        ArrayList<Expression> arrayList = null;
        Token token = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 101: {
                token = PrismParser.jj_consume_token(101);
                expressionStrategy = new ExpressionStrategy(true);
                list = PrismParser.ExpressionStrategyCoalitionList();
                PrismParser.jj_consume_token(102);
                break;
            }
            case 93: {
                token = PrismParser.jj_consume_token(93);
                expressionStrategy = new ExpressionStrategy(false);
                list = PrismParser.ExpressionStrategyCoalitionList();
                PrismParser.jj_consume_token(94);
                break;
            }
            default: {
                PrismParser.jj_la1[106] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expressionStrategy.setCoalitions(list);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 95: {
                PrismParser.jj_consume_token(95);
                arrayList = PrismParser.ExpressionStrategyOptions();
                PrismParser.jj_consume_token(96);
                break;
            }
            default: {
                PrismParser.jj_la1[107] = jj_gen;
            }
        }
        expressionStrategy.processOptions(arrayList);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 38: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                Expression expression;
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: {
                        expression = PrismParser.ExpressionProb(bl, bl2);
                        break;
                    }
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: {
                        expression = PrismParser.ExpressionReward(bl, bl2);
                        break;
                    }
                    case 38: 
                    case 42: {
                        expression = PrismParser.ExpressionMultiNash(bl, bl2);
                        break;
                    }
                    default: {
                        PrismParser.jj_la1[108] = jj_gen;
                        PrismParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expressionStrategy.setSingleOperand(expression);
                break;
            }
            case 89: {
                Expression expression = PrismParser.ExpressionParenth(bl, bl2);
                expressionStrategy.addOperand(expression);
                break;
            }
            default: {
                PrismParser.jj_la1[109] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expressionStrategy.setPosition(token, PrismParser.getToken(0));
        return expressionStrategy;
    }

    public static final List<Coalition> ExpressionStrategyCoalitionList() throws ParseException {
        ArrayList<Coalition> arrayList = new ArrayList<Coalition>();
        Coalition coalition = PrismParser.ExpressionStrategyCoalition();
        arrayList.add(coalition);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 85: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[110] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(85);
            coalition = PrismParser.ExpressionStrategyCoalition();
            arrayList.add(coalition);
        }
        return arrayList;
    }

    public static final Coalition ExpressionStrategyCoalition() throws ParseException {
        Coalition coalition = new Coalition();
        ArrayList<String> arrayList = new ArrayList<String>();
        block0 : switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 107: {
                PrismParser.jj_consume_token(107);
                coalition.setAllPlayers();
                break;
            }
            default: {
                PrismParser.jj_la1[113] = jj_gen;
                switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                    case 114: 
                    case 117: {
                        String string = PrismParser.ExpressionStrategyCoalitionPlayer();
                        arrayList.add(string);
                        block9: while (true) {
                            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                                case 87: {
                                    break;
                                }
                                default: {
                                    PrismParser.jj_la1[111] = jj_gen;
                                    break block9;
                                }
                            }
                            PrismParser.jj_consume_token(87);
                            string = PrismParser.ExpressionStrategyCoalitionPlayer();
                            arrayList.add(string);
                        }
                        coalition.setPlayers(arrayList);
                        break block0;
                    }
                }
                PrismParser.jj_la1[112] = jj_gen;
            }
        }
        return coalition;
    }

    public static final String ExpressionStrategyCoalitionPlayer() throws ParseException {
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 114: {
                PrismParser.jj_consume_token(114);
                break;
            }
            case 117: {
                PrismParser.jj_consume_token(117);
                break;
            }
            default: {
                PrismParser.jj_la1[114] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String string = PrismParser.getToken((int)0).image;
        return string;
    }

    public static final ArrayList<Expression> ExpressionStrategyOptions() throws ParseException, PrismLangException {
        Expression expression = PrismParser.Expression(false, false);
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(expression);
        block3: while (true) {
            switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
                case 87: {
                    break;
                }
                default: {
                    PrismParser.jj_la1[115] = jj_gen;
                    break block3;
                }
            }
            PrismParser.jj_consume_token(87);
            expression = PrismParser.Expression(false, false);
            arrayList.add(expression);
        }
        return arrayList;
    }

    public static final Expression ExpressionLabel(boolean bl, boolean bl2) throws ParseException {
        String string;
        ExpressionLabel expressionLabel = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        Token token = PrismParser.jj_consume_token(113);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 117: {
                string = PrismParser.Identifier();
                break;
            }
            case 31: {
                PrismParser.jj_consume_token(31);
                string = "init";
                break;
            }
            default: {
                PrismParser.jj_la1[116] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(113);
        expressionLabel = new ExpressionLabel(string);
        expressionLabel.setPosition(token, PrismParser.getToken(0));
        return expressionLabel;
    }

    public static final Expression ExpressionFilter(boolean bl, boolean bl2) throws ParseException, PrismLangException {
        ExpressionFilter expressionFilter = null;
        String string = null;
        Expression expression = null;
        Expression expression2 = null;
        Token token = null;
        if (!bl) {
            throw PrismParser.generateParseException();
        }
        token = PrismParser.jj_consume_token(24);
        PrismParser.jj_consume_token(89);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 42: {
                PrismParser.jj_consume_token(42);
                string = "min";
                break;
            }
            case 38: {
                PrismParser.jj_consume_token(38);
                string = "max";
                break;
            }
            case 105: {
                PrismParser.jj_consume_token(105);
                string = "+";
                break;
            }
            case 80: {
                PrismParser.jj_consume_token(80);
                string = "&";
                break;
            }
            case 81: {
                PrismParser.jj_consume_token(81);
                string = "|";
                break;
            }
            case 117: {
                string = PrismParser.Identifier();
                break;
            }
            default: {
                PrismParser.jj_la1[117] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PrismParser.jj_consume_token(87);
        expression2 = PrismParser.Expression(bl, bl2);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 87: {
                PrismParser.jj_consume_token(87);
                expression = PrismParser.Expression(bl, bl2);
                break;
            }
            default: {
                PrismParser.jj_la1[118] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(90);
        expressionFilter = new ExpressionFilter(string, expression2, expression);
        expressionFilter.setPosition(token, PrismParser.getToken(0));
        return expressionFilter;
    }

    public static final String Identifier() throws ParseException {
        PrismParser.jj_consume_token(117);
        return PrismParser.getToken((int)0).image;
    }

    public static final ExpressionIdent IdentifierExpression() throws ParseException {
        String string = PrismParser.Identifier();
        ExpressionIdent expressionIdent = new ExpressionIdent(string);
        expressionIdent.setPosition(PrismParser.getToken(0));
        return expressionIdent;
    }

    public static final ExpressionIdent IdentifierExpressionMinMax() throws ParseException {
        String string;
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 117: {
                string = PrismParser.Identifier();
                break;
            }
            case 42: {
                PrismParser.jj_consume_token(42);
                string = "min";
                break;
            }
            case 38: {
                PrismParser.jj_consume_token(38);
                string = "max";
                break;
            }
            default: {
                PrismParser.jj_la1[119] = jj_gen;
                PrismParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ExpressionIdent expressionIdent = new ExpressionIdent(string);
        expressionIdent.setPosition(PrismParser.getToken(0));
        return expressionIdent;
    }

    public static final ExpressionIdent IdentifierPrime() throws ParseException {
        PrismParser.jj_consume_token(116);
        String string = PrismParser.getToken((int)0).image;
        string = string.substring(0, string.length() - 1);
        ExpressionIdent expressionIdent = new ExpressionIdent(string);
        expressionIdent.setPosition(token);
        expressionIdent.setEndColumn(expressionIdent.getEndColumn() - 1);
        expressionIdent.setPrime(true);
        return expressionIdent;
    }

    public static final int EqNeq() throws ParseException {
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 97: {
                PrismParser.jj_consume_token(97);
                return 5;
            }
            case 98: {
                PrismParser.jj_consume_token(98);
                return 6;
            }
        }
        PrismParser.jj_la1[120] = jj_gen;
        PrismParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final int LtGt() throws ParseException {
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 100: {
                PrismParser.jj_consume_token(100);
                return 7;
            }
            case 99: {
                PrismParser.jj_consume_token(99);
                return 9;
            }
            case 104: {
                PrismParser.jj_consume_token(104);
                return 8;
            }
            case 103: {
                PrismParser.jj_consume_token(103);
                return 10;
            }
        }
        PrismParser.jj_la1[121] = jj_gen;
        PrismParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final ForLoop ForLoop() throws ParseException, PrismLangException {
        Expression expression = null;
        Expression expression2 = null;
        Expression expression3 = null;
        ForLoop forLoop = new ForLoop();
        Token token = PrismParser.getToken(1);
        String string = PrismParser.Identifier();
        PrismParser.jj_consume_token(97);
        expression = PrismParser.Expression(false, false);
        PrismParser.jj_consume_token(85);
        expression2 = PrismParser.Expression(false, false);
        switch (jj_ntk == -1 ? PrismParser.jj_ntk_f() : jj_ntk) {
            case 85: {
                PrismParser.jj_consume_token(85);
                expression3 = PrismParser.Expression(false, false);
                break;
            }
            default: {
                PrismParser.jj_la1[122] = jj_gen;
            }
        }
        PrismParser.jj_consume_token(0);
        forLoop.setLHS(string);
        forLoop.setFrom(expression);
        forLoop.setTo(expression2);
        if (expression3 != null) {
            forLoop.setStep(expression3);
        }
        forLoop.setPosition(token, PrismParser.getToken(0));
        return forLoop;
    }

    private static boolean jj_2_1(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(0, n);
        }
    }

    private static boolean jj_2_2(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(1, n);
        }
    }

    private static boolean jj_2_3(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(2, n);
        }
    }

    private static boolean jj_2_4(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(3, n);
        }
    }

    private static boolean jj_2_5(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(4, n);
        }
    }

    private static boolean jj_2_6(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(5, n);
        }
    }

    private static boolean jj_2_7(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(6, n);
        }
    }

    private static boolean jj_2_8(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(7, n);
        }
    }

    private static boolean jj_2_9(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(8, n);
        }
    }

    private static boolean jj_2_10(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(9, n);
        }
    }

    private static boolean jj_2_11(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(10, n);
        }
    }

    private static boolean jj_2_12(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(11, n);
        }
    }

    private static boolean jj_2_13(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(12, n);
        }
    }

    private static boolean jj_2_14(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(13, n);
        }
    }

    private static boolean jj_2_15(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(14, n);
        }
    }

    private static boolean jj_2_16(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(15, n);
        }
    }

    private static boolean jj_2_17(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(16, n);
        }
    }

    private static boolean jj_2_18(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(17, n);
        }
    }

    private static boolean jj_2_19(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !PrismParser.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            PrismParser.jj_save(18, n);
        }
    }

    private static boolean jj_3R_ExpressionBasic_1517_9_135() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionBasic_1518_17_136()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionBasic_1520_17_137()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionBasic_1522_17_138()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_ExpressionBasic_1524_17_139()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_ExpressionBasic_1526_17_140()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_ExpressionBasic_1529_17_141()) {
                                jj_scanpos = token;
                                if (PrismParser.jj_3R_ExpressionBasic_1531_17_142()) {
                                    jj_scanpos = token;
                                    if (PrismParser.jj_3R_ExpressionBasic_1533_17_143()) {
                                        jj_scanpos = token;
                                        if (PrismParser.jj_3R_ExpressionBasic_1535_17_144()) {
                                            jj_scanpos = token;
                                            if (PrismParser.jj_3R_ExpressionBasic_1537_17_145()) {
                                                jj_scanpos = token;
                                                if (PrismParser.jj_3R_ExpressionBasic_1539_17_146()) {
                                                    jj_scanpos = token;
                                                    if (PrismParser.jj_3R_ExpressionBasic_1541_17_147()) {
                                                        jj_scanpos = token;
                                                        if (PrismParser.jj_3R_ExpressionBasic_1543_17_148()) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_LtGt_2282_9_59() {
        return PrismParser.jj_scan_token(103);
    }

    private static boolean jj_3R_SystemParallel_1130_11_64() {
        Token token;
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        if (PrismParser.jj_scan_token(91)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_SystemParallel_1131_65_75());
        jj_scanpos = token;
        if (PrismParser.jj_scan_token(92)) {
            return true;
        }
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        return PrismParser.jj_3R_SystemHideRename_1156_9_63();
    }

    private static boolean jj_3R_LtGt_2281_9_58() {
        return PrismParser.jj_scan_token(104);
    }

    private static boolean jj_3R_LtGt_2280_9_57() {
        return PrismParser.jj_scan_token(99);
    }

    private static boolean jj_3R_ExpressionUnaryMinus_1505_17_134() {
        return PrismParser.jj_3R_ExpressionBasic_1517_9_135();
    }

    private static boolean jj_3R_LtGt_2279_9_56() {
        return PrismParser.jj_scan_token(100);
    }

    private static boolean jj_3R_LtGt_2279_9_50() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_LtGt_2279_9_56()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_LtGt_2280_9_57()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_LtGt_2281_9_58()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_LtGt_2282_9_59()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3_15() {
        return PrismParser.jj_scan_token(113);
    }

    private static boolean jj_3R_SystemParallel_1128_9_54() {
        if (PrismParser.jj_3R_SystemHideRename_1156_9_63()) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_SystemParallel_1130_11_64()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_ExpressionUnaryMinus_1502_17_133() {
        if (PrismParser.jj_scan_token(106)) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionUnaryMinus_1501_9_129();
    }

    private static boolean jj_3R_RewardIndex_1889_11_259() {
        if (PrismParser.jj_scan_token(108)) {
            return true;
        }
        if (PrismParser.jj_scan_token(95)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_RewardIndex_1889_33_267()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_RewardIndex_1889_101_268()) {
                return true;
            }
        }
        return PrismParser.jj_scan_token(96);
    }

    private static boolean jj_3R_ExpressionPlusMinus_1454_62_128() {
        return PrismParser.jj_scan_token(106);
    }

    private static boolean jj_3R_RewardIndex_1886_10_258() {
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        if (PrismParser.jj_scan_token(11)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_EqNeq_2270_9_124() {
        return PrismParser.jj_scan_token(98);
    }

    private static boolean jj_3R_EqNeq_2269_9_120() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_EqNeq_2269_9_123()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_EqNeq_2270_9_124()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_EqNeq_2269_9_123() {
        return PrismParser.jj_scan_token(97);
    }

    private static boolean jj_3R_RewardIndex_1884_10_255() {
        if (PrismParser.jj_scan_token(113)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        return PrismParser.jj_scan_token(113);
    }

    private static boolean jj_3R_ExpressionUnaryMinus_1501_9_129() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionUnaryMinus_1502_17_133()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionUnaryMinus_1505_17_134()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_RewardIndex_1882_9_244() {
        if (PrismParser.jj_scan_token(95)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_RewardIndex_1884_10_255()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_RewardIndex_1884_75_256()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_RewardIndex_1884_125_257()) {
                    return true;
                }
            }
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_RewardIndex_1886_10_258()) {
            jj_scanpos = token;
        }
        if (PrismParser.jj_scan_token(96)) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_RewardIndex_1889_11_259()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_ExpressionPower_1488_17_130() {
        if (PrismParser.jj_scan_token(109)) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionPower_1486_9_125();
    }

    private static boolean jj_3R_SystemInterleaved_1104_9_47() {
        Token token;
        if (PrismParser.jj_3R_SystemParallel_1128_9_54()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_SystemInterleaved_1106_70_55());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionStrategyOptions_2158_103_253() {
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionPower_1486_9_125() {
        if (PrismParser.jj_3R_ExpressionUnaryMinus_1501_9_129()) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionPower_1488_17_130()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_IdentifierPrime_2250_9_53() {
        return PrismParser.jj_scan_token(116);
    }

    private static boolean jj_3R_ExpressionTimesDivide_1471_19_131() {
        return PrismParser.jj_scan_token(107);
    }

    private static boolean jj_3R_ExpressionTimesDivide_1471_17_126() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionTimesDivide_1471_19_131()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionTimesDivide_1471_64_132()) {
                return true;
            }
        }
        return PrismParser.jj_3R_ExpressionPower_1486_9_125();
    }

    private static boolean jj_3R_ExpressionFilter_2196_56_202() {
        return PrismParser.jj_scan_token(81);
    }

    private static boolean jj_3R_ExpressionReward_1837_26_250() {
        if (PrismParser.jj_scan_token(38)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1836_26_249() {
        if (PrismParser.jj_scan_token(42)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1835_26_248() {
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionTimesDivide_1469_9_121() {
        Token token;
        if (PrismParser.jj_3R_ExpressionPower_1486_9_125()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionTimesDivide_1471_17_126());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionReward_1850_10_188() {
        if (PrismParser.jj_scan_token(63)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1833_26_247() {
        if (PrismParser.jj_scan_token(38)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1842_17_224() {
        if (PrismParser.jj_scan_token(36)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1849_10_187() {
        if (PrismParser.jj_scan_token(64)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1832_26_246() {
        if (PrismParser.jj_scan_token(42)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1841_17_223() {
        if (PrismParser.jj_scan_token(37)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1848_10_186() {
        if (PrismParser.jj_scan_token(66)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1831_26_245() {
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1840_17_222() {
        if (PrismParser.jj_scan_token(40)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1847_10_185() {
        if (PrismParser.jj_scan_token(67)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1839_17_221() {
        if (PrismParser.jj_scan_token(41)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1846_10_184() {
        if (PrismParser.jj_scan_token(65)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_SystemFullParallel_1081_9_40() {
        Token token;
        if (PrismParser.jj_3R_SystemInterleaved_1104_9_47()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_SystemFullParallel_1083_71_48());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionPlusMinus_1454_19_127() {
        return PrismParser.jj_scan_token(105);
    }

    private static boolean jj_3R_ExpressionReward_1845_10_183() {
        if (PrismParser.jj_scan_token(68)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionPlusMinus_1454_17_122() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionPlusMinus_1454_19_127()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionPlusMinus_1454_62_128()) {
                return true;
            }
        }
        return PrismParser.jj_3R_ExpressionTimesDivide_1469_9_121();
    }

    private static boolean jj_3R_IdentifierExpression_2228_9_37() {
        return PrismParser.jj_3R_Identifier_2217_9_34();
    }

    private static boolean jj_3R_ExpressionReward_1835_17_220() {
        if (PrismParser.jj_scan_token(38)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionReward_1835_26_248()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionReward_1836_26_249()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionReward_1837_26_250()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean jj_3_2() {
        if (PrismParser.jj_scan_token(113)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        if (PrismParser.jj_scan_token(113)) {
            return true;
        }
        return PrismParser.jj_scan_token(85);
    }

    private static boolean jj_3R_ExpressionReward_1831_17_219() {
        if (PrismParser.jj_scan_token(42)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionReward_1831_26_245()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionReward_1832_26_246()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionReward_1833_26_247()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionReward_1830_17_218() {
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionReward_1829_18_217() {
        if (PrismParser.jj_3R_LtGt_2279_9_50()) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionFilter_2196_34_201() {
        return PrismParser.jj_scan_token(80);
    }

    private static boolean jj_3R_ExpressionFilter_2195_35_199() {
        return PrismParser.jj_scan_token(38);
    }

    private static boolean jj_3R_ExpressionReward_1828_18_216() {
        return PrismParser.jj_3R_RewardIndex_1882_9_244();
    }

    private static boolean jj_3R_ExpressionReward_1827_19_215() {
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        if (PrismParser.jj_3R_IdentifierExpression_2228_9_37()) {
            return true;
        }
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3R_ExpressionPlusMinus_1452_9_118() {
        Token token;
        if (PrismParser.jj_3R_ExpressionTimesDivide_1469_9_121()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionPlusMinus_1454_17_122());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_SystemDefn_1068_9_36() {
        return PrismParser.jj_3R_SystemFullParallel_1081_9_40();
    }

    private static boolean jj_3R_ExpressionSS_1788_55_44() {
        return PrismParser.jj_3R_Filter_1756_9_52();
    }

    private static boolean jj_3R_Identifier_2217_9_34() {
        return PrismParser.jj_scan_token(117);
    }

    private static boolean jj_3_7() {
        if (PrismParser.jj_scan_token(113)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        if (PrismParser.jj_scan_token(113)) {
            return true;
        }
        return PrismParser.jj_3R_SystemDefn_1068_9_36();
    }

    private static boolean jj_3R_ExpressionLabel_2174_47_197() {
        return PrismParser.jj_scan_token(31);
    }

    private static boolean jj_3R_ExpressionReward_1826_10_182() {
        if (PrismParser.jj_scan_token(69)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionReward_1827_19_215()) {
            jj_scanpos = token;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionReward_1828_18_216()) {
            jj_scanpos = token;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionReward_1829_18_217()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionReward_1830_17_218()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionReward_1831_17_219()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_ExpressionReward_1835_17_220()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_ExpressionReward_1839_17_221()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_ExpressionReward_1840_17_222()) {
                                jj_scanpos = token;
                                if (PrismParser.jj_3R_ExpressionReward_1841_17_223()) {
                                    jj_scanpos = token;
                                    if (PrismParser.jj_3R_ExpressionReward_1842_17_224()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionReward_1824_9_155() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionReward_1826_10_182()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionReward_1845_10_183()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionReward_1846_10_184()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_ExpressionReward_1847_10_185()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_ExpressionReward_1848_10_186()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_ExpressionReward_1849_10_187()) {
                                jj_scanpos = token;
                                if (PrismParser.jj_3R_ExpressionReward_1850_10_188()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (PrismParser.jj_scan_token(91)) {
            return true;
        }
        if (PrismParser.jj_3R_ExpressionRewardContents_1915_9_189()) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionReward_1852_69_190()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_scan_token(92);
    }

    private static boolean jj_3R_ExpressionFilter_2201_11_204() {
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionRelop_1432_11_119() {
        if (PrismParser.jj_3R_LtGt_2279_9_50()) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionPlusMinus_1452_9_118();
    }

    private static boolean jj_3R_ExpressionFilter_2197_11_203() {
        return PrismParser.jj_3R_Identifier_2217_9_34();
    }

    private static boolean jj_3R_ExpressionFilter_2196_11_200() {
        return PrismParser.jj_scan_token(105);
    }

    private static boolean jj_3R_ExpressionFilter_2195_11_198() {
        return PrismParser.jj_scan_token(42);
    }

    private static boolean jj_3R_ExpressionRelop_1431_9_116() {
        Token token;
        if (PrismParser.jj_3R_ExpressionPlusMinus_1452_9_118()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionRelop_1432_11_119());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionLabel_2174_30_196() {
        return PrismParser.jj_3R_Identifier_2217_9_34();
    }

    private static boolean jj_3R_ExpressionFilter_2190_9_160() {
        if (PrismParser.jj_scan_token(24)) {
            return true;
        }
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionFilter_2195_11_198()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionFilter_2195_35_199()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionFilter_2196_11_200()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_ExpressionFilter_2196_34_201()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_ExpressionFilter_2196_56_202()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_ExpressionFilter_2197_11_203()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionFilter_2201_11_204()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3R_ExpressionEquality_1418_11_117() {
        if (PrismParser.jj_3R_EqNeq_2269_9_120()) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionRelop_1431_9_116();
    }

    private static boolean jj_3R_ExpressionEquality_1417_9_115() {
        Token token;
        if (PrismParser.jj_3R_ExpressionRelop_1431_9_116()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionEquality_1418_11_117());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionStrategy_2097_93_237() {
        return PrismParser.jj_3R_ExpressionMultiNash_1949_9_254();
    }

    private static boolean jj_3R_ExpressionNot_1403_17_114() {
        return PrismParser.jj_3R_ExpressionEquality_1417_9_115();
    }

    private static boolean jj_3R_ExpressionSS_1785_17_42() {
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionSS_1783_19_49() {
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        if (PrismParser.jj_3R_IdentifierExpression_2228_9_37()) {
            return true;
        }
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3R_ExpressionNot_1401_17_113() {
        if (PrismParser.jj_scan_token(79)) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionNot_1400_9_111();
    }

    private static boolean jj_3R_TimeBound_1318_99_106() {
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionSS_1783_17_41() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionSS_1783_19_49()) {
            jj_scanpos = token;
        }
        if (PrismParser.jj_3R_LtGt_2279_9_50()) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_TimeBound_1317_99_104() {
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionLabel_2172_9_159() {
        if (PrismParser.jj_scan_token(113)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionLabel_2174_30_196()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionLabel_2174_47_197()) {
                return true;
            }
        }
        return PrismParser.jj_scan_token(113);
    }

    private static boolean jj_3R_TimeBound_1316_99_102() {
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_TimeBound_1315_99_100() {
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionNot_1400_9_111() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionNot_1401_17_113()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionNot_1403_17_114()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionSS_1780_9_38() {
        if (PrismParser.jj_scan_token(70)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionSS_1783_17_41()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionSS_1785_17_42()) {
                return true;
            }
        }
        if (PrismParser.jj_scan_token(91)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionSS_1788_55_44()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_scan_token(92);
    }

    private static boolean jj_3R_ExpressionStrategyOptions_2158_9_234() {
        Token token;
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionStrategyOptions_2158_103_253());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionAnd_1388_11_112() {
        if (PrismParser.jj_scan_token(80)) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionNot_1400_9_111();
    }

    private static boolean jj_3R_ExpressionAnd_1387_9_109() {
        Token token;
        if (PrismParser.jj_3R_ExpressionNot_1400_9_111()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionAnd_1388_11_112());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionProb_1727_51_181() {
        return PrismParser.jj_3R_Filter_1756_9_52();
    }

    private static boolean jj_3R_Filter_1759_19_72() {
        return PrismParser.jj_scan_token(38);
    }

    private static boolean jj_3R_Filter_1758_19_71() {
        return PrismParser.jj_scan_token(42);
    }

    private static boolean jj_3R_ExpressionStrategyCoalitionPlayer_2146_9_278() {
        Token token = jj_scanpos;
        if (PrismParser.jj_scan_token(114)) {
            jj_scanpos = token;
            if (PrismParser.jj_scan_token(117)) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionOr_1375_11_110() {
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionAnd_1387_9_109();
    }

    private static boolean jj_3R_Filter_1757_11_62() {
        if (PrismParser.jj_scan_token(95)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_Filter_1758_19_71()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_Filter_1759_19_72()) {
                return true;
            }
        }
        return PrismParser.jj_scan_token(96);
    }

    private static boolean jj_3R_ExpressionOr_1374_9_107() {
        Token token;
        if (PrismParser.jj_3R_ExpressionAnd_1387_9_109()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionOr_1375_11_110());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionStrategy_2097_51_236() {
        return PrismParser.jj_3R_ExpressionReward_1824_9_155();
    }

    private static boolean jj_3_6() {
        return PrismParser.jj_scan_token(113);
    }

    private static boolean jj_3R_Filter_1756_9_52() {
        Token token;
        if (PrismParser.jj_scan_token(95)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        if (PrismParser.jj_scan_token(96)) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_Filter_1757_11_62());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionStrategyCoalition_2133_13_279() {
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionStrategyCoalitionPlayer_2146_9_278();
    }

    private static boolean jj_3R_ExpressionStrategyCoalition_2132_11_269() {
        Token token;
        if (PrismParser.jj_3R_ExpressionStrategyCoalitionPlayer_2146_9_278()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionStrategyCoalition_2133_13_279());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionStrategyCoalition_2132_9_261() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionStrategyCoalition_2132_11_269()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_ExpressionStrategyCoalition_2130_11_260() {
        return PrismParser.jj_scan_token(107);
    }

    private static boolean jj_3_1() {
        if (PrismParser.jj_scan_token(43)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        return PrismParser.jj_scan_token(97);
    }

    private static boolean jj_3R_ExpressionStrategyCoalition_2130_9_251() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionStrategyCoalition_2130_11_260()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionStrategyCoalition_2132_9_261()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionIff_1362_11_108() {
        if (PrismParser.jj_scan_token(83)) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionOr_1374_9_107();
    }

    private static boolean jj_3R_ExpressionIff_1361_9_97() {
        Token token;
        if (PrismParser.jj_3R_ExpressionOr_1374_9_107()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionIff_1362_11_108());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionStrategyCoalitionList_2117_10_252() {
        if (PrismParser.jj_scan_token(85)) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionStrategyCoalition_2130_9_251();
    }

    private static boolean jj_3R_ExpressionImplies_1349_11_98() {
        if (PrismParser.jj_scan_token(82)) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionImplies_1348_9_87();
    }

    private static boolean jj_3R_ExpressionStrategyCoalitionList_2116_9_233() {
        Token token;
        if (PrismParser.jj_3R_ExpressionStrategyCoalition_2130_9_251()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionStrategyCoalitionList_2117_10_252());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionImplies_1348_9_87() {
        if (PrismParser.jj_3R_ExpressionIff_1361_9_97()) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionImplies_1349_11_98()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_ExpressionProb_1712_26_243() {
        if (PrismParser.jj_scan_token(38)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1711_26_242() {
        if (PrismParser.jj_scan_token(42)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1710_26_241() {
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1725_10_180() {
        if (PrismParser.jj_scan_token(48)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1708_26_240() {
        if (PrismParser.jj_scan_token(38)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1717_17_214() {
        if (PrismParser.jj_scan_token(36)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1724_10_179() {
        if (PrismParser.jj_scan_token(49)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionITE_1334_17_88() {
        if (PrismParser.jj_scan_token(112)) {
            return true;
        }
        if (PrismParser.jj_3R_ExpressionImplies_1348_9_87()) {
            return true;
        }
        if (PrismParser.jj_scan_token(85)) {
            return true;
        }
        return PrismParser.jj_3R_ExpressionITE_1332_9_80();
    }

    private static boolean jj_3R_ExpressionProb_1707_26_239() {
        if (PrismParser.jj_scan_token(42)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1716_17_213() {
        if (PrismParser.jj_scan_token(37)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1723_10_178() {
        if (PrismParser.jj_scan_token(51)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1706_26_238() {
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1715_17_212() {
        if (PrismParser.jj_scan_token(40)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1722_10_177() {
        if (PrismParser.jj_scan_token(52)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1714_17_211() {
        if (PrismParser.jj_scan_token(41)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionProb_1721_10_176() {
        if (PrismParser.jj_scan_token(50)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3_14() {
        if (PrismParser.jj_3R_IdentifierExpression_2228_9_37()) {
            return true;
        }
        return PrismParser.jj_scan_token(89);
    }

    private static boolean jj_3R_ExpressionProb_1720_10_175() {
        if (PrismParser.jj_scan_token(53)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3_13() {
        if (PrismParser.jj_3R_IdentifierExpression_2228_9_37()) {
            return true;
        }
        return PrismParser.jj_scan_token(89);
    }

    private static boolean jj_3R_ExpressionProb_1704_25_207() {
        if (PrismParser.jj_3R_LtGt_2279_9_50()) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionProb_1703_26_206() {
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        if (PrismParser.jj_3R_IdentifierExpression_2228_9_37()) {
            return true;
        }
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3_12() {
        if (PrismParser.jj_3R_IdentifierExpression_2228_9_37()) {
            return true;
        }
        return PrismParser.jj_scan_token(89);
    }

    private static boolean jj_3_11() {
        if (PrismParser.jj_3R_IdentifierExpression_2228_9_37()) {
            return true;
        }
        return PrismParser.jj_scan_token(89);
    }

    private static boolean jj_3R_ExpressionProb_1710_17_210() {
        if (PrismParser.jj_scan_token(38)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionProb_1710_26_241()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionProb_1711_26_242()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionProb_1712_26_243()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionStrategy_2099_11_195() {
        return PrismParser.jj_3R_ExpressionParenth_1660_9_153();
    }

    private static boolean jj_3R_ExpressionStrategy_2097_11_235() {
        return PrismParser.jj_3R_ExpressionProb_1701_9_154();
    }

    private static boolean jj_3R_ExpressionITE_1332_9_80() {
        if (PrismParser.jj_3R_ExpressionImplies_1348_9_87()) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionITE_1334_17_88()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_ExpressionProb_1706_17_209() {
        if (PrismParser.jj_scan_token(42)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionProb_1706_26_238()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionProb_1707_26_239()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionProb_1708_26_240()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionStrategy_2097_9_194() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionStrategy_2097_11_235()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionStrategy_2097_51_236()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionStrategy_2097_93_237()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionProb_1705_17_208() {
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_TimeBound_1318_20_105() {
        return PrismParser.jj_3R_IdentifierExpression_2228_9_37();
    }

    private static boolean jj_3R_ExpressionStrategy_2093_10_193() {
        if (PrismParser.jj_scan_token(95)) {
            return true;
        }
        if (PrismParser.jj_3R_ExpressionStrategyOptions_2158_9_234()) {
            return true;
        }
        return PrismParser.jj_scan_token(96);
    }

    private static boolean jj_3R_TimeBound_1317_20_103() {
        return PrismParser.jj_3R_IdentifierExpression_2228_9_37();
    }

    private static boolean jj_3R_MultiNashRewardIndexes_2029_73_282() {
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_Update_917_36_46() {
        if (PrismParser.jj_scan_token(80)) {
            return true;
        }
        return PrismParser.jj_3R_UpdateElement_930_9_45();
    }

    private static boolean jj_3R_TimeBound_1316_20_101() {
        return PrismParser.jj_3R_IdentifierExpression_2228_9_37();
    }

    private static boolean jj_3R_ExpressionStrategy_2090_11_192() {
        if (PrismParser.jj_scan_token(93)) {
            return true;
        }
        if (PrismParser.jj_3R_ExpressionStrategyCoalitionList_2116_9_233()) {
            return true;
        }
        return PrismParser.jj_scan_token(94);
    }

    private static boolean jj_3R_TimeBound_1315_20_99() {
        return PrismParser.jj_3R_IdentifierExpression_2228_9_37();
    }

    private static boolean jj_3R_ExpressionStrategy_2089_10_191() {
        if (PrismParser.jj_scan_token(101)) {
            return true;
        }
        if (PrismParser.jj_3R_ExpressionStrategyCoalitionList_2116_9_233()) {
            return true;
        }
        return PrismParser.jj_scan_token(102);
    }

    private static boolean jj_3R_TimeBound_1320_11_94() {
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionProb_1703_10_174() {
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionProb_1703_26_206()) {
            jj_scanpos = token;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionProb_1704_25_207()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionProb_1705_17_208()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionProb_1706_17_209()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_ExpressionProb_1710_17_210()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_ExpressionProb_1714_17_211()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_ExpressionProb_1715_17_212()) {
                                jj_scanpos = token;
                                if (PrismParser.jj_3R_ExpressionProb_1716_17_213()) {
                                    jj_scanpos = token;
                                    if (PrismParser.jj_3R_ExpressionProb_1717_17_214()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_TimeBound_1319_11_93() {
        if (PrismParser.jj_scan_token(91)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        return PrismParser.jj_scan_token(92);
    }

    private static boolean jj_3R_ExpressionStrategy_2086_9_158() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionStrategy_2089_10_191()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionStrategy_2090_11_192()) {
                return true;
            }
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionStrategy_2093_10_193()) {
            jj_scanpos = token;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionStrategy_2097_9_194()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionStrategy_2099_11_195()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_TimeBound_1318_11_92() {
        if (PrismParser.jj_scan_token(100)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_TimeBound_1318_20_105()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_TimeBound_1318_99_106()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_TimeBound_1317_11_91() {
        if (PrismParser.jj_scan_token(104)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_TimeBound_1317_20_103()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_TimeBound_1317_99_104()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_TimeBound_1316_11_90() {
        if (PrismParser.jj_scan_token(99)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_TimeBound_1316_20_101()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_TimeBound_1316_99_102()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionProb_1701_9_154() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionProb_1703_10_174()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionProb_1720_10_175()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionProb_1721_10_176()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_ExpressionProb_1722_10_177()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_ExpressionProb_1723_10_178()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_ExpressionProb_1724_10_179()) {
                                jj_scanpos = token;
                                if (PrismParser.jj_3R_ExpressionProb_1725_10_180()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (PrismParser.jj_scan_token(91)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionProb_1727_51_181()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_scan_token(92);
    }

    private static boolean jj_3R_TimeBound_1315_11_89() {
        if (PrismParser.jj_scan_token(103)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_TimeBound_1315_20_99()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_TimeBound_1315_99_100()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_TimeBound_1315_9_81() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_TimeBound_1315_11_89()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_TimeBound_1316_11_90()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_TimeBound_1317_11_91()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_TimeBound_1318_11_92()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_TimeBound_1319_11_93()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_TimeBound_1320_11_94()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_UpdateElement_930_9_45() {
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        if (PrismParser.jj_3R_IdentifierPrime_2250_9_53()) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3R_ExpressionTemporalUnary_1302_17_66() {
        return PrismParser.jj_3R_ExpressionITE_1332_9_80();
    }

    private static boolean jj_3R_ExpressionTemporalUnary_1298_19_79() {
        return PrismParser.jj_3R_TimeBound_1315_9_81();
    }

    private static boolean jj_3R_ExpressionTemporalUnary_1297_19_78() {
        return PrismParser.jj_scan_token(30);
    }

    private static boolean jj_3R_ExpressionTemporalUnary_1296_19_77() {
        return PrismParser.jj_scan_token(26);
    }

    private static boolean jj_3R_ExpressionTemporalUnary_1295_19_76() {
        return PrismParser.jj_scan_token(44);
    }

    private static boolean jj_3R_Update_917_10_39() {
        Token token;
        if (PrismParser.jj_3R_UpdateElement_930_9_45()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_Update_917_36_46());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionTemporalUnary_1293_17_65() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionTemporalUnary_1295_19_76()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionTemporalUnary_1296_19_77()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionTemporalUnary_1297_19_78()) {
                    return true;
                }
            }
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionTemporalUnary_1298_19_79()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_3R_ExpressionTemporalUnary_1291_9_60();
    }

    private static boolean jj_3R_ExpressionMultiNash_1953_122_273() {
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_ExpressionForAll_2065_9_157() {
        if (PrismParser.jj_scan_token(3)) {
            return true;
        }
        if (PrismParser.jj_scan_token(91)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        return PrismParser.jj_scan_token(92);
    }

    private static boolean jj_3R_ExpressionMultiNash_1951_122_271() {
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_scan_token(112);
    }

    private static boolean jj_3R_Update_915_9_35() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_Update_917_10_39()) {
            jj_scanpos = token;
            if (PrismParser.jj_scan_token(76)) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3_5() {
        return PrismParser.jj_3R_Update_915_9_35();
    }

    private static boolean jj_3R_ExpressionTemporalUnary_1291_9_60() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionTemporalUnary_1293_17_65()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionTemporalUnary_1302_17_66()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionFuncArgs_1610_72_205() {
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionFuncOldStyle_1598_83_173() {
        return PrismParser.jj_3R_Identifier_2217_9_34();
    }

    private static boolean jj_3R_ExpressionTemporalBinary_1277_19_70() {
        return PrismParser.jj_3R_TimeBound_1315_9_81();
    }

    private static boolean jj_3R_ExpressionTemporalBinary_1276_19_69() {
        return PrismParser.jj_scan_token(69);
    }

    private static boolean jj_3R_ExpressionTemporalBinary_1275_19_68() {
        return PrismParser.jj_scan_token(78);
    }

    private static boolean jj_3R_ExpressionTemporalBinary_1274_19_67() {
        return PrismParser.jj_scan_token(77);
    }

    private static boolean jj_3R_ExpressionTemporalBinary_1272_17_61() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionTemporalBinary_1274_19_67()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionTemporalBinary_1275_19_68()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionTemporalBinary_1276_19_69()) {
                    return true;
                }
            }
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionTemporalBinary_1277_19_70()) {
            jj_scanpos = token;
        }
        return PrismParser.jj_3R_ExpressionTemporalUnary_1291_9_60();
    }

    private static boolean jj_3R_ExpressionExists_2046_9_156() {
        if (PrismParser.jj_scan_token(14)) {
            return true;
        }
        if (PrismParser.jj_scan_token(91)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        return PrismParser.jj_scan_token(92);
    }

    private static boolean jj_3R_ExpressionParenth_1660_9_153() {
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3_19() {
        return PrismParser.jj_scan_token(113);
    }

    private static boolean jj_3R_ExpressionTemporalBinary_1269_9_51() {
        if (PrismParser.jj_3R_ExpressionTemporalUnary_1291_9_60()) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionTemporalBinary_1272_17_61()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_ExpressionFuncOldStyle_1598_60_172() {
        return PrismParser.jj_scan_token(38);
    }

    private static boolean jj_3R_MultiNashRewardIndexes_2029_10_281() {
        if (PrismParser.jj_scan_token(113)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        return PrismParser.jj_scan_token(113);
    }

    private static boolean jj_3R_ExpressionLiteral_1647_9_164() {
        return PrismParser.jj_scan_token(22);
    }

    private static boolean jj_3R_MultiNashRewardIndexes_2028_9_280() {
        if (PrismParser.jj_scan_token(95)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_MultiNashRewardIndexes_2029_10_281()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_MultiNashRewardIndexes_2029_73_282()) {
                return true;
            }
        }
        return PrismParser.jj_scan_token(96);
    }

    private static boolean jj_3R_ExpressionLiteral_1645_9_163() {
        return PrismParser.jj_scan_token(76);
    }

    private static boolean jj_3R_ExpressionLiteral_1634_9_162() {
        return PrismParser.jj_scan_token(115);
    }

    private static boolean jj_3R_ExpressionFuncOldStyle_1598_37_171() {
        return PrismParser.jj_scan_token(42);
    }

    private static boolean jj_3R_ExpressionMultiNashReward_2008_9_275() {
        if (PrismParser.jj_scan_token(69)) {
            return true;
        }
        if (PrismParser.jj_3R_MultiNashRewardIndexes_2028_9_280()) {
            return true;
        }
        if (PrismParser.jj_scan_token(91)) {
            return true;
        }
        if (PrismParser.jj_3R_ExpressionRewardContents_1915_9_189()) {
            return true;
        }
        return PrismParser.jj_scan_token(92);
    }

    private static boolean jj_3R_Expression_1239_9_43() {
        return PrismParser.jj_3R_ExpressionTemporalBinary_1269_9_51();
    }

    private static boolean jj_3R_ExpressionLiteral_1621_9_161() {
        return PrismParser.jj_scan_token(114);
    }

    private static boolean jj_3R_ExpressionLiteral_1620_9_149() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionLiteral_1621_9_161()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionLiteral_1634_9_162()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionLiteral_1645_9_163()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_ExpressionLiteral_1647_9_164()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_RewardIndex_1884_125_257() {
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionFuncMinMax_1584_42_169() {
        return PrismParser.jj_scan_token(38);
    }

    private static boolean jj_3R_SystemHideRename_1161_81_95() {
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        return PrismParser.jj_3R_Identifier_2217_9_34();
    }

    private static boolean jj_3R_ExpressionFuncArgs_1610_9_170() {
        Token token;
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionFuncArgs_1610_72_205());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionMultiNashProb_1986_9_274() {
        if (PrismParser.jj_scan_token(54)) {
            return true;
        }
        if (PrismParser.jj_scan_token(91)) {
            return true;
        }
        if (PrismParser.jj_3R_Expression_1239_9_43()) {
            return true;
        }
        return PrismParser.jj_scan_token(92);
    }

    private static boolean jj_3R_RewardIndex_1889_101_268() {
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionFuncOldStyle_1598_9_152() {
        if (PrismParser.jj_scan_token(25)) {
            return true;
        }
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionFuncOldStyle_1598_37_171()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionFuncOldStyle_1598_60_172()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionFuncOldStyle_1598_83_173()) {
                    return true;
                }
            }
        }
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        if (PrismParser.jj_3R_ExpressionFuncArgs_1610_9_170()) {
            return true;
        }
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3R_ExpressionMultiNash_1964_25_277() {
        return PrismParser.jj_3R_ExpressionMultiNashReward_2008_9_275();
    }

    private static boolean jj_3R_ExpressionMultiNash_1962_26_276() {
        return PrismParser.jj_3R_ExpressionMultiNashProb_1986_9_274();
    }

    private static boolean jj_3R_ExpressionMultiNash_1961_18_266() {
        if (PrismParser.jj_scan_token(105)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionMultiNash_1962_26_276()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionMultiNash_1964_25_277()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionFuncMinMax_1584_11_168() {
        return PrismParser.jj_scan_token(42);
    }

    private static boolean jj_3R_ExpressionMultiNash_1959_17_265() {
        return PrismParser.jj_3R_ExpressionMultiNashReward_2008_9_275();
    }

    private static boolean jj_3R_ExpressionFuncMinMax_1584_9_151() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionFuncMinMax_1584_11_168()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionFuncMinMax_1584_42_169()) {
                return true;
            }
        }
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        if (PrismParser.jj_3R_ExpressionFuncArgs_1610_9_170()) {
            return true;
        }
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3R_ExpressionMultiNash_1957_18_264() {
        return PrismParser.jj_3R_ExpressionMultiNashProb_1986_9_274();
    }

    private static boolean jj_3R_ExpressionMultiNash_1953_16_272() {
        if (PrismParser.jj_3R_LtGt_2279_9_50()) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionMultiNash_1951_16_270() {
        if (PrismParser.jj_3R_LtGt_2279_9_50()) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_SystemAtomic_1191_10_84() {
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        if (PrismParser.jj_3R_SystemDefn_1068_9_36()) {
            return true;
        }
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3R_ExpressionFuncOrIdent_1571_11_167() {
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        if (PrismParser.jj_3R_ExpressionFuncArgs_1610_9_170()) {
            return true;
        }
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3R_SystemAtomic_1189_10_83() {
        if (PrismParser.jj_scan_token(113)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        return PrismParser.jj_scan_token(113);
    }

    private static boolean jj_3R_ExpressionMultiNash_1953_9_263() {
        if (PrismParser.jj_scan_token(38)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionMultiNash_1953_16_272()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionMultiNash_1953_122_273()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionFuncOrIdent_1568_11_166() {
        return PrismParser.jj_3R_IdentifierPrime_2250_9_53();
    }

    private static boolean jj_3R_SystemAtomic_1187_9_82() {
        return PrismParser.jj_3R_Identifier_2217_9_34();
    }

    private static boolean jj_3R_SystemParallel_1131_65_75() {
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        return PrismParser.jj_3R_Identifier_2217_9_34();
    }

    private static boolean jj_3R_ExpressionFuncOrIdent_1567_11_165() {
        return PrismParser.jj_3R_Identifier_2217_9_34();
    }

    private static boolean jj_3R_ExpressionMultiNash_1951_9_262() {
        if (PrismParser.jj_scan_token(42)) {
            return true;
        }
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionMultiNash_1951_16_270()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionMultiNash_1951_122_271()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_RewardIndex_1884_75_256() {
        if (PrismParser.jj_scan_token(11)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_SystemAtomic_1184_9_73() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_SystemAtomic_1187_9_82()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_SystemAtomic_1189_10_83()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_SystemAtomic_1191_10_84()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionMultiNash_1949_9_254() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionMultiNash_1951_9_262()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionMultiNash_1953_9_263()) {
                return true;
            }
        }
        if (PrismParser.jj_scan_token(89)) {
            return true;
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionMultiNash_1957_18_264()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionMultiNash_1959_17_265()) {
                return true;
            }
        }
        if (PrismParser.jj_3R_ExpressionMultiNash_1961_18_266()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_ExpressionMultiNash_1961_18_266());
        jj_scanpos = token;
        return PrismParser.jj_scan_token(90);
    }

    private static boolean jj_3R_ExpressionFuncOrIdent_1566_9_150() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionFuncOrIdent_1567_11_165()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionFuncOrIdent_1568_11_166()) {
                return true;
            }
        }
        token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionFuncOrIdent_1571_11_167()) {
            jj_scanpos = token;
        }
        return false;
    }

    private static boolean jj_3R_SystemHideRename_1168_19_96() {
        if (PrismParser.jj_scan_token(87)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        if (PrismParser.jj_scan_token(111)) {
            return true;
        }
        return PrismParser.jj_3R_Identifier_2217_9_34();
    }

    private static boolean jj_3_9() {
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        return PrismParser.jj_scan_token(81);
    }

    private static boolean jj_3R_ExpressionBasic_1543_17_148() {
        return PrismParser.jj_3R_ExpressionFilter_2190_9_160();
    }

    private static boolean jj_3_18() {
        if (PrismParser.jj_scan_token(10)) {
            return true;
        }
        return PrismParser.jj_scan_token(103);
    }

    private static boolean jj_3R_SystemInterleaved_1106_70_55() {
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        return PrismParser.jj_3R_SystemFullParallel_1081_9_40();
    }

    private static boolean jj_3R_SystemHideRename_1165_11_86() {
        Token token;
        if (PrismParser.jj_scan_token(95)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        if (PrismParser.jj_scan_token(111)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_SystemHideRename_1168_19_96());
        jj_scanpos = token;
        return PrismParser.jj_scan_token(96);
    }

    private static boolean jj_3R_ExpressionBasic_1541_17_147() {
        return PrismParser.jj_3R_ExpressionLabel_2172_9_159();
    }

    private static boolean jj_3R_ExpressionRewardContents_1929_11_232() {
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionBasic_1539_17_146() {
        return PrismParser.jj_3R_ExpressionStrategy_2086_9_158();
    }

    private static boolean jj_3R_ExpressionRewardContents_1926_11_231() {
        if (PrismParser.jj_scan_token(28)) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionBasic_1537_17_145() {
        return PrismParser.jj_3R_ExpressionForAll_2065_9_157();
    }

    private static boolean jj_3_17() {
        return PrismParser.jj_3R_ExpressionSS_1780_9_38();
    }

    private static boolean jj_3R_ExpressionRewardContents_1925_11_230() {
        if (PrismParser.jj_scan_token(27)) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionRewardContents_1924_11_229() {
        if (PrismParser.jj_scan_token(33)) {
            return true;
        }
        if (PrismParser.jj_scan_token(97)) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionBasic_1535_17_144() {
        return PrismParser.jj_3R_ExpressionExists_2046_9_156();
    }

    private static boolean jj_3R_ExpressionRewardContents_1923_11_228() {
        return PrismParser.jj_scan_token(10);
    }

    private static boolean jj_3R_SystemHideRename_1159_9_85() {
        Token token;
        if (PrismParser.jj_scan_token(108)) {
            return true;
        }
        if (PrismParser.jj_scan_token(95)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_SystemHideRename_1161_81_95());
        jj_scanpos = token;
        return PrismParser.jj_scan_token(96);
    }

    private static boolean jj_3R_SystemHideRename_1159_9_74() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_SystemHideRename_1159_9_85()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_SystemHideRename_1165_11_86()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionRewardContents_1922_11_227() {
        if (PrismParser.jj_scan_token(10)) {
            return true;
        }
        if (PrismParser.jj_scan_token(103)) {
            return true;
        }
        return PrismParser.jj_3R_Expression_1239_9_43();
    }

    private static boolean jj_3R_ExpressionBasic_1533_17_143() {
        return PrismParser.jj_3R_ExpressionReward_1824_9_155();
    }

    private static boolean jj_3_16() {
        return PrismParser.jj_scan_token(113);
    }

    private static boolean jj_3R_SystemHideRename_1156_9_63() {
        Token token;
        if (PrismParser.jj_3R_SystemAtomic_1184_9_73()) {
            return true;
        }
        do {
            token = jj_scanpos;
        } while (!PrismParser.jj_3R_SystemHideRename_1159_9_74());
        jj_scanpos = token;
        return false;
    }

    private static boolean jj_3R_ExpressionBasic_1531_17_142() {
        return PrismParser.jj_3R_ExpressionSS_1780_9_38();
    }

    private static boolean jj_3R_ExpressionRewardContents_1919_11_226() {
        return PrismParser.jj_scan_token(70);
    }

    private static boolean jj_3_8() {
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        return PrismParser.jj_scan_token(81);
    }

    private static boolean jj_3R_ExpressionBasic_1529_17_141() {
        return PrismParser.jj_3R_ExpressionProb_1701_9_154();
    }

    private static boolean jj_3R_ExpressionRewardContents_1918_9_225() {
        return PrismParser.jj_3R_ExpressionSS_1780_9_38();
    }

    private static boolean jj_3_4() {
        return PrismParser.jj_scan_token(35);
    }

    private static boolean jj_3R_ExpressionBasic_1526_17_140() {
        return PrismParser.jj_3R_ExpressionParenth_1660_9_153();
    }

    private static boolean jj_3R_ExpressionRewardContents_1915_9_189() {
        Token token = jj_scanpos;
        if (PrismParser.jj_3R_ExpressionRewardContents_1918_9_225()) {
            jj_scanpos = token;
            if (PrismParser.jj_3R_ExpressionRewardContents_1919_11_226()) {
                jj_scanpos = token;
                if (PrismParser.jj_3R_ExpressionRewardContents_1922_11_227()) {
                    jj_scanpos = token;
                    if (PrismParser.jj_3R_ExpressionRewardContents_1923_11_228()) {
                        jj_scanpos = token;
                        if (PrismParser.jj_3R_ExpressionRewardContents_1924_11_229()) {
                            jj_scanpos = token;
                            if (PrismParser.jj_3R_ExpressionRewardContents_1925_11_230()) {
                                jj_scanpos = token;
                                if (PrismParser.jj_3R_ExpressionRewardContents_1926_11_231()) {
                                    jj_scanpos = token;
                                    if (PrismParser.jj_3R_ExpressionRewardContents_1929_11_232()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_ExpressionBasic_1524_17_139() {
        return PrismParser.jj_3R_ExpressionFuncOldStyle_1598_9_152();
    }

    private static boolean jj_3R_RewardIndex_1889_33_267() {
        if (PrismParser.jj_scan_token(113)) {
            return true;
        }
        if (PrismParser.jj_3R_Identifier_2217_9_34()) {
            return true;
        }
        return PrismParser.jj_scan_token(113);
    }

    private static boolean jj_3_3() {
        if (PrismParser.jj_scan_token(35)) {
            return true;
        }
        return PrismParser.jj_scan_token(113);
    }

    private static boolean jj_3R_ExpressionBasic_1522_17_138() {
        return PrismParser.jj_3R_ExpressionFuncMinMax_1584_9_151();
    }

    private static boolean jj_3R_ExpressionReward_1852_69_190() {
        return PrismParser.jj_3R_Filter_1756_9_52();
    }

    private static boolean jj_3R_SystemFullParallel_1083_71_48() {
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        return PrismParser.jj_3R_SystemParallel_1128_9_54();
    }

    private static boolean jj_3R_ExpressionBasic_1520_17_137() {
        return PrismParser.jj_3R_ExpressionFuncOrIdent_1566_9_150();
    }

    private static boolean jj_3R_ExpressionTimesDivide_1471_64_132() {
        return PrismParser.jj_scan_token(108);
    }

    private static boolean jj_3R_ExpressionBasic_1518_17_136() {
        return PrismParser.jj_3R_ExpressionLiteral_1620_9_149();
    }

    private static boolean jj_3_10() {
        if (PrismParser.jj_scan_token(81)) {
            return true;
        }
        return PrismParser.jj_scan_token(91);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{-1602214976, 545268672, Integer.MIN_VALUE, 54542408, 0, 54542408, 54542408, 0, 54542408, 8192, 0, 256, 9088, 4112, 4112, 0, 64, 0, Integer.MIN_VALUE, 48, 0, 0, 0, 0, 1195393032, 1195393032, 0, 0, 0, 1195393032, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x44000000, 0, 1195393032, 1195393032, 1195393032, 1195393032, 1195393032, 0, 0, 0, 0, 0, 0, 54542344, 0, 0, 0, 0, 0, 0, 0, 54542344, 54542344, 0, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1195395080, 0, 1195393032, 0, 0, 1598047240, 0, 0, 0, 0, 0, 0, 1195393032, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{2139154568, 1056972936, 1082181632, -1468070840, 0, -1468070840, -1468070840, 0, -1468070840, 0x4000000, 8320, 0, 385884288, 4, 4, 0x28000000, 0x28000000, 0, 0, 4, 0, 1, 0, 0, -2139155392, -2139155392, 0, 0, 0, -2139155392, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, -2139155392, -2139155392, -2139155392, -2139155392, -2139155392, 0, 0, 0, 0, 0, 0, -2139159488, 0, 0, 0, 0, 0, 0, 0, -2139159488, -2139159488, 0, 0, 1088, 1088, 0, 0, 0, 1088, 1088, 1904, 0x7F0000, 0, 0, 1088, 0, 0, 0, 0, 0, 1088, 1088, 1904, Integer.MIN_VALUE, 0, -2139155392, 0, -2139155392, 0, 0, -2139155390, 0, 0, 1088, 0x400000, 0x400000, 0, -2139155392, 0, 0, -2139159488, -2139159488, 0, 0, 0, 0, 0, 0, 0, 1088, 0, 1088, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{3968, 2944, 1024, 570462335, 0x400000, 570462335, 570462335, 0x400000, 570462335, 0, 0, 128, 2944, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0x8000000, 0, 704680063, 704680063, 65536, 0x2001000, 0x800000, 704680063, 0x8000000, 0x800000, 0, 0x800000, 0x800000, Integer.MIN_VALUE, 0x800000, 0x800000, Integer.MIN_VALUE, 0x2000000, 0x800000, 0x8000000, 0x8000000, 24608, 0x8000000, 24608, 0, 0x8000000, 570462335, 570462335, 570462335, 570462335, 570462335, 0x8000000, 0, 262144, 524288, 131072, 65536, 570462335, 0, 0, 0, 0, 0, 0, 0, 570429567, 570429567, 0, 0x2000000, 0, 0, 0x800000, 4096, 0x2000000, 0, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0x2000000, 0x2000000, Integer.MIN_VALUE, 0x2000000, Integer.MIN_VALUE, 0, 0, 0, 63, Integer.MIN_VALUE, 570462335, 0x800000, 570462335, 0, 64, 570462335, 0, 0, 0, 32, 32, 0, 570462335, 0x20000000, Integer.MIN_VALUE, 63, 33554495, 0x200000, 0x800000, 0, 0, 0, 0x800000, 0, 196608, 0x800000, 0, 0, 0, 0x200000};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 4064288, 0, 4064288, 4064288, 0, 4064288, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0x200000, 0, 0, 512, 4064288, 4064288, 0, 0, 0, 4064288, 0, 0, 0x200000, 0, 0, 4096, 0, 0, 4096, 0x220000, 0, 0x200000, 0x200000, 0, 410, 0, 0, 410, 4064288, 4064288, 4064288, 4064288, 4064288, 410, 65536, 0, 0, 0, 0, 4064288, 6, 408, 1536, 1536, 6144, 6144, 8192, 4064288, 4063264, 0x300000, 0, 0, 0x200000, 0, 786432, 0, 2, 2, 410, 0, 0, 0, 0, 0, 410, 0, 0, 0, 2, 2, 410, 0, 0, 4064288, 0, 4064288, 4096, 0, 4064288, 410, 410, 0, 0, 0, 512, 4064288, 32, 0, 0, 0, 0, 0, 0x240000, 2048, 0x240000, 0, 0x200000, 0x200200, 0, 0x200000, 6, 408, 0};
    }

    public PrismParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public PrismParser(InputStream inputStream, String string) {
        int n;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("\t   You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("\t   during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        token_source = new PrismParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 123; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    public static void ReInit(InputStream inputStream) {
        PrismParser.ReInit(inputStream, null);
    }

    public static void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        PrismParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 123; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    public PrismParser(Reader reader) {
        int n;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("\t   You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("\t   during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(reader, 1, 1);
        token_source = new PrismParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 123; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    public static void ReInit(Reader reader) {
        int n;
        if (jj_input_stream == null) {
            jj_input_stream = new SimpleCharStream(reader, 1, 1);
        } else {
            jj_input_stream.ReInit(reader, 1, 1);
        }
        if (token_source == null) {
            token_source = new PrismParserTokenManager(jj_input_stream);
        }
        PrismParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 123; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    public PrismParser(PrismParserTokenManager prismParserTokenManager) {
        int n;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("\t   You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("\t   during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = prismParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 123; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(PrismParserTokenManager prismParserTokenManager) {
        int n;
        token_source = prismParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (n = 0; n < 123; ++n) {
            PrismParser.jj_la1[n] = -1;
        }
        for (n = 0; n < jj_2_rtns.length; ++n) {
            PrismParser.jj_2_rtns[n] = new JJCalls();
        }
    }

    private static Token jj_consume_token(int n) throws ParseException {
        Token token = PrismParser.token;
        PrismParser.token = token.next != null ? PrismParser.token.next : (PrismParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (PrismParser.token.kind == n) {
            ++jj_gen;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return PrismParser.token;
        }
        PrismParser.token = token;
        jj_kind = n;
        throw PrismParser.generateParseException();
    }

    private static boolean jj_scan_token(int n) {
        if (jj_scanpos == jj_lastpos) {
            --jj_la;
            if (PrismParser.jj_scanpos.next == null) {
                jj_scanpos = PrismParser.jj_scanpos.next = token_source.getNextToken();
                jj_lastpos = PrismParser.jj_scanpos.next;
            } else {
                jj_lastpos = jj_scanpos = PrismParser.jj_scanpos.next;
            }
        } else {
            jj_scanpos = PrismParser.jj_scanpos.next;
        }
        if (jj_rescan) {
            int n2 = 0;
            Token token = PrismParser.token;
            while (token != null && token != jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                PrismParser.jj_add_error_token(n, n2);
            }
        }
        if (PrismParser.jj_scanpos.kind != n) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public static final Token getNextToken() {
        token = PrismParser.token.next != null ? PrismParser.token.next : (PrismParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int n) {
        Token token = PrismParser.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = token_source.getNextToken());
        }
        return token;
    }

    private static int jj_ntk_f() {
        jj_nt = PrismParser.token.next;
        if (jj_nt == null) {
            PrismParser.token.next = token_source.getNextToken();
            jj_ntk = PrismParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = PrismParser.jj_nt.kind;
        return jj_ntk;
    }

    private static void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == jj_endpos + 1) {
            PrismParser.jj_lasttokens[PrismParser.jj_endpos++] = n;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; ++i) {
                PrismParser.jj_expentry[i] = jj_lasttokens[i];
            }
            for (int[] nArray : jj_expentries) {
                if (nArray.length != jj_expentry.length) continue;
                boolean bl = true;
                for (int i = 0; i < jj_expentry.length; ++i) {
                    if (nArray[i] == jj_expentry[i]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                jj_expentries.add(jj_expentry);
                break;
            }
            if (n2 != 0) {
                jj_endpos = n2;
                PrismParser.jj_lasttokens[PrismParser.jj_endpos - 1] = n;
            }
        }
    }

    public static ParseException generateParseException() {
        int n;
        int n2;
        jj_expentries.clear();
        boolean[] blArray = new boolean[120];
        if (jj_kind >= 0) {
            blArray[PrismParser.jj_kind] = true;
            jj_kind = -1;
        }
        for (n2 = 0; n2 < 123; ++n2) {
            if (jj_la1[n2] != jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) != 0) {
                    blArray[64 + n] = true;
                }
                if ((jj_la1_3[n2] & 1 << n) == 0) continue;
                blArray[96 + n] = true;
            }
        }
        for (n2 = 0; n2 < 120; ++n2) {
            if (!blArray[n2]) continue;
            jj_expentry = new int[1];
            PrismParser.jj_expentry[0] = n2;
            jj_expentries.add(jj_expentry);
        }
        jj_endpos = 0;
        PrismParser.jj_rescan_token();
        PrismParser.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[jj_expentries.size()][];
        for (n = 0; n < jj_expentries.size(); ++n) {
            nArrayArray[n] = jj_expentries.get(n);
        }
        return new ParseException(token, nArrayArray, tokenImage);
    }

    public static final boolean trace_enabled() {
        return trace_enabled;
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    private static void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 19; ++i) {
            try {
                JJCalls jJCalls = jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= jj_gen) continue;
                    jj_la = jJCalls.arg;
                    jj_lastpos = jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            PrismParser.jj_3_1();
                            break;
                        }
                        case 1: {
                            PrismParser.jj_3_2();
                            break;
                        }
                        case 2: {
                            PrismParser.jj_3_3();
                            break;
                        }
                        case 3: {
                            PrismParser.jj_3_4();
                            break;
                        }
                        case 4: {
                            PrismParser.jj_3_5();
                            break;
                        }
                        case 5: {
                            PrismParser.jj_3_6();
                            break;
                        }
                        case 6: {
                            PrismParser.jj_3_7();
                            break;
                        }
                        case 7: {
                            PrismParser.jj_3_8();
                            break;
                        }
                        case 8: {
                            PrismParser.jj_3_9();
                            break;
                        }
                        case 9: {
                            PrismParser.jj_3_10();
                            break;
                        }
                        case 10: {
                            PrismParser.jj_3_11();
                            break;
                        }
                        case 11: {
                            PrismParser.jj_3_12();
                            break;
                        }
                        case 12: {
                            PrismParser.jj_3_13();
                            break;
                        }
                        case 13: {
                            PrismParser.jj_3_14();
                            break;
                        }
                        case 14: {
                            PrismParser.jj_3_15();
                            break;
                        }
                        case 15: {
                            PrismParser.jj_3_16();
                            break;
                        }
                        case 16: {
                            PrismParser.jj_3_17();
                            break;
                        }
                        case 17: {
                            PrismParser.jj_3_18();
                            break;
                        }
                        case 18: {
                            PrismParser.jj_3_19();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        jj_rescan = false;
    }

    private static void jj_save(int n, int n2) {
        JJCalls jJCalls = jj_2_rtns[n];
        while (jJCalls.gen > jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = jj_gen + n2 - jj_la;
        jJCalls.first = token;
        jJCalls.arg = n2;
    }

    static {
        keywordList = new ArrayList();
        keywordList.clear();
        for (int i = 3; i < 79; ++i) {
            keywordList.add(PrismParserConstants.tokenImage[i].replaceAll("\"", ""));
        }
        jj_initialized_once = false;
        jj_la1 = new int[123];
        PrismParser.jj_la1_init_0();
        PrismParser.jj_la1_init_1();
        PrismParser.jj_la1_init_2();
        PrismParser.jj_la1_init_3();
        jj_2_rtns = new JJCalls[19];
        jj_rescan = false;
        jj_gc = 0;
        jj_ls = new LookaheadSuccess();
        jj_expentries = new ArrayList<int[]>();
        jj_kind = -1;
        jj_lasttokens = new int[100];
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    static class ExpressionPair {
        public Expression expr1 = null;
        public Expression expr2 = null;

        ExpressionPair() {
        }
    }
}

