/*
 * Decompiled with CFR 0.152.
 */
package param;

import common.IterableBitSet;
import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.CTMC;
import explicit.DTMC;
import explicit.DTMCFromMDPMemorylessAdversary;
import explicit.DTMCModelChecker;
import explicit.MDP;
import explicit.MDPModelChecker;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ProbModelChecker;
import explicit.rewards.MCRewards;
import explicit.rewards.MCRewardsFromMDPRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.MDPRewardsSimple;
import explicit.rewards.Rewards;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import param.BigRational;
import param.BoxRegion;
import param.ConstraintChecker;
import param.Function;
import param.FunctionFactory;
import param.Lumper;
import param.MutablePMC;
import param.NullLumper;
import param.ParamMode;
import param.Point;
import param.Region;
import param.RegionFactory;
import param.RegionIntersection;
import param.RegionValues;
import param.RegionValuesIntersections;
import param.RegionsTODO;
import param.Scheduler;
import param.StateEliminator;
import param.StateValues;
import param.StrongLumper;
import param.WeakLumper;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;

final class ValueComputer
extends PrismComponent {
    private ParamMode mode;
    private RegionFactory regionFactory;
    private FunctionFactory functionFactory;
    private ConstraintChecker constraintChecker;
    private BigRational precision;
    private HashMap<SchedulerCacheKey, ArrayList<Scheduler>> schedCache;
    private HashMap<ResultCacheKey, ResultCacheEntry> resultCache;
    private StateEliminator.EliminationOrder eliminationOrder;
    private Lumper.BisimType bisimType;

    ValueComputer(PrismComponent prismComponent, ParamMode paramMode, RegionFactory regionFactory, BigRational bigRational, StateEliminator.EliminationOrder eliminationOrder, Lumper.BisimType bisimType) {
        super(prismComponent);
        this.mode = paramMode;
        this.regionFactory = regionFactory;
        this.functionFactory = regionFactory.getFunctionFactory();
        this.constraintChecker = regionFactory.getConstraintChecker();
        this.precision = bigRational;
        this.schedCache = new HashMap();
        this.resultCache = new HashMap();
        this.eliminationOrder = eliminationOrder;
        this.bisimType = bisimType;
    }

    RegionValues computeUnbounded(Model<?> model, RegionValues regionValues, RegionValues regionValues2, boolean bl, Rewards<?> rewards) throws PrismException {
        RegionValues regionValues3 = new RegionValues(this.regionFactory);
        RegionValuesIntersections regionValuesIntersections = new RegionValuesIntersections(regionValues, regionValues2);
        for (RegionIntersection regionIntersection : regionValuesIntersections) {
            Region region = regionIntersection.getRegion();
            StateValues stateValues = regionIntersection.getStateValues1();
            StateValues stateValues2 = regionIntersection.getStateValues2();
            RegionValues regionValues4 = this.computeUnbounded(model, region, stateValues, stateValues2, bl, rewards);
            regionValues3.addAll(regionValues4);
        }
        return regionValues3;
    }

    private RegionValues computeUnbounded(Model<?> model, Region region, StateValues stateValues, StateValues stateValues2, boolean bl, Rewards<?> rewards) throws PrismException {
        switch (model.getModelType()) {
            case CTMC: 
            case DTMC: {
                return this.computeUnboundedMC((DTMC)model, region, stateValues, stateValues2, (MCRewards)rewards);
            }
            case MDP: {
                return this.computeUnboundedMDP((MDP)model, region, stateValues, stateValues2, bl, (MDPRewards)rewards);
            }
        }
        throw new PrismNotSupportedException("Parametric unbounded reachability computation not supported for " + String.valueOf((Object)model.getModelType()));
    }

    private RegionValues computeUnboundedMC(DTMC<Function> dTMC, Region region, StateValues stateValues, StateValues stateValues2, MCRewards<Function> mCRewards) throws PrismException {
        Object object;
        Object object2;
        BitSet bitSet = null;
        if (mCRewards != null) {
            object2 = new DTMCModelChecker(this);
            ((ProbModelChecker)object2).setSilentPrecomputations(true);
            bitSet = ((DTMCModelChecker)object2).prob1(dTMC, stateValues.toBitSet(), stateValues2.toBitSet());
            bitSet.flip(0, dTMC.getNumStates());
            object = new IterableStateSet(bitSet, dTMC.getNumStates()).iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                stateValues.setStateValue(n, false);
            }
        }
        object2 = this.buildAlterablePMCForReach(dTMC, stateValues, stateValues2, mCRewards);
        object = this.computeValues((MutablePMC)object2, dTMC.getFirstInitialState());
        if (mCRewards != null) {
            FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, dTMC.getNumStates()).iterator();
            while (ofInt.hasNext()) {
                int n = (Integer)ofInt.next();
                ((StateValues)object).setStateValue(n, this.functionFactory.getInf());
            }
        }
        return this.regionFactory.completeCover((StateValues)object);
    }

    private RegionValues computeUnboundedMDP(MDP<Function> mDP, Region region, StateValues stateValues, StateValues stateValues2, boolean bl, MDPRewards<Function> mDPRewards) throws PrismException {
        Object object;
        Object object2;
        Object object3;
        BigRational bigRational = region.volume().multiply(this.precision);
        BigRational bigRational2 = region.volume().subtract(bigRational);
        RegionValues regionValues = new RegionValues(this.regionFactory);
        RegionsTODO regionsTODO = new RegionsTODO();
        regionsTODO.add(region);
        BigRational bigRational3 = BigRational.ZERO;
        if (mDPRewards != null) {
            object3 = new MDPModelChecker(this);
            ((ProbModelChecker)object3).setSilentPrecomputations(true);
            object2 = ((MDPModelChecker)object3).prob1(mDP, stateValues.toBitSet(), stateValues2.toBitSet(), !bl, null);
            ((BitSet)object2).flip(0, mDP.getNumStates());
            object = new IterableStateSet((BitSet)object2, mDP.getNumStates()).iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                stateValues.setStateValue(n, false);
            }
        }
        object3 = new Scheduler(mDP);
        this.precomputeScheduler(mDP, (Scheduler)object3, stateValues, stateValues2, mDPRewards, bl);
        while (bigRational3.compareTo(bigRational2) == -1) {
            Function[] functionArray;
            StateValues stateValues3;
            Object object4;
            object2 = regionsTODO.poll();
            object = ((BoxRegion)object2).getMidPoint();
            Scheduler scheduler = this.computeOptConcreteReachScheduler((Point)object, mDP, stateValues, stateValues2, bl, mDPRewards, (Scheduler)object3);
            if (scheduler == null) {
                if (((Region)object2).volume().compareTo(bigRational) <= 0) {
                    bigRational2 = bigRational2.subtract(((Region)object2).volume());
                    continue;
                }
                regionsTODO.addAll(((Region)object2).split());
                continue;
            }
            ResultCacheEntry resultCacheEntry = this.lookupValues(PropType.REACH, stateValues, stateValues2, mDPRewards, scheduler, bl);
            if (resultCacheEntry == null) {
                DTMCFromMDPMemorylessAdversary<Function> dTMCFromMDPMemorylessAdversary = new DTMCFromMDPMemorylessAdversary<Function>(mDP, scheduler.choices);
                object4 = mDPRewards == null ? null : new MCRewardsFromMDPRewards<Function>(mDPRewards, scheduler.choices);
                MutablePMC mutablePMC = this.buildAlterablePMCForReach((DTMC<Function>)dTMCFromMDPMemorylessAdversary, stateValues, stateValues2, (MCRewards<Function>)object4);
                stateValues3 = this.computeValues(mutablePMC, mDP.getFirstInitialState());
                functionArray = this.computeCompare(mDP, stateValues, stateValues2, mDPRewards, scheduler, bl, stateValues3);
                this.storeValues(PropType.REACH, stateValues, stateValues2, mDPRewards, scheduler, bl, stateValues3, functionArray);
            } else {
                stateValues3 = resultCacheEntry.getValues();
                functionArray = resultCacheEntry.getCompare();
            }
            boolean bl2 = true;
            object4 = null;
            for (Function function : functionArray) {
                object4 = function;
                if (this.constraintChecker.check((Region)object2, function, false)) continue;
                bl2 = false;
            }
            if (bl2) {
                bigRational3 = bigRational3.add(((Region)object2).volume());
                regionValues.add((Region)object2, stateValues3);
                continue;
            }
            regionsTODO.addAll(((Region)object2).split((Function)object4));
        }
        return regionValues;
    }

    private Function[] computeCompare(MDP<Function> mDP, StateValues stateValues, StateValues stateValues2, MDPRewards<Function> mDPRewards, Scheduler scheduler, boolean bl, StateValues stateValues3) {
        HashSet<Function> hashSet = new HashSet<Function>();
        for (int i = 0; i < mDP.getNumStates(); ++i) {
            if (!stateValues.getStateValueAsBoolean(i) || stateValues2.getStateValueAsBoolean(i)) continue;
            Function function = stateValues3.getStateValueAsFunction(i);
            for (int j = 0; j < mDP.getNumChoices(i); ++j) {
                Function function2 = this.functionFactory.getZero();
                if (mDPRewards != null) {
                    function2 = function2.add((Function)mDPRewards.getStateReward(i));
                    function2 = function2.add((Function)mDPRewards.getTransitionReward(i, j));
                }
                Iterator<Map.Entry<Integer, Function>> iterator = mDP.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Function> entry = iterator.next();
                    int n = entry.getKey();
                    Function function3 = entry.getValue().multiply(stateValues3.getStateValueAsFunction(n));
                    function2 = function2.add(function3);
                }
                function2 = bl ? function2.subtract(function) : function.subtract(function2);
                hashSet.add(function2);
            }
        }
        return hashSet.toArray(new Function[0]);
    }

    private void storeValues(PropType propType, StateValues stateValues, StateValues stateValues2, Rewards<?> rewards, Scheduler scheduler, boolean bl, StateValues stateValues3, Function[] functionArray) {
        ResultCacheKey resultCacheKey = new ResultCacheKey(propType, stateValues, stateValues2, rewards, scheduler, bl);
        ResultCacheEntry resultCacheEntry = new ResultCacheEntry(stateValues3, functionArray);
        this.resultCache.put(resultCacheKey, resultCacheEntry);
    }

    private ResultCacheEntry lookupValues(PropType propType, StateValues stateValues, StateValues stateValues2, Rewards<?> rewards, Scheduler scheduler, boolean bl) {
        ResultCacheKey resultCacheKey = new ResultCacheKey(propType, stateValues, stateValues2, rewards, scheduler, bl);
        ResultCacheEntry resultCacheEntry = this.resultCache.get(resultCacheKey);
        return resultCacheEntry;
    }

    Scheduler computeOptConcreteReachScheduler(Point point, MDP<Function> mDP, StateValues stateValues, StateValues stateValues2, boolean bl, MDPRewards<Function> mDPRewards, Scheduler scheduler) throws PrismException {
        Object object;
        Map.Entry entry;
        Object object2;
        int n;
        MDPSimple<Function> mDPSimple = new MDPSimple<Function>(mDP, function -> this.functionFactory.fromBigRational(function.evaluate(point)));
        MDPRewardsSimple<Function> mDPRewardsSimple = null;
        if (mDPRewards != null) {
            mDPRewardsSimple = new MDPRewardsSimple<Function>(mDPRewards, mDP, function -> this.functionFactory.fromBigRational(function.evaluate(point)));
        }
        for (int i = 0; i < mDPSimple.getNumStates(); ++i) {
            for (n = 0; n < mDPSimple.getNumChoices(i); ++n) {
                object2 = mDPSimple.getTransitionsIterator(i, n);
                while (object2.hasNext()) {
                    entry = object2.next();
                    object = ((Function)entry.getValue()).asBigRational();
                    if (!((BigRational)object).isSpecial() && ((BigRational)object).compareTo(BigRational.ONE) != 1 && ((BigRational)object).signum() > 0) continue;
                    throw new PrismException("Parametric MDP is not well defined: probability in state " + i + " is " + String.valueOf(object));
                }
            }
        }
        Scheduler scheduler2 = this.lookupScheduler(point, mDPSimple, PropType.REACH, stateValues, stateValues2, bl, mDPRewardsSimple);
        if (scheduler2 != null) {
            return scheduler2;
        }
        scheduler2 = scheduler.clone();
        n = 1;
        while (n != 0) {
            int n2;
            object2 = new DTMCFromMDPMemorylessAdversary<Function>(mDPSimple, scheduler2.choices);
            entry = mDPRewardsSimple == null ? null : new MCRewardsFromMDPRewards<Function>(mDPRewardsSimple, scheduler2.choices);
            object = this.buildAlterablePMCForReach((DTMC<Function>)object2, stateValues, stateValues2, (MCRewards<Function>)((Object)entry));
            StateValues stateValues3 = this.computeValues((MutablePMC)object, mDPSimple.getFirstInitialState());
            BigRational[] bigRationalArray = new BigRational[stateValues3.getNumStates()];
            for (n2 = 0; n2 < mDPSimple.getNumStates(); ++n2) {
                bigRationalArray[n2] = stateValues3.getStateValueAsFunction(n2).asBigRational();
            }
            n = 0;
            for (n2 = 0; n2 < mDPSimple.getNumStates(); ++n2) {
                if (!stateValues.getStateValueAsBoolean(n2) || stateValues2.getStateValueAsBoolean(n2)) continue;
                BigRational bigRational = bigRationalArray[n2];
                for (int i = 0; i < mDPSimple.getNumChoices(n2); ++i) {
                    BigRational bigRational2 = BigRational.ZERO;
                    Iterator iterator = mDPSimple.getTransitionsIterator(n2, i);
                    while (iterator.hasNext()) {
                        Map.Entry entry2 = iterator.next();
                        int n3 = entry2.getKey();
                        BigRational bigRational3 = ((Function)entry2.getValue()).asBigRational();
                        BigRational bigRational4 = bigRationalArray[n3];
                        BigRational bigRational5 = bigRational3.multiply(bigRational4);
                        bigRational2 = bigRational2.add(bigRational5);
                    }
                    if (mDPRewards != null) {
                        bigRational2 = bigRational2.add(((Function)mDPRewards.getStateReward(n2)).asBigRational());
                        bigRational2 = bigRational2.add(((Function)mDPRewards.getTransitionReward(n2, i)).asBigRational());
                    }
                    if (bigRational.compareTo(bigRational2) != (bl ? 1 : -1)) continue;
                    scheduler2.setChoice(n2, i);
                    bigRational = bigRational2;
                    n = 1;
                }
            }
        }
        this.storeScheduler(PropType.REACH, stateValues, stateValues2, bl, mDPRewards, scheduler2);
        return scheduler2;
    }

    private void storeScheduler(PropType propType, StateValues stateValues, StateValues stateValues2, boolean bl, Rewards<?> rewards, Scheduler scheduler) {
        SchedulerCacheKey schedulerCacheKey = new SchedulerCacheKey(propType, stateValues, stateValues2, bl, rewards, null);
        ArrayList<Scheduler> arrayList = this.schedCache.get(schedulerCacheKey);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.schedCache.put(schedulerCacheKey, arrayList);
        }
        arrayList.add(scheduler);
    }

    private Scheduler lookupScheduler(Point point, MDP<Function> mDP, PropType propType, StateValues stateValues, StateValues stateValues2, boolean bl, Rewards<?> rewards) {
        SchedulerCacheKey schedulerCacheKey = new SchedulerCacheKey(propType, stateValues, stateValues2, bl, rewards, null);
        ArrayList<Scheduler> arrayList = this.schedCache.get(schedulerCacheKey);
        if (arrayList == null) {
            return null;
        }
        for (Scheduler scheduler : arrayList) {
            if (!this.checkScheduler(point, propType, stateValues, stateValues2, bl, rewards, scheduler)) continue;
            return scheduler;
        }
        return null;
    }

    private boolean checkScheduler(Point point, PropType propType, StateValues stateValues, StateValues stateValues2, boolean bl, Rewards<?> rewards, Scheduler scheduler) {
        Function[] functionArray;
        ResultCacheKey resultCacheKey = new ResultCacheKey(propType, stateValues, stateValues2, rewards, scheduler, bl);
        ResultCacheEntry resultCacheEntry = this.resultCache.get(resultCacheKey);
        for (Function function : functionArray = resultCacheEntry.getCompare()) {
            if (function.evaluate(point, false).signum() != -1) continue;
            return false;
        }
        return true;
    }

    private void precomputeScheduler(MDP<Function> mDP, Scheduler scheduler, StateValues stateValues, StateValues stateValues2, MDPRewards<Function> mDPRewards, boolean bl) throws PrismException {
        if (mDPRewards == null) {
            if (bl) {
                this.precomputePmin(mDP, scheduler, stateValues, stateValues2);
            }
        } else if (bl) {
            this.precomputeRminProperScheduler(mDP, scheduler, stateValues, stateValues2);
        }
    }

    private void precomputeRminProperScheduler(MDP<Function> mDP, Scheduler scheduler, StateValues stateValues, StateValues stateValues2) throws PrismException {
        MDPModelChecker mDPModelChecker = new MDPModelChecker(this);
        mDPModelChecker.setSilentPrecomputations(true);
        int[] nArray = new int[mDP.getNumStates()];
        BitSet bitSet = stateValues.toBitSet();
        mDPModelChecker.prob1(mDP, bitSet, stateValues2.toBitSet(), false, nArray);
        FunctionalPrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(bitSet).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            assert (nArray[n] >= 0);
            scheduler.setChoice(n, nArray[n]);
        }
    }

    private void precomputePmin(MDP<Function> mDP, Scheduler scheduler, StateValues stateValues, StateValues stateValues2) {
        int n;
        BitSet bitSet = new BitSet(mDP.getNumStates());
        for (n = 0; n < mDP.getNumStates(); ++n) {
            bitSet.set(n, stateValues2.getStateValueAsBoolean(n));
        }
        n = 1;
        while (n != 0) {
            n = 0;
            for (int i = 0; i < mDP.getNumStates(); ++i) {
                if (!stateValues.getStateValueAsBoolean(i) || bitSet.get(i)) continue;
                boolean bl = true;
                for (int j = 0; j < mDP.getNumChoices(i); ++j) {
                    boolean bl2 = false;
                    Iterator<Map.Entry<Integer, Function>> iterator = mDP.getTransitionsIterator(i, j);
                    while (iterator.hasNext()) {
                        Map.Entry<Integer, Function> entry = iterator.next();
                        if (!bitSet.get(entry.getKey())) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    scheduler.setChoice(i, j);
                    bl = false;
                }
                if (!bl) continue;
                bitSet.set(i, true);
                n = 1;
            }
        }
    }

    private MutablePMC buildAlterablePMCForReach(DTMC<Function> dTMC, StateValues stateValues, StateValues stateValues2, MCRewards<Function> mCRewards) throws PrismException {
        MutablePMC mutablePMC = this.buildAlterablePMC(dTMC, stateValues2.toBitSet(), stateValues.toBitSet(), mCRewards != null, false);
        if (mCRewards != null) {
            this.setPMCReward(mutablePMC, n -> stateValues2.toBitSet().get((int)n) ? this.functionFactory.getZero() : (stateValues.toBitSet().get((int)n) ? (Function)mCRewards.getStateReward((int)n) : this.functionFactory.getInf()));
        }
        if (dTMC.getModelType() == ModelType.CTMC && mCRewards != null) {
            this.normalisePMCRewards(mutablePMC, (CTMC)dTMC);
        }
        return mutablePMC;
    }

    private MutablePMC buildAlterablePMC(DTMC<Function> dTMC, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) throws PrismException {
        if (dTMC.getModelType() == ModelType.CTMC) {
            dTMC = ((CTMC)dTMC).getImplicitEmbeddedDTMC();
        }
        MutablePMC mutablePMC = new MutablePMC(this.functionFactory, dTMC.getNumStates(), bl, bl2);
        for (int i = 0; i < dTMC.getNumStates(); ++i) {
            mutablePMC.setTargetState(i, bitSet.get(i));
            mutablePMC.setInitState(i, dTMC.isInitialState(i));
            if ((bitSet2 == null || bitSet2.get(i)) && !bitSet.get(i)) {
                Iterator<Map.Entry<Integer, Function>> iterator = dTMC.getTransitionsIterator(i);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Function> entry = iterator.next();
                    mutablePMC.addTransition(i, entry.getKey(), entry.getValue());
                }
                continue;
            }
            mutablePMC.addTransition(i, i, this.functionFactory.getOne());
        }
        return mutablePMC;
    }

    private void setPMCReward(MutablePMC mutablePMC, java.util.function.Function<Integer, Function> function) {
        int n = mutablePMC.getNumStates();
        for (int i = 0; i < n; ++i) {
            mutablePMC.setReward(i, function.apply(i));
        }
    }

    private void normalisePMCRewards(MutablePMC mutablePMC, CTMC<Function> cTMC) {
        int n = mutablePMC.getNumStates();
        for (int i = 0; i < n; ++i) {
            mutablePMC.setReward(i, mutablePMC.getReward(i).divide(cTMC.getExitRate(i)));
        }
    }

    private void normalisePMCTimes(MutablePMC mutablePMC, CTMC<Function> cTMC) {
        int n = mutablePMC.getNumStates();
        for (int i = 0; i < n; ++i) {
            mutablePMC.setTime(i, mutablePMC.getTime(i).divide(cTMC.getExitRate(i)));
        }
    }

    private StateValues computeValues(MutablePMC mutablePMC, int n) {
        Lumper lumper;
        switch (this.bisimType) {
            case NULL: {
                lumper = new NullLumper(mutablePMC);
                break;
            }
            case STRONG: {
                lumper = new StrongLumper(mutablePMC);
                break;
            }
            case WEAK: {
                if (mutablePMC.isUseRewards()) {
                    lumper = new StrongLumper(mutablePMC);
                    break;
                }
                lumper = new WeakLumper(mutablePMC);
                break;
            }
            default: {
                throw new RuntimeException("invalid bisimulation method");
            }
        }
        if (lumper instanceof WeakLumper && mutablePMC.isUseTime()) {
            lumper = new StrongLumper(mutablePMC);
        }
        MutablePMC mutablePMC2 = lumper.getQuotient();
        StateEliminator stateEliminator = new StateEliminator(mutablePMC2, this.eliminationOrder);
        stateEliminator.eliminate();
        int[] nArray = lumper.getOriginalToOptimised();
        StateValues stateValues = new StateValues(mutablePMC.getNumStates(), n);
        for (int i = 0; i < nArray.length; ++i) {
            stateValues.setStateValue(i, stateEliminator.getResult(nArray[i]));
        }
        return stateValues;
    }

    private RegionValues computeSteadyState(Model<?> model, Region region, StateValues stateValues, boolean bl, Rewards<?> rewards) throws PrismException {
        StateValues stateValues2;
        if (model.getModelType() != ModelType.DTMC && model.getModelType() != ModelType.CTMC) {
            throw new PrismNotSupportedException("Parametric steady state computation not supported for " + String.valueOf((Object)model.getModelType()));
        }
        MCRewards mCRewards = (MCRewards)rewards;
        RegionValues regionValues = new RegionValues(this.regionFactory);
        ResultCacheEntry resultCacheEntry = this.lookupValues(PropType.STEADY, stateValues, null, rewards, null, bl);
        if (resultCacheEntry == null) {
            MutablePMC mutablePMC = this.buildAlterablePMC((DTMC)model, new BitSet(), null, true, true);
            if (rewards != null) {
                this.setPMCReward(mutablePMC, n -> (Function)((MCRewards)rewards).getStateReward((int)n));
            } else {
                this.setPMCReward(mutablePMC, n -> stateValues.getStateValueAsBoolean((int)n) ? this.functionFactory.getOne() : this.functionFactory.getZero());
            }
            if (model.getModelType() == ModelType.CTMC) {
                this.normalisePMCRewards(mutablePMC, (CTMC)model);
                this.normalisePMCTimes(mutablePMC, (CTMC)model);
            }
            stateValues2 = this.computeValues(mutablePMC, model.getFirstInitialState());
            this.storeValues(PropType.STEADY, stateValues, null, rewards, null, bl, stateValues2, null);
        } else {
            stateValues2 = resultCacheEntry.getValues();
        }
        regionValues.add(region, stateValues2);
        return regionValues;
    }

    public RegionValues computeSteadyState(Model<?> model, RegionValues regionValues, boolean bl, Rewards<?> rewards) throws PrismException {
        RegionValues regionValues2 = new RegionValues(this.regionFactory);
        for (Map.Entry<Region, StateValues> entry : regionValues) {
            Region region = entry.getKey();
            StateValues stateValues = entry.getValue();
            RegionValues regionValues3 = this.computeSteadyState(model, region, stateValues, bl, rewards);
            regionValues2.addAll(regionValues3);
        }
        return regionValues2;
    }

    private static enum PropType {
        REACH,
        STEADY;

    }

    class ResultCacheEntry {
        private final StateValues values;
        private final Function[] compare;

        ResultCacheEntry(StateValues stateValues, Function[] functionArray) {
            this.values = stateValues;
            this.compare = functionArray;
        }

        StateValues getValues() {
            return this.values;
        }

        Function[] getCompare() {
            return this.compare;
        }
    }

    class ResultCacheKey {
        private final PropType propType;
        private final BitSet b1;
        private final BitSet b2;
        private final Rewards<?> rew;
        private final Scheduler sched;
        private final boolean min;

        ResultCacheKey(PropType propType, StateValues stateValues, StateValues stateValues2, Rewards<?> rewards, Scheduler scheduler, boolean bl) {
            this.propType = propType;
            this.b1 = stateValues.toBitSet();
            this.b2 = stateValues2 == null ? null : stateValues2.toBitSet();
            this.rew = rewards;
            this.sched = scheduler;
            this.min = bl;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ResultCacheKey)) {
                return false;
            }
            ResultCacheKey resultCacheKey = (ResultCacheKey)object;
            if (!this.propType.equals((Object)resultCacheKey.propType)) {
                return false;
            }
            if (!this.b1.equals(resultCacheKey.b1)) {
                return false;
            }
            if (this.b2 == null != (resultCacheKey.b2 == null)) {
                return false;
            }
            if (this.b2 != null && !this.b2.equals(resultCacheKey.b2)) {
                return false;
            }
            if (this.rew == null != (resultCacheKey.rew == null)) {
                return false;
            }
            if (this.rew != null && !this.rew.equals(resultCacheKey.rew)) {
                return false;
            }
            if (this.sched == null != (resultCacheKey.sched == null)) {
                return false;
            }
            if (!this.sched.equals(resultCacheKey.sched)) {
                return false;
            }
            return this.min == resultCacheKey.min;
        }

        public int hashCode() {
            int n = 0;
            switch (this.propType) {
                case REACH: {
                    n = 13;
                    break;
                }
                case STEADY: {
                    n = 17;
                }
            }
            n = this.b1.hashCode() + (n << 6) + (n << 16) - n;
            if (this.b2 != null) {
                n = this.b2.hashCode() + (n << 6) + (n << 16) - n;
            }
            n = (this.rew == null ? 0 : this.rew.hashCode()) + (n << 6) + (n << 16) - n;
            n = (this.sched == null ? 0 : this.sched.hashCode()) + (n << 6) + (n << 16) - n;
            n = (this.min ? 13 : 17) + (n << 6) + (n << 16) - n;
            return n;
        }
    }

    class SchedulerCacheKey {
        private final PropType propType;
        private final BitSet b1;
        private final BitSet b2;
        private final boolean min;
        private final Rewards<?> rew;

        SchedulerCacheKey(PropType propType, StateValues stateValues, StateValues stateValues2, boolean bl, Rewards<?> rewards, Region region) {
            this.propType = propType;
            this.b1 = stateValues.toBitSet();
            this.b2 = stateValues2 == null ? null : stateValues2.toBitSet();
            this.min = bl;
            this.rew = rewards;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SchedulerCacheKey)) {
                return false;
            }
            SchedulerCacheKey schedulerCacheKey = (SchedulerCacheKey)object;
            if (!this.propType.equals((Object)schedulerCacheKey.propType)) {
                return false;
            }
            if (!this.b1.equals(schedulerCacheKey.b1)) {
                return false;
            }
            if (this.b2 == null != (schedulerCacheKey.b2 == null)) {
                return false;
            }
            if (this.b2 != null && !this.b2.equals(schedulerCacheKey.b2)) {
                return false;
            }
            if (this.rew == null != (schedulerCacheKey.rew == null)) {
                return false;
            }
            if (this.rew != null && !this.rew.equals(schedulerCacheKey.rew)) {
                return false;
            }
            return this.min == schedulerCacheKey.min;
        }

        public int hashCode() {
            int n = 0;
            switch (this.propType) {
                case REACH: {
                    n = 13;
                    break;
                }
                case STEADY: {
                    n = 17;
                }
            }
            n = (this.b1 == null ? 0 : this.b1.hashCode()) + (n << 6) + (n << 16) - n;
            if (this.b2 != null) {
                n = (this.b2 == null ? 0 : this.b2.hashCode()) + (n << 6) + (n << 16) - n;
            }
            n = (this.min ? 13 : 17) + (n << 6) + (n << 16) - n;
            n = (this.rew == null ? 0 : this.rew.hashCode()) + (n << 6) + (n << 16) - n;
            return n;
        }
    }
}

