/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import param.MutablePMC;

final class Partition {
    private MutablePMC pmc;
    private HashSet<HashSet<Integer>> blocks;
    private ArrayList<HashSet<Integer>> stateToBlock;
    private PriorityQueue<HashSet<Integer>> mayChange;
    private HashSet<HashSet<Integer>> mayChangeHash;
    private HashSet<Integer> nextBlock;

    Partition(MutablePMC mutablePMC) {
        this.pmc = mutablePMC;
        this.blocks = new HashSet();
        this.stateToBlock = new ArrayList(mutablePMC.getNumStates());
        HashSet<Integer> hashSet = new HashSet<Integer>(1);
        this.mayChange = new PriorityQueue<HashSet<Integer>>(11, new HashSetSizeComparator());
        this.mayChangeHash = new HashSet();
        for (int i = 0; i < mutablePMC.getNumStates(); ++i) {
            hashSet.add(i);
            this.stateToBlock.add(hashSet);
        }
        this.blocks.add(hashSet);
        this.mayChange.add(hashSet);
        this.mayChangeHash.add(hashSet);
    }

    HashSet<Integer> nextChangeableBlock() {
        this.nextBlock = this.mayChange.poll();
        this.mayChangeHash.remove(this.nextBlock);
        this.blocks.remove(this.nextBlock);
        return this.nextBlock;
    }

    void addBlocks(ArrayList<HashSet<Integer>> arrayList) {
        this.blocks.addAll(arrayList);
        for (HashSet<Integer> hashSet : arrayList) {
            for (int n : hashSet) {
                this.stateToBlock.set(n, hashSet);
            }
            if (hashSet.equals(this.nextBlock)) {
                return;
            }
            this.mayChange.add(hashSet);
            this.mayChangeHash.add(hashSet);
        }
        for (HashSet<Integer> hashSet : arrayList) {
            for (int n : hashSet) {
                Iterator iterator = this.pmc.incoming.get(n).iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    HashSet<Integer> hashSet2 = this.stateToBlock.get(n2);
                    if (this.nextBlock.contains(n2) || this.mayChangeHash.contains(hashSet2) || hashSet2.size() <= 1) continue;
                    this.mayChange.add(hashSet2);
                    this.mayChangeHash.add(hashSet2);
                }
            }
        }
    }

    boolean mayChange() {
        return !this.mayChange.isEmpty();
    }

    ArrayList<HashSet<Integer>> getAllBlocks() {
        ArrayList<HashSet<Integer>> arrayList = new ArrayList<HashSet<Integer>>(this.blocks.size());
        for (HashSet<Integer> hashSet : this.blocks) {
            arrayList.add(hashSet);
        }
        return arrayList;
    }

    HashSet<Integer> getStateBlock(int n) {
        return this.stateToBlock.get(n);
    }

    void markAllBlocksAsNew() {
        this.mayChange.clear();
        this.mayChangeHash.clear();
        for (HashSet<Integer> hashSet : this.blocks) {
            this.mayChange.add(hashSet);
            this.mayChangeHash.add(hashSet);
        }
    }

    final class HashSetSizeComparator
    implements Comparator<HashSet<Integer>> {
        HashSetSizeComparator() {
        }

        @Override
        public int compare(HashSet<Integer> hashSet, HashSet<Integer> hashSet2) {
            int n;
            int n2 = hashSet.size();
            if (n2 < (n = hashSet2.size())) {
                return 1;
            }
            if (n2 == n) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof HashSetSizeComparator;
        }

        public int hashCode() {
            return 0;
        }
    }
}

