/*
 * Decompiled with CFR 0.152.
 */
package param;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.ufd.Quotient;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import param.BigRational;
import param.Function;
import param.JasFunctionFactory;
import param.Point;
import param.Polynomial;
import parser.ast.Expression;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionLiteral;
import parser.type.TypeDouble;
import prism.PrismException;

final class JasFunction
extends Function {
    private Quotient<edu.jas.arith.BigInteger> jas;
    Polynomial num;
    Polynomial den;
    int type;
    static final int NORMAL = 0;
    static final int INF = 1;
    static final int MINF = 2;
    static final int NAN = 3;

    JasFunction(JasFunctionFactory jasFunctionFactory, Quotient<edu.jas.arith.BigInteger> quotient, int n) {
        super(jasFunctionFactory);
        this.jas = quotient;
        this.num = null;
        this.den = null;
        this.type = n;
    }

    public String toString() {
        return this.toStringExpression();
    }

    public String toStringExpression() {
        try {
            return this.asExpression().toString();
        }
        catch (PrismException prismException) {
            return "?";
        }
    }

    public String toStringJas() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInf()) {
            return "Infinity";
        }
        if (this.isMInf()) {
            return "-Infinity";
        }
        return this.jas.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JasFunction)) {
            return false;
        }
        JasFunction jasFunction = (JasFunction)object;
        if (this.isNaN()) {
            return jasFunction.isNaN();
        }
        if (this.isInf()) {
            return jasFunction.isInf();
        }
        if (this.isMInf()) {
            return jasFunction.isMInf();
        }
        return this.jas.equals(jasFunction.jas);
    }

    public int hashCode() {
        return this.jas.hashCode();
    }

    Quotient<edu.jas.arith.BigInteger> getJas() {
        return this.jas;
    }

    @Override
    public Function add(Function function) {
        if (this.isNaN() || function.isNaN()) {
            return this.factory.getNaN();
        }
        if (this.isInf() || function.isInf()) {
            if (this.isMInf() || function.isMInf()) {
                return this.factory.getZero();
            }
            return this.factory.getInf();
        }
        if (this.isMInf() || function.isMInf()) {
            return this.factory.getMInf();
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.sum(((JasFunction)function).jas), 0);
    }

    @Override
    public Function negate() {
        if (this.isNaN()) {
            return this.factory.getNaN();
        }
        if (this.isInf()) {
            return this.factory.getMInf();
        }
        if (this.isMInf()) {
            return this.factory.getMInf();
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.negate(), 0);
    }

    @Override
    public Function multiply(Function function) {
        if (this.isNaN() || function.isNaN()) {
            return this.factory.getNaN();
        }
        if (this.isZero() || function.isZero()) {
            return this.factory.getZero();
        }
        if (this.isInf() || function.isInf()) {
            if (this.isMInf() || function.isMInf()) {
                return this.factory.getMInf();
            }
            return this.factory.getInf();
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.multiply(((JasFunction)function).jas), 0);
    }

    @Override
    public Function divide(Function function) {
        if (this.isNaN() || function.isNaN()) {
            return this.factory.getNaN();
        }
        if (function.isInf() || function.isMInf()) {
            return this.factory.getNaN();
        }
        if (function.isZero()) {
            if (this.isConstant()) {
                return this.factory.fromBigRational(this.asBigRational().divide(BigRational.ZERO));
            }
            return this.factory.getInf();
        }
        if (this.isZero()) {
            return this.factory.getZero();
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.divide(((JasFunction)function).jas), 0);
    }

    @Override
    public Function pow(int n) {
        if (this.isNaN()) {
            return this.factory.getNaN();
        }
        if (this.isInf()) {
            return this.factory.getMInf();
        }
        if (this.isMInf()) {
            return this.factory.getMInf();
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)((Quotient)this.jas.power((long)n)), 0);
    }

    @Override
    public Function star() {
        if (this.isNaN()) {
            return this.factory.getNaN();
        }
        Quotient quotient = ((JasFunctionFactory)this.factory).getJasQuotRing().getONE();
        Quotient quotient2 = quotient.subtract(this.jas);
        quotient2 = quotient.divide(quotient2);
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)quotient2, 0);
    }

    private Polynomial jasToPoly(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        int n = genPolynomial.numberOfVariables();
        Polynomial polynomial = new Polynomial(n, genPolynomial.length());
        for (Monomial monomial : genPolynomial) {
            BigInteger bigInteger = ((edu.jas.arith.BigInteger)monomial.coefficient()).getVal();
            ExpVector expVector = monomial.exponent();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < n; ++i) {
                arrayList.add((int)expVector.getVal(i));
            }
            polynomial.addTerm(bigInteger, arrayList);
        }
        return polynomial;
    }

    @Override
    public Function toConstraint() {
        if (this.isNaN() || this.isInf() || this.isMInf()) {
            return this;
        }
        if (this.num == null) {
            this.num = this.jasToPoly((GenPolynomial<edu.jas.arith.BigInteger>)this.jas.num);
        }
        if (this.den == null) {
            this.den = this.jasToPoly((GenPolynomial<edu.jas.arith.BigInteger>)this.jas.den);
        }
        BigRational[] bigRationalArray = new BigRational[this.factory.getNumVariables()];
        for (int i = 0; i < this.factory.getNumVariables(); ++i) {
            bigRationalArray[i] = this.factory.getUpperBound(i).subtract(this.factory.getLowerBound(i));
        }
        BigRational bigRational = BigRational.ZERO;
        while (bigRational.isZero() || bigRational.isSpecial()) {
            for (int i = 0; i < this.factory.getNumVariables(); ++i) {
                bigRationalArray[i] = bigRationalArray[i].divide(2L);
            }
            BigRational[] bigRationalArray2 = new BigRational[this.factory.getNumVariables()];
            for (int i = 0; i < this.factory.getNumVariables(); ++i) {
                bigRationalArray2[i] = this.factory.getLowerBound(i).add(bigRationalArray[i]);
            }
            bigRational = this.den.evaluate(new Point(bigRationalArray2), false);
        }
        if (bigRational.signum() == -1) {
            return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.multiply(this.jas.den).negate(), 0);
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.multiply(this.jas.den), 0);
    }

    @Override
    public BigRational evaluate(Point point, boolean bl) {
        if (this.isNaN()) {
            return BigRational.NAN;
        }
        if (this.isInf()) {
            return BigRational.INF;
        }
        if (this.isMInf()) {
            return BigRational.MINF;
        }
        if (this.num == null) {
            this.num = this.jasToPoly((GenPolynomial<edu.jas.arith.BigInteger>)this.jas.num);
        }
        if (this.den == null) {
            this.den = this.jasToPoly((GenPolynomial<edu.jas.arith.BigInteger>)this.jas.den);
        }
        if (this.isNaN()) {
            return BigRational.NAN;
        }
        return this.num.evaluate(point, bl).divide(this.den.evaluate(point, bl), bl);
    }

    @Override
    public BigRational evaluate(Point point) {
        return this.evaluate(point, true);
    }

    @Override
    public boolean check(Point point, boolean bl) {
        BigRational bigRational = this.evaluate(point, false);
        int n = bigRational.signum();
        return bl ? n > 0 : n >= 0;
    }

    @Override
    public Expression asExpression() throws PrismException {
        if (this.isNaN()) {
            return new ExpressionLiteral(TypeDouble.getInstance(), BigRational.NAN, BigRational.NAN.toString());
        }
        if (this.isInf()) {
            return new ExpressionLiteral(TypeDouble.getInstance(), BigRational.INF, BigRational.INF.toString());
        }
        if (this.isMInf()) {
            return new ExpressionLiteral(TypeDouble.getInstance(), BigRational.MINF, BigRational.MINF.toString());
        }
        Expression expression = this.jasPoly2expr((GenPolynomial<edu.jas.arith.BigInteger>)this.jas.num);
        if (!this.jas.den.isONE()) {
            expression = Expression.Divide(expression, this.jasPoly2expr((GenPolynomial<edu.jas.arith.BigInteger>)this.jas.den));
        }
        return expression;
    }

    private Expression jasPoly2expr(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) throws PrismException {
        int n;
        BigInteger bigInteger;
        Object object2;
        if (genPolynomial.isZERO()) {
            return new ExpressionLiteral(TypeDouble.getInstance(), edu.jas.arith.BigInteger.ZERO, "0");
        }
        int n2 = genPolynomial.numberOfVariables();
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        ArrayList<ExpressionConstant> arrayList2 = new ArrayList<ExpressionConstant>();
        int n3 = 0;
        int n4 = -1;
        for (Object object2 : genPolynomial) {
            BigInteger bigInteger2 = ((edu.jas.arith.BigInteger)object2.coefficient()).getVal();
            if (bigInteger2.signum() == 0) continue;
            bigInteger = bigInteger2.signum() > 0 ? bigInteger2 : bigInteger2.negate();
            arrayList.add(bigInteger);
            bitSet.set(n3, bigInteger2.signum() < 0);
            bitSet2.set(n3, bigInteger.equals(BigInteger.ONE));
            if (n4 == -1 && bigInteger2.signum() > 0) {
                n4 = n3;
            }
            ExpVector expVector = object2.exponent();
            ExpressionConstant expressionConstant = null;
            for (int i = 0; i < n2; ++i) {
                int n5 = (int)expVector.getVal(i);
                if (n5 < 0) {
                    throw new PrismException("Polynomials with negative powers not supported");
                }
                if (n5 <= 0) continue;
                Expression expression = new ExpressionConstant(this.factory.getParameterName(i), TypeDouble.getInstance());
                if (n5 > 1) {
                    expression = Expression.Pow(expression, Expression.Int(n5));
                }
                expressionConstant = expressionConstant == null ? expression : Expression.Times(expressionConstant, expression);
            }
            arrayList2.add(expressionConstant);
            ++n3;
        }
        Object object3 = null;
        object2 = null;
        int n6 = n = n4 != -1 ? n4 : 0;
        if (arrayList2.get(n) == null) {
            bigInteger = bitSet.get(n) ? ((BigInteger)arrayList.get(n)).negate() : (BigInteger)arrayList.get(n);
            object2 = new ExpressionLiteral(TypeDouble.getInstance(), bigInteger, bigInteger.toString());
        } else if (bitSet2.get(n)) {
            object2 = bitSet.get(n) ? Expression.Minus((Expression)arrayList2.get(n)) : (Expression)arrayList2.get(n);
        } else {
            bigInteger = bitSet.get(n) ? ((BigInteger)arrayList.get(n)).negate() : (BigInteger)arrayList.get(n);
            object2 = Expression.Times(new ExpressionLiteral(TypeDouble.getInstance(), bigInteger, bigInteger.toString()), (Expression)arrayList2.get(n));
        }
        object3 = object2;
        for (int i = 0; i < n3; ++i) {
            if (i == n) continue;
            object2 = arrayList2.get(i) == null ? new ExpressionLiteral(TypeDouble.getInstance(), arrayList.get(i), ((BigInteger)arrayList.get(i)).toString()) : (bitSet2.get(i) ? (Expression)arrayList2.get(i) : Expression.Times(new ExpressionLiteral(TypeDouble.getInstance(), arrayList.get(i), ((BigInteger)arrayList.get(i)).toString()), (Expression)arrayList2.get(i)));
            object3 = bitSet.get(i) ? Expression.Minus((Expression)object3, (Expression)object2) : Expression.Plus((Expression)object3, (Expression)object2);
        }
        return object3;
    }

    @Override
    public BigRational asBigRational() {
        if (this.isNaN()) {
            return BigRational.NAN;
        }
        if (this.isInf()) {
            return BigRational.INF;
        }
        if (this.isMInf()) {
            return BigRational.MINF;
        }
        BigRational[] bigRationalArray = new BigRational[this.factory.getNumVariables()];
        for (int i = 0; i < this.factory.getNumVariables(); ++i) {
            bigRationalArray[i] = new BigRational(0L);
        }
        return this.evaluate(new Point(bigRationalArray));
    }

    @Override
    public boolean isNaN() {
        return this.type == 3;
    }

    @Override
    public boolean isInf() {
        return this.type == 1;
    }

    @Override
    public boolean isMInf() {
        return this.type == 2;
    }

    @Override
    public boolean isOne() {
        if (this.type != 0) {
            return false;
        }
        return this.jas.isONE();
    }

    @Override
    public boolean isZero() {
        if (this.type != 0) {
            return false;
        }
        return this.jas.isZERO();
    }

    @Override
    public boolean isConstant() {
        if (this.type != 0) {
            return true;
        }
        if (this.jas.isZERO()) {
            return true;
        }
        return this.jas.isConstant();
    }
}

