/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmctools.umbj;

import io.github.pmctools.umbj.UMBBitPacking;
import io.github.pmctools.umbj.UMBBitString;
import io.github.pmctools.umbj.UMBException;
import io.github.pmctools.umbj.UMBFormat;
import io.github.pmctools.umbj.UMBIndex;
import io.github.pmctools.umbj.UMBType;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.doubles.DoubleConsumer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class UMBReader {
    private final File fileIn;
    private UMBIndex umbIndex;
    private static int BUFFER_SIZE = 65536;
    UMBIn umbInCached = null;

    public UMBReader(File file) throws UMBException {
        this.fileIn = file;
        this.extractIndex();
    }

    private void extractIndex() throws UMBException {
        UMBIn uMBIn = this.open();
        uMBIn.findArchiveEntry("index.json");
        String string = uMBIn.readAsString();
        uMBIn.close();
        this.umbIndex = UMBIndex.fromJSON(string);
        this.umbIndex.validate();
    }

    public UMBIndex getUMBIndex() {
        return this.umbIndex;
    }

    public void extractStateChoiceOffsets(LongConsumer longConsumer) throws UMBException {
        this.extractLongArray("state-to-choices.bin", this.umbIndex.getNumStates() + 1L, longConsumer);
    }

    public void extractStatePlayers(IntConsumer intConsumer) throws UMBException {
        this.extractIntArray("state-to-player.bin", this.umbIndex.getNumStates(), intConsumer);
    }

    public void extractInitialStates(LongConsumer longConsumer) throws UMBException {
        this.extractBooleanArraySparse("state-is-initial.bin", this.umbIndex.getNumStates(), longConsumer);
    }

    public void extractMarkovianStates(LongConsumer longConsumer) throws UMBException {
        this.extractBooleanArraySparse("state-is-markovian.bin", this.umbIndex.getNumStates(), longConsumer);
    }

    public void extractExitRates(Consumer<?> consumer) throws UMBException {
        this.extractContinuousNumericArray("state-to-exit-rate.bin", this.umbIndex.getExitRateType(), this.umbIndex.getNumStates(), consumer);
    }

    public void extractChoiceBranchOffsets(LongConsumer longConsumer) throws UMBException {
        this.extractLongArray("choice-to-branches.bin", this.umbIndex.getNumChoices() + 1L, longConsumer);
    }

    public void extractBranchTargets(LongConsumer longConsumer) throws UMBException {
        this.extractLongArray("branch-to-target.bin", this.umbIndex.getNumBranches(), longConsumer);
    }

    public void extractBranchProbabilities(Consumer<?> consumer) throws UMBException {
        this.extractContinuousNumericArray("branch-to-probability.bin", this.umbIndex.getBranchProbabilityType(), this.umbIndex.getNumBranches(), consumer);
    }

    public boolean hasChoiceActionIndices() throws UMBException {
        return this.fileExists(this.umbIndex.actionsAnnotation.getFilename(UMBIndex.UMBEntity.CHOICES));
    }

    public void extractChoiceActionIndices(IntConsumer intConsumer) throws UMBException {
        this.extractIntAnnotation(this.umbIndex.actionsAnnotation, UMBIndex.UMBEntity.CHOICES, intConsumer);
    }

    public boolean hasBranchActionIndices() throws UMBException {
        return this.fileExists(this.umbIndex.actionsAnnotation.getFilename(UMBIndex.UMBEntity.BRANCHES));
    }

    public void extractBranchActionIndices(IntConsumer intConsumer) throws UMBException {
        this.extractIntAnnotation(this.umbIndex.actionsAnnotation, UMBIndex.UMBEntity.BRANCHES, intConsumer);
    }

    public boolean hasChoiceActionStrings() throws UMBException {
        return this.fileExists(UMBFormat.stringOffsetsFile(this.umbIndex.actionsAnnotation.getFolderName(UMBIndex.UMBEntity.CHOICES))) && this.fileExists(UMBFormat.stringsFile(this.umbIndex.actionsAnnotation.getFolderName(UMBIndex.UMBEntity.CHOICES)));
    }

    public void extractChoiceActionStrings(Consumer<String> consumer) throws UMBException {
        String string = this.umbIndex.actionsAnnotation.getFolderName(UMBIndex.UMBEntity.CHOICES);
        this.extractStrings(string, this.umbIndex.getNumChoiceActions(), consumer);
    }

    public boolean hasBranchActionStrings() throws UMBException {
        return this.fileExists(UMBFormat.stringOffsetsFile(this.umbIndex.actionsAnnotation.getFolderName(UMBIndex.UMBEntity.BRANCHES))) && this.fileExists(UMBFormat.stringsFile(this.umbIndex.actionsAnnotation.getFolderName(UMBIndex.UMBEntity.BRANCHES)));
    }

    public void extractBranchActionStrings(Consumer<String> consumer) throws UMBException {
        String string = this.umbIndex.actionsAnnotation.getFolderName(UMBIndex.UMBEntity.BRANCHES);
        this.extractStrings(string, this.umbIndex.getNumBranchActions(), consumer);
    }

    public void extractStateObservations(LongConsumer longConsumer) throws UMBException {
        this.extractObservations(UMBIndex.UMBEntity.STATES, longConsumer);
    }

    public void extractBranchObservations(LongConsumer longConsumer) throws UMBException {
        this.extractObservations(UMBIndex.UMBEntity.BRANCHES, longConsumer);
    }

    public void extractObservations(UMBIndex.UMBEntity uMBEntity, LongConsumer longConsumer) throws UMBException {
        this.extractLongArray(this.umbIndex.observationsAnnotation.getFilename(uMBEntity), this.umbIndex.getEntityCount(uMBEntity), longConsumer);
    }

    public <T extends LongConsumer> T extractStateChoiceCounts(T t) throws UMBException {
        this.extractStateChoiceOffsets(new OffsetsToCounts(t));
        return t;
    }

    public long extractMaxStateChoiceCount() throws UMBException {
        return this.extractStateChoiceCounts(new LongMax()).getMax();
    }

    public void extractStateAP(int n, LongConsumer longConsumer) throws UMBException {
        UMBIndex.Annotation annotation = this.getUMBIndex().getAPAnnotation(n);
        this.extractBooleanAnnotationSparse(annotation, UMBIndex.UMBEntity.STATES, longConsumer);
    }

    public void extractStateAP(String string, LongConsumer longConsumer) throws UMBException {
        UMBIndex.Annotation annotation = this.getUMBIndex().getAPAnnotationByID(string);
        this.extractBooleanAnnotationSparse(annotation, UMBIndex.UMBEntity.STATES, longConsumer);
    }

    public void extractStateRewards(int n, Consumer<?> consumer) throws UMBException {
        UMBIndex.Annotation annotation = this.getUMBIndex().getRewardAnnotation(n);
        this.extractContinuousNumericAnnotation(annotation, UMBIndex.UMBEntity.STATES, consumer);
    }

    public void extractStateRewards(String string, Consumer<?> consumer) throws UMBException {
        UMBIndex.Annotation annotation = this.getUMBIndex().getRewardAnnotationByID(string);
        this.extractContinuousNumericAnnotation(annotation, UMBIndex.UMBEntity.STATES, consumer);
    }

    public void extractChoiceRewards(int n, Consumer<?> consumer) throws UMBException {
        UMBIndex.Annotation annotation = this.getUMBIndex().getRewardAnnotation(n);
        this.extractContinuousNumericAnnotation(annotation, UMBIndex.UMBEntity.CHOICES, consumer);
    }

    public void extractChoiceRewards(String string, Consumer<?> consumer) throws UMBException {
        UMBIndex.Annotation annotation = this.getUMBIndex().getRewardAnnotationByID(string);
        this.extractContinuousNumericAnnotation(annotation, UMBIndex.UMBEntity.CHOICES, consumer);
    }

    public void extractBranchRewards(int n, Consumer<?> consumer) throws UMBException {
        UMBIndex.Annotation annotation = this.getUMBIndex().getRewardAnnotation(n);
        this.extractContinuousNumericAnnotation(annotation, UMBIndex.UMBEntity.BRANCHES, consumer);
    }

    public void extractBranchRewards(String string, Consumer<?> consumer) throws UMBException {
        UMBIndex.Annotation annotation = this.getUMBIndex().getRewardAnnotationByID(string);
        this.extractContinuousNumericAnnotation(annotation, UMBIndex.UMBEntity.BRANCHES, consumer);
    }

    public void extractBooleanAnnotationSparse(String string, String string2, UMBIndex.UMBEntity uMBEntity, LongConsumer longConsumer) throws UMBException {
        this.extractBooleanAnnotationSparse(this.umbIndex.getAnnotation(string, string2), uMBEntity, longConsumer);
    }

    public void extractBooleanAnnotationSparse(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, LongConsumer longConsumer) throws UMBException {
        String string = annotation.getFilename(uMBEntity);
        this.extractBooleanArraySparse(string, this.getUMBIndex().getEntityCount(uMBEntity), longConsumer);
    }

    public void extractIndexedBooleanAnnotation(String string, String string2, UMBIndex.UMBEntity uMBEntity, LongBooleanConsumer longBooleanConsumer) throws UMBException {
        this.extractIndexedBooleanAnnotation(this.umbIndex.getAnnotation(string, string2), uMBEntity, longBooleanConsumer);
    }

    public void extractIndexedBooleanAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, LongBooleanConsumer longBooleanConsumer) throws UMBException {
        String string = annotation.getFilename(uMBEntity);
        this.extractBooleanArray(string, this.getUMBIndex().getEntityCount(uMBEntity), new IndexedBooleanConsumer(longBooleanConsumer));
    }

    public void extractIntAnnotation(String string, String string2, UMBIndex.UMBEntity uMBEntity, IntConsumer intConsumer) throws UMBException {
        this.extractIntAnnotation(this.umbIndex.getAnnotation(string, string2), uMBEntity, intConsumer);
    }

    public void extractIntAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, IntConsumer intConsumer) throws UMBException {
        String string = annotation.getFilename(uMBEntity);
        this.extractIntArray(string, this.getUMBIndex().getEntityCount(uMBEntity), intConsumer);
    }

    public void extractIndexedIntAnnotation(String string, String string2, UMBIndex.UMBEntity uMBEntity, LongIntConsumer longIntConsumer) throws UMBException {
        this.extractIndexedIntAnnotation(this.umbIndex.getAnnotation(string, string2), uMBEntity, longIntConsumer);
    }

    public void extractIndexedIntAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, LongIntConsumer longIntConsumer) throws UMBException {
        String string = annotation.getFilename(uMBEntity);
        this.extractIntArray(string, this.getUMBIndex().getEntityCount(uMBEntity), new IndexedIntConsumer(longIntConsumer));
    }

    public void extractDoubleAnnotation(String string, String string2, UMBIndex.UMBEntity uMBEntity, java.util.function.DoubleConsumer doubleConsumer) throws UMBException {
        this.extractDoubleAnnotation(this.umbIndex.getAnnotation(string, string2), uMBEntity, doubleConsumer);
    }

    public void extractDoubleAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, java.util.function.DoubleConsumer doubleConsumer) throws UMBException {
        String string = annotation.getFilename(uMBEntity);
        this.extractDoubleArray(string, this.getUMBIndex().getEntityCount(uMBEntity), doubleConsumer);
    }

    public void extractContinuousNumericAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, Consumer<?> consumer) throws UMBException {
        String string = annotation.getFilename(uMBEntity);
        this.extractContinuousNumericArray(string, annotation.getType(), this.getUMBIndex().getEntityCount(uMBEntity), consumer);
    }

    public void extractStringAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, Consumer<String> consumer) throws UMBException {
        String string = annotation.getFolderName(uMBEntity);
        this.extractStrings(string, annotation.getNumStrings(), consumer);
    }

    public void extractStateValuations(Consumer<UMBBitString> consumer) throws UMBException {
        this.extractValuations(UMBIndex.UMBEntity.STATES, consumer);
    }

    public void extractObservationValuations(Consumer<UMBBitString> consumer) throws UMBException {
        this.extractValuations(UMBIndex.UMBEntity.OBSERVATIONS, consumer);
    }

    public void extractValuationClasses(UMBIndex.UMBEntity uMBEntity, IntConsumer intConsumer) throws UMBException {
        this.extractIntArray(UMBFormat.valuationClassesFile(uMBEntity), this.umbIndex.getEntityCount(uMBEntity), intConsumer);
    }

    public void extractValuations(UMBIndex.UMBEntity uMBEntity, Consumer<UMBBitString> consumer) throws UMBException {
        UMBBitPacking uMBBitPacking = this.umbIndex.getValuationBitPacking(uMBEntity);
        this.extractBitStringArray(UMBFormat.valuationsFile(uMBEntity), this.umbIndex.getEntityCount(uMBEntity), uMBBitPacking.getTotalNumBytes(), consumer);
    }

    public IntRange getValuationIntRange(UMBIndex.UMBEntity uMBEntity, UMBBitPacking uMBBitPacking, int n) throws UMBException {
        IntRangeComputer intRangeComputer = new IntRangeComputer();
        try {
            this.extractValuations(uMBEntity, uMBBitString -> {
                try {
                    switch (uMBBitPacking.getVariable((int)n).getType().type) {
                        case INT: {
                            intRangeComputer.accept(uMBBitPacking.getIntVariableValue((UMBBitString)uMBBitString, n));
                            break;
                        }
                        case UINT: {
                            intRangeComputer.accept(uMBBitPacking.getUIntVariableValue((UMBBitString)uMBBitString, n));
                            break;
                        }
                        default: {
                            throw new UMBException("Cannot compute the integer range of a " + String.valueOf(uMBBitPacking.getVariable((int)n).getType().type));
                        }
                    }
                }
                catch (UMBException uMBException) {
                    throw new RuntimeException(uMBException.getMessage());
                }
            });
        }
        catch (UMBException | RuntimeException exception) {
            throw new UMBException("UMB import problem: " + exception.getMessage());
        }
        return intRangeComputer;
    }

    private boolean fileExists(String string) throws UMBException {
        UMBIn uMBIn = this.open();
        boolean bl = uMBIn.archiveEntryExists(string);
        uMBIn.close();
        return bl;
    }

    private void extractBooleanArraySparse(String string, long l, LongConsumer longConsumer) throws UMBException {
        try (UMBIn uMBIn = this.open();){
            ByteBuffer byteBuffer;
            long l2 = uMBIn.findArchiveEntry(string);
            long l3 = (l + 63L) / 64L * 8L;
            if (l2 != l3) {
                throw new UMBException("File " + string + " has unexpected size (" + l2 + " bytes)");
            }
            int n = 8;
            long l4 = (l + 63L) / 64L;
            int n2 = (int)Math.min((long)(BUFFER_SIZE / n), l4);
            long[] lArray = new long[n2];
            int n3 = (int)Math.min(l4, (long)n2);
            long l5 = 0L;
            while (n3 > 0 && (byteBuffer = uMBIn.readBytes(n3 * n)) != null) {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    lArray[n4] = byteBuffer.getLong();
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    long l6 = lArray[n4];
                    int n5 = l5 + 64L <= l ? 64 : (int)(l - l5);
                    for (int i = 0; i < n5; ++i) {
                        if ((l6 & 1L << i) == 0L) continue;
                        longConsumer.accept(l5 + (long)i);
                    }
                    l5 += 64L;
                }
                n3 = (int)Math.min(l4 -= (long)n3, (long)n2);
            }
        }
    }

    private void extractBooleanArray(String string, long l, BooleanConsumer booleanConsumer) throws UMBException {
        try (UMBIn uMBIn = this.open();){
            ByteBuffer byteBuffer;
            long l2 = uMBIn.findArchiveEntry(string);
            long l3 = (l + 63L) / 64L * 8L;
            if (l2 != l3) {
                throw new UMBException("File " + string + " has unexpected size (" + l2 + " bytes)");
            }
            int n = 8;
            long l4 = (l + 63L) / 64L;
            int n2 = (int)Math.min((long)(BUFFER_SIZE / n), l4);
            long[] lArray = new long[n2];
            int n3 = (int)Math.min(l4, (long)n2);
            long l5 = 0L;
            while (n3 > 0 && (byteBuffer = uMBIn.readBytes(n3 * n)) != null) {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    lArray[n4] = byteBuffer.getLong();
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    long l6 = lArray[n4];
                    int n5 = l5 + 64L <= l ? 64 : (int)(l - l5);
                    for (int i = 0; i < n5; ++i) {
                        booleanConsumer.accept((l6 & 1L << i) != 0L);
                    }
                    l5 += 64L;
                }
                n3 = (int)Math.min(l4 -= (long)n3, (long)n2);
            }
        }
    }

    private void extractIntArray(String string, long l, IntConsumer intConsumer) throws UMBException {
        try (UMBIn uMBIn = this.open();){
            ByteBuffer byteBuffer;
            long l2 = uMBIn.findArchiveEntry(string);
            if (l2 != l * 4L) {
                throw new UMBException("File " + string + " has unexpected size (" + l2 + " bytes, not " + l * 4L + ")");
            }
            int n = 4;
            long l3 = l;
            int n2 = (int)Math.min((long)(BUFFER_SIZE / n), l3);
            int[] nArray = new int[n2];
            int n3 = (int)Math.min(l3, (long)n2);
            while (n3 > 0 && (byteBuffer = uMBIn.readBytes(n3 * n)) != null) {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    nArray[n4] = byteBuffer.getInt();
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    intConsumer.accept(nArray[n4]);
                }
                n3 = (int)Math.min(l3 -= (long)n3, (long)n2);
            }
        }
    }

    private void extractLongArray(String string, long l, LongConsumer longConsumer) throws UMBException {
        try (UMBIn uMBIn = this.open();){
            ByteBuffer byteBuffer;
            long l2 = uMBIn.findArchiveEntry(string);
            if (l2 != l * 8L) {
                throw new UMBException("File " + string + " has unexpected size (" + l2 + " bytes, not " + l * 8L + ")");
            }
            int n = 8;
            long l3 = l;
            int n2 = (int)Math.min((long)(BUFFER_SIZE / n), l3);
            long[] lArray = new long[n2];
            int n3 = (int)Math.min(l3, (long)n2);
            while (n3 > 0 && (byteBuffer = uMBIn.readBytes(n3 * n)) != null) {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    lArray[n4] = byteBuffer.getLong();
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    longConsumer.accept(lArray[n4]);
                }
                n3 = (int)Math.min(l3 -= (long)n3, (long)n2);
            }
        }
    }

    private void extractDoubleArray(String string, long l, java.util.function.DoubleConsumer doubleConsumer) throws UMBException {
        try (UMBIn uMBIn = this.open();){
            ByteBuffer byteBuffer;
            long l2 = uMBIn.findArchiveEntry(string);
            if (l2 != l * 8L) {
                throw new UMBException("File " + string + " has unexpected size (" + l2 + " bytes, not " + l * 8L + ")");
            }
            int n = 8;
            long l3 = l;
            int n2 = (int)Math.min((long)(BUFFER_SIZE / n), l3);
            double[] dArray = new double[n2];
            int n3 = (int)Math.min(l3, (long)n2);
            while (n3 > 0 && (byteBuffer = uMBIn.readBytes(n3 * n)) != null) {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    dArray[n4] = byteBuffer.getDouble();
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    doubleConsumer.accept(dArray[n4]);
                }
                n3 = (int)Math.min(l3 -= (long)n3, (long)n2);
            }
        }
    }

    private void extractContinuousNumericArray(String string, UMBType uMBType, long l, Consumer<?> consumer) throws UMBException {
        long l2;
        long l3 = l2 = uMBType.type.isInterval() ? l * 2L : l;
        if (uMBType.type.isDouble()) {
            this.extractDoubleArray(string, l2, (java.util.function.DoubleConsumer)((DoubleConsumer)consumer::accept));
        } else if (uMBType.type.isRational()) {
            if (!uMBType.isDefaultSize()) {
                throw new UMBException("Non-default sized rationals are not yet supported");
            }
            this.extractLongArray(string, l2 * 2L, (LongConsumer)((it.unimi.dsi.fastutil.longs.LongConsumer)consumer::accept));
        } else {
            throw new UMBException("Unsupported continuous numeric type " + String.valueOf(uMBType));
        }
    }

    private void extractBitStringArray(String string, long l, int n, Consumer<UMBBitString> consumer) throws UMBException {
        try (UMBIn uMBIn = this.open();){
            ByteBuffer byteBuffer;
            int n2;
            long l2 = uMBIn.findArchiveEntry(string);
            if (l2 != l * (long)n) {
                throw new UMBException("File " + string + " has unexpected size (" + l2 + " bytes, not " + l * (long)n + ")");
            }
            long l3 = l;
            int n3 = (int)Math.min((long)(BUFFER_SIZE / n), l3);
            UMBBitString[] uMBBitStringArray = new UMBBitString[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                uMBBitStringArray[n2] = new UMBBitString(n);
            }
            n2 = (int)Math.min(l3, (long)n3);
            while (n2 > 0 && (byteBuffer = uMBIn.readBytes(n2 * n)) != null) {
                int n4;
                for (n4 = 0; n4 < n2; ++n4) {
                    byteBuffer.get(uMBBitStringArray[n4].bytes);
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    consumer.accept(uMBBitStringArray[n4]);
                }
                n2 = (int)Math.min(l3 -= (long)n2, (long)n3);
            }
        }
    }

    private void extractStrings(String string, int n, Consumer<String> consumer) throws UMBException {
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        this.extractLongArray(UMBFormat.stringOffsetsFile(string), n + 1, arrayList::add);
        this.extractStringList(UMBFormat.stringsFile(string), arrayList, consumer);
    }

    private void extractStringList(String string, List<Long> list, Consumer<String> consumer) throws UMBException {
        try (UMBIn uMBIn = this.open();){
            int n = list.size() - 1;
            long l = uMBIn.findArchiveEntry(string);
            if (l != list.get(n)) {
                throw new UMBException("File " + string + " has unexpected size (" + l + " bytes, not " + String.valueOf(list.get(n)) + ")");
            }
            for (int i = 0; i < n; ++i) {
                long l2 = list.get(i + 1) - list.get(i);
                if (l2 > Integer.MAX_VALUE) {
                    throw new UMBException("Could not read overlength string (" + l2 + "bytes) from file " + string);
                }
                String string2 = uMBIn.readString((int)l2);
                if (string2 == null) {
                    throw new UMBException("Could not read string of length " + l2 + " from file " + string);
                }
                consumer.accept(string2);
            }
        }
    }

    private UMBIn open() throws UMBException {
        if (this.umbInCached != null) {
            return this.umbInCached;
        }
        return new UMBIn(this.fileIn);
    }

    private static class UMBIn {
        private final InputStream fsIn;
        private CompressorInputStream zipIn;
        private TarArchiveInputStream tarIn;
        private ByteBuffer byteBuffer;
        private static final int DEFAULT_BUFFER_SIZE = 1024;

        public UMBIn(File file) throws UMBException {
            try {
                this.fsIn = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                try {
                    this.zipIn = new CompressorStreamFactory().createCompressorInputStream(this.fsIn);
                    this.tarIn = new TarArchiveInputStream((InputStream)this.zipIn);
                }
                catch (CompressorException compressorException) {
                    this.zipIn = null;
                    this.tarIn = new TarArchiveInputStream(this.fsIn);
                }
                this.byteBuffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);
            }
            catch (IOException iOException) {
                throw new UMBException("Could not open UMB file: " + iOException.getMessage());
            }
        }

        public boolean archiveEntryExists(String string) throws UMBException {
            try {
                TarArchiveEntry tarArchiveEntry;
                while ((tarArchiveEntry = this.tarIn.getNextTarEntry()) != null) {
                    if (!this.tarIn.canReadEntryData((ArchiveEntry)tarArchiveEntry) || !tarArchiveEntry.getName().equals(string)) continue;
                    return true;
                }
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error extracting from UMB file");
            }
            return false;
        }

        public long findArchiveEntry(String string) throws UMBException {
            try {
                TarArchiveEntry tarArchiveEntry;
                while ((tarArchiveEntry = this.tarIn.getNextTarEntry()) != null) {
                    if (!this.tarIn.canReadEntryData((ArchiveEntry)tarArchiveEntry) || !tarArchiveEntry.getName().equals(string)) continue;
                    return tarArchiveEntry.getSize();
                }
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error extracting from UMB file");
            }
            throw new UMBException("UMB archive entry \"" + string + "\" not found");
        }

        public TarArchiveInputStream getInputStream() {
            return this.tarIn;
        }

        public ByteBuffer readBytes(int n) throws UMBException {
            if (n > this.byteBuffer.capacity()) {
                this.byteBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            }
            try {
                byte[] byArray = this.byteBuffer.array();
                int n2 = this.tarIn.read(byArray, 0, n);
                this.byteBuffer.position(n);
                if (n2 < n) {
                    return null;
                }
                this.byteBuffer.flip();
                return this.byteBuffer;
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error extracting " + n + " bytes from UMB entry \"" + this.tarIn.getCurrentEntry().getName() + "\"");
            }
        }

        public ByteBuffer readBytesPadded(int n) throws UMBException {
            if (n > this.byteBuffer.capacity()) {
                this.byteBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            }
            try {
                byte[] byArray = this.byteBuffer.array();
                int n2 = this.tarIn.read(byArray, 0, n);
                this.byteBuffer.position(n);
                if (n2 <= 0) {
                    return null;
                }
                if (n2 < n) {
                    for (int i = n2; i < n; ++i) {
                        byArray[i] = 0;
                    }
                }
                this.byteBuffer.flip();
                return this.byteBuffer;
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error extracting " + n + " bytes from UMB entry \"" + this.tarIn.getCurrentEntry().getName() + "\"");
            }
        }

        public String readString(int n) throws UMBException {
            if (n > this.byteBuffer.capacity()) {
                this.byteBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            }
            try {
                byte[] byArray = this.byteBuffer.array();
                int n2 = this.tarIn.read(byArray, 0, n);
                this.byteBuffer.position(n);
                if (n2 < n) {
                    return null;
                }
                return new String(byArray, 0, n2, StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error extracting string from UMB entry \"" + this.tarIn.getCurrentEntry().getName() + "\"");
            }
        }

        public String readAsString() throws UMBException {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                int n;
                byte[] byArray = this.byteBuffer.array();
                while ((n = this.tarIn.read(byArray)) != -1) {
                    stringBuilder.append(new String(byArray, 0, n, StandardCharsets.UTF_8));
                }
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error extracting string from UMB entry \"" + this.tarIn.getCurrentEntry().getName() + "\"");
            }
        }

        public void close() throws UMBException {
            try {
                if (this.tarIn != null) {
                    this.tarIn.close();
                }
                if (this.zipIn != null) {
                    this.zipIn.close();
                }
                if (this.fsIn != null) {
                    this.fsIn.close();
                }
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error closing UMB file");
            }
        }
    }

    public static class OffsetsToCounts
    implements LongConsumer {
        LongConsumer out;
        long offsetLast;

        OffsetsToCounts(LongConsumer longConsumer) {
            this.out = longConsumer;
        }

        @Override
        public void accept(long l) {
            if (this.offsetLast != -1L) {
                this.out.accept(l - this.offsetLast);
            }
            this.offsetLast = l;
        }
    }

    public static class LongMax
    implements LongConsumer {
        long max = Long.MIN_VALUE;

        public long getMax() {
            return this.max;
        }

        @Override
        public void accept(long l) {
            this.max = Long.max(this.max, l);
        }
    }

    @FunctionalInterface
    public static interface LongBooleanConsumer {
        public void accept(long var1, boolean var3);
    }

    public static class IndexedBooleanConsumer
    implements BooleanConsumer {
        private final LongBooleanConsumer longBooleanConsumer;
        private long index = 0L;

        public IndexedBooleanConsumer(LongBooleanConsumer longBooleanConsumer) {
            this.longBooleanConsumer = longBooleanConsumer;
        }

        public void accept(boolean bl) {
            this.longBooleanConsumer.accept(this.index++, bl);
        }
    }

    @FunctionalInterface
    public static interface LongIntConsumer {
        public void accept(long var1, int var3);
    }

    public static class IndexedIntConsumer
    implements IntConsumer {
        private final LongIntConsumer longIntConsumer;
        private long index = 0L;

        public IndexedIntConsumer(LongIntConsumer longIntConsumer) {
            this.longIntConsumer = longIntConsumer;
        }

        @Override
        public void accept(int n) {
            this.longIntConsumer.accept(this.index++, n);
        }
    }

    public static class IntRangeComputer
    extends IntRange
    implements IntConsumer {
        @Override
        public void accept(int n) {
            this.min = Integer.min(this.min, n);
            this.max = Integer.max(this.max, n);
        }
    }

    public static class IntRange {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }
    }

    @FunctionalInterface
    public static interface LongLongConsumer {
        public void accept(long var1, long var3);
    }
}

