/*
 * Decompiled with CFR 0.152.
 */
package io;

import common.IteratorTools;
import explicit.DTMC;
import explicit.IDTMC;
import explicit.Model;
import explicit.NondetModel;
import explicit.PartiallyObservableModel;
import explicit.TurnBasedGame;
import explicit.rewards.Rewards;
import io.ModelExportOptions;
import io.ModelExporter;
import io.Transition;
import java.util.BitSet;
import java.util.List;
import parser.State;
import parser.VarList;
import prism.Evaluator;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;

public class PrismExplicitExporter<Value>
extends ModelExporter<Value> {
    public PrismExplicitExporter() {
    }

    public PrismExplicitExporter(ModelExportOptions modelExportOptions) {
        super(modelExportOptions);
    }

    @Override
    public void exportModel(Model<Value> model, PrismLog prismLog) throws PrismException {
        this.exportTransitions(model, prismLog);
    }

    public <ValueM> void exportTransitions(Model<ValueM> model, PrismLog prismLog) throws PrismException {
        ModelType modelType = model.getModelType();
        boolean bl = this.modelExportOptions.getShowActions();
        boolean bl2 = modelType.partiallyObservable();
        int n = model.getNumStates();
        prismLog.print(n);
        if (modelType.multiplePlayers()) {
            prismLog.print(":" + model.getNumPlayers());
        }
        if (modelType.nondeterministic()) {
            prismLog.print(" " + ((NondetModel)model).getNumChoices());
        }
        prismLog.print(" " + model.getNumTransitions());
        if (modelType.partiallyObservable()) {
            prismLog.print(" " + ((PartiallyObservableModel)model).getNumObservations());
        }
        prismLog.print("\n");
        if (bl2) {
            for (int n2 : model.getInitialStates()) {
                prismLog.print("-");
                if (modelType.nondeterministic()) {
                    prismLog.print(" -");
                }
                prismLog.print(" " + n2);
                if (modelType.isProbabilistic()) {
                    prismLog.print(" -");
                }
                if (modelType.partiallyObservable()) {
                    prismLog.print(" " + ((PartiallyObservableModel)model).getObservation(n2));
                }
                prismLog.print("\n");
            }
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            n2 = 1;
            if (modelType.nondeterministic()) {
                n2 = ((NondetModel)model).getNumChoices(i);
            }
            for (int j = 0; j < n2; ++j) {
                for (Transition<Object> transition : this.getSortedTransitionsIterator(model, i, j, bl)) {
                    prismLog.print(i);
                    if (modelType.multiplePlayers() && !modelType.concurrent()) {
                        prismLog.print(":" + ((TurnBasedGame)((Object)model)).getPlayer(i));
                    }
                    if (modelType.nondeterministic()) {
                        prismLog.print(" " + j);
                    }
                    prismLog.print(" " + transition.target);
                    if (modelType.isProbabilistic()) {
                        prismLog.print(" " + transition.toString(this.modelExportOptions));
                    }
                    if (modelType.partiallyObservable()) {
                        prismLog.print(" " + ((PartiallyObservableModel)model).getObservation(transition.target));
                    }
                    if (bl && transition.action != null && !"".equals(transition.action)) {
                        prismLog.print(" " + String.valueOf(transition.action));
                    }
                    prismLog.print("\n");
                }
            }
        }
    }

    public void exportStateRewards(Model<Value> model, Rewards<Value> rewards, String string, PrismLog prismLog) throws PrismException {
        Value Value2;
        int n;
        this.setEvaluator(model.getEvaluator());
        Evaluator<Value> evaluator = rewards.getEvaluator();
        boolean bl = !this.getModelExportOptions().getPrintHeaders();
        int n2 = model.getNumStates();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            Value2 = rewards.getStateReward(n);
            if (evaluator.isZero(Value2)) continue;
            ++n3;
        }
        this.printStateRewardsHeader(prismLog, string, bl);
        prismLog.println(n2 + " " + n3);
        for (n = 0; n < n2; ++n) {
            Value2 = rewards.getStateReward(n);
            if (evaluator.isZero(Value2)) continue;
            prismLog.println(n + " " + this.formatValue(Value2, evaluator));
        }
    }

    public void printStateRewardsHeader(PrismLog prismLog, String string, boolean bl) {
        if (bl) {
            return;
        }
        prismLog.print("# Reward structure");
        if (!"".equals(string)) {
            prismLog.print(" \"" + string + "\"");
        }
        prismLog.println("\n# State rewards");
    }

    public void exportTransRewards(Model<Value> model, Rewards<Value> rewards, String string, PrismLog prismLog) throws PrismException {
        int n;
        this.setEvaluator(model.getEvaluator());
        Evaluator<Value> evaluator = rewards.getEvaluator();
        boolean bl = !this.getModelExportOptions().getPrintHeaders();
        boolean bl2 = model.getModelType().nondeterministic();
        int n2 = model.getNumStates();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (bl2) {
                int n4 = ((NondetModel)model).getNumChoices();
                for (int i = 0; i < n4; ++i) {
                    Value object2 = rewards.getTransitionReward(n, i);
                    if (evaluator.isZero(object2)) continue;
                    n3 += ((NondetModel)model).getNumTransitions(n, i);
                }
                continue;
            }
            Model model2 = model instanceof IDTMC ? ((IDTMC)model).getIntervalModel() : (DTMC)model;
            n3 += Math.toIntExact(IteratorTools.count(this.getSortedTransitionRewardsIterator(model2, rewards, n, true), transition -> !transition.isZero()));
        }
        this.printTransRewardsHeader(prismLog, string, bl);
        prismLog.print(n2);
        if (bl2) {
            prismLog.print(" " + ((NondetModel)model).getNumChoices());
        }
        prismLog.println(" " + n3);
        for (n = 0; n < n2; ++n) {
            if (bl2) {
                int n5 = ((NondetModel)model).getNumChoices();
                for (int i = 0; i < n5; ++i) {
                    Value Value2 = rewards.getTransitionReward(n, i);
                    if (evaluator.isZero(Value2)) continue;
                    for (Transition<Object> transition2 : this.getSortedTransitionsIterator(model, n, i, this.modelExportOptions.getShowActions())) {
                        prismLog.println(n + " " + i + " " + transition2.target + " " + this.formatValue(Value2, evaluator));
                    }
                }
                continue;
            }
            Model model3 = model instanceof IDTMC ? ((IDTMC)model).getIntervalModel() : (DTMC)model;
            for (Transition<Value> transition3 : this.getSortedTransitionRewardsIterator(model3, rewards, n, true)) {
                if (transition3.isZero()) continue;
                prismLog.println(n + " " + transition3.target + " " + transition3.toString(this.modelExportOptions));
            }
        }
    }

    public void printTransRewardsHeader(PrismLog prismLog, String string, boolean bl) {
        if (bl) {
            return;
        }
        prismLog.print("# Reward structure");
        if (!"".equals(string)) {
            prismLog.print(" \"" + string + "\"");
        }
        prismLog.println("\n# Transition rewards");
    }

    public void exportStates(Model<Value> model, VarList varList, PrismLog prismLog) throws PrismException {
        int n;
        List<State> list = model.getStatesList();
        if (list == null) {
            return;
        }
        prismLog.print("(");
        int n2 = varList.getNumVars();
        for (n = 0; n < n2; ++n) {
            prismLog.print(varList.getName(n));
            if (n >= n2 - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        n = list.size();
        for (int i = 0; i < n; ++i) {
            prismLog.println(i + ":" + list.get(i).toString());
        }
    }

    public void exportObservations(PartiallyObservableModel<Value> partiallyObservableModel, ModelInfo modelInfo, PrismLog prismLog) throws PrismException {
        int n;
        List<State> list = partiallyObservableModel.getObservationsList();
        prismLog.print("(");
        int n2 = modelInfo.getNumObservables();
        for (n = 0; n < n2; ++n) {
            prismLog.print(modelInfo.getObservableName(n));
            if (n >= n2 - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        n = partiallyObservableModel.getNumObservations();
        for (int i = 0; i < n; ++i) {
            prismLog.println(i + ":" + list.get(i).toString());
        }
    }

    public void exportLabels(Model<Value> model, List<String> list, List<BitSet> list2, PrismLog prismLog) throws PrismException {
        int n;
        this.setEvaluator(model.getEvaluator());
        int n2 = model.getNumStates();
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            prismLog.print((n > 0 ? " " : "") + n + "=\"" + list.get(n) + "\"");
        }
        prismLog.println();
        for (n = 0; n < n2; ++n) {
            boolean bl = true;
            for (int i = 0; i < n3; ++i) {
                if (!list2.get(i).get(n)) continue;
                if (bl) {
                    prismLog.print(n + ":");
                    bl = false;
                }
                prismLog.print(" " + i);
            }
            if (bl) continue;
            prismLog.println();
        }
    }
}

