/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableBitSet;
import common.functions.PairPredicateInt;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.BasicModelTransformation;
import explicit.ECComputer;
import explicit.ECComputerDefault;
import explicit.MDP;
import explicit.Product;
import explicit.modelviews.EquivalenceRelationInteger;
import explicit.modelviews.MDPDroppedChoicesCached;
import explicit.modelviews.MDPEquiv;
import explicit.modelviews.StateChoicePair;
import explicit.rewards.MDPRewards;
import java.util.BitSet;
import java.util.List;
import prism.PrismComponent;
import prism.PrismException;

public class ZeroRewardECQuotient<Value> {
    private MDPEquiv<Value> quotient;
    private MDPRewards<Value> quotientRewards;
    private int numberOfZMECs;
    private static final boolean debug = false;

    private ZeroRewardECQuotient(MDPEquiv<Value> mDPEquiv, MDPRewards<Value> mDPRewards, int n) {
        this.quotient = mDPEquiv;
        this.quotientRewards = mDPRewards;
        this.numberOfZMECs = n;
    }

    public MDP<Value> getModel() {
        return this.quotient;
    }

    public MDPRewards<Value> getRewards() {
        return this.quotientRewards;
    }

    public int getNumberOfZeroRewardMECs() {
        return this.numberOfZMECs;
    }

    public BitSet getNonRepresentativeStates() {
        return this.quotient.getNonRepresentativeStates();
    }

    public void mapResults(double[] dArray) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableBitSet(this.quotient.getNonRepresentativeStates()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            int n2 = this.quotient.mapStateToRestrictedModel(n);
            dArray[n] = dArray[n2];
        }
    }

    public static <Value> ZeroRewardECQuotient<Value> getQuotient(PrismComponent prismComponent, MDP<Value> mDP, BitSet bitSet, final MDPRewards<Value> mDPRewards) throws PrismException {
        PairPredicateInt pairPredicateInt = (n, n2) -> {
            if (mDP.getEvaluator().gt(mDPRewards.getStateReward(n), mDP.getEvaluator().zero())) {
                return true;
            }
            return mDP.getEvaluator().gt(mDPRewards.getTransitionReward(n, n2), mDP.getEvaluator().zero());
        };
        MDPDroppedChoicesCached<Value> mDPDroppedChoicesCached = new MDPDroppedChoicesCached<Value>(mDP, pairPredicateInt);
        ECComputer eCComputer = ECComputerDefault.createECComputer(prismComponent, mDPDroppedChoicesCached);
        eCComputer.computeMECStates(bitSet);
        List<BitSet> list = eCComputer.getMECStates();
        if (list.isEmpty()) {
            return null;
        }
        EquivalenceRelationInteger equivalenceRelationInteger = new EquivalenceRelationInteger(list);
        PairPredicateInt pairPredicateInt2 = (n, n3) -> {
            if (pairPredicateInt.test(n, n3)) {
                return false;
            }
            boolean bl = mDP.allSuccessorsMatch(n, n3, n2 -> equivalenceRelationInteger.test(n, n2));
            return bl;
        };
        final MDPDroppedChoicesCached<Value> mDPDroppedChoicesCached2 = new MDPDroppedChoicesCached<Value>(mDP, pairPredicateInt2);
        BasicModelTransformation<MDP<Value>, MDPEquiv<Value>> basicModelTransformation = MDPEquiv.transform(mDPDroppedChoicesCached2, equivalenceRelationInteger);
        final MDPEquiv<Value> mDPEquiv = basicModelTransformation.getTransformedModel();
        MDPRewards mDPRewards2 = new MDPRewards<Value>(){

            @Override
            public Value getStateReward(int n) {
                return mDPRewards.getStateReward(n);
            }

            @Override
            public Value getTransitionReward(int n, int n2) {
                StateChoicePair stateChoicePair = mDPEquiv.mapToOriginalModel(n, n2);
                int n3 = mDPDroppedChoicesCached2.mapChoiceToOriginalModel(stateChoicePair.getState(), stateChoicePair.getChoice());
                return mDPRewards.getTransitionReward(stateChoicePair.getState(), n3);
            }

            @Override
            public MDPRewards<Value> liftFromModel(Product<?> product) {
                throw new RuntimeException("Not implemented");
            }

            @Override
            public boolean hasTransitionRewards() {
                return mDPRewards.hasTransitionRewards();
            }
        };
        return new ZeroRewardECQuotient<Value>(mDPEquiv, mDPRewards2, list.size());
    }
}

