/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import java.text.DecimalFormat;
import java.util.Arrays;

public class ReachTuple {
    private static DecimalFormat df = new DecimalFormat("0.0000");
    private static boolean roundingOn = false;
    private static boolean roundDown = false;
    private static double eps = 1.0E-5;
    private double[] values;

    public ReachTuple(int n) {
        this.values = new double[n];
    }

    public ReachTuple(double[] dArray) {
        this.values = (double[])dArray.clone();
    }

    public ReachTuple(ReachTuple reachTuple, double d) {
        this.values = (double[])reachTuple.getValues().clone();
        int n = 0;
        while (n < this.values.length) {
            int n2 = n++;
            this.values[n2] = this.values[n2] * d;
        }
    }

    public ReachTuple(ReachTuple reachTuple, double d, ReachTuple reachTuple2, double d2) {
        if (reachTuple.size() != reachTuple2.size()) {
            throw new IllegalArgumentException("Cannot add two tuples of different sizes");
        }
        this.values = new double[reachTuple.size()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = d * reachTuple.getValue(i) + d2 * reachTuple2.getValue(i);
        }
    }

    public ReachTuple(ReachTuple reachTuple, ReachTuple reachTuple2, boolean bl) {
        if (reachTuple.size() != reachTuple2.size()) {
            throw new IllegalArgumentException("Cannot add two tuples of different sizes");
        }
        this.values = new double[reachTuple.size()];
        if (bl) {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = Math.min(reachTuple.getValue(i), reachTuple2.getValue(i));
            }
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = Math.max(reachTuple.getValue(i), reachTuple2.getValue(i));
            }
        }
    }

    public void add(ReachTuple reachTuple) {
        if (reachTuple.size() != this.size()) {
            throw new IllegalArgumentException("Cannot add tuples of different sizes");
        }
        for (int i = 0; i < this.values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] + reachTuple.getValue(i);
        }
    }

    public double[] getValues() {
        return this.values;
    }

    public double getValue(int n) {
        if (n < this.values.length) {
            return this.values[n];
        }
        throw new IllegalArgumentException("Index exceeds the number of targets");
    }

    public void setValue(int n, double d) {
        if (n >= this.values.length) {
            throw new IllegalArgumentException("Index exceeds the number of targets");
        }
        this.values[n] = d;
    }

    public boolean isContained(ReachTuple reachTuple, ReachTuple reachTuple2) {
        if (reachTuple.size() != reachTuple2.size() || reachTuple.size() != this.size()) {
            return false;
        }
        if (roundDown) {
            this.roundDown();
            reachTuple.roundDown();
            reachTuple2.roundDown();
        }
        double d = roundingOn ? this.getEpsilon() : 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        for (int i = 0; i < this.size(); ++i) {
            double d4;
            double d5;
            if (reachTuple.getValue(i) > reachTuple2.getValue(i)) {
                if (d < this.getValue(i) - reachTuple.getValue(i)) {
                    return false;
                }
                d5 = 1.0;
                d4 = (this.getValue(i) - reachTuple2.getValue(i) - (this.getValue(i) == reachTuple2.getValue(i) ? 0.0 : d)) / (reachTuple.getValue(i) - reachTuple2.getValue(i));
            } else if (reachTuple.getValue(i) < reachTuple2.getValue(i)) {
                if (d < this.getValue(i) - reachTuple2.getValue(i)) {
                    return false;
                }
                d4 = 0.0;
                d5 = (this.getValue(i) - reachTuple2.getValue(i) - (this.getValue(i) == reachTuple2.getValue(i) ? 0.0 : d)) / (reachTuple.getValue(i) - reachTuple2.getValue(i));
            } else {
                if (d < this.getValue(i) - reachTuple2.getValue(i)) {
                    return false;
                }
                d5 = 1.0;
                d4 = 0.0;
            }
            if (d4 > d2) {
                d2 = d4;
            }
            if (d5 < d3 && d5 >= 0.0) {
                d3 = d5;
            }
            if (!(d3 < d2)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(ReachTuple reachTuple) {
        if (reachTuple.size() != this.size()) {
            return false;
        }
        if (roundDown) {
            this.roundDown();
            reachTuple.roundDown();
        }
        double d = roundingOn ? this.getEpsilon() : 0.0;
        for (int i = 0; i < this.size(); ++i) {
            if (!(reachTuple.getValue(i) > this.getValue(i) + d)) continue;
            return false;
        }
        return true;
    }

    public void roundDown() {
        for (int i = 0; i < this.getValues().length; ++i) {
            this.values[i] = Math.floor(this.values[i] / eps) * eps;
        }
    }

    private double getEpsilon() {
        if (Math.random() > -1.0) {
            return eps;
        }
        return 0.0;
    }

    public int size() {
        return this.getValues().length;
    }

    public boolean isZero() {
        for (int i = 0; i < this.getValues().length; ++i) {
            if (this.getValue(i) == 0.0) continue;
            return false;
        }
        return true;
    }

    public void perturbateUp() {
        int n;
        double d = 0.0;
        for (n = 0; n < this.values.length; ++n) {
            d += this.values[n];
        }
        if (d == 1.0) {
            return;
        }
        for (n = 0; n < this.values.length; ++n) {
            if (this.values[n] != 0.0) continue;
            this.values[n] = 0.1;
        }
    }

    public void perturbateDown() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == 1.0 || !(this.values[i] > 0.1)) continue;
            int n = i;
            this.values[n] = this.values[n] - 0.1;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReachTuple)) {
            return false;
        }
        return Arrays.equals(this.getValues(), ((ReachTuple)object).getValues());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getValues());
    }

    public String toString() {
        Object object = "[ ";
        for (int i = 0; i < this.getValues().length; ++i) {
            object = (String)object + df.format(this.getValue(i)) + " ";
        }
        object = (String)object + "]";
        return object;
    }

    private static void testIsContained() {
        ReachTuple reachTuple = new ReachTuple(new double[]{0.0, 0.8, 0.0});
        ReachTuple reachTuple2 = new ReachTuple(new double[]{0.508, 0.0, 0.48000000000000004});
        ReachTuple reachTuple3 = new ReachTuple(new double[]{0.4, 0.16000000000000003, 0.4});
        ReachTuple reachTuple4 = new ReachTuple(new double[]{0.49600000000000005, 0.006400000000000002, 0.49600000000000005});
        ReachTuple reachTuple5 = new ReachTuple(new double[]{0.48000000000000004, 0.03200000000000001, 0.48000000000000004});
        ReachTuple reachTuple6 = new ReachTuple(new double[]{0.54, 0.0, 0.4});
        System.out.println(reachTuple3.isContained(reachTuple, reachTuple4));
    }

    public static void testContains() {
        ReachTuple reachTuple = new ReachTuple(new double[]{0.499968, 5.1200000000000025E-5, 0.499968});
        ReachTuple reachTuple2 = new ReachTuple(new double[]{0.5000128, 0.0, 0.499968});
        System.out.println(reachTuple.contains(reachTuple2) + " " + reachTuple2.contains(reachTuple));
    }

    public static void main(String[] stringArray) {
        ReachTuple.testIsContained();
        ReachTuple.testContains();
        ReachTuple reachTuple = new ReachTuple(new double[]{0.1, 0.7, 0.1});
        ReachTuple reachTuple2 = new ReachTuple(new double[]{0.5, 0.2, 0.9});
        ReachTuple reachTuple3 = new ReachTuple(new double[]{0.3, 0.3, 0.5});
        reachTuple3.isContained(reachTuple, reachTuple2);
        double[] dArray = new double[]{1.0, 0.5};
        System.out.println(Arrays.toString(dArray));
        ReachTuple reachTuple4 = new ReachTuple(dArray);
        reachTuple4.setValue(0, 0.333);
        System.out.println(Arrays.toString(dArray));
        System.out.println(Arrays.toString(reachTuple4.getValues()));
    }
}

