/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterator;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public abstract class EmptyIterator<E>
implements FunctionalIterator<E> {
    public static <E> Of<E> of() {
        return Of.OF;
    }

    public static OfDouble ofDouble() {
        return OfDouble.OF_DOUBLE;
    }

    public static OfInt ofInt() {
        return OfInt.OF_INT;
    }

    public static OfLong ofLong() {
        return OfLong.OF_LONG;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public EmptyIterator<E> dedupe() {
        return this;
    }

    @Override
    public EmptyIterator<E> distinct() {
        return this;
    }

    public static class Of<E>
    extends EmptyIterator<E> {
        private static final Of<?> OF = new Of();

        private Of() {
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }
    }

    public static class OfDouble
    extends EmptyIterator<Double>
    implements FunctionalPrimitiveIterator.OfDouble {
        private static final OfDouble OF_DOUBLE = new OfDouble();

        private OfDouble() {
        }

        @Override
        public double nextDouble() {
            throw new NoSuchElementException();
        }

        @Override
        public OfDouble dedupe() {
            return this;
        }

        @Override
        public OfDouble distinct() {
            return this;
        }

        @Override
        public OptionalDouble max() {
            return OptionalDouble.empty();
        }

        @Override
        public OptionalDouble min() {
            return this.max();
        }

        @Override
        public double sum() {
            return 0.0;
        }
    }

    public static class OfInt
    extends EmptyIterator<Integer>
    implements FunctionalPrimitiveIterator.OfInt {
        private static final OfInt OF_INT = new OfInt();

        private OfInt() {
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public OfInt dedupe() {
            return this;
        }

        @Override
        public OfInt distinct() {
            return this;
        }

        @Override
        public OptionalInt max() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt min() {
            return this.max();
        }

        @Override
        public long sum() {
            return 0L;
        }
    }

    public static class OfLong
    extends EmptyIterator<Long>
    implements FunctionalPrimitiveIterator.OfLong {
        private static final OfLong OF_LONG = new OfLong();

        private OfLong() {
        }

        @Override
        public long nextLong() {
            throw new NoSuchElementException();
        }

        @Override
        public OfLong dedupe() {
            return this;
        }

        @Override
        public OfLong distinct() {
            return this;
        }

        @Override
        public OptionalLong max() {
            return OptionalLong.empty();
        }

        @Override
        public OptionalLong min() {
            return this.max();
        }

        @Override
        public long sum() {
            return 0L;
        }
    }
}

