/*
 * Decompiled with CFR 0.152.
 */
package userinterface.util;

import java.util.ArrayList;
import java.util.Observable;
import userinterface.util.PropertyOwner;
import userinterface.util.SelectionEvent;
import userinterface.util.SelectionListener;

public abstract class SelectionModel
extends Observable {
    private ArrayList<SelectionListener> listeners = new ArrayList();
    private ArrayList<PropertyOwner> currentSelection = new ArrayList();

    public void addSelectionListener(SelectionListener selectionListener) {
        this.listeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.listeners.remove(selectionListener);
    }

    public void fireSelectionChanged() {
        SelectionEvent selectionEvent = new SelectionEvent(this.getCurrentSelection());
        for (int i = 0; i < this.listeners.size(); ++i) {
            SelectionListener selectionListener = this.listeners.get(i);
            selectionListener.selectionPerformed(selectionEvent);
        }
    }

    public ArrayList<PropertyOwner> getCurrentSelection() {
        return this.currentSelection;
    }

    public PropertyOwner getSelectedItem(int n) {
        return this.currentSelection.get(n);
    }

    public int getSelectionSize() {
        return this.currentSelection.size();
    }

    protected void addToSelection(PropertyOwner propertyOwner, boolean bl) {
        if (!this.currentSelection.contains(propertyOwner)) {
            this.currentSelection.add(propertyOwner);
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    protected void removeFromSelection(PropertyOwner propertyOwner, boolean bl) {
        if (this.currentSelection.contains(propertyOwner)) {
            this.currentSelection.remove(propertyOwner);
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    protected void clearSelection(boolean bl) {
        this.currentSelection.clear();
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    protected void setSelection(ArrayList<PropertyOwner> arrayList, boolean bl) {
        this.currentSelection = arrayList;
        if (bl) {
            this.fireSelectionChanged();
        }
    }
}

