/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.DefinedConstant;
import prism.PrismException;

public class ConstantLine
extends JPanel {
    public static final String SINGLE_DEFAULT = "0";
    public static final String RANGE_START_DEFAULT = "0";
    public static final String RANGE_END_DEFAULT = "1";
    public static final String STEP_DEFAULT = "1";
    private Type type;
    JComboBox boolSingleValueCombo;
    private ButtonGroup choiceButtonGroup;
    JTextField endValueField;
    JLabel nameLabel;
    JRadioButton rangeCombo;
    JRadioButton singleValueCombo;
    JTextField singleValueField;
    JPanel sizerPanel;
    JTextField startValueField;
    JTextField stepValueField;
    JLabel typeLabel;

    public ConstantLine(String string, Type type) {
        this.initComponents();
        this.setPreferredSize(new Dimension(1, this.getFontMetrics(this.getFont()).getHeight() + 4));
        this.setConstName(string);
        this.setConstType(type);
        this.doDefaults();
    }

    public void setConstName(String string) {
        this.nameLabel.setText(string);
    }

    public void setConstType(Type type) {
        this.type = type;
        if (type instanceof TypeBool) {
            this.typeLabel.setText("bool");
            this.rangeCombo.setEnabled(false);
            this.singleValueCombo.setSelected(true);
            this.remove(this.singleValueField);
            this.remove(this.boolSingleValueCombo);
            this.remove(this.sizerPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.2;
            gridBagConstraints.ipadx = 5;
            this.add((Component)this.boolSingleValueCombo, gridBagConstraints);
        } else if (type instanceof TypeDouble) {
            this.typeLabel.setText("double");
            this.rangeCombo.setEnabled(true);
            this.singleValueCombo.setSelected(true);
            this.remove(this.singleValueField);
            this.remove(this.boolSingleValueCombo);
            this.remove(this.sizerPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.2;
            gridBagConstraints.ipadx = 5;
            this.add((Component)this.singleValueField, gridBagConstraints);
        } else if (type instanceof TypeInt) {
            this.typeLabel.setText("int");
            this.rangeCombo.setEnabled(true);
            this.singleValueCombo.setSelected(true);
            this.remove(this.singleValueField);
            this.remove(this.boolSingleValueCombo);
            this.remove(this.sizerPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.2;
            gridBagConstraints.ipadx = 5;
            this.add((Component)this.singleValueField, gridBagConstraints);
        } else {
            this.typeLabel.setText("unknown");
            this.rangeCombo.setEnabled(true);
            this.singleValueCombo.setSelected(true);
            this.remove(this.singleValueField);
            this.remove(this.boolSingleValueCombo);
            this.remove(this.sizerPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.2;
            this.add((Component)this.singleValueField, gridBagConstraints);
        }
    }

    public void doDefaults() {
        this.singleValueField.setText("0");
        this.startValueField.setText("0");
        this.endValueField.setText("1");
        this.stepValueField.setText("1");
        this.singleValueCombo.setSelected(true);
        this.doEnables();
    }

    public void doEnables() {
        if (this.singleValueCombo.isSelected()) {
            this.startValueField.setEnabled(false);
            this.endValueField.setEnabled(false);
            this.stepValueField.setEnabled(false);
            this.boolSingleValueCombo.setEnabled(true);
            this.singleValueField.setEnabled(true);
        } else if (this.rangeCombo.isSelected()) {
            this.startValueField.setEnabled(true);
            this.endValueField.setEnabled(true);
            this.stepValueField.setEnabled(true);
            this.boolSingleValueCombo.setEnabled(false);
            this.singleValueField.setEnabled(false);
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean isRange() {
        return this.rangeCombo.isSelected();
    }

    public void setIsRange(boolean bl) {
        this.rangeCombo.setSelected(bl);
        this.singleValueCombo.setSelected(!bl);
        this.doEnables();
    }

    public String getSingleValue() {
        if (this.type instanceof TypeBool) {
            return this.boolSingleValueCombo.getSelectedItem().toString();
        }
        return this.singleValueField.getText();
    }

    public void setSingleValue(String string) {
        if (this.type instanceof TypeBool) {
            if (string != null) {
                this.boolSingleValueCombo.setSelectedIndex(string.equals("true") ? 0 : 1);
            } else {
                this.boolSingleValueCombo.setSelectedIndex(0);
            }
        } else if (string != null) {
            this.singleValueField.setText(string);
        } else {
            this.singleValueField.setText("0");
        }
    }

    public String getStartValue() {
        return this.startValueField.getText();
    }

    public void setStartValue(String string) {
        this.startValueField.setText(string != null ? string : "0");
    }

    public String getEndValue() {
        return this.endValueField.getText();
    }

    public void setEndValue(String string) {
        this.endValueField.setText(string != null ? string : "1");
    }

    public String getStepValue() {
        return this.stepValueField.getText();
    }

    public void setStepValue(String string) {
        this.stepValueField.setText(string != null ? string : "1");
    }

    @Override
    public String getName() {
        return this.nameLabel.getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkValid() throws PrismException {
        String string = "";
        if (this.type instanceof TypeBool) {
            string = this.boolSingleValueCombo.getSelectedItem().toString();
            if (string.equals("true") | string.equals("false")) return;
            throw new PrismException("Invalid value \"" + string + "\" for Boolean constant \"" + this.getName() + "\"");
        }
        if (this.type instanceof TypeInt) {
            try {
                string = this.singleValueField.getText();
                Integer.parseInt(string);
                if (!this.isRange()) return;
                string = this.startValueField.getText();
                Integer.parseInt(string);
                string = this.endValueField.getText();
                Integer.parseInt(string);
                string = this.stepValueField.getText();
                Integer.parseInt(string);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value \"" + string + "\" for integer constant \"" + this.getName() + "\"");
            }
        }
        if (!(this.type instanceof TypeDouble)) throw new PrismException("Unknown type for constant \"" + this.getName() + "\"");
        try {
            string = this.singleValueField.getText();
            DefinedConstant.parseDouble(string);
            if (!this.isRange()) return;
            string = this.startValueField.getText();
            DefinedConstant.parseDouble(string);
            string = this.endValueField.getText();
            DefinedConstant.parseDouble(string);
            string = this.stepValueField.getText();
            DefinedConstant.parseDouble(string);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Invalid value \"" + string + "\" for double constant \"" + this.getName() + "\"");
        }
    }

    private void initComponents() {
        this.choiceButtonGroup = new ButtonGroup();
        this.boolSingleValueCombo = new JComboBox();
        this.sizerPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.singleValueField = new JTextField();
        this.startValueField = new JTextField();
        this.endValueField = new JTextField();
        this.stepValueField = new JTextField();
        this.singleValueCombo = new JRadioButton();
        this.rangeCombo = new JRadioButton();
        this.boolSingleValueCombo.setBackground(new Color(255, 255, 255));
        this.boolSingleValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"true", "false"}));
        this.boolSingleValueCombo.setMinimumSize(new Dimension(4, 19));
        this.boolSingleValueCombo.setPreferredSize(new Dimension(4, 19));
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(255, 255, 255));
        this.setPreferredSize(new Dimension(640, 23));
        this.nameLabel.setText("a");
        this.nameLabel.setMaximumSize(new Dimension(100, 15));
        this.nameLabel.setMinimumSize(new Dimension(50, 15));
        this.nameLabel.setPreferredSize(new Dimension(100, 15));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.typeLabel.setText("double");
        this.typeLabel.setMaximumSize(new Dimension(150, 15));
        this.typeLabel.setMinimumSize(new Dimension(50, 15));
        this.typeLabel.setPreferredSize(new Dimension(100, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.typeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.singleValueField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.startValueField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.endValueField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.stepValueField, gridBagConstraints);
        this.singleValueCombo.setBackground(new Color(255, 255, 255));
        this.choiceButtonGroup.add(this.singleValueCombo);
        this.singleValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConstantLine.this.singleValueComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        this.add((Component)this.singleValueCombo, gridBagConstraints);
        this.rangeCombo.setBackground(new Color(255, 255, 255));
        this.choiceButtonGroup.add(this.rangeCombo);
        this.rangeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConstantLine.this.rangeComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        this.add((Component)this.rangeCombo, gridBagConstraints);
    }

    private void rangeComboActionPerformed(ActionEvent actionEvent) {
        this.doEnables();
    }

    private void singleValueComboActionPerformed(ActionEvent actionEvent) {
        this.doEnables();
    }

    class BottomBorder
    implements Border {
        BottomBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
    }
}

