/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model;

import io.ModelExportFormat;
import io.ModelExportOptions;
import io.ModelExportTask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import prism.ModelType;
import prism.PrismSettings;
import prism.PrismSettingsListener;
import userinterface.GUIClipboardEvent;
import userinterface.GUIPlugin;
import userinterface.GUIPrism;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.GUITextModelEditor;
import userinterface.model.GUITransientTime;
import userinterface.properties.GUIPropertiesEvent;
import userinterface.simulator.GUISimulator;
import userinterface.util.GUIComputationEvent;
import userinterface.util.GUIEvent;
import userinterface.util.GUIExitEvent;
import userinterface.util.GUIUndoManager;

public class GUIMultiModel
extends GUIPlugin
implements PrismSettingsListener {
    public static final int CONTINUE = 0;
    public static final int CANCEL = 1;
    private JTextField fileTextField;
    private JMenu modelMenu;
    private JMenu newMenu;
    private JMenu viewMenu;
    private JMenu exportMenu;
    private JMenu computeMenu;
    private JMenu computeExportMenu;
    private JMenu exportSSMenu;
    private JMenu exportTrMenu;
    private AbstractAction viewStates;
    private AbstractAction viewTrans;
    private AbstractAction viewObs;
    private AbstractAction viewStateRewards;
    private AbstractAction viewTransRewards;
    private AbstractAction viewLabels;
    private AbstractAction viewPrismCode;
    private AbstractAction computeSS;
    private AbstractAction computeTr;
    private AbstractAction newPRISMModel;
    private AbstractAction newPEPAModel;
    private AbstractAction loadModel;
    private AbstractAction reloadModel;
    private AbstractAction saveModel;
    private AbstractAction saveAsModel;
    private AbstractAction parseModel;
    private AbstractAction buildModel;
    private AbstractAction exportStatesPlain;
    private AbstractAction exportStatesMatlab;
    private AbstractAction exportTransPlain;
    private AbstractAction exportTransMatlab;
    private AbstractAction exportTransDot;
    private AbstractAction exportTransUMB;
    private AbstractAction exportObsPlain;
    private AbstractAction exportObsMatlab;
    private AbstractAction exportStateRewardsPlain;
    private AbstractAction exportStateRewardsMatlab;
    private AbstractAction exportTransRewardsPlain;
    private AbstractAction exportTransRewardsMatlab;
    private AbstractAction exportLabelsPlain;
    private AbstractAction exportLabelsMatlab;
    private AbstractAction exportSSPlain;
    private AbstractAction exportSSMatlab;
    private AbstractAction exportTrPlain;
    private AbstractAction exportTrMatlab;
    private JPopupMenu popup;
    private GUIMultiModelHandler handler;
    private Map<String, FileFilter> modelFilters;
    private Map<String, FileFilter> staFilters;
    private Map<String, FileFilter> traFilters;
    private Map<String, FileFilter> obsFilters;
    private Map<String, FileFilter> labFilters;
    private FileFilter textFilter;
    private FileFilter matlabFilter;
    private FileFilter dotFilter;
    private FileFilter umbFilter;
    private boolean computing = false;
    private boolean initialised = false;
    private GUISimulator sim;

    public GUIMultiModel(GUIPrism gUIPrism) {
        super(gUIPrism);
        this.initComponents();
        this.initialised = true;
        this.doEnables();
    }

    @Override
    public void takeCLArgs(String[] stringArray) {
        if (stringArray.length > 0) {
            File file = new File(stringArray[0]);
            this.handler.loadModel(file, false);
            File file2 = file.getParentFile();
            if (file2 == null) {
                file2 = new File(".");
            }
            this.getGUI().getChooser().setCurrentDirectory(file2);
        }
    }

    @Override
    public void onInitComponentsCompleted() {
        this.handler.onInitComponentsCompleted();
    }

    public GUIMultiModelHandler getHandler() {
        return this.handler;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public boolean getComputing() {
        return this.computing;
    }

    public void doEnables() {
        if (!this.initialised) {
            return;
        }
        int n = this.handler.getModelMode();
        Object object = "";
        switch (n) {
            case 1: {
                object = (String)object + "PRISM Model File: ";
                break;
            }
            case 2: {
                object = (String)object + "PEPA Model File: ";
            }
        }
        object = (String)object + this.handler.getActiveFileName();
        if (this.handler.modified()) {
            object = (String)object + "*";
        }
        this.fileTextField.setText((String)object);
        this.newPRISMModel.setEnabled(!this.computing);
        this.newPEPAModel.setEnabled(!this.computing);
        this.loadModel.setEnabled(!this.computing);
        this.reloadModel.setEnabled(!this.computing && this.handler.hasActiveFile());
        this.saveModel.setEnabled(!this.computing && this.handler.modified());
        this.saveAsModel.setEnabled(!this.computing);
        this.parseModel.setEnabled(!this.computing);
        this.buildModel.setEnabled(!this.computing);
        this.viewStates.setEnabled(!this.computing);
        this.viewTrans.setEnabled(!this.computing);
        this.viewObs.setEnabled(!this.computing);
        this.viewStateRewards.setEnabled(!this.computing);
        this.viewTransRewards.setEnabled(!this.computing);
        this.viewLabels.setEnabled(!this.computing);
        this.viewPrismCode.setEnabled(!this.computing && this.handler.getParseState() == 0);
        this.computeSS.setEnabled(!this.computing && (this.handler.getParsedModelType() == ModelType.CTMC || this.handler.getParsedModelType() == ModelType.DTMC));
        this.computeTr.setEnabled(!this.computing && (this.handler.getParsedModelType() == ModelType.CTMC || this.handler.getParsedModelType() == ModelType.DTMC));
        this.exportStatesPlain.setEnabled(!this.computing);
        this.exportStatesMatlab.setEnabled(!this.computing);
        this.exportTransPlain.setEnabled(!this.computing);
        this.exportTransMatlab.setEnabled(!this.computing);
        this.exportTransDot.setEnabled(!this.computing);
        this.exportTransUMB.setEnabled(!this.computing);
        this.exportObsPlain.setEnabled(!this.computing);
        this.exportObsMatlab.setEnabled(!this.computing);
        this.exportStateRewardsPlain.setEnabled(!this.computing);
        this.exportStateRewardsMatlab.setEnabled(!this.computing);
        this.exportTransRewardsPlain.setEnabled(!this.computing);
        this.exportTransRewardsMatlab.setEnabled(!this.computing);
        this.exportLabelsPlain.setEnabled(!this.computing);
        this.exportLabelsMatlab.setEnabled(!this.computing);
    }

    public int doModificationCheck() {
        if (!this.handler.modified()) {
            return 0;
        }
        if (!this.handler.hasActiveFile()) {
            String[] stringArray = new String[]{"Yes", "No", "Cancel"};
            int n = -1;
            n = this.optionPane("Model has been modified.\nDo you wish to save it?", "Question", 2, 3, stringArray, stringArray[0]);
            switch (n) {
                case 0: {
                    return this.a_saveModelAs();
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
            }
            return 1;
        }
        String[] stringArray = new String[]{"Yes", "No", "Save As...", "Cancel"};
        int n = -1;
        n = this.optionPane("Model has been modified.\nDo you wish to save it?", "Question", 2, 3, stringArray, stringArray[0]);
        switch (n) {
            case 0: {
                return this.a_saveModel();
            }
            case 1: {
                return 0;
            }
            case 2: {
                return this.a_saveModelAs();
            }
            case 3: {
                return 1;
            }
        }
        return 1;
    }

    public void showModel(String string) {
        JDialog jDialog = new JDialog((Frame)this.getGUI(), false);
        jDialog.setTitle("Parsed PRISM Model");
        GUITextModelEditor gUITextModelEditor = new GUITextModelEditor(string, this.handler);
        gUITextModelEditor.setEditable(false);
        gUITextModelEditor.setBackground(new Color(224, 255, 255));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(640, 300));
        jScrollPane.setViewportView(gUITextModelEditor);
        jDialog.getContentPane().add(jScrollPane);
        jDialog.setDefaultCloseOperation(2);
        jDialog.pack();
        jDialog.setLocationRelativeTo(this.getGUI());
        jDialog.setVisible(true);
    }

    protected void a_newPRISMModel() {
        int n = this.doModificationCheck();
        if (n == 0) {
            this.handler.newPRISMModel();
        }
    }

    protected void a_newPEPAModel() {
        int n = this.doModificationCheck();
        if (n == 0) {
            this.handler.newPEPAModel();
        }
    }

    protected void a_openModel() {
        int n = this.doModificationCheck();
        if (n == 0) {
            String string;
            switch (this.handler.getModelMode()) {
                case 2: {
                    string = "pepa";
                    break;
                }
                default: {
                    string = "prism";
                }
            }
            if (this.showOpenFileDialog(this.modelFilters.values(), this.modelFilters.get(string)) == 0) {
                File file = this.getChooserFile();
                if (file == null) {
                    this.error("No file selected");
                    return;
                }
                this.getPrism().getMainLog().resetNumberOfWarnings();
                this.handler.loadModel(file);
            }
        }
    }

    protected void a_reloadModel() {
        int n = this.doModificationCheck();
        if (n == 0) {
            this.getPrism().getMainLog().resetNumberOfWarnings();
            this.handler.reloadActiveFile();
        }
    }

    protected int a_saveModel() {
        if (!this.handler.hasActiveFile()) {
            return this.a_saveModelAs();
        }
        this.getPrism().getMainLog().resetNumberOfWarnings();
        return this.handler.saveToActiveFile();
    }

    protected int a_saveModelAs() {
        String string;
        switch (this.handler.getModelMode()) {
            case 2: {
                string = "pepa";
                break;
            }
            default: {
                string = "prism";
            }
        }
        if (this.showSaveFileDialog(this.modelFilters.values(), this.modelFilters.get(string)) != 0) {
            return 1;
        }
        return this.handler.saveToFile(this.getChooserFile());
    }

    protected void a_refreshParseTree() {
        this.handler.requestParse(true);
    }

    protected void a_build() {
        this.getPrism().getMainLog().resetNumberOfWarnings();
        this.handler.forceBuild();
    }

    protected void a_exportBuildAs(ModelExportTask.ModelExportEntity modelExportEntity, ModelExportFormat modelExportFormat) {
        int n = 1;
        block0 : switch (modelExportFormat) {
            case DOT: {
                n = this.showSaveFileDialog(this.dotFilter);
                break;
            }
            case UMB: {
                n = this.showSaveFileDialog(this.umbFilter);
                break;
            }
            case MATLAB: {
                n = this.showSaveFileDialog(this.matlabFilter);
                break;
            }
            default: {
                switch (modelExportEntity) {
                    case STATES: {
                        n = this.showSaveFileDialog(this.staFilters.values(), this.staFilters.get("sta"));
                        break block0;
                    }
                    case MODEL: {
                        n = this.showSaveFileDialog(this.traFilters.values(), this.traFilters.get("tra"));
                        break block0;
                    }
                    case OBSERVATIONS: {
                        n = this.showSaveFileDialog(this.obsFilters.values(), this.obsFilters.get("obs"));
                        break block0;
                    }
                    case LABELS: {
                        n = this.showSaveFileDialog(this.labFilters.values(), this.labFilters.get("lab"));
                        break block0;
                    }
                }
                n = this.showSaveFileDialog(this.textFilter);
            }
        }
        if (n != 0) {
            return;
        }
        this.getPrism().getMainLog().resetNumberOfWarnings();
        this.handler.export(new ModelExportTask(modelExportEntity, this.getChooserFile(), new ModelExportOptions(modelExportFormat)));
    }

    protected void a_viewBuild(ModelExportTask.ModelExportEntity modelExportEntity, ModelExportFormat modelExportFormat) {
        this.getPrism().getMainLog().resetNumberOfWarnings();
        this.handler.export(new ModelExportTask(modelExportEntity, (File)null, new ModelExportOptions(modelExportFormat)));
    }

    protected void a_viewCurrentModelBuild() {
        this.handler.requestViewModel();
    }

    protected void a_exportSteadyState(ModelExportFormat modelExportFormat) {
        int n = 1;
        switch (modelExportFormat) {
            case MATLAB: {
                n = this.showSaveFileDialog(this.matlabFilter);
                break;
            }
            default: {
                n = this.showSaveFileDialog(this.textFilter);
            }
        }
        if (n != 0) {
            return;
        }
        this.getPrism().getMainLog().resetNumberOfWarnings();
        this.handler.computeSteadyState(new ModelExportTask(ModelExportTask.ModelExportEntity.MODEL, this.getChooserFile(), new ModelExportOptions(modelExportFormat)));
    }

    protected void a_computeSteadyState() {
        this.getPrism().getMainLog().resetNumberOfWarnings();
        this.handler.computeSteadyState(new ModelExportTask(ModelExportTask.ModelExportEntity.MODEL, (File)null, new ModelExportOptions(ModelExportFormat.EXPLICIT)));
    }

    protected void a_exportTransient(ModelExportFormat modelExportFormat) {
        int n = GUITransientTime.requestTime(this.getGUI());
        if (n != 0) {
            return;
        }
        int n2 = 1;
        switch (modelExportFormat) {
            case MATLAB: {
                n2 = this.showSaveFileDialog(this.matlabFilter);
                break;
            }
            default: {
                n2 = this.showSaveFileDialog(this.textFilter);
            }
        }
        if (n2 != 0) {
            return;
        }
        this.getPrism().getMainLog().resetNumberOfWarnings();
        this.handler.computeTransient(GUITransientTime.getTimeSpec(), new ModelExportTask(ModelExportTask.ModelExportEntity.MODEL, this.getChooserFile(), new ModelExportOptions(modelExportFormat)));
    }

    protected void a_computeTransient() {
        this.getPrism().getMainLog().resetNumberOfWarnings();
        int n = GUITransientTime.requestTime(this.getGUI());
        if (n != 0) {
            return;
        }
        this.handler.computeTransient(GUITransientTime.getTimeSpec(), new ModelExportTask(ModelExportTask.ModelExportEntity.MODEL, (File)null, new ModelExportOptions(ModelExportFormat.EXPLICIT)));
    }

    protected void a_convertToPrismTextModel() {
        int n = this.doModificationCheck();
        if (n == 0 && this.handler.getModelMode() != 1) {
            String[] stringArray = new String[]{"Yes", "No", "Cancel"};
            int n2 = -1;
            n2 = this.optionPane("WARNING: This is a one way operation. Continue?", "Question", 2, 3, stringArray, stringArray[0]);
            switch (n2) {
                case 0: {
                    this.handler.convertViewToPRISM();
                }
            }
        }
    }

    private void setupActions() {
        this.newPRISMModel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_newPRISMModel();
            }
        };
        this.newPRISMModel.putValue("LongDescription", "Removes the current build, and loads a new model editor in PRISM Text Model mode.");
        this.newPRISMModel.putValue("MnemonicKey", 80);
        this.newPRISMModel.putValue("Name", "PRISM model");
        this.newPRISMModel.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFilePrism.png"));
        this.newPRISMModel.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.newPEPAModel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_newPEPAModel();
            }
        };
        this.newPEPAModel.putValue("LongDescription", "Removes the current build, and loads a new model editor in PEPA Text Model mode.");
        this.newPEPAModel.putValue("MnemonicKey", 69);
        this.newPEPAModel.putValue("Name", "PEPA model");
        this.newPEPAModel.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFilePepa.png"));
        this.loadModel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_openModel();
            }
        };
        this.loadModel.putValue("LongDescription", "Brings up a file loading dialogue and loads the file into the editor.  The editor will change mode according to the format of the file.  The loaded file is active for saving.");
        this.loadModel.putValue("MnemonicKey", 79);
        this.loadModel.putValue("Name", "Open model...");
        this.loadModel.putValue("SmallIcon", GUIPrism.getIconFromImage("smallOpen.png"));
        this.loadModel.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.reloadModel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_reloadModel();
            }
        };
        this.reloadModel.putValue("LongDescription", "Reloads the current active file.");
        this.reloadModel.putValue("MnemonicKey", 82);
        this.reloadModel.putValue("Name", "Reload model");
        this.reloadModel.putValue("SmallIcon", GUIPrism.getIconFromImage("smallReload.png"));
        this.reloadModel.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.saveModel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_saveModel();
            }
        };
        this.saveModel.putValue("LongDescription", "Brings up a file saving dialogue and saves the current text editor to the active file or to a new file.  The saved file becomes active");
        this.saveModel.putValue("MnemonicKey", 83);
        this.saveModel.putValue("Name", "Save model");
        this.saveModel.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.saveModel.putValue("SmallIcon", GUIPrism.getIconFromImage("smallSave.png"));
        this.saveAsModel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_saveModelAs();
            }
        };
        this.saveAsModel.putValue("LongDescription", "Brings up a file saving dialogue and saves the current text editor to a new file.  The saved file becomes active");
        this.saveAsModel.putValue("MnemonicKey", 65);
        this.saveAsModel.putValue("Name", "Save model as...");
        this.saveAsModel.putValue("SmallIcon", GUIPrism.getIconFromImage("smallSaveAs.png"));
        this.parseModel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_refreshParseTree();
            }
        };
        this.parseModel.putValue("LongDescription", "Forces a parse of the model in the editor.  The parsed description is shown in the model tree.");
        this.parseModel.putValue("MnemonicKey", 80);
        this.parseModel.putValue("Name", "Parse model");
        this.parseModel.putValue("SmallIcon", GUIPrism.getIconFromImage("smallParse.png"));
        this.parseModel.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
        this.buildModel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_build();
            }
        };
        this.buildModel.putValue("LongDescription", "Builds the model that has been parsed.");
        this.buildModel.putValue("MnemonicKey", 66);
        this.buildModel.putValue("Name", "Build model");
        this.buildModel.putValue("SmallIcon", GUIPrism.getIconFromImage("smallBuild.png"));
        this.buildModel.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
        this.exportStatesPlain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.STATES, ModelExportFormat.EXPLICIT);
            }
        };
        this.exportStatesPlain.putValue("LongDescription", "Exports the states to a plain text file");
        this.exportStatesPlain.putValue("MnemonicKey", 83);
        this.exportStatesPlain.putValue("Name", "States");
        this.exportStatesPlain.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.exportStatesMatlab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.STATES, ModelExportFormat.MATLAB);
            }
        };
        this.exportStatesMatlab.putValue("LongDescription", "Exports the states to a Matlab file");
        this.exportStatesMatlab.putValue("MnemonicKey", 83);
        this.exportStatesMatlab.putValue("Name", "States");
        this.exportStatesMatlab.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.exportTransPlain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.MODEL, ModelExportFormat.EXPLICIT);
            }
        };
        this.exportTransPlain.putValue("LongDescription", "Exports the transition matrix to a plain text file");
        this.exportTransPlain.putValue("MnemonicKey", 84);
        this.exportTransPlain.putValue("Name", "Transition matrix");
        this.exportTransPlain.putValue("SmallIcon", GUIPrism.getIconFromImage("smallMatrix.png"));
        this.exportTransMatlab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.MODEL, ModelExportFormat.MATLAB);
            }
        };
        this.exportTransMatlab.putValue("LongDescription", "Exports the transition matrix to a Matlab file");
        this.exportTransMatlab.putValue("MnemonicKey", 84);
        this.exportTransMatlab.putValue("Name", "Transition matrix");
        this.exportTransMatlab.putValue("SmallIcon", GUIPrism.getIconFromImage("smallMatrix.png"));
        this.exportTransDot = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.MODEL, ModelExportFormat.DOT);
            }
        };
        this.exportTransDot.putValue("LongDescription", "Exports the model to a Dot file");
        this.exportTransDot.putValue("MnemonicKey", 68);
        this.exportTransDot.putValue("Name", "Dot");
        this.exportTransDot.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileDot.png"));
        this.exportTransUMB = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.MODEL, ModelExportFormat.UMB);
            }
        };
        this.exportTransUMB.putValue("LongDescription", "Exports the model to a UMB file");
        this.exportTransUMB.putValue("MnemonicKey", 68);
        this.exportTransUMB.putValue("Name", "UMB");
        this.exportTransUMB.putValue("SmallIcon", GUIPrism.getIconFromImage("smallMatrix.png"));
        this.exportObsPlain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.OBSERVATIONS, ModelExportFormat.EXPLICIT);
            }
        };
        this.exportObsPlain.putValue("LongDescription", "Exports the observations to a plain text file");
        this.exportObsPlain.putValue("MnemonicKey", 79);
        this.exportObsPlain.putValue("Name", "Observations");
        this.exportObsPlain.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.exportObsMatlab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.OBSERVATIONS, ModelExportFormat.MATLAB);
            }
        };
        this.exportObsMatlab.putValue("LongDescription", "Exports the observations to a Matlab file");
        this.exportObsMatlab.putValue("MnemonicKey", 79);
        this.exportObsMatlab.putValue("Name", "Observations");
        this.exportObsMatlab.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.exportStateRewardsPlain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.STATE_REWARDS, ModelExportFormat.EXPLICIT);
            }
        };
        this.exportStateRewardsPlain.putValue("LongDescription", "Exports the state rewards vector to a plain text file");
        this.exportStateRewardsPlain.putValue("MnemonicKey", 82);
        this.exportStateRewardsPlain.putValue("Name", "State rewards");
        this.exportStateRewardsPlain.putValue("SmallIcon", GUIPrism.getIconFromImage("JMenu .png"));
        this.exportStateRewardsMatlab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.STATE_REWARDS, ModelExportFormat.MATLAB);
            }
        };
        this.exportStateRewardsMatlab.putValue("LongDescription", "Exports the state rewards vector to a Matlab file");
        this.exportStateRewardsMatlab.putValue("MnemonicKey", 82);
        this.exportStateRewardsMatlab.putValue("Name", "State rewards");
        this.exportStateRewardsMatlab.putValue("SmallIcon", GUIPrism.getIconFromImage("JMenu .png"));
        this.exportTransRewardsPlain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.STATE_REWARDS, ModelExportFormat.EXPLICIT);
            }
        };
        this.exportTransRewardsPlain.putValue("LongDescription", "Exports the transition rewards matrix to a plain text file");
        this.exportTransRewardsPlain.putValue("MnemonicKey", 69);
        this.exportTransRewardsPlain.putValue("Name", "Transition rewards");
        this.exportTransRewardsPlain.putValue("SmallIcon", GUIPrism.getIconFromImage("smallMatrix.png"));
        this.exportTransRewardsMatlab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.TRANSITION_REWARDS, ModelExportFormat.MATLAB);
            }
        };
        this.exportTransRewardsMatlab.putValue("LongDescription", "Exports the transition rewards matrix to a Matlab file");
        this.exportTransRewardsMatlab.putValue("MnemonicKey", 69);
        this.exportTransRewardsMatlab.putValue("Name", "Transition rewards");
        this.exportTransRewardsMatlab.putValue("SmallIcon", GUIPrism.getIconFromImage("smallMatrix.png"));
        this.exportLabelsPlain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.LABELS, ModelExportFormat.EXPLICIT);
            }
        };
        this.exportLabelsPlain.putValue("LongDescription", "Exports the model's labels and their satisfying states to a plain text file");
        this.exportLabelsPlain.putValue("MnemonicKey", 76);
        this.exportLabelsPlain.putValue("Name", "Labels");
        this.exportLabelsPlain.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.exportLabelsMatlab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportBuildAs(ModelExportTask.ModelExportEntity.LABELS, ModelExportFormat.MATLAB);
            }
        };
        this.exportLabelsMatlab.putValue("LongDescription", "Exports the model's labels and their satisfying states to a Matlab file");
        this.exportLabelsMatlab.putValue("MnemonicKey", 76);
        this.exportLabelsMatlab.putValue("Name", "Labels");
        this.exportLabelsMatlab.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.computeSS = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_computeSteadyState();
            }
        };
        this.computeSS.putValue("LongDescription", "Computes steady-state probabilities for the model");
        this.computeSS.putValue("MnemonicKey", 83);
        this.computeSS.putValue("Name", "Steady-state probabilities");
        this.computeSS.putValue("SmallIcon", GUIPrism.getIconFromImage("smallSteadyState.png"));
        this.computeSS.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 0));
        this.computeTr = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_computeTransient();
            }
        };
        this.computeTr.putValue("LongDescription", "Computes transient probabilities for the model");
        this.computeTr.putValue("MnemonicKey", 84);
        this.computeTr.putValue("Name", "Transient probabilities");
        this.computeTr.putValue("SmallIcon", GUIPrism.getIconFromImage("smallClockAnim1.png"));
        this.computeTr.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 128));
        this.exportSSPlain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportSteadyState(ModelExportFormat.EXPLICIT);
            }
        };
        this.exportSSPlain.putValue("LongDescription", "Exports the steady-state probabilities to a plain text file");
        this.exportSSPlain.putValue("MnemonicKey", 80);
        this.exportSSPlain.putValue("Name", "Plain text file");
        this.exportSSPlain.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileText.png"));
        this.exportSSMatlab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportSteadyState(ModelExportFormat.MATLAB);
            }
        };
        this.exportSSMatlab.putValue("LongDescription", "Exports the steady-state probabilities to a Matlab file");
        this.exportSSMatlab.putValue("MnemonicKey", 77);
        this.exportSSMatlab.putValue("Name", "Matlab file");
        this.exportSSMatlab.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileMatlab.png"));
        this.exportTrPlain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportTransient(ModelExportFormat.EXPLICIT);
            }
        };
        this.exportTrPlain.putValue("LongDescription", "Exports the transient probabilities to a plain text file");
        this.exportTrPlain.putValue("MnemonicKey", 80);
        this.exportTrPlain.putValue("Name", "Plain text file");
        this.exportTrPlain.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileText.png"));
        this.exportTrMatlab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_exportTransient(ModelExportFormat.MATLAB);
            }
        };
        this.exportTrMatlab.putValue("LongDescription", "Exports the transient probabilities to a Matlab file");
        this.exportTrMatlab.putValue("MnemonicKey", 77);
        this.exportTrMatlab.putValue("Name", "Matlab file");
        this.exportTrMatlab.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileMatlab.png"));
        this.viewStates = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_viewBuild(ModelExportTask.ModelExportEntity.STATES, ModelExportFormat.EXPLICIT);
            }
        };
        this.viewStates.putValue("LongDescription", "Print the reachable states to the log");
        this.viewStates.putValue("MnemonicKey", 83);
        this.viewStates.putValue("Name", "States");
        this.viewStates.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.viewTrans = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_viewBuild(ModelExportTask.ModelExportEntity.MODEL, ModelExportFormat.EXPLICIT);
            }
        };
        this.viewTrans.putValue("LongDescription", "Print the transition matrix to the log");
        this.viewTrans.putValue("MnemonicKey", 84);
        this.viewTrans.putValue("Name", "Transition matrix");
        this.viewTrans.putValue("SmallIcon", GUIPrism.getIconFromImage("smallMatrix.png"));
        this.viewObs = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_viewBuild(ModelExportTask.ModelExportEntity.OBSERVATIONS, ModelExportFormat.EXPLICIT);
            }
        };
        this.viewObs.putValue("LongDescription", "Print the observations to the log");
        this.viewObs.putValue("MnemonicKey", 83);
        this.viewObs.putValue("Name", "Observations");
        this.viewObs.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.viewStateRewards = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_viewBuild(ModelExportTask.ModelExportEntity.STATE_REWARDS, ModelExportFormat.EXPLICIT);
            }
        };
        this.viewStateRewards.putValue("LongDescription", "Print the state rewards to the log");
        this.viewStateRewards.putValue("MnemonicKey", 82);
        this.viewStateRewards.putValue("Name", "State rewards");
        this.viewStateRewards.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.viewTransRewards = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_viewBuild(ModelExportTask.ModelExportEntity.TRANSITION_REWARDS, ModelExportFormat.EXPLICIT);
            }
        };
        this.viewTransRewards.putValue("LongDescription", "Print the transition rewards to the log");
        this.viewTransRewards.putValue("MnemonicKey", 69);
        this.viewTransRewards.putValue("Name", "Transition rewards");
        this.viewTransRewards.putValue("SmallIcon", GUIPrism.getIconFromImage("smallMatrix.png"));
        this.viewLabels = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_viewBuild(ModelExportTask.ModelExportEntity.LABELS, ModelExportFormat.EXPLICIT);
            }
        };
        this.viewLabels.putValue("LongDescription", "Print the labels and satisfying states to the log");
        this.viewLabels.putValue("MnemonicKey", 76);
        this.viewLabels.putValue("Name", "Labels");
        this.viewLabels.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStates.png"));
        this.viewPrismCode = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModel.this.a_viewCurrentModelBuild();
            }
        };
        this.viewPrismCode.putValue("LongDescription", "This shows the parsed model in a text editor.");
        this.viewPrismCode.putValue("MnemonicKey", 86);
        this.viewPrismCode.putValue("Name", "Parsed PRISM model");
        this.viewPrismCode.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFilePrism.png"));
    }

    @Override
    public boolean displaysTab() {
        return true;
    }

    @Override
    public JMenu getMenu() {
        return this.modelMenu;
    }

    @Override
    public String getTabText() {
        return "Model";
    }

    @Override
    public JToolBar getToolBar() {
        return null;
    }

    @Override
    public String getXMLIDTag() {
        return "";
    }

    @Override
    public Object getXMLSaveTree() {
        return null;
    }

    @Override
    public void loadXML(Object object) {
    }

    @Override
    public boolean processGUIEvent(GUIEvent gUIEvent) {
        if (gUIEvent instanceof GUIPropertiesEvent) {
            if (gUIEvent.getID() == 1) {
                this.handler.requestParse(false);
            }
        } else if (gUIEvent instanceof GUIClipboardEvent && super.getGUI().getFocussedPlugin() == this) {
            GUIClipboardEvent gUIClipboardEvent = (GUIClipboardEvent)gUIEvent;
            if (gUIClipboardEvent.getComponent() == this) {
                int n = gUIClipboardEvent.getID();
                if (n == 1) {
                    this.handler.cut();
                } else if (n == 0) {
                    this.handler.copy();
                } else if (n == 2) {
                    this.handler.paste();
                } else if (n == 3) {
                    this.handler.delete();
                } else if (n == 4) {
                    this.handler.selectAll();
                } else if (n == 5) {
                    this.handler.undo();
                } else if (n == 6) {
                    this.handler.redo();
                }
            }
        } else if (gUIEvent instanceof GUIComputationEvent) {
            if (gUIEvent.getID() == 0) {
                this.computing = true;
                this.doEnables();
                this.selectionChangeHandler.notifyListeners(new GUIEvent(1));
            } else if (gUIEvent.getID() == 1) {
                this.computing = false;
                this.doEnables();
                this.selectionChangeHandler.notifyListeners(new GUIEvent(1));
            } else if (gUIEvent.getID() == 2) {
                this.computing = false;
                this.doEnables();
                this.selectionChangeHandler.notifyListeners(new GUIEvent(1));
            }
        } else if (gUIEvent instanceof GUIExitEvent && gUIEvent.getID() == 0 && this.doModificationCheck() != 0) {
            this.notifyEventListeners(new GUIExitEvent(1));
            return true;
        }
        return false;
    }

    private JMenu initExportMenu() {
        JMenu jMenu = new JMenu("Export");
        jMenu.setMnemonic('E');
        jMenu.setIcon(GUIPrism.getIconFromImage("smallExport.png"));
        JMenu jMenu2 = new JMenu("Plain text");
        jMenu2.setMnemonic('P');
        jMenu2.setIcon(GUIPrism.getIconFromImage("smallFileText.png"));
        jMenu2.add(this.exportTransPlain);
        jMenu2.add(this.exportStateRewardsPlain);
        jMenu2.add(this.exportTransRewardsPlain);
        jMenu2.add(this.exportLabelsPlain);
        jMenu2.add(this.exportStatesPlain);
        jMenu2.add(this.exportObsPlain);
        jMenu.add(jMenu2);
        jMenu.add(this.exportTransDot);
        jMenu.add(this.exportTransUMB);
        JMenu jMenu3 = new JMenu("Matlab");
        jMenu3.setMnemonic('M');
        jMenu3.setIcon(GUIPrism.getIconFromImage("smallFileMatlab.png"));
        jMenu3.add(this.exportTransMatlab);
        jMenu3.add(this.exportStateRewardsMatlab);
        jMenu3.add(this.exportTransRewardsMatlab);
        jMenu3.add(this.exportLabelsMatlab);
        jMenu3.add(this.exportStatesMatlab);
        jMenu3.add(this.exportObsMatlab);
        jMenu.add(jMenu3);
        return jMenu;
    }

    private JMenu initViewMenu() {
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic('V');
        jMenu.setIcon(GUIPrism.getIconFromImage("smallView.png"));
        jMenu.add(this.viewStates);
        jMenu.add(this.viewTrans);
        jMenu.add(this.viewObs);
        jMenu.add(this.viewStateRewards);
        jMenu.add(this.viewTransRewards);
        jMenu.add(this.viewLabels);
        jMenu.add(this.viewPrismCode);
        return jMenu;
    }

    private JMenu initComputeMenu() {
        JMenu jMenu = new JMenu("Compute");
        jMenu.setMnemonic('C');
        jMenu.setIcon(GUIPrism.getIconFromImage("smallCompute.png"));
        jMenu.add(this.computeSS);
        jMenu.add(this.computeTr);
        return jMenu;
    }

    private JMenu initComputeExportMenu() {
        JMenu jMenu = new JMenu("Compute/export");
        jMenu.setMnemonic('X');
        jMenu.setIcon(GUIPrism.getIconFromImage("smallCompute.png"));
        this.exportSSMenu = new JMenu("Steady-state probabilities");
        this.exportSSMenu.setMnemonic('S');
        this.exportSSMenu.setIcon(GUIPrism.getIconFromImage("smallSteadyState.png"));
        this.exportSSMenu.add(this.exportSSPlain);
        this.exportSSMenu.add(this.exportSSMatlab);
        jMenu.add(this.exportSSMenu);
        this.exportTrMenu = new JMenu("Transient probabilities");
        this.exportTrMenu.setMnemonic('A');
        this.exportTrMenu.setIcon(GUIPrism.getIconFromImage("smallClockAnim1.png"));
        this.exportTrMenu.add(this.exportTrPlain);
        this.exportTrMenu.add(this.exportTrMatlab);
        jMenu.add(this.exportTrMenu);
        return jMenu;
    }

    private void initComponents() {
        this.setupActions();
        this.modelMenu = new JMenu("Model");
        this.exportMenu = this.initExportMenu();
        this.viewMenu = this.initViewMenu();
        this.computeMenu = this.initComputeMenu();
        this.computeExportMenu = this.initComputeExportMenu();
        JPanel jPanel = new JPanel();
        this.fileTextField = new JTextField();
        this.fileTextField.setHorizontalAlignment(2);
        this.fileTextField.setBorder(new EtchedBorder());
        this.fileTextField.setMinimumSize(new Dimension(40, 25));
        this.fileTextField.setEditable(false);
        this.fileTextField.setBackground(null);
        jPanel.setLayout(new BorderLayout());
        this.handler = new GUIMultiModelHandler(this);
        jPanel.add((Component)this.fileTextField, "North");
        jPanel.add((Component)this.handler, "Center");
        this.newMenu = new JMenu("New");
        this.newMenu.setMnemonic('N');
        this.newMenu.setIcon(GUIPrism.getIconFromImage("smallNew.png"));
        this.newMenu.add(this.newPRISMModel);
        this.newMenu.add(this.newPEPAModel);
        this.modelMenu.add(this.newMenu);
        this.modelMenu.add(new JSeparator());
        this.modelMenu.add(this.loadModel);
        this.modelMenu.add(this.reloadModel);
        this.modelMenu.add(new JSeparator());
        this.modelMenu.add(this.saveModel);
        this.modelMenu.add(this.saveAsModel);
        this.modelMenu.add(new JSeparator());
        this.modelMenu.setMnemonic(77);
        this.modelMenu.add(this.parseModel);
        this.modelMenu.add(this.buildModel);
        this.modelMenu.add(new JSeparator());
        this.modelMenu.add(this.exportMenu);
        this.modelMenu.add(this.viewMenu);
        this.modelMenu.add(this.computeMenu);
        this.modelMenu.add(this.computeExportMenu);
        this.popup = new JPopupMenu();
        this.popup.add(this.parseModel);
        this.popup.add(this.buildModel);
        this.popup.add(this.viewPrismCode);
        this.modelFilters = new HashMap<String, FileFilter>();
        this.modelFilters.put("prism", new FileNameExtensionFilter("PRISM models (*.prism, *.pm, *.nm, *.sm, *.smg)", "prism", "pm", "nm", "sm", "smg"));
        this.modelFilters.put("pepa", new FileNameExtensionFilter("PEPA models (*.pepa)", "pepa"));
        this.staFilters = new HashMap<String, FileFilter>();
        this.staFilters.put("sta", new FileNameExtensionFilter("State list files (*.sta)", "sta"));
        this.staFilters.put("txt", new FileNameExtensionFilter("Plain text files (*.txt)", "txt"));
        this.obsFilters = new HashMap<String, FileFilter>();
        this.obsFilters.put("obs", new FileNameExtensionFilter("Observations files (*.obs)", "obs"));
        this.obsFilters.put("txt", new FileNameExtensionFilter("Plain text files (*.txt)", "txt"));
        this.traFilters = new HashMap<String, FileFilter>();
        this.traFilters.put("tra", new FileNameExtensionFilter("Transition matrix files (*.tra)", "tra"));
        this.traFilters.put("txt", new FileNameExtensionFilter("Plain text files (*.txt)", "txt"));
        this.labFilters = new HashMap<String, FileFilter>();
        this.labFilters.put("lab", new FileNameExtensionFilter("Label files (*.lab)", "lab"));
        this.labFilters.put("txt", new FileNameExtensionFilter("Plain text files (*.txt)", "txt"));
        this.textFilter = new FileNameExtensionFilter("Plain text files (*.txt)", "txt");
        this.matlabFilter = new FileNameExtensionFilter("Matlab files (*.m)", "m");
        this.dotFilter = new FileNameExtensionFilter("Dot files (*.dot)", "dot");
        this.umbFilter = new FileNameExtensionFilter("UMB files (*.umb)", "dot");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.doEnables();
    }

    @Override
    public void notifySettings(PrismSettings prismSettings) {
        this.handler.notifySettings(prismSettings);
        this.repaint();
    }

    @Override
    public GUIUndoManager getUndoManager() {
        return this.handler.getUndoManager();
    }

    @Override
    public boolean canDoClipBoardAction(Action action) {
        if (this.computing) {
            return false;
        }
        return this.handler.canDoClipBoardAction(action);
    }

    public AbstractAction getParseModel() {
        return this.parseModel;
    }

    public AbstractAction getBuildModel() {
        return this.buildModel;
    }

    public JMenu getViewMenu() {
        return this.initViewMenu();
    }

    public JMenu getExportMenu() {
        return this.initExportMenu();
    }

    public JMenu getComputeMenu() {
        return this.initComputeMenu();
    }

    public JMenu getComputeExportMenu() {
        return this.initComputeExportMenu();
    }

    public void setGUISimulator(GUISimulator gUISimulator) {
        this.sim = gUISimulator;
    }

    public GUISimulator getGUISimulator() {
        return this.sim;
    }
}

