/*
 * Decompiled with CFR 0.152.
 */
package pta;

import explicit.IndexedSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismPrintStreamLog;
import prism.ProgressDisplay;
import pta.Constraint;
import pta.DBM;
import pta.DBMList;
import pta.Edge;
import pta.LocZone;
import pta.NCZone;
import pta.PTA;
import pta.ReachabilityGraph;
import pta.Transition;
import pta.Zone;

public class ForwardsReach {
    protected PrismLog mainLog;
    protected BitSet targetLocs;
    protected Constraint targetConstraint;
    protected BitSet target;
    protected List<Integer> initialStates;

    public ForwardsReach() {
        this(new PrismPrintStreamLog(System.out));
    }

    public ForwardsReach(PrismLog prismLog) {
        this.mainLog = prismLog;
    }

    public BitSet getTarget() {
        return this.target;
    }

    public List<Integer> getInitialStates() {
        return this.initialStates;
    }

    public ReachabilityGraph buildForwardsGraph(PTA pTA, BitSet bitSet, Constraint constraint) throws PrismException {
        return this.buildForwardsGraphFormats10(pTA, bitSet, constraint);
    }

    private ReachabilityGraph buildForwardsGraphFormats10(PTA pTA, BitSet bitSet, Constraint constraint) throws PrismException {
        this.targetLocs = bitSet;
        this.targetConstraint = constraint;
        this.mainLog.print("\nBuilding forwards reachability graph...");
        this.mainLog.flush();
        ProgressDisplay progressDisplay = new ProgressDisplay(this.mainLog);
        progressDisplay.start();
        long l = System.currentTimeMillis();
        if (constraint != null) {
            pTA.recomputeMaxClockConstraint(constraint);
        }
        ReachabilityGraph reachabilityGraph = new ReachabilityGraph(pTA);
        IndexedSet<LocZone> indexedSet = new IndexedSet<LocZone>();
        LinkedList<LocZone> linkedList = new LinkedList<LocZone>();
        this.target = new BitSet();
        LocZone locZone = new LocZone(0, DBM.createZero(pTA));
        indexedSet.add(locZone);
        linkedList.add(locZone);
        int n = -1;
        while (!linkedList.isEmpty()) {
            Object object;
            int[] nArray;
            LocZone locZone2 = (LocZone)linkedList.removeFirst();
            ++n;
            locZone2 = locZone2.deepCopy();
            locZone2.tPost(pTA);
            if (bitSet.get(locZone2.loc) && (constraint == null || locZone2.zone.isSatisfied(constraint))) {
                this.target.set(n);
                reachabilityGraph.addState();
                continue;
            }
            boolean bl = locZone2.zone.allClocksAreUnbounded();
            if (!bl && pTA.getTransitions(locZone2.loc).size() == 0) {
                throw new PrismException("Timelock (no transitions) in PTA at location " + String.valueOf(pTA.getLocationNameString(locZone2.loc)));
            }
            reachabilityGraph.addState();
            if (bl) {
                nArray = new int[]{n};
                object = new Transition(pTA, locZone2.loc, "_diverge");
                ((Transition)object).addEdge(1.0, locZone2.loc);
                reachabilityGraph.addTransition(n, (Transition)object, nArray, null);
            } else {
                DBMList dBMList = DBMList.createFalse(pTA);
                for (Transition transition : pTA.getTransitions(locZone2.loc)) {
                    object = DBM.createFromConstraints(pTA, transition.getGuardConstraints());
                    ((Zone)object).down();
                    ((NCZone)dBMList).union((Zone)object);
                }
                ((NCZone)dBMList).complement();
                ((Zone)dBMList).intersect(locZone2.zone);
                if (!((Zone)dBMList).isEmpty()) {
                    Object object2 = "Timelock in PTA at location " + String.valueOf(pTA.getLocationNameString(locZone2.loc));
                    object2 = (String)object2 + " when " + String.valueOf(((NCZone)dBMList).getAZone());
                    throw new PrismException((String)object2);
                }
            }
            for (Transition transition : pTA.getTransitions(locZone2.loc)) {
                nArray = new int[transition.getNumEdges()];
                boolean bl2 = false;
                boolean bl3 = false;
                Edge edge = null;
                int n2 = 0;
                for (Edge edge2 : transition.getEdges()) {
                    LocZone locZone3 = locZone2.deepCopy();
                    locZone3.dPost(edge2);
                    locZone3.cClosure(pTA);
                    if (!locZone3.zone.isEmpty()) {
                        if (indexedSet.add(locZone3)) {
                            linkedList.add(locZone3);
                        }
                        int n3 = indexedSet.getIndexOfLastAdd();
                        bl2 = true;
                        nArray[n2] = n3;
                    } else {
                        bl3 = true;
                        edge = edge == null ? edge2 : edge;
                        nArray[n2] = -1;
                    }
                    ++n2;
                }
                if (!bl2) continue;
                if (bl3) {
                    Object object3 = "Badly formed PTA at location " + String.valueOf(pTA.getLocationNameString(locZone2.loc)) + " when " + String.valueOf(locZone2.zone);
                    object3 = (String)object3 + ": \"" + transition.getAction() + "\"-labelled transition to ";
                    object3 = (String)object3 + String.valueOf(pTA.getLocationNameString(edge.getDestination()));
                    object3 = (String)object3 + " leads to state where invariant is not satisfied";
                    throw new PrismException((String)object3);
                }
                reachabilityGraph.addTransition(n, transition, nArray, null);
            }
            if (!bl && reachabilityGraph.trans.get(n).size() == 0) {
                object = "Timelock in PTA (no enabled transitions) at location " + String.valueOf(pTA.getLocationNameString(locZone2.loc));
                object = (String)object + " when " + String.valueOf(locZone2.zone);
                throw new PrismException((String)object);
            }
            if (!progressDisplay.ready()) continue;
            progressDisplay.update(indexedSet.size());
        }
        progressDisplay.update(indexedSet.size());
        progressDisplay.end(" states");
        reachabilityGraph.states = indexedSet.toArrayList();
        this.initialStates = new ArrayList<Integer>();
        this.initialStates.add(0);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Graph constructed in " + (double)l / 1000.0 + " secs.");
        this.mainLog.print("Graph: " + reachabilityGraph.states.size() + " symbolic states");
        this.mainLog.println(" (" + this.initialStates.size() + " initial, " + this.target.cardinality() + " target)");
        if (this.target.cardinality() == 0) {
            this.mainLog.printWarning("There are no target states.");
        }
        return reachabilityGraph;
    }

    private ReachabilityGraph buildForwardsGraphFormats09(PTA pTA, BitSet bitSet, Constraint constraint) throws PrismException {
        long l;
        this.targetLocs = bitSet;
        this.targetConstraint = constraint;
        this.mainLog.println("\nBuilding forwards reachability graph...");
        long l2 = l = System.currentTimeMillis();
        boolean bl = false;
        if (constraint != null) {
            pTA.recomputeMaxClockConstraint(constraint);
        }
        int n = pTA.getMaxClockConstraint();
        ReachabilityGraph reachabilityGraph = new ReachabilityGraph(pTA);
        IndexedSet<LocZone> indexedSet = new IndexedSet<LocZone>();
        LinkedList<LocZone> linkedList = new LinkedList<LocZone>();
        this.target = new BitSet();
        DBM dBM = DBM.createZero(pTA);
        LocZone locZone = new LocZone(0, dBM);
        locZone.tPost(pTA);
        locZone.cClosure(pTA);
        indexedSet.add(locZone);
        linkedList.add(locZone);
        int n2 = -1;
        while (!linkedList.isEmpty()) {
            LocZone locZone2 = (LocZone)linkedList.removeFirst();
            ++n2;
            if (bitSet.get(locZone2.loc) && (constraint == null || locZone2.zone.isSatisfied(constraint))) {
                this.target.set(n2);
                reachabilityGraph.addState();
                continue;
            }
            if (pTA.getTransitions(locZone2.loc).size() == 0) {
                throw new PrismException("PTA deadlocks in location " + String.valueOf(pTA.getLocationNameString(locZone2.loc)));
            }
            reachabilityGraph.addState();
            for (Transition transition : pTA.getTransitions(locZone2.loc)) {
                int[] nArray = new int[transition.getNumEdges()];
                boolean bl2 = false;
                boolean bl3 = false;
                int n3 = 0;
                for (Edge edge : transition.getEdges()) {
                    LocZone locZone3 = locZone2.deepCopy();
                    locZone3.dPost(edge);
                    locZone3.tPost(pTA);
                    locZone3.cClosure(pTA);
                    if (!locZone3.zone.isEmpty()) {
                        if (indexedSet.add(locZone3)) {
                            linkedList.add(locZone3);
                        }
                        int n4 = indexedSet.getIndexOfLastAdd();
                        bl2 = true;
                        nArray[n3] = n4;
                    } else {
                        bl3 = true;
                        nArray[n3] = -1;
                    }
                    ++n3;
                }
                if (!bl2) continue;
                if (bl3) {
                    throw new PrismException("Badly formed PTA: state " + n2);
                }
                reachabilityGraph.addTransition(n2, transition, nArray, null);
            }
            if (System.currentTimeMillis() - l <= 3000L) continue;
            if (!bl) {
                this.mainLog.print("Number of states so far:");
                bl = true;
            }
            this.mainLog.print(" " + indexedSet.size());
            this.mainLog.flush();
            l = System.currentTimeMillis();
        }
        if (bl) {
            this.mainLog.println(" " + indexedSet.size());
        }
        reachabilityGraph.states = indexedSet.toArrayList();
        this.initialStates = new ArrayList<Integer>();
        this.initialStates.add(0);
        l2 = System.currentTimeMillis() - l2;
        this.mainLog.println("Graph constructed in " + (double)l2 / 1000.0 + " secs.");
        this.mainLog.print("Graph: " + reachabilityGraph.states.size() + " symbolic states");
        this.mainLog.println("), " + this.target.cardinality() + " target states");
        if (this.target.cardinality() == 0) {
            this.mainLog.printWarning("There are no target states.");
        }
        return reachabilityGraph;
    }
}

