/*
 * Decompiled with CFR 0.152.
 */
package prism;

import acceptance.AcceptanceOmega;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismPrintStreamLog;

public class DA<Symbol, Acceptance extends AcceptanceOmega> {
    private List<String> apList = null;
    private int size;
    private int start;
    private List<List<Edge>> edges;
    private Acceptance acceptance;

    public DA(int n) {
        this.size = n;
        this.start = -1;
        this.edges = new ArrayList<List<Edge>>(n);
        for (int i = 0; i < n; ++i) {
            this.edges.add(new ArrayList());
        }
    }

    public void setAcceptance(Acceptance Acceptance) {
        this.acceptance = Acceptance;
    }

    public Acceptance getAcceptance() {
        return this.acceptance;
    }

    public void setAPList(List<String> list) {
        this.apList = list;
    }

    public List<String> getAPList() {
        return this.apList;
    }

    public void setStartState(int n) {
        this.start = n;
    }

    public void addEdge(int n, Symbol Symbol, int n2) {
        this.edges.get(n).add(new Edge(Symbol, n2));
    }

    public int size() {
        return this.size;
    }

    public int getStartState() {
        return this.start;
    }

    public int getNumEdges(int n) {
        return this.edges.get(n).size();
    }

    public int getEdgeDest(int n, int n2) {
        return this.edges.get(n).get(n2).dest;
    }

    public Symbol getEdgeLabel(int n, int n2) {
        return (Symbol)this.edges.get(n).get(n2).label;
    }

    public int getEdgeDestByLabel(int n, Symbol Symbol) {
        for (Edge edge : this.edges.get(n)) {
            if (!edge.label.equals(Symbol)) continue;
            return edge.dest;
        }
        return -1;
    }

    public void printDot(PrintStream printStream) throws PrismException {
        this.printDot(new PrismPrintStreamLog(printStream));
    }

    public void printDot(PrismLog prismLog) throws PrismException {
        int n;
        prismLog.println("digraph model {");
        for (n = 0; n < this.size; ++n) {
            prismLog.print("\t" + n + " [label=\"" + n + " [");
            prismLog.print(this.acceptance.getSignatureForState(n));
            prismLog.print("]\", shape=");
            if (n == this.start) {
                prismLog.println("doublecircle]");
                continue;
            }
            prismLog.println("ellipse]");
        }
        for (n = 0; n < this.size; ++n) {
            for (Edge edge : this.edges.get(n)) {
                prismLog.println("\t" + n + " -> " + edge.dest + " [label=\"" + String.valueOf(edge.label) + "\"]");
            }
        }
        prismLog.println("}");
    }

    public void print(PrismLog prismLog, String string) throws PrismException {
        if (string.equals("txt")) {
            prismLog.println(this.toString());
        } else if (string.equals("dot")) {
            this.printDot(prismLog);
        }
    }

    public String toString() {
        Object object = "";
        object = (String)object + this.size + " states (start " + this.start + ")";
        if (this.apList != null) {
            object = (String)object + ", " + this.apList.size() + " labels (" + String.valueOf(this.apList) + ")";
        }
        object = (String)object + ":";
        for (int i = 0; i < this.size; ++i) {
            for (Edge edge : this.edges.get(i)) {
                object = (String)object + " " + i + "-" + String.valueOf(edge.label) + "->" + edge.dest;
            }
        }
        object = (String)object + "; " + this.acceptance.getTypeName() + " acceptance: ";
        object = (String)object + String.valueOf(this.acceptance);
        return object;
    }

    public String getAutomataType() {
        return "D" + this.acceptance.getTypeAbbreviated() + "A";
    }

    public static void switchAcceptance(DA dA, AcceptanceOmega acceptanceOmega) {
        dA.acceptance = acceptanceOmega;
    }

    class Edge {
        private Symbol label;
        private int dest;

        public Edge(Symbol Symbol, int n) {
            this.label = Symbol;
            this.dest = n;
        }
    }
}

